/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.xml.XWriter;

public class FindCertificateMessage
extends KeyStoreMessage {
    private final X509Certificate cert;

    public FindCertificateMessage(String keyStoreType, X509Certificate cert) {
        super(keyStoreType);
        this.cert = cert;
    }

    public String getMethod() {
        return "POST";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    @Override
    public String getAction() {
        return "findCertificate";
    }

    public void write(OutputStream output) {
        try (XWriter out = new XWriter(output);){
            out.w((Object)"<certificate>").w((Object)CertUtils.encodeX509Certificate((X509Certificate)this.cert)).w((Object)"</certificate>");
            out.flush();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Failed to create FindCertificateMessage output", e);
            }
            LOG.log(Level.WARNING, "Failed to create FindCertificateMessage output: " + e);
        }
    }
}

