/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.xml.XWriter;

public class SetCertificateEntryMessage
extends KeyStoreMessage {
    private final String alias;
    private final X509Certificate cert;

    public SetCertificateEntryMessage(String keyStoreType, String alias, X509Certificate cert) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.cert = cert;
    }

    @Override
    public String getAction() {
        return "setCertificateEntry";
    }

    public String getMethod() {
        return "POST";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream output) {
        XWriter out = null;
        try {
            out = new XWriter(output);
            out.w((Object)"<certificate ");
            if (this.alias != null) {
                out.attr("alias", this.alias);
            }
            out.w((Object)" >");
            out.w((Object)CertUtils.encodeX509Certificate((X509Certificate)this.cert));
            out.w((Object)"</certificate>");
            out.flush();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Failed to create SetCertificateEntryMessage output", e);
            } else {
                LOG.log(Level.WARNING, "Failed to create SetCertificateEntryMessage output: " + e);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

