/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.fox.ChannelTrustStore;
import java.security.Key;
import java.security.cert.X509Certificate;
import javax.baja.sys.BComponent;

public class ChannelKeyStore
extends ChannelTrustStore
implements ICoreKeyStore {
    public ChannelKeyStore(BComponent parent, CryptoStoreId id) {
        super(parent, id);
    }

    public Key getKey(String alias, char[] password) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetKey(this.id, alias, password);
    }

    @Deprecated
    public void setKeyEntry(String alias, byte[] key, X509Certificate[] chain) throws Exception {
        throw new UnsupportedOperationException("setKeyEntry(String alias, byte[] key, X509Certificate[] chain) is no longer supported");
    }

    public void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws Exception {
        this.checkChannel();
        if (password != null) {
            this.setKeyEntry(alias, key, null, new SecretChars(password, false), chain);
        } else {
            this.setKeyEntry(alias, key, null, null, chain);
        }
    }

    public void setKeyEntry(String alias, Key key, SecretChars existingPassword, SecretChars newPassword, X509Certificate[] chain) throws Exception {
        this.checkChannel();
        this.channel.keyStoreSetKeyEntry1(this.id, alias, key, existingPassword, newPassword, chain);
    }

    public void deleteEntry(String alias, SecretChars password) throws Exception {
        this.checkChannel();
        this.channel.keyStoreDeleteEntry(this.id, alias, password);
    }
}

