/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CoreKeyStore;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.CheckOnboardingApproval;
import com.tridium.platcrypto.signing.GetSigningResult;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.platcrypto.signing.InitiateOnboarding;
import com.tridium.platcrypto.signing.SubmitRenewalCsr;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.security.BPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=65), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="requesterState", type="BRequesterState", defaultValue="BRequesterState.notOnboarded", flags=65), @NiagaraProperty(name="advanceRenewalPercent", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.make(\"percent\", BDimension.NULL))")}), @NiagaraProperty(name="advanceRenewal", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=65, facets={@Facet(value="BFacets.make(\"showDay\", BBoolean.TRUE, BFacets.SHOW_SECONDS, BBoolean.FALSE)")}), @NiagaraProperty(name="retryPeriod", type="BRelTime", defaultValue="BRelTime.makeDays(1)", facets={@Facet(value="BFacets.make(new String[]{BFacets.MIN, BFacets.MAX, \"showDay\", BFacets.SHOW_SECONDS}, new BIDataValue[]{BRelTime.makeMinutes(5), BRelTime.makeDays(5), BBoolean.TRUE, BBoolean.FALSE})")}), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="nextRenewalAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="alarmOnFailureToOnboard", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmOnFailureToRenew", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="requesterId", type="String", defaultValue="BString.DEFAULT", flags=65)})
@NiagaraActions(value={@NiagaraAction(name="onboard", parameterType="BString", defaultValue="BString.make(\"\")", flags=16), @NiagaraAction(name="renew", flags=16), @NiagaraAction(name="purgeExpiredUnsignedCerts", flags=20), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public abstract class BAbstractSigningRequester
extends BComponent
implements BIAlarmSource {
    @Generated
    public static final Property status = BAbstractSigningRequester.newProperty((int)65, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BAbstractSigningRequester.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property enabled = BAbstractSigningRequester.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property requesterState = BAbstractSigningRequester.newProperty((int)65, (BValue)BRequesterState.notOnboarded, null);
    @Generated
    public static final Property advanceRenewalPercent = BAbstractSigningRequester.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.make((String)"percent", (BDimension)BDimension.NULL)));
    @Generated
    public static final Property advanceRenewal = BAbstractSigningRequester.newProperty((int)65, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showDay", (BIDataValue)BBoolean.TRUE, (String)"showSeconds", (BIDataValue)BBoolean.FALSE));
    @Generated
    public static final Property retryPeriod = BAbstractSigningRequester.newProperty((int)0, (BValue)BRelTime.makeDays((int)1), (BFacets)BFacets.make((String[])new String[]{"min", "max", "showDay", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BRelTime.makeMinutes((int)5), BRelTime.makeDays((int)5), BBoolean.TRUE, BBoolean.FALSE}));
    @Generated
    public static final Property lastAttempt = BAbstractSigningRequester.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastSuccess = BAbstractSigningRequester.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailure = BAbstractSigningRequester.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property nextRenewalAttempt = BAbstractSigningRequester.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property alarmOnFailureToOnboard = BAbstractSigningRequester.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alarmOnFailureToRenew = BAbstractSigningRequester.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmSourceInfo = BAbstractSigningRequester.newProperty((int)0, (BValue)BAbstractSigningRequester.initAlarmSourceInfo(), null);
    @Generated
    public static final Property requesterId = BAbstractSigningRequester.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action onboard = BAbstractSigningRequester.newAction((int)16, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action renew = BAbstractSigningRequester.newAction((int)16, null);
    @Generated
    public static final Action purgeExpiredUnsignedCerts = BAbstractSigningRequester.newAction((int)20, null);
    @Generated
    public static final Action ackAlarm = BAbstractSigningRequester.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractSigningRequester.class);
    private Clock.Ticket renewalCheck;
    private long approvalCheckRetryDelay = DEFAULT_APPROVAL_CHECK_RETRY_DELAY;
    private long signingResultsCheckRetryDelay = DEFAULT_SIGNING_RESULTS_CHECK_RETRY_DELAY;
    private int maxApprovalCheckAttempts = MAX_APPROVAL_CHECK_ATTEMPTS;
    private int maxSigningResultsCheckAttempts = MAX_SIGNING_RESULTS_CHECK_ATTEMPTS;
    private ScheduledExecutorService executorService;
    private AlarmSupport alarmSupport;
    private Clock.Ticket purgeTicket;
    public static final Logger LOG = Logger.getLogger("signing.requester");
    public static final Lexicon LEX = Lexicon.make(BAbstractSigningRequester.class);
    static final long DEFAULT_APPROVAL_CHECK_RETRY_DELAY = AccessController.doPrivileged(() -> Long.getLong("niagara.signingRequester.approvalCheckRetryDelay", 15000L));
    static final int MAX_APPROVAL_CHECK_ATTEMPTS = AccessController.doPrivileged(() -> Integer.getInteger("niagara.signingRequester.approvalCheckMaxAttempts", 1440));
    static final long DEFAULT_SIGNING_RESULTS_CHECK_RETRY_DELAY = AccessController.doPrivileged(() -> Long.getLong("niagara.signingRequester.signingResultsCheckRetryDelay", 1000L));
    static final int MAX_SIGNING_RESULTS_CHECK_ATTEMPTS = AccessController.doPrivileged(() -> Integer.getInteger("niagara.signingRequester.signingResultsCheckMaxAttempts", 1800));
    private static final String EXECUTOR_THREAD_NAME_PREFIX = "SigningRequester.Thread";
    private static final int UNUSED_STATUS_BITS_TO_REMOVE_MASK = -117;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final X509Certificate[] EMPTY_CERT_ARRAY = new X509Certificate[0];
    private static final FilePath UNSIGNED_KEY_STORE_DIRECTORY = new FilePath("^^signingRequester");
    private static final String UNSIGNED_KEY_STORE_NAME = "signingRequester";
    private static final String UNSIGNED_KEY_STORE_KEY_RING_NAME = "platCrypto.BAbstractSigningRequester$UnsignedKeyStore";

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRequesterState getRequesterState() {
        return (BRequesterState)this.get(requesterState);
    }

    @Generated
    public void setRequesterState(BRequesterState v) {
        this.set(requesterState, (BValue)v, null);
    }

    @Generated
    public int getAdvanceRenewalPercent() {
        return this.getInt(advanceRenewalPercent);
    }

    @Generated
    public void setAdvanceRenewalPercent(int v) {
        this.setInt(advanceRenewalPercent, v, null);
    }

    @Generated
    public BRelTime getAdvanceRenewal() {
        return (BRelTime)this.get(advanceRenewal);
    }

    @Generated
    public void setAdvanceRenewal(BRelTime v) {
        this.set(advanceRenewal, (BValue)v, null);
    }

    @Generated
    public BRelTime getRetryPeriod() {
        return (BRelTime)this.get(retryPeriod);
    }

    @Generated
    public void setRetryPeriod(BRelTime v) {
        this.set(retryPeriod, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    @Generated
    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    @Generated
    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextRenewalAttempt() {
        return (BAbsTime)this.get(nextRenewalAttempt);
    }

    @Generated
    public void setNextRenewalAttempt(BAbsTime v) {
        this.set(nextRenewalAttempt, (BValue)v, null);
    }

    @Generated
    public boolean getAlarmOnFailureToOnboard() {
        return this.getBoolean(alarmOnFailureToOnboard);
    }

    @Generated
    public void setAlarmOnFailureToOnboard(boolean v) {
        this.setBoolean(alarmOnFailureToOnboard, v, null);
    }

    @Generated
    public boolean getAlarmOnFailureToRenew() {
        return this.getBoolean(alarmOnFailureToRenew);
    }

    @Generated
    public void setAlarmOnFailureToRenew(boolean v) {
        this.setBoolean(alarmOnFailureToRenew, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public String getRequesterId() {
        return this.getString(requesterId);
    }

    @Generated
    public void setRequesterId(String v) {
        this.setString(requesterId, v, null);
    }

    @Generated
    public void onboard(BString parameter) {
        this.invoke(onboard, (BValue)parameter, null);
    }

    @Generated
    public void renew() {
        this.invoke(renew, null, null);
    }

    @Generated
    public void purgeExpiredUnsignedCerts() {
        this.invoke(purgeExpiredUnsignedCerts, null, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract void initiateOnboarding(String var1, Context var2) throws IOException;

    public boolean supportsApprovalCheck() {
        return true;
    }

    public abstract BApprovalState checkOnboardingApproval() throws IOException;

    public abstract BCertificateParameter[] getCertificateParameterTemplates() throws IOException;

    public abstract void submitCertificateSigningRequest(NPKCS10CertificationRequest var1, boolean var2, Context var3) throws IOException;

    public abstract X509Certificate[] getCertificateSigningResult(boolean var1) throws IOException;

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        } else if (x == 12) {
            this.fwStopped();
        } else if (x == 2) {
            this.fwChanged((Property)a);
        }
        if ((x == 2 || x == 3) && "slotFacets_".equals(((Slot)a).getName())) {
            this.facetsChanged((Slot)a, (Context)b);
        } else if (x == 4 && "slotFacets_".equals(((Slot)a).getName())) {
            this.facetsChanged((Slot)a, (Context)c);
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        if (this.getEnabled()) {
            this.executorService = this.createExecutorService();
        }
        if (!this.getEnabled()) {
            this.setFlags((Slot)onboard, this.getFlags((Slot)onboard) | 4);
        } else {
            this.setFlags((Slot)onboard, this.getFlags((Slot)onboard) & 0xFFFFFFFB);
        }
        if (!this.getEnabled() || !this.isEligibleForRenewal()) {
            this.setFlags((Slot)renew, this.getFlags((Slot)renew) | 4);
        } else {
            this.setFlags((Slot)renew, this.getFlags((Slot)renew) & 0xFFFFFFFB);
        }
        if (this.getEnabled()) {
            this.initRequesterState();
        }
        this.updateStatus();
        this.schedulePurgeExpiredUnsignedCerts(BAbsTime.now().add(BRelTime.MINUTE));
    }

    private void fwStopped() {
        if (this.renewalCheck != null) {
            this.renewalCheck.cancel();
        }
        if (this.executorService != null) {
            this.shutdownExecutorService();
            this.executorService = null;
        }
    }

    private void fwChanged(Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            this.updateStatus();
            if (this.renewalCheck != null) {
                this.renewalCheck.cancel();
                this.setNextRenewalAttempt(BAbsTime.NULL);
            }
            if (this.getEnabled()) {
                this.executorService = this.createExecutorService();
                this.setFlags((Slot)onboard, this.getFlags((Slot)onboard) & 0xFFFFFFFB);
                if (this.isEligibleForRenewal()) {
                    this.setFlags((Slot)renew, this.getFlags((Slot)renew) & 0xFFFFFFFB);
                }
                this.initRequesterState();
            } else {
                if (this.executorService != null) {
                    this.shutdownExecutorService();
                    this.executorService = null;
                }
                this.setFlags((Slot)onboard, this.getFlags((Slot)onboard) | 4);
                this.setFlags((Slot)renew, this.getFlags((Slot)renew) | 4);
            }
        } else if (p.equals(advanceRenewalPercent)) {
            if (this.getAdvanceRenewalPercent() < 1) {
                this.setAdvanceRenewalPercent(1);
            } else if (this.getAdvanceRenewalPercent() > 100) {
                this.setAdvanceRenewalPercent(100);
            } else {
                this.updateAdvanceRenewal(this.isEligibleForRenewal());
                if (this.getEnabled() && this.getRequesterState() == BRequesterState.onboarded) {
                    this.scheduleRenewalCheck();
                }
            }
        } else if (p.equals(requesterState) && !this.isEligibleForRenewal()) {
            this.setFlags((Slot)renew, this.getFlags((Slot)renew) | 4);
        }
    }

    public final IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(renew) || action.equals(onboard)) {
            if (!this.getEnabled()) {
                throw new LocalizableRuntimeException("platCrypto", LEX.getText("signingRequester.notEnabled"));
            }
            Invocation invc = new Invocation((BComponent)this, action, argument, cx);
            this.executorService.submit((Runnable)invc);
            return null;
        }
        if (action.equals(purgeExpiredUnsignedCerts)) {
            Invocation invc = new Invocation((BComponent)this, action, argument, cx);
            if (this.executorService != null) {
                this.executorService.submit((Runnable)invc);
            } else {
                Thread thread = new Thread((Runnable)invc, "SigningRequester:PurgeExpiredUnsignedCerts");
                thread.setDaemon(true);
                thread.start();
            }
            return null;
        }
        return this.doPost(action, argument, cx);
    }

    protected IFuture doPost(Action action, BValue argument, Context cx) {
        if (this.executorService != null) {
            Invocation invc = new Invocation((BComponent)this, action, argument, cx);
            this.executorService.submit((Runnable)invc);
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Could not invoke action '" + action + "' on " + this.toPathString() + " because it is not currently operational.");
        }
        return null;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof IRequesterComponent && this.doIsParentLegal(parent);
    }

    protected boolean doIsParentLegal(BComponent parent) {
        return true;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(onboard)) {
            BUser user = BUser.getCurrentAuthenticatedUser();
            BasicContext cx = user != null ? new BasicContext(user) : null;
            return BString.make((String)Lexicon.make((String)"platCrypto", (Context)cx).getText("signingRequester.defaultOnboardingComment"));
        }
        return super.getActionParameterDefault(action);
    }

    public final void flagsChanged(Slot slot, Context context) {
        BComplex parent = this.getParent();
        if (parent != null) {
            parent.fw(9900, (Object)this, (Object)slot, (Object)context, null);
        }
    }

    public final void facetsChanged(Slot slot, Context context) {
        BComplex parent = this.getParent();
        if (parent != null) {
            parent.fw(9901, (Object)this, (Object)slot, (Object)context, null);
        }
    }

    public final IRequesterComponent getRequesterComponent() {
        IRequesterComponent parent = (IRequesterComponent)this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Must be parented.");
        }
        return parent;
    }

    public final void doOnboard(BString comment, Context cx) {
        if (!this.getEnabled()) {
            throw new LocalizableRuntimeException("platCrypto", LEX.getText("signingRequester.notEnabled"));
        }
        BAbsTime onboardingTime = BAbsTime.now();
        this.setLastAttempt(onboardingTime);
        this.setFaultCause("");
        this.getExecutorService().submit(new InitiateOnboarding(this, comment, cx));
    }

    public final void doRenew(Context cx) throws Exception {
        if (!this.getEnabled()) {
            throw new LocalizableRuntimeException("platCrypto", LEX.getText("signingRequester.notEnabled"));
        }
        BAbsTime attemptTime = BAbsTime.now();
        this.setLastAttempt(attemptTime);
        if (cx != null && cx.getUser() != null) {
            this.setFaultCause("");
        }
        if (!this.hasSignedCertificate()) {
            this.setRequesterState(BRequesterState.notOnboarded);
            this.fail(LEX.getText("signingRequester.noCertificateResettingState", new Object[]{this.getRequesterComponent().getCertAlias()}));
            return;
        }
        if (!this.isEligibleForRenewal()) {
            this.fail(LEX.getText("signingRequester.notEligibleForRenewal", new Object[]{this.getRequesterState()}));
            return;
        }
        try {
            Optional<X509Certificate> cert = this.getCertificate(true);
            if (cert.isPresent()) {
                NPKCS10CertificationRequest csr = CertUtils.generateCSR((X509Certificate)cert.get(), (PrivateKey)this.getPrivateKey(true));
                this.getExecutorService().submit(new SubmitRenewalCsr(this, csr, cx));
            } else {
                this.fail(LEX.getText("signingRequester.noCertificateResettingState", new Object[]{this.getRequesterComponent().getCertAlias()}));
                this.setRequesterState(BRequesterState.notOnboarded);
            }
        }
        catch (Exception e) {
            this.fail(LEX.getText("signingRequester.failedToGenerateRenewalCsr"), e);
            this.scheduleRenewalCheck(BAbsTime.now().add(this.getRetryPeriod()));
        }
    }

    public final void doPurgeExpiredUnsignedCerts() {
        AtomicReference nextPurge = new AtomicReference();
        try {
            AccessController.doPrivileged(() -> {
                if (BAbstractSigningRequester.getUnsignedKeystoreFile(false).exists()) {
                    ArrayList expiredAliases = new ArrayList();
                    ICoreKeyStore keyStore = BAbstractSigningRequester.getKeyStore(false);
                    keyStore.getCertificateEntries().forEach(certificateEntry -> {
                        IX509Certificate cert = certificateEntry.getCertificate(0);
                        long certExpirationMillis = cert.getNotAfter().getTime();
                        if (certExpirationMillis <= BAbsTime.now().getMillis()) {
                            expiredAliases.add(certificateEntry.getAlias());
                        } else if (nextPurge.get() == null || ((BAbsTime)nextPurge.get()).getMillis() > certExpirationMillis) {
                            nextPurge.set(BAbsTime.make((long)certExpirationMillis));
                        }
                    });
                    if (!expiredAliases.isEmpty()) {
                        keyStore.deleteEntries(expiredAliases.toArray(EMPTY_STRING_ARRAY));
                        keyStore.save();
                    }
                }
                return null;
            });
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Purge check failed while looking for expired unsigned requester certs.", t);
        }
        this.schedulePurgeExpiredUnsignedCerts((BAbsTime)nextPurge.get());
    }

    protected final boolean isEligibleForRenewal() {
        return this.getRequesterState() == BRequesterState.onboarded || this.getRequesterState() == BRequesterState.renewalCsrSubmitted || this.getRequesterState() == BRequesterState.renewalFailed;
    }

    protected final void success() {
        this.setFaultCause("");
        this.setLastSuccess(BAbsTime.now());
        if (this.getStatus().isAlarm()) {
            this.processAlarmNormal();
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        this.updateStatus();
    }

    protected final void fail(String message) {
        this.fail(message, null);
    }

    protected final void fail(Throwable cause) {
        this.fail("", cause);
    }

    protected final void fail(String message, Throwable t) {
        this.fail(message, t, false);
    }

    protected final void fail(String message, Throwable t, boolean failureKnownToBeDuringOnboarding) {
        String exceptionMsg;
        String string = exceptionMsg = t != null ? BAbstractSigningRequester.extractErrorMessage(t) : null;
        if (message != null && exceptionMsg != null) {
            message = message + ": " + exceptionMsg;
        } else if (exceptionMsg != null) {
            message = exceptionMsg;
        } else if (message == null) {
            message = LEX.getText("signingRequester.unknown");
        }
        this.setFaultCause(message);
        this.setLastFailure(BAbsTime.now());
        if (this.getEnabled() && (this.getAlarmOnFailureToOnboard() && (failureKnownToBeDuringOnboarding || Flags.isHidden((BComplex)this, (Slot)renew)) || this.getAlarmOnFailureToRenew() && !failureKnownToBeDuringOnboarding && !Flags.isHidden((BComplex)this, (Slot)renew))) {
            boolean ackRequired = this.processAlarmOffNormal(message);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.updateStatus();
    }

    static String extractErrorMessage(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            if (cause instanceof Localizable) {
                return ((Localizable)cause).toString(null);
            }
            Throwable priorCause = cause;
            if (priorCause != (cause = cause.getCause())) continue;
            break;
        }
        if (t != null && t.getMessage() != null) {
            return t.getMessage();
        }
        return LEX.getText("signingRequester.unknown");
    }

    protected final void updateStatus() {
        int newStatus = this.getStatus().getBits();
        newStatus &= 0xFFFFFF8B;
        newStatus = this.getEnabled() ? (newStatus &= 0xFFFFFFFE) : (newStatus |= 1);
        newStatus = this.getLastFailure().getMillis() > this.getLastSuccess().getMillis() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected void generateRequesterId(boolean force) {
        if (force || this.getRequesterId().isEmpty()) {
            this.setRequesterId(UUID.randomUUID().toString());
        }
    }

    ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    long getApprovalCheckRetryDelay() {
        return this.approvalCheckRetryDelay;
    }

    long getSigningCheckCheckRetryDelay() {
        return this.signingResultsCheckRetryDelay;
    }

    int getMaxApprovalCheckAttempts() {
        return this.maxApprovalCheckAttempts;
    }

    int getMaxSigningResultsCheckAttempts() {
        return this.maxSigningResultsCheckAttempts;
    }

    void scheduleRenewalCheck() {
        Optional<X509Certificate> cert = this.getCertificate(true);
        if (cert.isPresent()) {
            BAbsTime expr = this.getCertificateExpiration(true);
            BRelTime validity = this.getCertificateValidity(true);
            long backoff = Math.round((double)(validity.getMillis() * (long)this.getAdvanceRenewalPercent()) * 0.01);
            BAbsTime startOfRenewalPeriod = expr.subtract(BRelTime.make((long)backoff));
            this.scheduleRenewalCheck(startOfRenewalPeriod, true);
        } else {
            this.setRequesterState(BRequesterState.notOnboarded);
            this.fail(LEX.getText("signingRequester.noCertificateResettingState", new Object[]{this.getRequesterComponent().getCertAlias()}));
        }
    }

    void scheduleRenewalCheck(BAbsTime renewalTime) {
        this.scheduleRenewalCheck(renewalTime, false);
    }

    void scheduleRenewalCheck(BAbsTime renewalTime, boolean force) {
        if (this.renewalCheck != null) {
            this.renewalCheck.cancel();
            this.setNextRenewalAttempt(BAbsTime.NULL);
        }
        this.setFlags((Slot)renew, this.getFlags((Slot)renew) & 0xFFFFFFFB);
        try {
            if (renewalTime.getMillis() <= BAbsTime.now().getMillis()) {
                throw new IllegalArgumentException("Attempted to schedule renewal check in the past at " + renewalTime);
            }
            BAbsTime certificateExpr = this.getCertificateExpiration(true);
            if (certificateExpr.isNull()) {
                throw new IllegalArgumentException("Cannot find certificate for " + this.getRequesterComponent().getCertAlias());
            }
            if (renewalTime.getMillis() <= certificateExpr.getMillis() || force) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Scheduling renewal check for " + renewalTime);
                }
                this.renewalCheck = Clock.schedule((BComponent)this, (BAbsTime)renewalTime, (Action)renew, null);
                this.setNextRenewalAttempt(renewalTime);
            } else {
                LOG.warning("Attempted to schedule auto-renewal for " + renewalTime + " which is after the certificate expiration of " + certificateExpr + ". Must manually invoke renew() action.");
            }
        }
        catch (IllegalArgumentException | NotRunningException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Failed to schedule renewal check for " + renewalTime, e);
            }
            LOG.log(Level.WARNING, "Failed to schedule renewal check for " + renewalTime + " : " + e.getMessage());
        }
    }

    void storeSignedCertificate(X509Certificate[] certificateChain, boolean renewal) throws Exception {
        this.storeCertificate(this.getPrivateKey(renewal), certificateChain, true);
    }

    void storeUnsignedCertificate(PrivateKey privateKey, X509Certificate[] certificateChain) throws Exception {
        this.storeCertificate(privateKey, certificateChain, false);
    }

    private void storeCertificate(PrivateKey privateKey, X509Certificate[] certificateChain, boolean useCoreKeystore) throws Exception {
        CoreKeyStore unsignedKeyStore;
        Optional<BPassword> pwd;
        Optional<BPassword> certificatePassword;
        X509Certificate existingCert;
        CoreKeyStore keyStore = (CoreKeyStore)BAbstractSigningRequester.getKeyStore(useCoreKeystore);
        X509Certificate[] sortedChain = CertUtils.sortCertChain(Arrays.asList(certificateChain)).toArray(EMPTY_CERT_ARRAY);
        String alias = this.getRequesterComponent().getCertAlias();
        if (useCoreKeystore && (existingCert = keyStore.getCertificate(alias)) != null && !existingCert.getPublicKey().equals(sortedChain[0].getPublicKey())) {
            boolean illegalOverwriteAttempt = true;
            if (this.getRequesterComponent().allowExistingCertReplacement()) {
                certificatePassword = this.getRequesterComponent().getCertificatePassword();
                if (certificatePassword.isPresent()) {
                    try {
                        try (SecretChars secretChars = ((BPassword)certificatePassword.get()).getSecretChars();){
                            keyStore.getKey(alias, secretChars.get());
                        }
                        illegalOverwriteAttempt = false;
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        keyStore.getKey(alias, null);
                        illegalOverwriteAttempt = false;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (illegalOverwriteAttempt) {
                throw new LocalizableException("platCrypto", "signingRequester.certificateOverwriteAttempt", new Object[]{alias});
            }
        }
        if ((pwd = this.getRequesterComponent().getCertificatePassword()).isPresent()) {
            SecretChars secretChars = pwd.get().getSecretChars();
            certificatePassword = null;
            try {
                keyStore.setKeyEntry(alias, (Key)privateKey, secretChars.get(), sortedChain, false);
            }
            catch (Throwable throwable) {
                certificatePassword = throwable;
                throw throwable;
            }
            finally {
                if (secretChars != null) {
                    if (certificatePassword != null) {
                        try {
                            secretChars.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)certificatePassword)).addSuppressed(throwable);
                        }
                    } else {
                        secretChars.close();
                    }
                }
            }
        } else {
            keyStore.setKeyEntry(alias, (Key)privateKey, null, sortedChain, false);
        }
        keyStore.save();
        this.updateAdvanceRenewal(useCoreKeystore);
        boolean unsignedKeystoreExists = BAbstractSigningRequester.getUnsignedKeystoreFile(false).exists();
        if (useCoreKeystore && unsignedKeystoreExists && (unsignedKeyStore = (CoreKeyStore)BAbstractSigningRequester.getKeyStore(false)) != null && unsignedKeyStore.containsAlias(alias)) {
            unsignedKeyStore.deleteEntry(alias);
            unsignedKeyStore.save();
        }
        if (unsignedKeystoreExists) {
            this.doPurgeExpiredUnsignedCerts();
        }
    }

    private ScheduledExecutorService createExecutorService() {
        return ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)EXECUTOR_THREAD_NAME_PREFIX, (long)this.getExecutorKeepAlive(), (TimeUnit)TimeUnit.MILLISECONDS, (boolean)true);
    }

    private long getExecutorKeepAlive() {
        return Math.max(this.approvalCheckRetryDelay, this.signingResultsCheckRetryDelay) + 1000L;
    }

    private void initRequesterState() {
        LOG.fine("Checking initial requester state: " + (Object)((Object)this.getRequesterState()));
        switch (this.getRequesterState().getOrdinal()) {
            case 1: {
                this.getExecutorService().submit(new CheckOnboardingApproval(this, null));
                return;
            }
            case 2: 
            case 3: {
                if (this.getCertificate(false).isPresent() || this.getCertificate(true).isPresent()) {
                    boolean renewal = this.hasSignedCertificate();
                    this.getExecutorService().submit(new GetSigningResult(this, renewal, null));
                } else {
                    LOG.warning("No certificate available, resetting requester state to notOnboarded");
                    this.setRequesterState(BRequesterState.notOnboarded);
                    this.fail(LEX.getText("signingRequester.noCertificateResettingState"));
                }
                return;
            }
            case 4: 
            case 5: {
                if (!this.getCertificate(true).isPresent()) {
                    LOG.warning("No certificate available, resetting requester state to notOnboarded");
                    this.setRequesterState(BRequesterState.notOnboarded);
                    this.fail(LEX.getText("signingRequester.noCertificateResettingState"));
                } else {
                    this.scheduleRenewalCheck();
                }
                return;
            }
        }
    }

    private void updateAdvanceRenewal(boolean useCoreKeystore) {
        BRelTime validity = this.getCertificateValidity(useCoreKeystore);
        long backoff = Math.round((double)(validity.getMillis() * (long)this.getAdvanceRenewalPercent()) * 0.01);
        this.setAdvanceRenewal(BRelTime.make((long)backoff));
        if (this.renewalCheck != null) {
            this.renewalCheck.cancel();
            this.setNextRenewalAttempt(BAbsTime.NULL);
        }
    }

    PrivateKey getPrivateKey(boolean useCoreKeystore) throws Exception {
        Key key;
        try {
            key = AccessController.doPrivileged(() -> {
                Optional<BPassword> pwd = this.getRequesterComponent().getCertificatePassword();
                if (pwd.isPresent()) {
                    try (SecretChars secretChars = pwd.get().getSecretChars();){
                        Key key = BAbstractSigningRequester.getKeyStore(useCoreKeystore).getKey(this.getRequesterComponent().getCertAlias(), secretChars.get());
                        return key;
                    }
                }
                return BAbstractSigningRequester.getKeyStore(useCoreKeystore).getKey(this.getRequesterComponent().getCertAlias(), null);
            });
        }
        catch (Throwable t) {
            throw new LocalizableException("platCrypto", "signingRequester.certificateOverwriteAttempt", new Object[]{this.getRequesterComponent().getCertAlias()});
        }
        if (!(key instanceof PrivateKey)) {
            throw new SecurityException("not private key");
        }
        return (PrivateKey)key;
    }

    Optional<X509Certificate> getCertificate(boolean useCoreKeystore) {
        try {
            return Optional.ofNullable(AccessController.doPrivileged(() -> BAbstractSigningRequester.getKeyStore(useCoreKeystore).getCertificate(this.getRequesterComponent().getCertAlias())));
        }
        catch (PrivilegedActionException e) {
            LOG.log(Level.FINEST, "Unable to access KeyStore", e);
            return Optional.empty();
        }
    }

    public static ICoreKeyStore getKeyStore(boolean useCoreKeystore) {
        if (useCoreKeystore) {
            return CoreCryptoManager.get().getKeyStore();
        }
        CoreKeyStore unsignedKeyStore = UnsignedKeyStoreHolder.UNSIGNED_KEY_STORE;
        if (unsignedKeyStore != null) {
            try {
                AccessController.doPrivileged(() -> {
                    if (!BAbstractSigningRequester.getUnsignedKeystoreFile(true).exists()) {
                        unsignedKeyStore.load();
                    }
                    return null;
                });
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not load Keystore for Signing Requester Onboarding. Onboarding may not function.", e);
            }
        }
        return unsignedKeyStore;
    }

    private boolean hasSignedCertificate() {
        return this.getCertificate(true).filter(x509Certificate -> !NX509Certificate.make((X509Certificate)x509Certificate).isSelfSigned()).isPresent();
    }

    BAbsTime getCertificateExpiration(boolean useCoreKeystore) {
        Optional<X509Certificate> cert = this.getCertificate(useCoreKeystore);
        if (cert.isPresent()) {
            return BAbsTime.make((long)cert.get().getNotAfter().getTime());
        }
        return BAbsTime.DEFAULT;
    }

    private BRelTime getCertificateValidity(boolean useCoreKeystore) {
        Optional<X509Certificate> cert = this.getCertificate(useCoreKeystore);
        if (cert.isPresent()) {
            long validityPeriod = cert.get().getNotAfter().getTime() - cert.get().getNotBefore().getTime();
            return BRelTime.make((long)validityPeriod);
        }
        return BRelTime.DEFAULT;
    }

    private void schedulePurgeExpiredUnsignedCerts(BAbsTime purgeDate) {
        if (this.purgeTicket != null && !this.purgeTicket.isExpired()) {
            this.purgeTicket.cancel();
        }
        this.purgeTicket = null;
        if (purgeDate != null) {
            BAbsTime minFutureTimeToPurge = BAbsTime.now().add(BRelTime.MINUTE);
            if (purgeDate.getMillis() < minFutureTimeToPurge.getMillis()) {
                purgeDate = minFutureTimeToPurge;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Scheduled next purge expired unsigned certs at %s", purgeDate));
            }
            this.purgeTicket = Clock.schedule((BComponent)this, (BAbsTime)purgeDate, (Action)purgeExpiredUnsignedCerts, null);
        }
    }

    private void shutdownExecutorService() {
        AccessController.doPrivileged(() -> {
            if (Sys.getStation() != null && !Sys.getStation().isRunning()) {
                ExecutorUtil.shutdown((ExecutorService)this.executorService);
            } else {
                this.executorService.shutdownNow();
            }
            return null;
        });
    }

    private static File getUnsignedKeystoreFile(boolean createDir) throws Exception {
        if (createDir) {
            AccessController.doPrivileged(() -> {
                BFileSystem.INSTANCE.makeDir(UNSIGNED_KEY_STORE_DIRECTORY);
                return null;
            });
        }
        return CoreCryptoManager.getStoreFile((File)BFileSystem.INSTANCE.pathToLocalFile(UNSIGNED_KEY_STORE_DIRECTORY), (String)UNSIGNED_KEY_STORE_NAME);
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = this.processAlarmAck(ackRequest);
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(platCrypto:signingRequester.alarmFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(platCrypto:signingRequester.alarmSuccess)%"));
        return asi;
    }

    private BBoolean processAlarmAck(BAlarmRecord ackRequest) {
        try {
            return BBoolean.make((boolean)this.alarmSupport.ackAlarm(ackRequest));
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to ack alarm for " + this.getAlarmSourceInfo().toPathString(), e);
            }
            return BBoolean.FALSE;
        }
    }

    private void processAlarmNormal() {
        block2: {
            try {
                this.alarmSupport.toNormal(null);
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "Failed to send toNormal alarm for " + this.getAlarmSourceInfo().toPathString(), e);
            }
        }
    }

    private boolean processAlarmOffNormal(String reason) {
        boolean ackRequired;
        block3: {
            ackRequired = false;
            try {
                ackRequired = this.alarmSupport.isAckRequired(BSourceState.offnormal);
                BFacets alarmData = this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                String msgText = alarmData.gets("msgText", "");
                alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
                BOrd navOrd = this.getNavOrd();
                if (alarmData.get("hyperlinkOrd") == null && navOrd != null) {
                    alarmData = BFacets.make((BFacets)alarmData, (String)"hyperlinkOrd", (BIDataValue)BString.make((String)navOrd.relativizeToSession().toString()));
                }
                this.alarmSupport.newOffnormalAlarm(alarmData);
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "Failed to send offNormal alarm for " + this.getAlarmSourceInfo().toPathString(), e);
            }
        }
        return ackRequired;
    }

    public void spy(SpyWriter out) throws Exception {
        if (Sys.isStation() && AccessController.doPrivileged(() -> BAbstractSigningRequester.getUnsignedKeystoreFile(false).exists()).booleanValue()) {
            out.startProps("Unsigned Signing Requester Keystore (stores temporary certs during onboarding)");
            out.startTable(true);
            out.w((Object)"<tr>");
            out.thTitle((Object)"Alias");
            out.thTitle((Object)"Subject");
            out.thTitle((Object)"Not After");
            out.thTitle((Object)"Key Algorithm");
            out.thTitle((Object)"Key Size");
            out.thTitle((Object)"Valid");
            out.thTitle((Object)"Issued By");
            out.thTitle((Object)"Not Before");
            out.thTitle((Object)"Signature Algorithm");
            out.thTitle((Object)"Signature Size");
            out.thTitle((Object)"Self Signed");
            out.w((Object)"</tr>");
            try {
                ICoreKeyStore keyStore = BAbstractSigningRequester.getKeyStore(false);
                Iterable certificateEntries = keyStore.getCertificateEntries();
                certificateEntries.forEach(certificateEntry -> {
                    out.tr();
                    out.td((Object)certificateEntry.getAlias());
                    IX509Certificate cert = certificateEntry.getCertificate(0);
                    out.td((Object)cert.getSubject());
                    out.td((Object)cert.getNotAfter());
                    out.td((Object)cert.getKeyAlgorithm());
                    out.td((Object)cert.getKeySize());
                    out.td((Object)cert.checkValidity());
                    out.td((Object)cert.getIssuer());
                    out.td((Object)cert.getNotBefore());
                    out.td((Object)cert.getSignatureAlgorithm());
                    out.td((Object)cert.getSignatureSize());
                    out.td((Object)cert.isSelfSigned());
                    out.endTr();
                });
            }
            catch (Throwable t) {
                out.trTitle((Object)("Failed to spy on the Unsigned Signing Requester Keystore: " + t.getMessage()), 11);
            }
            out.endTable();
            out.endProps();
        }
        super.spy(out);
    }

    private static class UnsignedKeyStore
    extends CoreKeyStore {
        public UnsignedKeyStore() throws Exception {
            super((ICoreCryptoManager)CoreCryptoManager.get(), BAbstractSigningRequester.getUnsignedKeystoreFile(true), SecurityInitializer.getInstance().getSecurityInfoProvider(), BAbstractSigningRequester.UNSIGNED_KEY_STORE_KEY_RING_NAME, SecurityInitializer.getInstance().getCryptoProvider().getDefaultKeyStoreType(), BAbstractSigningRequester.UNSIGNED_KEY_STORE_NAME);
            this.isReadOnly = false;
        }
    }

    private static final class UnsignedKeyStoreHolder {
        static final CoreKeyStore UNSIGNED_KEY_STORE;

        private UnsignedKeyStoreHolder() {
        }

        static {
            CoreKeyStore unsignedKeyStore = null;
            try {
                unsignedKeyStore = AccessController.doPrivileged(() -> new UnsignedKeyStore());
            }
            catch (Exception e) {
                try {
                    unsignedKeyStore = AccessController.doPrivileged(() -> {
                        File existingFile = BAbstractSigningRequester.getUnsignedKeystoreFile(false);
                        if (existingFile.exists() && !existingFile.delete()) {
                            LOG.warning("Failed to remove existing unsigned certificate keystore: " + existingFile.getAbsolutePath());
                        }
                        return new UnsignedKeyStore();
                    });
                    LOG.log(Level.FINE, "Re-created Keystore for Signing Requester Onboarding due to the following error: ", e);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Could not initialize Keystore for Signing Requester Onboarding. Onboarding will not function.", ex);
                }
            }
            UNSIGNED_KEY_STORE = unsignedKeyStore;
        }
    }
}

