/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import com.tridium.platcrypto.signing.CertificateParameterType;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.util.CompUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.jetbrains.annotations.NotNull;

@NiagaraType
@NiagaraProperty(name="parameterType", type="String", defaultValue="DN")
public class BCertificateParameter
extends BComponent
implements Comparable<BCertificateParameter> {
    @Generated
    public static final Property parameterType = BCertificateParameter.newProperty((int)0, (String)"DN", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateParameter.class);
    static final String VALUE = "value";
    static final String COMMON_NAME = "commonName";
    static final Pattern CN_PATTERN = Pattern.compile("([Cc][Nn])\\s*=\\s*([^,]+)");

    @Generated
    public String getParameterType() {
        return this.getString(parameterType);
    }

    @Generated
    public void setParameterType(String v) {
        this.setString(parameterType, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof IRequesterComponent || SigningProfileTypeInfoHolder.ABSTRACT_SIGNING_PROFILE_TYPE != null && parent.getType().is(SigningProfileTypeInfoHolder.ABSTRACT_SIGNING_PROFILE_TYPE);
    }

    public static BCertificateParameter make(CertificateParameterType type, BValue value) {
        BCertificateParameter parameter = new BCertificateParameter();
        parameter.setParameterType(type.name());
        parameter.setValue(value);
        return parameter;
    }

    public final void setValue(BValue value) {
        CompUtil.setOrAdd((BComponent)this, (String)VALUE, (BValue)value, null);
    }

    public final BValue getValue() {
        return this.get(VALUE);
    }

    public final void resolve(Object obj, Context cx) {
        String cn;
        BValue resolved;
        if (this.isResolvable() && (resolved = this.doResolve(obj, cx)) != null) {
            this.setValue(resolved);
        }
        if (this.maySupplyCommonName() && (cn = this.supplyCommonName()) != null && cx instanceof BaseSigningRequesterTask.AppendableFacetsContext) {
            ((BaseSigningRequesterTask.AppendableFacetsContext)cx).addFacet(COMMON_NAME, (BIDataValue)BString.make((String)cn));
        }
    }

    protected BValue doResolve(Object obj, Context cx) {
        return null;
    }

    public boolean isResolvable() {
        return false;
    }

    public boolean maySupplyCommonName() {
        return this.getParameterType().equals(CertificateParameterType.DN.toString()) && this.getValue() != null && this.getValue().toString().toUpperCase().contains("CN");
    }

    public String supplyCommonName() {
        String cn;
        Matcher matcher;
        if (this.getParameterType().equals(CertificateParameterType.DN.toString()) && this.getValue() != null && (matcher = CN_PATTERN.matcher(this.getValue().toString())).find() && (cn = matcher.group(2)) != null) {
            return cn;
        }
        return null;
    }

    public BCertificateParameter getNewInstanceForCsrGeneration(Context context) {
        return (BCertificateParameter)this.newCopy();
    }

    public boolean equivalent(Object obj) {
        return obj instanceof BCertificateParameter && ((BCertificateParameter)obj).getParameterType().equals(this.getParameterType());
    }

    @Override
    public int compareTo(@NotNull BCertificateParameter o) {
        boolean cn = this.maySupplyCommonName();
        boolean otherCn = o.maySupplyCommonName();
        return cn && !otherCn ? -1 : (cn == otherCn ? 0 : 1);
    }

    private static final class SigningProfileTypeInfoHolder {
        static final TypeInfo ABSTRACT_SIGNING_PROFILE_TYPE;

        private SigningProfileTypeInfoHolder() {
        }

        static {
            TypeInfo abstractSigningProfileType;
            try {
                abstractSigningProfileType = Sys.getType((String)"signingService:AbstractSigningProfile").getTypeInfo();
            }
            catch (Exception e) {
                abstractSigningProfileType = null;
            }
            ABSTRACT_SIGNING_PROFILE_TYPE = abstractSigningProfileType;
        }
    }
}

