/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.web;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.NEcdsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.cert.NX509CertificateBuilderBundle;
import com.tridium.crypto.core.cert.PrivateKeyDecryptionException;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CoreKeyStore;
import com.tridium.crypto.core.io.CoreTrustStore;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.web.CertificateManagementRpcException;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.nre.function.SupplierCanThrowException;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.util.LexiconModule;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

@NiagaraType
public class BCertificateManagementRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateManagementRpc.class);
    private static final String PLAT_CRYPTO = "platCrypto";
    private static final LexiconModule LEX = LexiconModule.make((String)"platCrypto");
    private static final Logger LOG = Logger.getLogger("crypto.certManagement");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static JSONObject getCertStoreData(String storeType, Context context) throws LocalizableException {
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        if (storeType == null || storeType.isEmpty()) {
            LOG.fine("The 'storeType' parameter is missing. It should be one of: userKeyStore, userTrustStore, systemTrustStore, userExemptionStore.");
            throw new CertificateManagementRpcException(0);
        }
        try {
            CryptoStoreId cryptoStoreId = CryptoStoreId.getEnum((String)storeType);
            switch (cryptoStoreId) {
                case USER_KEY_STORE: {
                    return BCertificateManagementRpc.getCertStoreJSON((ICoreTrustStore)CoreCryptoManager.get().getKeyStore(), context);
                }
                case USER_TRUST_STORE: {
                    return BCertificateManagementRpc.getCertStoreJSON(CoreCryptoManager.get().getUserTrustStore(), context);
                }
                case SYSTEM_TRUST_STORE: {
                    return BCertificateManagementRpc.getCertStoreJSON(CoreCryptoManager.get().getSystemTrustStore(), context);
                }
                case USER_EXEMPTION_STORE: {
                    return BCertificateManagementRpc.getExemptionStoreJSON(context);
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.fine("The supplied 'storeType' parameter is invalid. It should be one of: userKeyStore, userTrustStore, systemTrustStore, userExemptionStore.");
            throw new CertificateManagementRpcException(2);
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not get store data", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.getCertStoreData.error.failed", new Object[]{storeType}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)}, isSecure=true)
    public static JSONObject parsePemFile(String pemFile, String storeType, Context context) throws LocalizableException {
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        ICoreTrustStore coreStore = BCertificateManagementRpc.getCertStore(storeType, EnumSet.of(CryptoStoreId.USER_TRUST_STORE, CryptoStoreId.USER_KEY_STORE), context);
        if (coreStore.getClass() == CoreKeyStore.class) {
            return BCertificateManagementRpc.parsePemFileForUserKeyStore(pemFile);
        }
        if (coreStore.getClass() == CoreTrustStore.class) {
            return BCertificateManagementRpc.parsePemFileForUserTrustStore(pemFile);
        }
        return new JSONObject();
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static void importCertificate(Map<String, Object> params, Context context) throws Exception {
        String storeType = (String)params.get("storeType");
        ICoreTrustStore coreStore = BCertificateManagementRpc.getCertStore(storeType, EnumSet.of(CryptoStoreId.USER_TRUST_STORE, CryptoStoreId.USER_KEY_STORE), context);
        if (CryptoStoreId.getEnum((String)storeType).equals((Object)CryptoStoreId.USER_TRUST_STORE)) {
            BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.userTrustStore.importCommand", context), context);
        } else {
            BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminInvoke, context);
        }
        JSONArray certificatesJSON = new JSONArray((Collection)((List)params.get("certificates")));
        if (coreStore.getClass() == CoreKeyStore.class) {
            String jsonDecryptPassword = (String)params.get("passwordToDecryptKey");
            String storeKeyDecryptPassword = (String)params.get("keyStorePassword");
            Boolean useGlobal = (Boolean)params.getOrDefault("useGlobalPassword", Boolean.FALSE);
            String passwordToEncryptKey = (String)params.get("passwordToEncryptKey");
            if (!useGlobal.booleanValue() && passwordToEncryptKey == null) {
                throw new CertificateManagementRpcException(3);
            }
            String encryptPassword = useGlobal != false ? null : passwordToEncryptKey;
            ICoreKeyStore keyStore = (ICoreKeyStore)coreStore;
            JSONObject privateKeyJSON = new JSONObject((Map)params.get("privateKey"));
            BCertificateManagementRpc.runDoPrivileged(() -> BCertificateManagementRpc.importToUserKeyStore(keyStore, jsonDecryptPassword, storeKeyDecryptPassword, encryptPassword, privateKeyJSON, certificatesJSON, context));
        } else if (coreStore.getClass() == CoreTrustStore.class) {
            BCertificateManagementRpc.runDoPrivileged(() -> BCertificateManagementRpc.importToUserTrustStore(coreStore, certificatesJSON, context));
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static String exportCertificate(String storeType, String alias, boolean exportCert, boolean exportPrivateKey, boolean encryptPrivateKey, String decryptPassword, String encryptPassword, String exportFormat, Context context) throws Exception {
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        return (String)BCertificateManagementRpc.runDoPrivileged(() -> BCertificateManagementRpc.doExportCertificate(storeType, alias, exportCert, exportPrivateKey, encryptPrivateKey, decryptPassword, encryptPassword, exportFormat, context));
    }

    private static String doExportCertificate(String storeType, String alias, boolean exportCert, boolean exportPrivateKey, boolean encryptPrivateKey, String decryptPassword, String encryptPassword, String exportFormat, Context context) throws Exception {
        if (exportPrivateKey && encryptPrivateKey && (encryptPassword == null || encryptPassword.isEmpty())) {
            LOG.fine("The 'encryptPassword' parameter is required when exporting the private key.");
            throw new CertificateManagementRpcException(3);
        }
        ICoreTrustStore coreStore = BCertificateManagementRpc.getCertStore(storeType, EnumSet.of(CryptoStoreId.USER_TRUST_STORE, CryptoStoreId.USER_KEY_STORE, CryptoStoreId.SYSTEM_TRUST_STORE), context);
        BCertificateManagementRpc.verifyAliasExists(alias, coreStore);
        if (exportPrivateKey && coreStore instanceof ICoreKeyStore) {
            BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, BCertificateManagementRpc.getCoreKeyStore(), decryptPassword);
        }
        PrivateKey privateKey = null;
        if (exportPrivateKey && !coreStore.isKeyEntry(alias)) {
            LOG.fine("The provided alias is not a key entry, so the private key cannot be exported.");
            throw new CertificateManagementRpcException(4);
        }
        if (exportPrivateKey) {
            privateKey = (PrivateKey)((ICoreKeyStore)coreStore).getKey(alias, decryptPassword == null ? null : decryptPassword.toCharArray());
        }
        try {
            BICertificateFormatHandler certFormatHandler = BICertificateFormatHandler.getHandlerFromFormatName(exportFormat, context);
            if (certFormatHandler == null) {
                certFormatHandler = BPEMCertificateHandler.INSTANCE;
            }
            X509Certificate[] certChain = BCertificateManagementRpc.getCertificateChain(alias, coreStore);
            if (exportPrivateKey && exportCert) {
                return certFormatHandler.writeCertAndKey(privateKey, encryptPrivateKey, BPassword.make((String)encryptPassword), certChain);
            }
            if (exportPrivateKey) {
                return certFormatHandler.writeKey(privateKey, encryptPrivateKey, BPassword.make((String)encryptPassword));
            }
            if (exportCert) {
                return certFormatHandler.writeCert(certChain);
            }
        }
        catch (UnsupportedOperationException e) {
            BCertificateManagementRpc.log(Level.WARNING, "Unsupported export format.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.exportCertificate.error.unsupportedOperation", (Object[])new String[]{alias}, (Throwable)e);
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not export certificate.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.exportCertificate.error.internalServerError", (Object[])new String[]{alias}, (Throwable)e);
        }
        return "";
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static void deleteCertificate(String storeType, String alias, String decryptPassword, Context context) throws LocalizableException {
        ICoreTrustStore coreStore = BCertificateManagementRpc.getCertStore(storeType, EnumSet.of(CryptoStoreId.USER_TRUST_STORE, CryptoStoreId.USER_KEY_STORE), context);
        BCertificateManagementRpc.verifyAliasExists(alias, coreStore);
        if (CryptoStoreId.getEnum((String)storeType).equals((Object)CryptoStoreId.USER_TRUST_STORE)) {
            BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.userTrustStore.deleteCommand", context), context);
        } else {
            BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminInvoke, context);
        }
        if (coreStore instanceof ICoreKeyStore) {
            if ("default".equalsIgnoreCase(alias)) {
                throw new LocalizableException(PLAT_CRYPTO, "certRpc.deleteCertificate.error.defaultAlias", (Object[])new String[]{"default"});
            }
            try {
                BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.userTrustStore.deleteCommand", context), context);
            }
            catch (Exception e) {
                BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, BCertificateManagementRpc.getCoreKeyStore(), decryptPassword);
            }
        }
        try {
            BCertificateManagementRpc.runDoPrivileged(() -> {
                coreStore.deleteEntry(alias);
                coreStore.save();
                return null;
            });
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not delete certificate.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.deleteCertificate.error.deleteFailed", (Object[])new String[]{alias}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static int generateCertificate(String builderBundleJSON, Context context) throws LocalizableException {
        NKeyPairGenerator keyPairGenerator;
        SecretChars password;
        NX509CertificateBuilder builder;
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminInvoke, context);
        if (builderBundleJSON == null || builderBundleJSON.isEmpty()) {
            LOG.warning("The 'builderBundleJSON' parameter is empty or null.");
            throw new CertificateManagementRpcException(6);
        }
        try {
            JSONObject object;
            NX509CertificateBuilderBundle builderBundle = NX509CertificateBuilderBundle.decodeFromString((String)builderBundleJSON);
            builder = builderBundle.getBuilder();
            password = builderBundle.getPassword();
            keyPairGenerator = builderBundle.getGenerator();
            SecretChars keyStorePassword = builder.getKeyStorePassword();
            String alias = builder.getAlias();
            if ("default".equalsIgnoreCase(alias)) {
                LOG.warning("Cannot generate a certificate with the 'default' alias.");
                throw new LocalizableException(PLAT_CRYPTO, "certRpc.generateCertificate.error.defaultAlias", (Object[])new String[]{"default"});
            }
            ICoreKeyStore keyStore = CoreCryptoManager.get().getKeyStore();
            try {
                boolean isPasswordRequired;
                boolean existingAlias;
                boolean bl = existingAlias = alias != null ? (Boolean)BCertificateManagementRpc.runDoPrivileged(() -> keyStore.containsAlias(alias)) : false;
                if (existingAlias && (isPasswordRequired = BCertificateManagementRpc.isPasswordRequired(alias, null))) {
                    try {
                        BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.userTrustStore.generateCommand", context), context);
                    }
                    catch (Exception e) {
                        if (keyStorePassword == null) {
                            LOG.warning(LEX.getText("certRpc.generateCertificate.error.nullPasswordForExistingAlias", context, new Object[]{alias}));
                            throw new LocalizableException(PLAT_CRYPTO, "certRpc.generateCertificate.error.nullPasswordForExistingAlias", (Object[])new String[]{alias}, (Throwable)e);
                        }
                        BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, keyStore, String.valueOf(keyStorePassword.get()));
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof LocalizableException) {
                    throw (LocalizableException)e;
                }
                throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.generateCertificate.error.certGenFailed", (Throwable)e);
            }
            AtomicReference<Localizable> messageReference = new AtomicReference<Localizable>();
            if (password != null && password.size() > 0 && !BCertificateManagementRpc.isValidPasswordFormat(String.valueOf(password.get()), messageReference)) {
                LOG.warning(LEX.getText("certRpc.error.invalidPasswordFormat", context, new Object[]{messageReference.get().toString(context)}));
                throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.invalidPasswordFormat", (Object[])new String[]{messageReference.get().toString(context)});
            }
            if ((password == null || password.size() == 0) && (object = new JSONObject(builder.encodeToString())).has("extensions")) {
                JSONArray extensions = object.getJSONArray("extensions");
                for (int i = 0; i < extensions.length(); ++i) {
                    JSONObject extensionJson = extensions.getJSONObject(i);
                    String oid = extensionJson.getString("oid");
                    JSONObject value = extensionJson.getJSONObject("value");
                    if (!oid.equals("2.5.29.19") || !value.getBoolean("isCA")) continue;
                    LOG.warning(LEX.get("certRpc.generateCertificate.error.nullPasswordForCACert", context));
                    throw new LocalizableException(PLAT_CRYPTO, "certRpc.generateCertificate.error.nullPasswordForCACert");
                }
            }
        }
        catch (CertificateParseException e) {
            BCertificateManagementRpc.log(Level.WARNING, "Parsing error during generate certificate.", e);
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.certParsing", new Object[]{BCertificateManagementRpc.localizeFieldName(e.getFieldName(), context), e.getFieldValue()}, (Throwable)e);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "The 'builderBundleJSON' parameter is invalid: \n", e);
            throw new CertificateManagementRpcException(7);
        }
        if (keyPairGenerator == null) {
            LOG.warning("The 'builderBundleJSON' parameter does not contain a key generator.");
            throw new CertificateManagementRpcException(8);
        }
        try {
            int requestId = (Integer)BCertificateManagementRpc.runDoPrivileged(() -> CoreCryptoManager.get().generateSelfSignedCert(builder, keyPairGenerator, password));
            BCertificateManagementRpc.audit("Certificate generation", "Enqueued a request to generate a certificate with alias: " + builder.getAlias());
            return requestId;
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not generate certificate.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.generateCertificate.error.certGenFailed", (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static int checkRequestStatus(double requestId, Context context) {
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        return CoreCryptoManager.get().getCertGenerationStatus((int)requestId);
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static String generateCSR(String alias, String decryptPassword, Context context) throws LocalizableException {
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminInvoke, context);
        ICoreKeyStore keyStore = BCertificateManagementRpc.getCoreKeyStore();
        BCertificateManagementRpc.verifyAliasExists(alias, (ICoreTrustStore)keyStore);
        BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, keyStore, decryptPassword);
        try {
            NPKCS10CertificationRequest csr = CoreCryptoManager.get().generateCSR(alias, decryptPassword);
            return csr.encodeToString();
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not generate CSR.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.generateCSR.error.csrGenFailed", (Object[])new String[]{alias}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static int resetKeyStore(Context context) {
        BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.userTrustStore.resetCommand", context), context);
        try {
            BCertificateManagementRpc.audit("User Key Store reset", "Reset the User Key Store");
            int requestId = (Integer)BCertificateManagementRpc.runDoPrivileged(() -> CoreCryptoManager.get().resetUserKeyStore());
            if (requestId == -1) {
                throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.resetKeyStore.error.generate");
            }
            return requestId;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.resetKeyStore.error.delete", (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static void setExemption(String hostPortKey, boolean isApproved, boolean changeApproved, Context cx) throws LocalizableException {
        if (isApproved) {
            BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.exemptionStore.approveCommand", cx), cx);
        } else {
            BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.exemptionStore.unapproveCommand", cx), cx);
        }
        if (hostPortKey == null || hostPortKey.isEmpty()) {
            LOG.fine("Missing 'hostPortKey' parameter.");
            throw new CertificateManagementRpcException(9);
        }
        ICoreExemptionStore mgr = CoreCryptoManager.get().getExemptionStore();
        BCertificateManagementRpc.validateHostPortKey(hostPortKey, mgr);
        try {
            NHostExemption exemption = mgr.getExemption(hostPortKey);
            exemption.setApproved(isApproved);
            if (isApproved && changeApproved && exemption.getChanged() != null) {
                exemption.approveChanged();
            }
            mgr.setExemption(exemption);
            mgr.save();
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not set exemption.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.setExemption.error.setExemptionFailed", (Object[])new String[]{hostPortKey}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static void deleteExemption(String hostPortKey, Context cx) throws LocalizableException {
        BCertificateManagementRpc.verifyHasSuperUserPermissions(LEX.getText("cert.exemptionStore.deleteCommand", cx), cx);
        if (hostPortKey == null || hostPortKey.isEmpty()) {
            LOG.fine("Missing 'hostPortKey' parameter.");
            throw new CertificateManagementRpcException(9);
        }
        ICoreExemptionStore mgr = CoreCryptoManager.get().getExemptionStore();
        BCertificateManagementRpc.validateHostPortKey(hostPortKey, mgr);
        try {
            mgr.deleteExemption(hostPortKey);
            mgr.save();
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not delete exemption.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.deleteExemption.error.deleteExemptionFailed", (Object[])new String[]{hostPortKey}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static boolean isPasswordRequired(String alias, Context context) throws LocalizableException {
        ICoreKeyStore keyStore = BCertificateManagementRpc.getCoreKeyStore();
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        BCertificateManagementRpc.verifyAliasExists(alias, (ICoreTrustStore)keyStore);
        try {
            return BCertificateManagementRpc.keyRequiresPassword(alias, keyStore);
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, LEX.getText("certRpc.error.passwordCheck", context, new Object[]{alias}), e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.error.passwordCheck", (Object[])new String[]{alias}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static boolean isKeyStorePasswordValid(String alias, String password, Context context) throws LocalizableException {
        ICoreKeyStore coreKeyStore = BCertificateManagementRpc.getCoreKeyStore();
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        BCertificateManagementRpc.verifyAliasExists(alias, (ICoreTrustStore)coreKeyStore);
        try {
            BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, coreKeyStore, password);
            return true;
        }
        catch (CouldNotDecryptPrivateKeyException e) {
            return false;
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, LEX.getText("certRpc.error.passwordCheck", context, new Object[]{alias}), e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.error.passwordCheck", (Object[])new String[]{alias}, (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static boolean isParsedPemPasswordValid(Map<String, Object> parsedPem, String password, Context context) throws LocalizableException {
        String keyPEMString;
        BCertificateManagementRpc.verifyHasPermissionsOnCertManagerService(BPermissions.adminRead, context);
        JSONObject pemJSON = new JSONObject(parsedPem);
        try {
            keyPEMString = ((JSONObject)pemJSON.get("privateKey")).getString("privateKey");
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "The supplied parsed PEM did not contain a private key.", e);
            throw new CertificateManagementRpcException(10);
        }
        try {
            BCertificateManagementRpc.runDoPrivileged(() -> {
                CertUtils.parsePrivateKey((String)keyPEMString, (String)password);
                return null;
            });
            return true;
        }
        catch (PrivateKeyDecryptionException e) {
            if (e.getCauseCode() == 2) {
                return false;
            }
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.isParsedPemPasswordValid.error", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.fine("The supplied parsed PEM did not contain a private key.");
            throw new CertificateManagementRpcException(1);
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not resolve the private key", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.isParsedPemPasswordValid.error", (Throwable)e);
        }
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static int getDefaultRsaKeySize(Context context) {
        return 2048;
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static JSONArray getSupportedRsaKeySizes(Context context) {
        JSONArray supportedRsaKeySizes = new JSONArray();
        Iterator iterator = NRsaKeyPairGenerator.RSA_KEYSIZE_SET.iterator();
        while (iterator.hasNext()) {
            int keySize = (Integer)iterator.next();
            supportedRsaKeySizes.put(keySize);
        }
        return supportedRsaKeySizes;
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static String getDefaultECKeySpec(Context context) {
        return "P-256";
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static JSONArray getSupportedECKeySpecs(Context context) {
        JSONArray supportedKeySpecs = new JSONArray();
        for (String keySpec : NEcdsaKeyPairGenerator.ECDSA_KEYSPEC_SET) {
            supportedKeySpecs.put((Object)keySpec);
        }
        return supportedKeySpecs;
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static JSONArray getSupportedKeyAlgorithms(Context context) {
        JSONArray supportedKeyAlgorithms = new JSONArray();
        supportedKeyAlgorithms.put((Object)"RSA");
        supportedKeyAlgorithms.put((Object)"EC");
        return supportedKeyAlgorithms;
    }

    @NiagaraRpc(permissions="unrestricted", isSecure=true, transports={@Transport(type=TransportType.box)})
    public static JSONObject getSupportedExportFormats(Context context) {
        JSONObject supportedExportFormats = new JSONObject();
        supportedExportFormats.put("defaultExportFormat", (Object)BPEMCertificateHandler.INSTANCE.getCertificateFormatName(context));
        for (BICertificateFormatHandler handler : BICertificateFormatHandler.getCertificateFormatHandlers()) {
            JSONObject handlerJSON = new JSONObject();
            handlerJSON.put("exportFormatName", (Object)handler.getCertificateFormatName(context));
            handlerJSON.put("supportsPrivateKey", handler.supportsPrivateKey());
            handlerJSON.put("supportedFileExtensions", handler.getSupportedFileExtensions());
            handlerJSON.put("defaultFileExtension", (Object)handler.getDefaultFileExtension());
            handlerJSON.put("fileTypeName", (Object)handler.getCertificateFormatFileTypeName(context));
            handlerJSON.put("mimeType", (Object)handler.getMimeType());
            supportedExportFormats.append("supportedExportFormats", (Object)handlerJSON);
        }
        return supportedExportFormats;
    }

    private static void verifyHasPermissionsOnCertManagerService(BPermissions permissions, Context context) {
        if (!Sys.isStation()) {
            return;
        }
        BCertManagerService certManagerService = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
        if (certManagerService != null && authenticatedUser != null) {
            BPermissions actualPermissions = authenticatedUser.getPermissionsFor((BIProtected)certManagerService);
            if (actualPermissions.has(permissions)) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(LEX.getText("cert.userTrustStore.checkPermissionsException", context, new Object[]{actualPermissions + "<" + permissions}));
            }
        }
        throw new PermissionException(LEX.getText("cert.userTrustStore.checkPermissionsException", context, new Object[]{permissions}));
    }

    private static void verifyHasSuperUserPermissions(String commandName, Context context) {
        if (!Sys.isStation()) {
            return;
        }
        BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
        if (authenticatedUser != null && authenticatedUser.getPermissions().isSuperUser()) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(LEX.getText("cert.userTrustStore.superUserPermissionException", context, new Object[]{commandName}));
        }
        throw new PermissionException(LEX.getText("cert.userTrustStore.superUserPermissionException", context, new Object[]{commandName}));
    }

    private static void validateHostPortKey(String hostPortKey, ICoreExemptionStore certExemptionStore) throws LocalizableException {
        try {
            NHostExemption exemption = certExemptionStore.getExemption(hostPortKey);
            if (exemption == null) {
                throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.invalidHostPortKey", (Object[])new String[]{hostPortKey});
            }
        }
        catch (LocalizableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.invalidHostPortKey", (Object[])new String[]{hostPortKey}, (Throwable)e);
        }
    }

    private static void verifyAliasExists(String alias, ICoreTrustStore certStore) throws LocalizableException {
        boolean containsAlias;
        if (alias == null || alias.isEmpty()) {
            LOG.fine("The 'alias' parameter is empty or null. It should correspond to an existing alias within the requested cert store.");
            throw new CertificateManagementRpcException(11);
        }
        try {
            containsAlias = (Boolean)BCertificateManagementRpc.runDoPrivileged(() -> certStore.containsAlias(alias));
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.error.couldNotCheckAlias", (Object[])new String[]{alias}, (Throwable)e);
        }
        if (!containsAlias) {
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.invalidAlias", (Object[])new String[]{alias});
        }
    }

    private static void verifyPasswordDecryptsPrivateKeyFromStore(String alias, ICoreKeyStore keyStore, String password) throws CouldNotDecryptPrivateKeyException {
        try {
            keyStore.getKey(alias, password == null ? null : password.toCharArray());
        }
        catch (Exception e) {
            throw new CouldNotDecryptPrivateKeyException(alias, e);
        }
    }

    private static boolean isValidPasswordFormat(String password, AtomicReference<Localizable> messageReference) {
        try {
            if (SecurityInitializer.getInstance().isFips()) {
                return BPasswordStrength.FIPS_1.isPasswordValid(password.toCharArray(), messageReference::set);
            }
            return BPasswordStrength.DEFAULT.isPasswordValid(password.toCharArray(), messageReference::set);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Key getKeyFromStore(String alias, ICoreKeyStore keyStore, String storeKeyDecryptPassword) throws Exception {
        if (BCertificateManagementRpc.keyRequiresPassword(alias, keyStore)) {
            BCertificateManagementRpc.verifyPasswordDecryptsPrivateKeyFromStore(alias, keyStore, storeKeyDecryptPassword);
            return keyStore.getKey(alias, storeKeyDecryptPassword.toCharArray());
        }
        return keyStore.getKey(alias, null);
    }

    private static boolean keyRequiresPassword(String alias, ICoreKeyStore keyStore) throws Exception {
        try {
            BCertificateManagementRpc.runDoPrivileged(() -> keyStore.getKey(alias, null));
            return false;
        }
        catch (UnrecoverableKeyException e) {
            return true;
        }
    }

    private static JSONObject parsePemFileForUserKeyStore(String pemFile) throws LocalizableException {
        JSONObject parsedCertificates = new JSONObject();
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        try {
            StringReader stringReader = new StringReader(pemFile);
            Object object = null;
            try (PemReader pemReader2 = new PemReader((Reader)stringReader);){
                PemObject pemObject = pemReader2.readPemObject();
                while (pemObject != null) {
                    Object decodedPemObject;
                    String pemObjectString;
                    try (StringWriter stringWriter = new StringWriter();
                         PemWriter pemWriter = new PemWriter((Writer)stringWriter);){
                        pemWriter.writeObject((PemObjectGenerator)pemObject);
                        pemWriter.flush();
                        pemObjectString = stringWriter.toString();
                    }
                    catch (IOException e) {
                        LOG.warning("Could not write PEM object from supplied PEM file.");
                        throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.parsePemFile.error.writePem", (Throwable)e);
                    }
                    try (StringReader singlePemStringReader = new StringReader(pemObjectString);
                         PEMParser pemParser = new PEMParser((Reader)singlePemStringReader);){
                        decodedPemObject = pemParser.readObject();
                    }
                    if (CertUtils.isSupportedCertificate((Object)decodedPemObject)) {
                        X509Certificate certificate = CertUtils.getCertificateFromPemObject((Object)decodedPemObject);
                        if (certificate != null) {
                            certificateList.add(certificate);
                        }
                    } else if (CertUtils.isSupportedPrivateKey((Object)decodedPemObject)) {
                        JSONObject privateKeyObject = new JSONObject();
                        privateKeyObject.put("pemPrivateKeyPasswordNeeded", CertUtils.isEncryptedPrivateKey((Object)decodedPemObject));
                        privateKeyObject.put("privateKey", (Object)pemObjectString);
                        parsedCertificates.put("privateKey", (Object)privateKeyObject);
                    } else {
                        LOG.fine("Found non cert or private key object in PEM file while parsing for the user key store. Ignoring.");
                    }
                    pemObject = pemReader2.readPemObject();
                }
            }
            catch (Throwable pemReader2) {
                object = pemReader2;
                throw pemReader2;
            }
            finally {
                if (stringReader != null) {
                    if (object != null) {
                        try {
                            stringReader.close();
                        }
                        catch (Throwable pemReader2) {
                            ((Throwable)object).addSuppressed(pemReader2);
                        }
                    } else {
                        stringReader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.parsePemFile.error.readPem", (Throwable)e);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.parsePemFile.error.parsePem", (Throwable)e);
        }
        List sortedCertChain = CertUtils.sortCertChain(certificateList);
        for (Certificate certificate : sortedCertChain) {
            JSONObject certificateObject = new JSONObject();
            X509Certificate x509Certificate = (X509Certificate)certificate;
            NX509Certificate nCertificate = NX509Certificate.make((X509Certificate)x509Certificate);
            certificateObject.put("certificate", (Object)nCertificate.getJSONObject());
            parsedCertificates.append("certificates", (Object)certificateObject);
        }
        try {
            ICoreKeyStore keyStore = CoreCryptoManager.get().getKeyStore();
            String existingAlias = keyStore.findCertificate((X509Certificate)sortedCertChain.get(0));
            if (existingAlias != null) {
                parsedCertificates.put("suggestedKeyStoreAlias", (Object)existingAlias);
                parsedCertificates.put("existingKeyStoreAlias", (Object)existingAlias);
                parsedCertificates.put("keyStorePrivateKeyPasswordNeeded", BCertificateManagementRpc.keyRequiresPassword(existingAlias, keyStore));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedCertificates;
    }

    private static JSONObject parsePemFileForUserTrustStore(String pemFile) {
        JSONObject parsedCertificates = new JSONObject();
        try (StringReader stringReader = new StringReader(pemFile);
             PEMParser pemParser = new PEMParser((Reader)stringReader);){
            Object pemObject = pemParser.readObject();
            while (pemObject != null) {
                if (!CertUtils.isSupportedCertificate((Object)pemObject)) {
                    LOG.fine("Found non-cert object in PEM file while parsing for the user trust store. Ignoring.");
                    pemObject = pemParser.readObject();
                    continue;
                }
                JSONObject certificateObject = new JSONObject();
                X509Certificate certificate = CertUtils.getCertificateFromPemObject((Object)pemObject);
                if (certificate != null) {
                    NX509Certificate nCertificate = NX509Certificate.make((X509Certificate)certificate);
                    certificateObject.put("suggestedAlias", (Object)nCertificate.getSubject());
                    certificateObject.put("certificate", (Object)nCertificate.getJSONObject());
                    parsedCertificates.append("certificates", (Object)certificateObject);
                }
                pemObject = pemParser.readObject();
            }
        }
        catch (IOException e) {
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.parsePemFile.error.readPem", (Throwable)e);
        }
        return parsedCertificates;
    }

    private static void importToUserKeyStore(ICoreKeyStore keyStore, String jsonDecryptPassword, String storeKeyDecryptPassword, String encryptPassword, JSONObject privateKeyJSONObject, JSONArray certificateJSONArray, Context context) throws LocalizableException {
        X509Certificate[] certChain;
        AtomicReference<Localizable> messageReference = new AtomicReference<Localizable>();
        if (encryptPassword != null && !BCertificateManagementRpc.isValidPasswordFormat(encryptPassword, messageReference)) {
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.error.invalidPasswordFormat", (Object[])new String[]{messageReference.get().toString(context)});
        }
        String keyPEMString = null;
        boolean encrypted = false;
        try {
            keyPEMString = privateKeyJSONObject.getString("privateKey");
            encrypted = privateKeyJSONObject.getBoolean("pemPrivateKeyPasswordNeeded");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (encrypted && jsonDecryptPassword == null) {
            LOG.fine("The private key is encrypted but the provided decrypt password input is null.");
            throw new CertificateManagementRpcException(12);
        }
        Key pkey = null;
        try {
            if (keyPEMString != null) {
                pkey = CertUtils.parsePrivateKey((String)keyPEMString, (String)jsonDecryptPassword);
            }
        }
        catch (PrivateKeyDecryptionException e) {
            if (e.getCauseCode() == 2) {
                throw new LocalizableException(PLAT_CRYPTO, "certRpc.importCertificatePrivateKey.password.error", (Throwable)e);
            }
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.importCertificatePrivateKey.error", (Throwable)e);
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not resolve the private key", e);
            throw new LocalizableException(PLAT_CRYPTO, "certRpc.importCertificatePrivateKey.error", (Throwable)e);
        }
        String alias = null;
        try {
            certChain = new X509Certificate[certificateJSONArray.length()];
            for (int i = 0; i < certificateJSONArray.length(); ++i) {
                JSONObject certificateJSON = certificateJSONArray.getJSONObject(i);
                if (i == 0) {
                    if (!certificateJSON.has("alias")) {
                        LOG.fine("No alias provided in certificate import JSON.");
                        throw new CertificateManagementRpcException(13);
                    }
                    alias = certificateJSON.getString("alias");
                    if (alias.isEmpty()) {
                        LOG.fine("No alias provided in certificate import JSON.");
                        throw new CertificateManagementRpcException(13);
                    }
                    if ("default".equalsIgnoreCase(alias)) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("The alias 'default' is protected and cannot be used for import.");
                        }
                        throw new LocalizableException(PLAT_CRYPTO, "certRpc.importCertificate.error.defaultAlias", (Object[])new String[]{"default"});
                    }
                }
                JSONObject certificate = (JSONObject)certificateJSON.get("certificate");
                certChain[i] = CertUtils.decodeX509Certificate((String)certificate.getString("pemString"));
            }
        }
        catch (LocalizableException e) {
            throw e;
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not resolve the certificate chain.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.importCertificateChain.error", (Throwable)e);
        }
        try {
            if (pkey == null) {
                BCertificateManagementRpc.verifyAliasExists(alias, (ICoreTrustStore)keyStore);
                String certAlias = keyStore.findCertificate(certChain[0]);
                if (!alias.equalsIgnoreCase(certAlias)) {
                    throw new LocalizableException(PLAT_CRYPTO, "certRpc.importCertificate.certDoesNotMatchKey", new Object[]{alias});
                }
                pkey = BCertificateManagementRpc.getKeyFromStore(alias, keyStore, storeKeyDecryptPassword);
            }
            String finalAlias = alias;
            PrivateKey finalPkey = pkey;
            char[] finalEncryptPasswordChars = encryptPassword == null ? null : encryptPassword.toCharArray();
            BCertificateManagementRpc.runDoPrivileged(() -> {
                if (keyStore instanceof CoreKeyStore) {
                    ((CoreKeyStore)keyStore).setKeyEntry(finalAlias, finalPkey, finalEncryptPasswordChars, certChain, false);
                } else {
                    keyStore.setKeyEntry(finalAlias, finalPkey, finalEncryptPasswordChars, certChain);
                }
                return null;
            });
            keyStore.save();
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not import certificate.", e);
            if (e instanceof LocalizableException) {
                throw (LocalizableException)((Object)e);
            }
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.importCertificateFail.error", (Throwable)e);
        }
    }

    private static <E extends Exception> void runDoPrivileged(RunnableCanThrowException<E> runnable) throws E {
        BCertificateManagementRpc.runDoPrivileged(() -> {
            runnable.run();
            return null;
        });
    }

    private static <T, E extends Exception> T runDoPrivileged(SupplierCanThrowException<T, E> supplier) throws E {
        try {
            return (T)AccessController.doPrivileged(() -> supplier.get());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static void importToUserTrustStore(ICoreTrustStore trustStore, JSONArray certificateJSONArray, Context context) {
        try {
            for (int i = 0; i < certificateJSONArray.length(); ++i) {
                JSONObject certificateJSON = certificateJSONArray.getJSONObject(i);
                if (!certificateJSON.has("alias")) {
                    LOG.fine("No alias provided in certificate import JSON.");
                    throw new CertificateManagementRpcException(13);
                }
                String alias = certificateJSON.getString("alias");
                if (alias.isEmpty()) {
                    LOG.fine("No alias provided in certificate import JSON.");
                    throw new CertificateManagementRpcException(13);
                }
                try {
                    X509Certificate certificate = CertUtils.decodeX509Certificate((String)certificateJSON.getJSONObject("certificate").getString("pemString"));
                    trustStore.setCertificateEntry(alias, certificate);
                    trustStore.save();
                    continue;
                }
                catch (IOException e) {
                    BCertificateManagementRpc.log(Level.WARNING, "Could not import certificate to User Trust Store for alias: " + alias, e);
                    throw new LocalizableException(PLAT_CRYPTO, "certRpc.importCertificate.trustStoreDecode.error", new Object[]{alias}, (Throwable)e);
                }
                catch (Exception e) {
                    BCertificateManagementRpc.log(Level.WARNING, "Could decode certificate from provided PEM string for alias: " + alias, e);
                    throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.importCertificate.trustStoreImport.error", new Object[]{alias}, (Throwable)e);
                }
            }
        }
        catch (LocalizableRuntimeException e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not import certificate.", e);
            throw e;
        }
        catch (Exception e) {
            BCertificateManagementRpc.log(Level.WARNING, "Could not import certificate.", e);
            throw new LocalizableRuntimeException(PLAT_CRYPTO, "certRpc.importCertificateFail.error", (Throwable)e);
        }
    }

    private static ICoreTrustStore getCertStore(String storeType, EnumSet<CryptoStoreId> allowedStores, Context context) throws LocalizableException {
        CryptoStoreId cryptoStoreId;
        if (storeType == null || storeType.isEmpty()) {
            LOG.fine("The 'storeType' parameter is empty or null. It should correspond to a valid CryptoStoreId.");
            throw new CertificateManagementRpcException(14);
        }
        try {
            cryptoStoreId = CryptoStoreId.getEnum((String)storeType);
        }
        catch (IllegalArgumentException e) {
            LOG.fine("The 'storeType' parameter is invalid. It should correspond to a valid CryptoStoreId.");
            throw new CertificateManagementRpcException(15);
        }
        if (!allowedStores.contains(cryptoStoreId)) {
            LOG.fine("The 'storeType' parameter is invalid for the requested operation.");
            throw new CertificateManagementRpcException(16);
        }
        CoreCryptoManager coreCryptoManager = CoreCryptoManager.get();
        switch (cryptoStoreId) {
            case USER_KEY_STORE: {
                return coreCryptoManager.getKeyStore();
            }
            case USER_TRUST_STORE: {
                return coreCryptoManager.getUserTrustStore();
            }
            case SYSTEM_TRUST_STORE: {
                return coreCryptoManager.getSystemTrustStore();
            }
        }
        LOG.fine("The 'storeType' parameter is unsupported for certificate management operations.");
        throw new CertificateManagementRpcException(17);
    }

    private static JSONObject getCertStoreJSON(ICoreTrustStore certStore, Context cx) throws Exception {
        Iterable certificateEntries = (Iterable)BCertificateManagementRpc.runDoPrivileged(() -> ((ICoreTrustStore)certStore).getCertificateEntries());
        JSONObject certsJSON = new JSONObject();
        for (IX509CertificateEntry certificateEntry : certificateEntries) {
            IX509Certificate cert = certificateEntry.getCertificate(0);
            JSONObject certJSON = cert instanceof NX509Certificate ? ((NX509Certificate)cert).getJSONObject() : new JSONObject(cert.getJSON());
            certJSON.put("alias", (Object)certificateEntry.getAlias());
            BCertificateManagementRpc.localizeCert(certJSON, cx);
            certsJSON.append("certs", (Object)certJSON);
        }
        return certsJSON;
    }

    private static void localizeCert(JSONObject certJSON, Context cx) {
        certJSON.put("version", (Object)(LEX.getText("cert.field.version.prefix", cx) + certJSON.get("version")));
        String keyType = (String)certJSON.get("keyAlgorithm");
        String lexEntry = LEX.get("cert.field.keyType." + keyType, cx);
        if (lexEntry != null) {
            keyType = lexEntry;
        }
        certJSON.put("keyAlgorithm", (Object)keyType);
        String spec = (String)certJSON.get("spec");
        if (spec != null && !spec.isEmpty()) {
            lexEntry = LEX.get("cert.field.spec." + spec, cx);
            if (lexEntry != null) {
                spec = lexEntry;
            }
            certJSON.put("spec", (Object)spec);
        }
    }

    private static JSONObject getExemptionStoreJSON(Context cx) throws Exception {
        JSONObject exemptionsJSON = new JSONObject();
        ICoreExemptionStore exemptionStore = CoreCryptoManager.get().getExemptionStore();
        Enumeration exemptions = (Enumeration)BCertificateManagementRpc.runDoPrivileged(() -> ((ICoreExemptionStore)exemptionStore).exemptions());
        while (exemptions.hasMoreElements()) {
            JSONObject exemptionJSON = ((NHostExemption)exemptions.nextElement()).getJSON();
            JSONObject certJSON = exemptionJSON.getJSONObject("certificate");
            BCertificateManagementRpc.localizeCert(certJSON, cx);
            exemptionsJSON.append("exemptions", (Object)exemptionJSON);
        }
        return exemptionsJSON;
    }

    private static X509Certificate[] getCertificateChain(String alias, ICoreTrustStore store) throws Exception {
        if (store instanceof CoreKeyStore) {
            return store.getCertificateChain(alias);
        }
        return new X509Certificate[]{store.getCertificate(alias)};
    }

    private static Object localizeFieldName(String fieldName, Context cx) {
        String lexEntry = LEX.get("cert.field." + fieldName, cx);
        if (lexEntry != null) {
            return lexEntry;
        }
        return fieldName;
    }

    private static void audit(String operation, String message) {
        if (Sys.isStation()) {
            BUser user = BUser.getCurrentAuthenticatedUser();
            String username = user != null ? user.getName() : "";
            Nre.getSecurityAuditor().audit(new SecurityAuditEvent(operation, username, message));
        }
    }

    private static void log(Level level, String message, Throwable e) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(level, message, e);
        } else {
            LOG.log(level, message + ". Cause is: " + e.getMessage());
        }
    }

    private static ICoreKeyStore getCoreKeyStore() {
        return CoreCryptoManager.get().getKeyStore();
    }

    public static class CouldNotDecryptPrivateKeyException
    extends LocalizableException {
        private CouldNotDecryptPrivateKeyException(String alias, Throwable cause) {
            super(BCertificateManagementRpc.PLAT_CRYPTO, "certRpc.error.badPassword", (Object[])new String[]{alias}, cause);
        }
    }
}

