/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.baja.file.BAbstractFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS8EncryptedPrivateKeyInfoBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;

@NiagaraType
@NiagaraSingleton
public final class BPEMCertificateHandler
extends BObject
implements BICertificateFormatHandler {
    @Generated
    public static final BPEMCertificateHandler INSTANCE = new BPEMCertificateHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BPEMCertificateHandler.class);
    private static final LexiconModule LEX = LexiconModule.make(BPEMCertificateHandler.class);
    private static final String MIME_TYPE = "application/x-pem-file";
    private static final String DEFAULT_PEM_EXTENSION = "pem";
    private static final Set<String> PEM_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("pem", "crt", "cer", "key")));

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeCertToFile(X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        if (certFile != null) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
                 JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
                for (X509Certificate cert : certChain) {
                    pem.writeObject((Object)cert);
                }
            }
        }
    }

    @Override
    public void writeKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, BAbstractFile certFile) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
             JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
            if (privateKey != null) {
                pem.writeObject(BPEMCertificateHandler.getConditionallyEncryptedPrivateKey(privateKey, encryptKey, encryptionKey));
            }
        }
        catch (OperatorCreationException e) {
            throw new IOException("Could not write certificate to file", e);
        }
    }

    @Override
    public void writeCertAndKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
             JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
            if (privateKey != null) {
                pem.writeObject(BPEMCertificateHandler.getConditionallyEncryptedPrivateKey(privateKey, encryptKey, encryptionKey));
            }
            if (certChain != null) {
                for (X509Certificate cert : certChain) {
                    pem.writeObject((Object)cert);
                }
            }
        }
        catch (OperatorCreationException e) {
            throw new IOException("Could not write certificate to file", e);
        }
    }

    @Override
    public String writeCert(X509Certificate[] certChain) throws IOException {
        try {
            StringBuilder certs = new StringBuilder();
            for (X509Certificate cert : certChain) {
                certs.append(NX509Certificate.make((X509Certificate)cert).encodeToString());
            }
            return certs.toString();
        }
        catch (Exception e) {
            throw new IOException("Could not write certificate to String", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String writeKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String writeCertAndKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        return PEM_EXTENSIONS;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_PEM_EXTENSION;
    }

    @Override
    public String getCertificateFormatName(Context cx) {
        return LEX.get("cert.format.pem.name", cx);
    }

    @Override
    public String getCertificateFormatFileTypeName(Context cx) {
        return LEX.get("cert.format.pem.file.type", cx);
    }

    @Override
    public boolean supportsPrivateKey() {
        return true;
    }

    private static Object getConditionallyEncryptedPrivateKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey) throws OperatorCreationException {
        if (encryptKey) {
            JcaPKCS8EncryptedPrivateKeyInfoBuilder pkcs8Builder = new JcaPKCS8EncryptedPrivateKeyInfoBuilder(privateKey);
            return pkcs8Builder.build(new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes256_GCM).setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).build(AccessController.doPrivileged(() -> ((BPassword)encryptionKey).getValue()).toCharArray()));
        }
        return privateKey;
    }
}

