/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.job.BCcnLearnDataPointsJob;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnUtil;
import java.util.Vector;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnDataTableWithTimeSchedule", "ccn:CcnDataTable"}, requiredPermissions="r")})
public class BCcnDataPointsListManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnDataPointsListManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
    MgrColumn colPointName = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCcnProxyExt.fieldName}, 4);
    MgrColumn colDetail = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCcnProxyExt.description}, 4);
    MgrColumn colUnits = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCcnProxyExt.unitsEnum}, 4);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colDetail, this.colToString, this.colUnits, this.colPointName, this.colTuning};
    private static final BImage pointIconImg = BImage.make((BIcon)BIcon.std((String)"object.png"));
    private static final Log ccnLog = Log.getLog((String)"CCNNetworkLog");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnDataTable getDataTable() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnDataTable) {
            return (BCcnDataTable)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
        try {
            Object[] ccnDataPoints;
            BControlPoint[] points = (BControlPoint[])this.getDataTable().getChildren(BControlPoint.class);
            if (points != null) {
                for (int i = 0; i < points.length; ++i) {
                    if (!(points[i].getProxyExt() instanceof BCcnProxyExt)) continue;
                    points[i].lease(2, 500L);
                }
            }
            if ((ccnDataPoints = (BCcnPointEntry[])this.getDataTable().getPointList().getChildren(BCcnPointEntry.class)) != null && ccnDataPoints.length > 0) {
                this.getLearn().updateRoots(ccnDataPoints);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new TridiumCCNDataPointListModel(this);
    }

    protected MgrController makeController() {
        return new TridiumCCNDataPointListController(this);
    }

    protected MgrLearn makeLearn() {
        return new TridiumCCNDataPointListLearn(this);
    }

    protected MgrState makeState() {
        return new TridiumCCNDataPointState();
    }

    class TridiumCCNDataPointListController
    extends MgrController {
        TridiumCCNDataPointListController(BPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BCcnDataTable ccnDataTable;
            super.doDiscover(cx);
            BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])BCcnDataPointsListManager.this.getDataTable().getPointList().getChildren(BCcnPointEntry.class);
            if (learnedPoints.length > 0) {
                BCcnDataPointsListManager.this.getDataTable().getPointList().removeAll();
            }
            if ((ccnDataTable = BCcnDataPointsListManager.this.getDataTable()) == null) {
                throw new Exception("Network null, can not discover devices");
            }
            this.discover.setEnabled(false);
            BOrd ordToDataPointListJob = ccnDataTable.submitDataPointDiscoveryJob();
            BCcnDataPointsListManager.this.getLearn().setJob(ordToDataPointListJob);
            return null;
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(table, event, row, col);
        }

        public CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            Object[] disSelRows = this.getLearnTable().getSelectedObjects();
            Object[] createPointList = null;
            BCcnPointList pointList = null;
            int notExistPointCOunt = 0;
            Vector<BCcnPointEntry> vec = new Vector<BCcnPointEntry>(0);
            for (int i = 0; i < disSelRows.length; ++i) {
                boolean isExisting = false;
                if (BCcnDataPointsListManager.this.getLearn().getExisting(disSelRows[i]) != null) {
                    isExisting = true;
                    continue;
                }
                if (isExisting) continue;
                ++notExistPointCOunt;
                vec.addElement((BCcnPointEntry)discovery[i]);
            }
            createPointList = new BCcnPointEntry[vec.size()];
            vec.copyInto(createPointList);
            pointList = new BCcnPointList((BCcnPointEntry[])createPointList);
            BCcnDataTable table = BCcnDataPointsListManager.this.getDataTable();
            if (table == null) {
                throw new Exception("Table is null, can not add points");
            }
            if (pointList.getPointList().length > 0) {
                BOrd ordToAddPointsJob = table.submitAddDataPointsJob(pointList);
                BCcnDataPointsListManager.this.getLearn().setJob(ordToAddPointsJob);
            } else {
                BDialog.message(null, (Object)"The selected point/s are already added to station database");
            }
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
        }
    }

    class TridiumCCNDataPointListLearn
    extends MgrLearn {
        TridiumCCNDataPointListLearn(BPointManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BCcnPointEntry.fieldName), new MgrColumn.Prop(BCcnPointEntry.valueBlock, 2), new MgrColumn.Prop(BCcnPointEntry.description, 2)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            try {
                BCcnPointEntry learnEntry = (BCcnPointEntry)discovery;
                Type type = null;
                if (learnEntry.getForceableFlag()) {
                    switch (CcnUtil.getControlPointType((BCcnPointEntry)learnEntry)) {
                        case 1: 
                        case 2: {
                            type = BNumericWritable.TYPE;
                            break;
                        }
                        case 10: 
                        case 11: {
                            type = BNumericPoint.TYPE;
                            break;
                        }
                        case 5: {
                            type = BBooleanWritable.TYPE;
                            break;
                        }
                        case 14: {
                            type = BBooleanPoint.TYPE;
                            break;
                        }
                        case 9: {
                            type = BStringWritable.TYPE;
                            break;
                        }
                        case 18: {
                            type = BStringPoint.TYPE;
                        }
                    }
                    if (type != null) {
                        return MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{type.getTypeInfo()});
                    }
                    return null;
                }
                switch (CcnUtil.getControlPointType((BCcnPointEntry)learnEntry)) {
                    case 1: 
                    case 2: 
                    case 10: 
                    case 11: {
                        type = BNumericPoint.TYPE;
                        break;
                    }
                    case 5: 
                    case 14: {
                        type = BBooleanPoint.TYPE;
                        break;
                    }
                    case 9: 
                    case 18: {
                        type = BStringPoint.TYPE;
                    }
                }
                if (type != null) {
                    return MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{type.getTypeInfo()});
                }
                return null;
            }
            catch (Exception e) {
                ccnLog.error("Exception occurred while getting point type", (Throwable)e);
                return null;
            }
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BCcnPointEntry learnEntry = (BCcnPointEntry)discovery;
            learnEntry.lease();
            BControlPoint pt = (BControlPoint)row.getTarget();
            BCcnProxyExt proxy = (BCcnProxyExt)pt.getProxyExt();
            proxy.setFieldIndex(learnEntry.getFieldIndex());
            proxy.setPointDataType(learnEntry.getPointDataType());
            proxy.setDataTypeEnum(learnEntry.getDataTypeEnum());
            proxy.setDisplayType(learnEntry.getDisplayType());
            proxy.setDisplayDigits(learnEntry.getDisplayDigits());
            proxy.setFieldByteCount(learnEntry.getFieldByteCount());
            proxy.setDiscreteTextOffset(learnEntry.getDiscreteTextOffset());
            proxy.setConfigFlags(learnEntry.getConfigFlags());
            proxy.setUnits(learnEntry.getUnits());
            proxy.setUnitsEnum(learnEntry.getUnitsEnum());
            proxy.setValueBlock(learnEntry.getValueBlock());
            proxy.setValueBlockOffset(learnEntry.getValueBlockOffset());
            proxy.setFieldStatus(learnEntry.getAlrmStatus().getTag());
            proxy.setForceLevel(CcnEnumsUtil.setProperForceLevel((String)learnEntry.getForceLevel().getTag()));
            proxy.setHiLimit(learnEntry.getHiLimit());
            proxy.setHiLimitBlock(learnEntry.getHiLimitBlock());
            proxy.setHiLimitBlockOffset(learnEntry.getHiLimitBlockOffset());
            proxy.setLoLimit(learnEntry.getLoLimit());
            proxy.setLoLimitBlock(learnEntry.getLoLimitBlock());
            proxy.setLoLimitBlockOffset(learnEntry.getHiLimitBlockOffset());
            proxy.setVariableNo(learnEntry.getVariableNo());
            proxy.setDescription(learnEntry.getDescription());
            proxy.setForceableFlag(learnEntry.getForceableFlag());
            row.setDefaultName(learnEntry.getFieldName());
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BCcnLearnDataPointsJob) {
                BCcnDataPointsListManager.this.updateLearnData();
            }
        }

        public final boolean isExisting(Object discovered, BComponent component) {
            if (!(component instanceof BControlPoint)) {
                return false;
            }
            BCcnPointEntry learnedPoint = (BCcnPointEntry)discovered;
            BControlPoint point = (BControlPoint)component;
            if (!(point.getProxyExt() instanceof BCcnProxyExt)) {
                return false;
            }
            BCcnProxyExt proxyExt = (BCcnProxyExt)point.getProxyExt();
            boolean exists = false;
            if (learnedPoint.getFieldName().equalsIgnoreCase(proxyExt.getFieldName()) && learnedPoint.getValueBlock() == proxyExt.getValueBlock() && learnedPoint.getFieldIndex() == proxyExt.getFieldIndex()) {
                exists = true;
            }
            return exists;
        }

        public final BImage getIcon(Object d) {
            return pointIconImg;
        }
    }

    class TridiumCCNDataPointListModel
    extends MgrModel {
        TridiumCCNDataPointListModel(BPointManager manager) {
            super((BAbstractManager)manager);
        }

        public TridiumCCNDataPointListModel(BCcnPointEntry[] initList) {
            super(null);
        }

        protected MgrColumn[] makeColumns() {
            return BCcnDataPointsListManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BStatusValue statusVal = pt.getStatusValue();
            if (statusVal instanceof BStatusNumeric) {
                pt.setProxyExt((BAbstractProxyExt)new BCcnProxyExt());
            } else if (statusVal instanceof BStatusBoolean) {
                pt.setProxyExt((BAbstractProxyExt)new BCcnProxyExt());
            } else if (statusVal instanceof BStatusEnum) {
                pt.setProxyExt((BAbstractProxyExt)new BCcnProxyExt());
            } else if (statusVal instanceof BStatusString) {
                pt.setProxyExt((BAbstractProxyExt)new BCcnProxyExt());
            }
            return pt;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = rows[i].getName();
                values[i] = rows[i].getTarget();
                if (names[i] == null) continue;
                String strTemp = SlotPath.unescape((String)names[i]);
                if (strTemp.trim().length() != 0) {
                    names[i] = strTemp;
                }
                if (strTemp == "" || strTemp.trim().length() == 0) {
                    BDialog.error((BWidget)this.getManager(), (Object)"The point name should not be NULL");
                    return null;
                }
                if (Character.isLetter(strTemp.charAt(0))) continue;
                BDialog.error((BWidget)this.getManager(), (Object)"The point name should start with a letter");
                return null;
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            return null;
        }
    }

    static class TridiumCCNDataPointState
    extends PointState {
        boolean isAllDescendants;
        MgrController controller;

        TridiumCCNDataPointState() {
        }

        protected void restoreForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                ((FolderController)controller).allDescendants.setSelected(this.isAllDescendants);
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                ((PointController)controller).allDescendants.setSelected(this.isAllDescendants);
            }
        }

        protected void saveForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                this.isAllDescendants = ((FolderController)controller).allDescendants.isSelected();
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                this.isAllDescendants = ((PointController)controller).allDescendants.isSelected();
            }
        }
    }
}

