/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.job.BCcnLearnTablesJob;
import com.tridium.ccn.point.BCcnPointDeviceExt;
import com.tridium.ccn.point.BCcnPointFolder;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import java.util.Vector;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnPointDeviceExt", "ccn:CcnPointFolder", "ccn:CcnTableGroup"}, requiredPermissions="r")})
public class BCcnTableManager
extends BFolderManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnTableManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colTablename = new MgrColumn.Prop(BCcnTable.tableName, 1);
    MgrColumn colTableTypeString = new MgrColumn.Prop(BCcnTable.tableTypeString, 1);
    MgrColumn colTableType = new MgrColumn.Prop(BCcnTable.tableType, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colName};
    BCcnDevice ccnDevice = null;
    BCcnNetwork ccnNetwork = null;
    private static final BImage tableImage = BImage.make((String)"module://ccn/images/CcnTable.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnDevice getDevice() {
        return this.ccnDevice;
    }

    public BCcnNetwork getNetwork() {
        return this.ccnNetwork;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        if (obj instanceof BCcnPointFolder) {
            BCcnPointFolder node = (BCcnPointFolder)obj;
            this.ccnDevice = node.getCcnDevice();
            this.ccnNetwork = this.ccnDevice.getCarrierNetwork();
        } else if (obj instanceof BCcnPointDeviceExt) {
            BCcnPointDeviceExt node = (BCcnPointDeviceExt)obj;
            this.ccnDevice = node.getCcnDevice();
            this.ccnNetwork = this.ccnDevice.getCarrierNetwork();
        }
        this.updateLearnData();
    }

    void updateLearnData() {
        try {
            Object[] tables = (BCcnTableEntry[])this.getDevice().getLearnedTables().getChildren(BCcnTableEntry.class);
            if (tables != null && tables.length > 0) {
                for (int i = 0; i < tables.length; ++i) {
                    tables[i].lease();
                }
            }
            this.getLearn().updateRoots(tables);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new TridiumCCNTableModel(this);
    }

    protected MgrController makeController() {
        return new TridiumCCNTableController(this);
    }

    protected MgrLearn makeLearn() {
        return new TridiumCCNTableLearn(this);
    }

    protected MgrState makeState() {
        return new TridiumCCNTableState();
    }

    class TridiumCCNTableController
    extends MgrController {
        TridiumCCNTableController(BFolderManager mgr) {
            super((BAbstractManager)mgr);
            this.newCommand.setEnabled(true);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BCcnDevice device;
            super.doDiscover(cx);
            BCcnTableEntry[] learnedTables = (BCcnTableEntry[])BCcnTableManager.this.getDevice().getLearnedTables().getChildren(BCcnTableEntry.class);
            if (learnedTables.length > 0) {
                BCcnTableManager.this.getDevice().getLearnedTables().removeAll();
            }
            if ((device = BCcnTableManager.this.getDevice()) == null) {
                throw new Exception("Device is null, can not discover devices");
            }
            this.discover.setEnabled(false);
            BOrd ordToDiscoveryJob = device.submitTableDiscoveryJob();
            BCcnTableManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        public CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            Object[] disSelRows = this.getLearnTable().getSelectedObjects();
            Object[] createList = null;
            BCcnTableList tableList = null;
            int notExistTableCOunt = 0;
            Vector<BCcnTableEntry> vec = new Vector<BCcnTableEntry>(0);
            for (int i = 0; i < disSelRows.length; ++i) {
                boolean isExisting = false;
                if (BCcnTableManager.this.getLearn().getExisting(disSelRows[i]) != null) {
                    isExisting = true;
                    continue;
                }
                if (isExisting) continue;
                ++notExistTableCOunt;
                vec.addElement((BCcnTableEntry)discovery[i]);
            }
            createList = new BCcnTableEntry[vec.size()];
            vec.copyInto(createList);
            tableList = new BCcnTableList((BCcnTableEntry[])createList);
            BCcnDevice device = BCcnTableManager.this.getDevice();
            if (device == null) {
                throw new Exception("Device is null, can not add tables");
            }
            if (tableList.getTableList().length > 0) {
                BOrd ordToAddTablesJob = device.submitAddTablesJob(tableList);
                BCcnTableManager.this.getLearn().setJob(ordToAddTablesJob);
            } else {
                BDialog.message(null, (Object)"The selected table/s are already added to station database");
            }
            return null;
        }

        public CommandArtifact doCancel(Context cx) throws Exception {
            return super.doCancel(cx);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(table, event, row, col);
        }

        public void updateCommands() {
            super.updateCommands();
            if (BCcnTableManager.this.getCurrentValue() instanceof BCcnTableGroup) {
                this.discover.setEnabled(false);
            }
        }
    }

    class TridiumCCNTableLearn
    extends MgrLearn {
        TridiumCCNTableLearn(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        public final boolean isExisting(Object discovered, BComponent db) {
            if (!(db instanceof BCcnTableGroup)) {
                return false;
            }
            BCcnTableEntry learnedTable = (BCcnTableEntry)discovered;
            BCcnTableGroup tableGroup = (BCcnTableGroup)db;
            boolean isExists = false;
            BCcnTable[] table = (BCcnTable[])tableGroup.getChildren(BCcnTable.class);
            for (int i = 0; i < table.length; ++i) {
                table[i].lease();
                if (!learnedTable.getTableName().equalsIgnoreCase(table[i].getTableName()) || learnedTable.getTableNum() != table[i].getTableNum() || learnedTable.getTableInstance() != table[i].getTableInstance() || learnedTable.getTableType() != table[i].getTableType()) continue;
                isExists = true;
            }
            return isExists;
        }

        public final BImage getIcon(Object d) {
            return tableImage;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BCcnTableEntry.tableName), new MgrColumn.Prop(BCcnTableEntry.tableType), new MgrColumn.Prop(BCcnTableEntry.tableTypeString)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BCcnTableEntry.TYPE);
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BCcnTableEntry learnEntry = (BCcnTableEntry)discovery;
            BCcnTable table = (BCcnTable)row.getTarget();
            table.setTableName(learnEntry.getTableName().trim());
            row.setDefaultName(learnEntry.getTableName());
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BCcnLearnTablesJob) {
                BCcnTableManager.this.updateLearnData();
            }
        }
    }

    class TridiumCCNTableModel
    extends MgrModel {
        public TridiumCCNTableModel(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return BCcnTableManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BCcnTable.TYPE);
        }
    }

    static class TridiumCCNTableState
    extends PointState {
        boolean isAllDescendants;
        MgrController controller;

        TridiumCCNTableState() {
        }

        protected void restoreForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                ((FolderController)controller).allDescendants.setSelected(this.isAllDescendants);
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                ((PointController)controller).allDescendants.setSelected(this.isAllDescendants);
            }
        }

        protected void saveForType(BAbstractManager manager) {
            MgrController controller = null;
            if (manager.getController() instanceof FolderController) {
                controller = manager.getController();
                this.isAllDescendants = ((FolderController)controller).allDescendants.isSelected();
            } else if (manager.getController() instanceof PointController) {
                controller = manager.getController();
                this.isAllDescendants = ((PointController)controller).allDescendants.isSelected();
            }
        }
    }
}

