/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.datatypes.BObjectParameters;
import com.tridium.driver.util.StringUtil;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetDeleteObjectJob
extends BDeviceManagerJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDeleteObjectJob.class);
    BObjectParameters params;
    BBacnetDevice dev;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetDeleteObjectJob() {
    }

    public BBacnetDeleteObjectJob(BBacnetDevice d, BObjectParameters p) {
        super((BBacnetNetwork)d.getNetwork());
        this.dev = d;
        this.params = p;
    }

    public void run(Context cx) throws Exception {
        BBacnetObjectIdentifier[] oids = (BBacnetObjectIdentifier[])StringUtil.getSimpleArray((String)this.params.getObjectIds(), (BSimple)BBacnetObjectIdentifier.DEFAULT);
        BOrd[] ords = (BOrd[])StringUtil.getSimpleArray((String)this.params.getOrds(), (BSimple)BOrd.DEFAULT);
        for (int i = 0; i < oids.length; ++i) {
            BBacnetObject bo = (BBacnetObject)ords[i].resolve((BObject)this.getComponentSpace()).get();
            String name = bo.getDisplayName(null);
            try {
                this.bacnet.getBacnetComm().deleteObject(this.dev.getAddress(), oids[i]);
                ((BComponent)bo.getParent()).remove((BComplex)bo);
                this.log().message("Deleted " + name);
                continue;
            }
            catch (BacnetException e) {
                this.log().failed("Error deleting " + name, (Throwable)e);
            }
        }
    }
}

