/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransaction;
import com.tridium.basicdriver.comm.CommTransactionManager;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.sys.BRelTime;

public abstract class Comm {
    private BBasicNetwork basicNetwork;
    private CommReceiver rDriver = null;
    private CommTransmitter tDriver = null;
    private CommTransactionManager transactionManager = null;
    private boolean commStarted = false;
    private Hashtable<Object, ArrayList<UnsolicitedMessageListener>> listeners = new Hashtable(32);

    public Comm(BBasicNetwork basicNetwork, CommReceiver rDriver) {
        this.basicNetwork = basicNetwork;
        this.setCommReceiver(rDriver);
        this.setCommTransmitter(new CommTransmitter());
        this.setCommTransactionManager(new CommTransactionManager());
    }

    public Comm(BBasicNetwork basicNetwork, CommReceiver rDriver, CommTransmitter tDriver) {
        this.basicNetwork = basicNetwork;
        this.setCommReceiver(rDriver);
        this.setCommTransmitter(tDriver);
        this.setCommTransactionManager(new CommTransactionManager());
    }

    public Comm(BBasicNetwork basicNetwork, CommReceiver rDriver, CommTransmitter tDriver, CommTransactionManager manager) {
        this.basicNetwork = basicNetwork;
        this.setCommReceiver(rDriver);
        this.setCommTransmitter(tDriver);
        this.setCommTransactionManager(manager);
    }

    public final void setCommTransactionManager(CommTransactionManager manager) {
        try {
            boolean restart = this.installSupport(this.transactionManager, manager);
            this.transactionManager = manager;
            if (restart) {
                this.start();
            }
        }
        catch (Exception e) {
            this.basicNetwork.getLog().error("Error in Comm.setCommTransactionManager()", (Throwable)e);
        }
    }

    public final void setCommTransmitter(CommTransmitter tDriver) {
        try {
            boolean restart = this.installSupport(this.tDriver, tDriver);
            this.tDriver = tDriver;
            if (restart) {
                this.start();
            }
        }
        catch (Exception e) {
            this.basicNetwork.getLog().error("Error in Comm.setCommTransmitter()", (Throwable)e);
        }
    }

    public final void setCommReceiver(CommReceiver rDriver) {
        try {
            boolean restart = this.installSupport(this.rDriver, rDriver);
            this.rDriver = rDriver;
            if (restart) {
                this.start();
            }
        }
        catch (Exception e) {
            this.basicNetwork.getLog().error("Error in Comm.setCommReceiver()", (Throwable)e);
        }
    }

    public BBasicNetwork getNetwork() {
        return this.basicNetwork;
    }

    public CommTransactionManager getCommTransactionManager() {
        return this.transactionManager;
    }

    public CommTransmitter getCommTransmitter() {
        return this.tDriver;
    }

    public CommReceiver getCommReceiver() {
        return this.rDriver;
    }

    private boolean installSupport(CommSupport old, CommSupport support) throws Exception {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return false;
        }
        if (support.comm != null) {
            throw new IllegalArgumentException("Already installed on another Comm");
        }
        boolean restart = this.isCommStarted();
        if (restart) {
            this.stop();
        }
        if (old != null) {
            old.setComm(null);
        }
        support.setComm(this);
        return restart;
    }

    public boolean isCommStarted() {
        return this.commStarted;
    }

    public final void start() throws Exception {
        if (!this.isCommStarted() && this.tDriver != null && this.started()) {
            this.commStarted = true;
        }
    }

    public final void stop() throws Exception {
        if (this.isCommStarted()) {
            this.commStarted = false;
            if (this.basicNetwork.getDispatcher().isRunning()) {
                StopRequest stopReq = new StopRequest();
                this.basicNetwork.dispatch(stopReq);
                stopReq.stop();
            }
            this.stopped();
        }
    }

    protected abstract boolean started() throws Exception;

    protected abstract void stopped() throws Exception;

    public final Message transmit(Message msg) throws BasicException {
        return this.transmit(msg, this.basicNetwork.getResponseTimeout(), this.basicNetwork.getRetryCount());
    }

    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (msg == null) {
            return null;
        }
        if (!msg.getResponseExpected()) {
            this.transmitNoResponse(msg);
            return null;
        }
        BasicException e = null;
        Message respMsg = null;
        try {
            for (int i = 0; !(i >= retryCount + 1 || (respMsg = this.processTransmit(msg, responseTimeout)) != null && respMsg.getSuccessfulResponse()); ++i) {
            }
            if (respMsg != null && !respMsg.getSuccessfulResponse()) {
                String failMsg = "Unsuccessful response for request message sent.";
                e = new BasicException(failMsg);
            }
        }
        catch (BasicException se) {
            e = se;
        }
        if (e != null) {
            if (e instanceof BasicException) {
                if (this.basicNetwork.getLog().isTraceOn()) {
                    this.basicNetwork.getLog().trace("Comm sendRequest exception: ", (Throwable)((Object)e));
                }
            } else {
                throw e;
            }
        }
        return respMsg;
    }

    public void transmitNoResponse(Message msg) throws BasicException {
        if (msg == null) {
            return;
        }
        if (!this.commStarted) {
            throw new BasicException("Communication handler service not started.");
        }
        this.tDriver.writeMessage(msg);
        this.getNetwork().incrementSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processTransmit(Message msg, BRelTime responseTimeout) throws BasicException {
        CommTransaction transaction;
        if (!this.commStarted) {
            throw new BasicException("Communication handler service not started.");
        }
        CommTransaction commTransaction = transaction = this.transactionManager.getCommTransaction(msg);
        synchronized (commTransaction) {
            block12: {
                this.tDriver.writeMessage(msg);
                this.getNetwork().incrementSent();
                try {
                    if (transaction.isComplete()) break block12;
                    transaction.wait(responseTimeout.getMillis());
                    if (!transaction.isComplete()) {
                        if (this.basicNetwork.getLog().isTraceOn()) {
                            Object reqTag = transaction.getRequestMessage().getTag();
                            this.basicNetwork.getLog().trace("CommTransaction timed out (tag: " + reqTag + ")");
                            if (!reqTag.equals(Message.DEFAULT_TAG)) {
                                try {
                                    Message req = transaction.getRequestMessage();
                                    if (req != null) {
                                        this.basicNetwork.getLog().trace("Failure to get response for sent message: " + req.toDebugString());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        transaction.setResponseMessage(null);
                        this.basicNetwork.incrementTimeouts();
                    }
                    transaction.setComplete(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Message resp = transaction.getResponseMessage();
        this.transactionManager.freeCommTransaction(transaction);
        return resp;
    }

    public void receive(ReceivedMessage msg) {
        if (msg == null) {
            return;
        }
        this.getNetwork().incrementReceived();
        if (this.basicNetwork.getLog().isTraceOn()) {
            this.basicNetwork.getLog().trace("**** Received message: " + msg.toDebugString());
        }
        if (msg.getUnsolicited()) {
            this.routeToListeners(msg);
        } else if (!this.handleReceivedMessage(msg)) {
            this.routeToListeners(msg);
        }
    }

    public synchronized void receiveFinal() {
        this.getCommTransactionManager().cancelAllOutstandingCommTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailedTransmit(Message msg, Exception e) {
        CommTransaction transaction;
        this.basicNetwork.getLog().message("Failure to transmit in CommTransmitter.", (Throwable)e);
        if (!msg.getResponseExpected()) {
            return;
        }
        Object tag = msg.getTag();
        CommTransaction commTransaction = transaction = this.getCommTransactionManager().getCommTransactionMatch(tag);
        synchronized (commTransaction) {
            transaction.setResponseMessage(null);
            transaction.setComplete(true);
            transaction.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleReceivedMessage(ReceivedMessage msg) {
        Object tag = msg.getTag();
        CommTransaction transaction = this.getCommTransactionManager().getCommTransactionMatch(tag);
        if (transaction == null) {
            return false;
        }
        CommTransaction commTransaction = transaction;
        synchronized (commTransaction) {
            if (!transaction.isUsed()) {
                if (this.basicNetwork.getLog().isTraceOn()) {
                    this.basicNetwork.getLog().trace("Unmatched response received - assuming unsolicited");
                }
                return false;
            }
            transaction.setResponseMessage(transaction.getRequestMessage().toResponse(msg));
            transaction.setComplete(true);
            transaction.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(UnsolicitedMessageListener listener) {
        Object unsolicitedListenerCode = listener.getUnsolicitedListenerCode();
        if (unsolicitedListenerCode == null) {
            return;
        }
        Hashtable<Object, ArrayList<UnsolicitedMessageListener>> hashtable = this.listeners;
        synchronized (hashtable) {
            ArrayList<UnsolicitedMessageListener> v = this.listeners.get(unsolicitedListenerCode);
            if (v == null) {
                v = new ArrayList(4);
                this.listeners.put(unsolicitedListenerCode, v);
            }
            for (int i = 0; i < v.size(); ++i) {
                UnsolicitedMessageListener ld = v.get(i);
                if (listener != ld) continue;
                return;
            }
            v.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(UnsolicitedMessageListener listener) {
        Object unsolicitedListenerCode = listener.getUnsolicitedListenerCode();
        if (unsolicitedListenerCode == null) {
            return;
        }
        Hashtable<Object, ArrayList<UnsolicitedMessageListener>> hashtable = this.listeners;
        synchronized (hashtable) {
            ArrayList<UnsolicitedMessageListener> v = this.listeners.get(unsolicitedListenerCode);
            if (v == null) {
                return;
            }
            this.unregister(v, listener);
        }
    }

    private void unregister(ArrayList<UnsolicitedMessageListener> v, UnsolicitedMessageListener listener) {
        for (int i = v.size() - 1; i >= 0; --i) {
            UnsolicitedMessageListener ld = v.get(i);
            if (listener != ld) continue;
            v.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void routeToListeners(ReceivedMessage msg) {
        Object unsolicitedListenerCode = msg.getUnsolicitedListenerCode();
        if (unsolicitedListenerCode == null) {
            return;
        }
        Hashtable<Object, ArrayList<UnsolicitedMessageListener>> hashtable = this.listeners;
        synchronized (hashtable) {
            ArrayList<UnsolicitedMessageListener> v = this.listeners.get(unsolicitedListenerCode);
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    UnsolicitedMessageListener ld = v.get(i);
                    ld.receiveMessage(msg);
                }
            }
        }
    }

    class StopRequest
    implements Runnable {
        private boolean complete = false;

        @Override
        public synchronized void run() {
            this.complete = true;
            this.notify();
        }

        public synchronized void stop() {
            if (!this.complete) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    Comm.this.basicNetwork.getLog().error("Error in Comm.StopRequest.stop()", (Throwable)e);
                }
            }
        }
    }

    public static abstract class CommSupport {
        Comm comm;

        public final Comm getComm() {
            return this.comm;
        }

        void setComm(Comm comm) {
            this.comm = comm;
        }
    }
}

