/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.file.history;

import com.tridium.driver.file.history.BDelimitedFileImport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public abstract class BCsvFileImport
extends BDelimitedFileImport {
    @Generated
    public static final Type TYPE = Sys.loadType(BCsvFileImport.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCsvFileImport() {
        this.setFlags((Slot)delimiter, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeFileImport(BIFile file) {
        InputStream in = null;
        BufferedReader fileReader = null;
        this.executeInProgress();
        int fileLineTracker = -1;
        try {
            BHistoryId id = this.getHistoryId();
            if (id.isNull()) {
                this.executeFail(lex.getText("import.error.nullId"));
                return;
            }
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (localDb == null) {
                this.executeFail(lex.getText("import.error.dbNotAvailable"));
                return;
            }
            BTypeSpec recordType = BCsvFileImport.getRecordType(this.getValueFormat());
            if (recordType == null) {
                Object[] args = new Object[]{this.getValueFormat()};
                this.executeFail(lex.getText("import.error.invalidRecordType", args));
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.getTimestampFormat());
            in = file.getInputStream();
            fileReader = new BufferedReader(new InputStreamReader(in));
            String[][] fileContents = this.parseCsv(fileReader);
            int startIndex = this.getRowStart();
            fileLineTracker = startIndex + 1;
            int endIndex = fileContents.length;
            if (this.getRowEnd() >= 0) {
                endIndex = Math.min(endIndex, this.getRowEnd() + 1);
            }
            int timeCol = this.getTimestampColumnIndex();
            int valCol = this.getValueColumnIndex();
            int statusCol = this.getStatusColumnIndex();
            int idCol = this.getIdentifierColumnIndex();
            if (this.rowPattern == null) {
                this.rowPattern = new BDelimitedFileImport.Pattern(this.getIdentifierPattern());
            }
            BDelimitedFileImport.Pattern rowId = this.rowPattern;
            boolean checkIdentifier = idCol >= 0 && rowId != null;
            Vector<BDelimitedFileImport.DelimitedRow> csvRows = new Vector<BDelimitedFileImport.DelimitedRow>();
            for (int i = startIndex; i < endIndex; ++i) {
                String statusString;
                String valueString;
                String timestampString;
                block68: {
                    block67: {
                        timestampString = null;
                        valueString = null;
                        statusString = null;
                        if (!checkIdentifier) break block67;
                        if (rowId.isMatch(fileContents[i][idCol])) {
                            if (timeCol >= 0) {
                                timestampString = fileContents[i][timeCol];
                            }
                            valueString = fileContents[i][valCol];
                            if (statusCol >= 0) {
                                statusString = fileContents[i][statusCol];
                            }
                            break block68;
                        } else {
                            ++fileLineTracker;
                            continue;
                        }
                    }
                    if (timeCol >= 0) {
                        timestampString = fileContents[i][timeCol];
                    }
                    valueString = fileContents[i][valCol];
                    if (statusCol >= 0) {
                        statusString = fileContents[i][statusCol];
                    }
                }
                BAbsTime tstamp = null;
                tstamp = timeCol >= 0 ? BAbsTime.make((long)dateFormat.parse(timestampString, new ParsePosition(0)).getTime()) : BAbsTime.now();
                BStatus status = BStatus.ok;
                if (statusCol >= 0) {
                    status = BStatus.make((int)Integer.parseInt(statusString));
                }
                csvRows.addElement(new BDelimitedFileImport.DelimitedRow(tstamp, valueString, status));
                ++fileLineTracker;
            }
            fileLineTracker = -1;
            BDelimitedFileImport.DelimitedRow[] rows = BDelimitedFileImport.sortByTimestamp(csvRows);
            BHistoryConfig config = null;
            BIHistory history = null;
            BAbsTime lastTimestamp = null;
            try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                if (!conn.exists(id)) {
                    config = this.makeLocalConfig(this.makeLocalHistoryFileConfig(id, recordType));
                    conn.createHistory(config);
                    history = conn.getHistory(id);
                } else {
                    if (this.getFullImportOnExecute()) {
                        conn.clearAllRecords(id);
                    }
                    config = this.makeLocalConfig(conn.getHistory(id).getConfig());
                    conn.reconfigureHistory(config);
                    history = conn.getHistory(id);
                    if (!this.getFullImportOnExecute()) {
                        lastTimestamp = conn.getLastTimestamp(history);
                    }
                }
                recordType = config.getRecordType();
                String recTypeName = recordType.getTypeName();
                BHistoryRecord rec = config.makeRecord();
                this.appendToHistory((HistorySpaceConnection)conn, history, rec, lastTimestamp, rows, recTypeName);
            }
            this.executeOk();
            return;
        }
        catch (Exception e) {
            if (fileLineTracker >= 0) {
                System.out.println("File import failed on file line " + fileLineTracker + ".");
            }
            e.printStackTrace();
            if (fileLineTracker >= 0) {
                Object[] args = new Object[]{fileLineTracker};
                this.executeFail(lex.getText("import.fileError.lineNumber", args));
                return;
            }
            if (e instanceof LocalizableRuntimeException) {
                this.executeFail(((LocalizableRuntimeException)e).toString(null));
                return;
            }
            this.executeFail(e);
            return;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    abstract String[][] parseCsv(BufferedReader var1) throws IOException;
}

