/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.ui.history;

import com.tridium.json.JSONObject;
import java.util.Optional;
import javax.baja.driver.history.BArchiveFolder;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.sys.BIObject;
import javax.baja.sys.Type;

public class DriverHistoryInfo {
    private final BIObject object;

    public DriverHistoryInfo(BIObject obj) {
        this.object = obj;
    }

    public Optional<Type> getArchiveFolderType() {
        if (this.object instanceof BIArchiveFolder) {
            return Optional.of(((BIArchiveFolder)this.object).getArchiveFolderType());
        }
        return Optional.empty();
    }

    public Optional<Type> getExportDescriptorType() {
        if (this.object instanceof BIArchiveFolder) {
            return Optional.ofNullable(((BIArchiveFolder)this.object).getExportDescriptorType());
        }
        return Optional.empty();
    }

    public boolean supportsArchiveFolders() {
        if (this.object instanceof BIArchiveFolder) {
            boolean thirdPartyOverrodeToDifferentType;
            BIArchiveFolder archiveFolder = (BIArchiveFolder)this.object;
            Type archiveFolderType = archiveFolder.getArchiveFolderType();
            boolean bl = thirdPartyOverrodeToDifferentType = !archiveFolderType.equals(BArchiveFolder.TYPE);
            if (thirdPartyOverrodeToDifferentType) {
                return true;
            }
            return archiveFolder.getDeviceExt().supportsGenericArchiveFolder();
        }
        return true;
    }

    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        this.getArchiveFolderType().ifPresent(archiveFolderType -> obj.put("archiveFolderType", (Object)archiveFolderType.toString()));
        this.getExportDescriptorType().ifPresent(exportDescriptorType -> obj.put("exportDescriptorType", (Object)exportDescriptorType.toString()));
        obj.put("supportsArchiveFolders", this.supportsArchiveFolders());
        return obj;
    }
}

