/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver;

import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.sys.metrics.Metrics;
import com.tridium.util.PxUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.BNetworkExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="health", type="BPingHealth", defaultValue="new BPingHealth()", flags=65), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="monitor", type="BPingMonitor", defaultValue="new BPingMonitor()")})
@NiagaraActions(value={@NiagaraAction(name="ping", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public abstract class BDeviceNetwork
extends BComponent
implements BIDeviceFolder,
BIStatus,
BIPingable,
BILicensed {
    @Generated
    public static final Property status = BDeviceNetwork.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property enabled = BDeviceNetwork.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property faultCause = BDeviceNetwork.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property health = BDeviceNetwork.newProperty((int)65, (BValue)new BPingHealth(), null);
    @Generated
    public static final Property alarmSourceInfo = BDeviceNetwork.newProperty((int)0, (BValue)BDeviceNetwork.initAlarmSourceInfo(), null);
    @Generated
    public static final Property monitor = BDeviceNetwork.newProperty((int)0, (BValue)new BPingMonitor(), null);
    @Generated
    public static final Action ping = BDeviceNetwork.newAction((int)16, null);
    @Generated
    public static final Action ackAlarm = BDeviceNetwork.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceNetwork.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/deviceNetwork.png");
    private static HashMap<String, HashMap<String, LicenseLimit>> globalLimits = new HashMap();
    private static final double EPSILON = 1.0E-5;
    private Logger log;
    private int oldStatus = 0;
    private boolean fatalFault;
    private boolean configFault;
    private boolean descendantsStarted;
    private HashMap<String, LicenseLimit> limits;
    private final AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Override
    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    @Generated
    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    @Generated
    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Override
    @Generated
    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    @Generated
    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    @Override
    @Generated
    public void ping() {
        this.invoke(ping, null, null);
    }

    @Override
    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public abstract Type getDeviceType();

    @Override
    public abstract Type getDeviceFolderType();

    @Override
    public final BDeviceNetwork getNetwork() {
        return this;
    }

    public final BNetworkExt[] getNetworkExts() {
        return (BNetworkExt[])this.getChildren(BNetworkExt.class);
    }

    public BDevice[] getDevices() {
        List<BDevice> list = this.getBDeviceList();
        return list.toArray(new BDevice[0]);
    }

    public List<BDevice> getBDeviceList() {
        ArrayList<BDevice> list = new ArrayList<BDevice>();
        this.getDevices(this, this.getDeviceType(), list);
        return list;
    }

    private void getDevices(BComponent comp, Type deviceType, List<BDevice> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(deviceType)) {
                list.add((BDevice)kid);
                continue;
            }
            this.getDevices(kid, deviceType, list);
        }
    }

    public final boolean isDescendantsStarted() {
        return this.descendantsStarted;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return !this.getEnabled() || this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    @Override
    public final void updateStatus() {
        int newStatus = this.getStatus().getBits();
        newStatus = !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.getHealth().getDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault | this.configFault ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        BNetworkExt[] exts = this.getNetworkExts();
        for (int i = 0; i < exts.length; ++i) {
            try {
                exts[i].updateStatus();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            try {
                devices[i].updateStatus();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public Feature getLicenseFeature() {
        return null;
    }

    private void checkLicense(String badGroups) {
        try {
            if (badGroups != null) {
                this.fatalFault = true;
                this.getLogger().severe("Exceeded network limit for " + badGroups);
                this.setFaultCause("Exceeded network limit for " + badGroups);
                return;
            }
            Feature feature = this.getLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
            String globalKey = feature.getVendorName() + ":" + feature.getFeatureName();
            globalKey = TextUtil.toLowerCase((String)globalKey);
            this.limits = globalLimits.get(globalKey);
            if (this.limits != null) {
                return;
            }
            this.limits = new HashMap();
            globalLimits.put(globalKey, this.limits);
            String[] keys = feature.list();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.endsWith(".limit")) continue;
                String val = feature.get(key);
                int limit = Integer.MAX_VALUE;
                if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
                    limit = Integer.parseInt(val);
                }
                LicenseLimit lic = new LicenseLimit();
                lic.key = key;
                lic.used = 0.0;
                lic.limit = limit;
                this.limits.put(key, lic);
            }
        }
        catch (Exception e) {
            this.fatalFault = true;
            this.getLogger().log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
            this.setFaultCause("Unlicensed: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getLicenseCount(String key) {
        if (this.limits == null) {
            return 0.0;
        }
        HashMap<String, LicenseLimit> hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit lic = this.limits.get(key);
            if (lic == null) {
                return 0.0;
            }
            return lic.used;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkLicenseLimit(String key, Object obj) {
        if (this.limits == null) {
            return null;
        }
        HashMap<String, LicenseLimit> hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit lic = this.limits.get(key);
            if (lic == null) {
                return "Unlicensed: " + key;
            }
            BObject bObj = obj instanceof BObject ? (BObject)obj : null;
            lic.used += BISubLicenseable.getLicenseLimitIncrement((BObject)bObj);
            if (lic.used - (double)lic.limit > 1.0E-5) {
                return "Exceeded " + lic.key + " of " + lic.limit;
            }
            return null;
        }
    }

    protected IFuture postPing() {
        try {
            this.doPing();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void doPing() throws Exception {
        this.pingOk();
    }

    @Override
    public void pingOk() {
        this.getHealth().pingOk();
    }

    @Override
    public void pingFail(String cause) {
        this.getHealth().pingFail(cause);
    }

    @Override
    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getHealth().doAckAlarm(ackRequest);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(ping)) {
            return this.postPing();
        }
        return super.post(action, arg, cx);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 501: {
                return this.checkLicenseLimit((String)a, b);
            }
            case 503: {
                return (int)Math.ceil(this.getLicenseCount((String)a) - 1.0E-5);
            }
            case 502: {
                return this.alarmSupport;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.checkLicense(Metrics.incrementNetwork((BComplex)this));
        this.updateStatus();
    }

    private void fwDescendantsStarted() {
        this.updateStatus();
        this.descendantsStarted = true;
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.updateStatus();
        }
    }

    @Deprecated
    public Log getLog() {
        return Log.getLog((String)this.getLogger().getName());
    }

    public Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getType().getModule().getModuleName());
        }
        return this.log;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.limits != null) {
            out.startTable(true);
            out.trTitle((Object)"License Limits", 3);
            out.w((Object)"<tr>").th((Object)"Feature").th((Object)"Used").th((Object)"Limit").w((Object)"</tr>\n");
            for (LicenseLimit lic : this.limits.values()) {
                String limit = lic.limit == Integer.MAX_VALUE ? "none" : "" + lic.limit;
                out.tr((Object)lic.key, (Object)new DecimalFormat("#0.#").format(lic.used), (Object)limit);
            }
            out.endTable();
        }
        super.spy(out);
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        for (int i = 0; i < kids.length; ++i) {
            BComponent kid = (BComponent)kids[i];
            if (kid.getPropertyInParent().isFrozen()) continue;
            acc.add((Object)kid);
        }
        return (BINavNode[])acc.trim();
    }

    protected static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return asi;
    }

    public AgentList getAgents(Context cx) {
        TypeInfo deviceManager = Sys.getRegistry().getType("driver:DeviceManager");
        AgentList agents = super.getAgents(cx);
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(deviceManager)) continue;
            return agents;
        }
        agents.add(deviceManager.getAgentInfo());
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    public BIcon getIcon() {
        return icon;
    }

    static class LicenseLimit {
        String key;
        int limit;
        double used;

        LicenseLimit() {
        }
    }
}

