/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ping;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.driver.ping.BIPingable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="down", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="alarm", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="lastOkTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65537), @NiagaraProperty(name="lastFailTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastFailCause", type="String", defaultValue="", flags=1)})
public class BPingHealth
extends BStruct {
    @Generated
    public static final Property down = BPingHealth.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property alarm = BPingHealth.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property lastOkTime = BPingHealth.newProperty((int)65537, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailTime = BPingHealth.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailCause = BPingHealth.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPingHealth.class);
    private static final BIcon icon = BIcon.std((String)"monitor.png");
    long lastAttemptTicks = 0L;

    @Generated
    public boolean getDown() {
        return this.getBoolean(down);
    }

    @Generated
    public void setDown(boolean v) {
        this.setBoolean(down, v, null);
    }

    @Generated
    public boolean getAlarm() {
        return this.getBoolean(alarm);
    }

    @Generated
    public void setAlarm(boolean v) {
        this.setBoolean(alarm, v, null);
    }

    @Generated
    public BAbsTime getLastOkTime() {
        return (BAbsTime)this.get(lastOkTime);
    }

    @Generated
    public void setLastOkTime(BAbsTime v) {
        this.set(lastOkTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailTime() {
        return (BAbsTime)this.get(lastFailTime);
    }

    @Generated
    public void setLastFailTime(BAbsTime v) {
        this.set(lastFailTime, (BValue)v, null);
    }

    @Generated
    public String getLastFailCause() {
        return this.getString(lastFailCause);
    }

    @Generated
    public void setLastFailCause(String v) {
        this.setString(lastFailCause, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BIPingable getParentPingable() {
        return (BIPingable)this.getParent();
    }

    public boolean inFailure() {
        return this.getLastFailTime().getMillis() >= this.getLastOkTime().getMillis();
    }

    public void pingOk() {
        this.lastAttemptTicks = Clock.ticks();
        long now = System.currentTimeMillis();
        long truncated = now - now % 60000L;
        BAbsTime t = truncated <= this.getLastFailTime().getMillis() ? BAbsTime.make((long)now) : BAbsTime.make((long)truncated);
        this.setLastOkTime(t);
        BIPingable parent = this.getParentPingable();
        if (this.getDown()) {
            this.setDown(false);
            parent.updateStatus();
        }
        parent.getMonitor().pingOk(parent);
    }

    public void pingFail(String cause) {
        this.lastAttemptTicks = Clock.ticks();
        long now = System.currentTimeMillis();
        long truncated = now - now % 60000L;
        BAbsTime t = truncated <= this.getLastOkTime().getMillis() ? BAbsTime.make((long)now) : BAbsTime.make((long)truncated);
        this.setLastFailTime(t);
        this.setLastFailCause(cause == null ? "" : cause);
        BIPingable parent = this.getParentPingable();
        if (!this.getDown()) {
            this.setDown(true);
            parent.updateStatus();
        }
        try {
            parent.getMonitor().pingFail(parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BIPingable parent = this.getParentPingable();
        return parent.getMonitor().alarmAck(parent, ackRequest);
    }

    public String toString(Context cx) {
        if (this.inFailure()) {
            return "Fail [" + this.getLastFailTime().toString(cx) + "] " + this.getLastFailCause();
        }
        return "Ok [" + this.getLastOkTime().toString(cx) + "]";
    }

    public BIcon getIcon() {
        return icon;
    }
}

