/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import java.util.logging.Logger;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BITunable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

public class Tuning {
    private static final BIcon icon = BIcon.std((String)"wrench.png");
    static final int FATAL = 1;
    static final int DOWN = 2;
    static final int DISABLED = 4;
    static final int STOP = 8;
    static final int DESIRED_SUB = 16;
    static final int UNOPERATIONAL = 15;
    static final int STATE = 31;
    static final int SUBSCRIBED = 32;
    static final int WRITE_PENDING = 64;
    static final Logger log = Logger.getLogger("driver.tuning");
    static long writeOnDelay = 5000L;
    BITunable parent;
    String cachedPolicyName;
    BTuningPolicy cachedPolicy;
    int packed;
    long readTicks;
    long writeTicks;
    long writeDesiredTicks = -1L;
    Context writeDesiredContext;

    public Tuning(BITunable parent) {
        this.parent = parent;
        this.state(8);
    }

    public final BDeviceNetwork getNetwork() {
        BComplex parent = (BComplex)this.parent;
        if (parent instanceof BProxyExt) {
            return ((BProxyExt)parent).getNetwork();
        }
        while (parent != null) {
            if (parent instanceof BDeviceNetwork) {
                return (BDeviceNetwork)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public final BTuningPolicyMap getPolicyMap() {
        BTuningPolicyMap map = (BTuningPolicyMap)this.getNetwork().get("tuningPolicies");
        if (map != null) {
            return map;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    public BTuningPolicy getPolicy() {
        String currentPolicyName = this.parent.getTuningPolicyName();
        if (this.cachedPolicy == null || this.cachedPolicyName != currentPolicyName) {
            BTuningPolicyMap map = this.getPolicyMap();
            this.cachedPolicyName = currentPolicyName;
            BValue x = map.get(this.cachedPolicyName);
            if (x instanceof BTuningPolicy) {
                this.cachedPolicy = (BTuningPolicy)x;
            } else {
                log.warning("TuningPolicy not found: " + this.cachedPolicyName);
                this.cachedPolicy = map.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    public final BITunable getTunable() {
        return this.parent;
    }

    public final long getLastReadTicks() {
        return this.readTicks;
    }

    public final long getLastWriteTicks() {
        return this.writeTicks;
    }

    public final BAbsTime getLastReadTime() {
        if (this.readTicks == 0L) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make((long)(System.currentTimeMillis() - (Clock.ticks() - this.readTicks)));
    }

    public final BAbsTime getLastWriteTime() {
        if (this.writeTicks == 0L) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make((long)(System.currentTimeMillis() - (Clock.ticks() - this.writeTicks)));
    }

    public String toString(Context cx) {
        String name = this.parent.getTuningPolicyName();
        if (name.equals("defaultPolicy")) {
            return BTuningPolicyMap.defaultPolicy.getDefaultDisplayName(cx);
        }
        return SlotPath.unescape((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition() {
        if (this.processId() == 0) {
            this.registerForProcessing();
        }
        BITunable tunable = this.getTunable();
        boolean callSub = false;
        boolean callUnsub = false;
        Tuning tuning = this;
        synchronized (tuning) {
            boolean newSub;
            boolean oldSub;
            int newState = Tuning.toState(tunable);
            int oldState = this.state();
            if (newState == oldState) {
                return;
            }
            this.state(newState);
            if (Tuning.isOperational(newState) && tunable.getMode().isWrite()) {
                BTuningPolicy policy = this.getPolicy();
                if (Tuning.isDownToUp(oldState, newState) && policy.getWriteOnUp()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnUpContext;
                } else if (Tuning.isDisabledToEnabled(oldState, newState) && policy.getWriteOnEnabled()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnEnabledContext;
                } else if (Tuning.isStopToStart(oldState, newState) && policy.getWriteOnStart()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnStartContext;
                }
            }
            if ((oldSub = this.subscribed()) != (newSub = Tuning.shouldBeSubscribed(newState))) {
                this.subscribed(newSub);
                if (newSub) {
                    callSub = true;
                } else {
                    callUnsub = true;
                }
            }
        }
        if (callSub) {
            this.readSubscribed();
        }
        if (callUnsub) {
            this.readUnsubscribed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDesired() {
        Tuning tuning = this;
        synchronized (tuning) {
            if (!Tuning.isOperational(this.state())) {
                return;
            }
            long minWrite = this.getPolicy().getMinWriteTime().getMillis();
            if (minWrite > 0L) {
                if (this.writeDesiredTicks < 0L) {
                    this.writeDesiredTicks = Clock.ticks();
                }
                return;
            }
        }
        this.write(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readOk() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.readTicks = Clock.ticks();
        }
    }

    public void readFail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOk() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.writePending(false);
            this.writeTicks = Clock.ticks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFail() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.writePending(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Context cx) {
        block9: {
            BITunable tunable = this.getTunable();
            Tuning tuning = this;
            synchronized (tuning) {
                if (this.writePending() || !Tuning.isOperational(this.state()) || !tunable.getMode().isWrite()) {
                    return;
                }
                this.writePending(true);
                this.writeDesiredTicks = -1L;
                this.writeDesiredContext = null;
            }
            try {
                boolean pending = tunable.write(cx);
                if (pending) break block9;
                Tuning tuning2 = this;
                synchronized (tuning2) {
                    this.writePending(false);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.writePending(false);
                tunable.writeFail("write(): " + e);
            }
        }
    }

    void readSubscribed() {
        try {
            this.getTunable().readSubscribed(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.getTunable().readFail("readSubscribed(): " + e);
        }
    }

    void readUnsubscribed() {
        try {
            this.getTunable().readUnsubscribed(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void stale() {
        try {
            this.getTunable().setStale(true, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void registerForProcessing() {
        try {
            BTuningPolicyMap map = this.getPolicyMap();
            if (map != null) {
                this.processId(map.register(this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean process() {
        long okTicks;
        if (!((BComponent)this.parent).isMounted()) {
            return false;
        }
        BTuningPolicy policy = this.getPolicy();
        long minWrite = policy.getMinWriteTime().getMillis();
        long maxWrite = policy.getMaxWriteTime().getMillis();
        long staleTime = policy.getStaleTime().getMillis();
        long now = Clock.ticks();
        boolean write = false;
        Context writeContext = null;
        Tuning tuning = this;
        synchronized (tuning) {
            if (this.writeDesiredTicks != -1L && this.writeDesiredTicks <= now) {
                if (now - this.writeTicks >= minWrite) {
                    write = true;
                    writeContext = this.writeDesiredContext;
                }
            } else if (maxWrite > 0L && now - this.writeTicks >= maxWrite) {
                write = true;
                writeContext = BTuningPolicy.maxWriteTimeContext;
            }
        }
        if (write) {
            this.write(writeContext);
        }
        if (staleTime > 0L && now - (okTicks = this.parent.getMode().isWriteonly() ? this.writeTicks : this.readTicks) > staleTime) {
            this.stale();
        }
        return true;
    }

    static int toState(BITunable tunable) {
        BStatus status = tunable.getStatus();
        boolean fatal = tunable.isFatalFault();
        boolean down = status.isDown();
        boolean disabled = status.isDisabled();
        boolean stop = !tunable.isRunning() || !Sys.atSteadyState();
        boolean desiredSub = tunable.isSubscribedDesired();
        int state = 0;
        state = Tuning.set(state, 1, fatal);
        state = Tuning.set(state, 2, down);
        state = Tuning.set(state, 4, disabled);
        state = Tuning.set(state, 8, stop);
        state = Tuning.set(state, 16, desiredSub);
        return state;
    }

    static boolean get(int state, int bit) {
        return (state & bit) != 0;
    }

    static int set(int state, int bit, boolean value) {
        if (value) {
            return state |= bit;
        }
        return state &= ~bit;
    }

    static boolean isOperational(int state) {
        return (state & 0xF) == 0;
    }

    static boolean isDownToUp(int old, int cur) {
        return Tuning.get(old, 2) && !Tuning.get(cur, 2);
    }

    static boolean isDisabledToEnabled(int old, int cur) {
        return Tuning.get(old, 4) && !Tuning.get(cur, 4);
    }

    static boolean isStopToStart(int old, int cur) {
        return Tuning.get(old, 8) && !Tuning.get(cur, 8);
    }

    static boolean shouldBeSubscribed(int state) {
        return state == 16;
    }

    static String toString(int state) {
        StringBuilder s = new StringBuilder();
        if (Tuning.get(state, 1)) {
            s.append("fatal ");
        }
        if (Tuning.get(state, 2)) {
            s.append("down ");
        }
        if (Tuning.get(state, 4)) {
            s.append("disabled ");
        }
        if (Tuning.get(state, 8)) {
            s.append("stop ");
        }
        if (Tuning.get(state, 16)) {
            s.append("desiredSub ");
        }
        return "{" + s.toString().trim() + "}";
    }

    public BIcon getIcon() {
        return icon;
    }

    final int state() {
        return this.packed & 0x1F;
    }

    final void state(int state) {
        this.packed = this.packed & 0xFFFFFFE0 | state;
    }

    final boolean subscribed() {
        return (this.packed & 0x20) != 0;
    }

    final void subscribed(boolean b) {
        this.packed = b ? (this.packed |= 0x20) : (this.packed &= 0xFFFFFFDF);
    }

    final boolean writePending() {
        return (this.packed & 0x40) != 0;
    }

    final void writePending(boolean b) {
        this.packed = b ? (this.packed |= 0x40) : (this.packed &= 0xFFFFFFBF);
    }

    final int processId() {
        return this.packed >> 8 & 0xFFFFFF;
    }

    final void processId(int id) {
        if (id > 0xFFFFFF) {
            throw new IllegalStateException();
        }
        this.packed = this.packed & 0xFF | id << 8;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"Tuning", 2);
        if (this.parent instanceof BComplex) {
            out.prop((Object)"parent", (Object)((BComplex)this.parent).getDisplayName(null));
        }
        out.prop((Object)"parent.isRunning", this.parent.isRunning());
        out.prop((Object)"parent.status", (Object)this.parent.getStatus());
        out.prop((Object)"parent.isSubscribedDesired", this.parent.isSubscribedDesired());
        out.prop((Object)"parent.mode", (Object)this.parent.getMode());
        out.prop((Object)"cachedPolicyName", (Object)this.cachedPolicyName);
        out.prop((Object)"state", (Object)Tuning.toString(this.packed));
        out.prop((Object)"isOperational", Tuning.isOperational(this.packed));
        out.prop((Object)"subscribed", this.subscribed());
        out.prop((Object)"writePending", this.writePending());
        out.prop((Object)"processId", this.processId());
        out.prop((Object)"readTicks", (Object)Tuning.timestr(this.readTicks));
        out.prop((Object)"writeTicks", (Object)Tuning.timestr(this.writeTicks));
        out.prop((Object)"writeDesiredTicks", (Object)Tuning.timestr(this.writeDesiredTicks));
        out.prop((Object)"writeDesiredContext", (Object)this.writeDesiredContext);
        out.endProps();
    }

    static String timestr(long ticks) {
        if (ticks == 0L) {
            return "null";
        }
        long now = Clock.ticks();
        long diff = now - ticks;
        if (diff < 1000L) {
            return "" + diff + "ms";
        }
        return diff / 1000L + "sec";
    }
}

