/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point.conv;

import com.tridium.driver.util.UnitConversionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.conv.BLinearConversion;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
public final class BLinearWithUnitConversion
extends BProxyConversion {
    public static final BLinearWithUnitConversion DEFAULT = new BLinearWithUnitConversion(1.0, 0.0, false);
    public static final Type TYPE = Sys.loadType(BLinearWithUnitConversion.class);
    private static final LexiconModule LEXICON = LexiconModule.make((String)"driver");
    private double scale;
    private double offset;
    private boolean applyUnitsToDevice;
    private int hashCode = -1;

    public static BLinearWithUnitConversion make(double scale, double offset, boolean applyUnitsToDevice) {
        if (scale == 1.0 && offset == 0.0 && !applyUnitsToDevice) {
            return DEFAULT;
        }
        return (BLinearWithUnitConversion)new BLinearWithUnitConversion(scale, offset, applyUnitsToDevice).intern();
    }

    private BLinearWithUnitConversion(double scale, double offset, boolean applyUnitsTo) {
        this.scale = scale;
        this.offset = offset;
        this.applyUnitsToDevice = applyUnitsTo;
    }

    public double getScale() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public boolean getApplyUnitsToDevice() {
        return this.applyUnitsToDevice;
    }

    @Override
    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            if (this.getApplyUnitsToDevice()) {
                UnitConversionUtil.convertUnits(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true);
                BLinearConversion.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)proxyValue, true, this.scale, this.offset);
            } else {
                BLinearConversion.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true, this.scale, this.offset);
                UnitConversionUtil.convertUnits(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)proxyValue, true);
            }
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    @Override
    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            if (this.getApplyUnitsToDevice()) {
                BLinearConversion.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false, this.scale, this.offset);
                UnitConversionUtil.convertUnits(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)deviceValue, false);
            } else {
                UnitConversionUtil.convertUnits(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false);
                BLinearConversion.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)deviceValue, false, this.scale, this.offset);
            }
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.offset);
            hash = hash * 37L + Double.doubleToRawLongBits(this.scale);
            hash = hash * 37L + (long)Boolean.valueOf(this.applyUnitsToDevice).hashCode();
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLinearWithUnitConversion) {
            BLinearWithUnitConversion x = (BLinearWithUnitConversion)((Object)obj);
            return this.scale == x.scale && this.offset == x.offset && this.applyUnitsToDevice == x.applyUnitsToDevice;
        }
        return false;
    }

    public String toString(Context context) {
        StringBuilder s = new StringBuilder();
        s.append(TYPE.getDisplayName(context));
        if (this.scale != 1.0) {
            s.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            s.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            s.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        String conversionText = LEXICON.get("LinearWithUnitConversion.unit.conversion", context);
        String deviceText = LEXICON.get("LinearWithUnitConversion.unit.conversion.device", context);
        String proxyText = LEXICON.get("LinearWithUnitConversion.unit.conversion.proxy", context);
        s.append(" ").append(conversionText).append(" ").append(this.applyUnitsToDevice ? deviceText : proxyText);
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.offset);
        out.writeBoolean(this.applyUnitsToDevice);
    }

    public BObject decode(DataInput in) throws IOException {
        return BLinearWithUnitConversion.make(in.readDouble(), in.readDouble(), in.readBoolean());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.scale) + ";" + BDouble.encode((double)this.offset) + ";" + BBoolean.encode((boolean)this.applyUnitsToDevice);
    }

    public BObject decodeFromString(String s) throws IOException {
        String[] parts = s.split(";");
        return BLinearWithUnitConversion.make(BDouble.decode((String)parts[0]), BDouble.decode((String)parts[1]), BBoolean.decode((String)parts[2]));
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

