/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSyncBacnet;

import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.fcModelSync.driver.BModelDiscoverer;
import com.tridium.util.CompUtil;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetDevice"})})
public class BBacnetModelDiscoverer
extends BModelDiscoverer {
    public static final Type TYPE = Sys.loadType(BBacnetModelDiscoverer.class);
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_UNITS = "units";
    private static final Logger logger = Logger.getLogger("fcModelSync.bacnet");
    private static final boolean readAdditionalProps = false;

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BBacnetDevice.TYPE;
    }

    public void discoverModelInfo(BDevice device, JobLog log) {
        log.message("Discovering BACnet model information for " + device.getName());
        BBacnetDevice dev = (BBacnetDevice)device;
        BOrd jobOrd = dev.getPoints().doSubmitPointDiscoveryJob(null);
        BBacnetDiscoverPointsJob job = (BBacnetDiscoverPointsJob)jobOrd.get((BObject)device);
        int count = 0;
        while (job.isAlive() && !job.getJobState().isComplete()) {
            if (++count % 5 == 0) {
                log.message("Waiting on point discovery for " + dev);
                count = 0;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.endFailed("Model discovery job interrupted!", (Throwable)e);
            }
        }
        BDiscoveryPoint[] discPts = (BDiscoveryPoint[])job.getChildren(BDiscoveryPoint.class);
        log.message("Point discovery job complete; point count: " + discPts.length);
        for (BDiscoveryPoint discPt : discPts) {
            BControlPoint pt = this.getProxyPoint(discPt, dev);
            if (pt == null) continue;
            this.addDescriptionToProxyExt(pt, discPt);
        }
    }

    public BControlPoint getProxyPoint(BDiscoveryPoint discPt, BBacnetDevice dev) {
        BControlPoint pt = dev.getPoints().findPoint(discPt.getObjectId(), discPt.getPropertyId(), discPt.getPropertyArrayIndex());
        logger.fine(() -> String.format("DiscoveryPoint %s, BACnet proxy point is %s [%s]", discPt, pt != null ? pt : "null", pt != null ? pt.getSlotPath() : "null"));
        return pt;
    }

    public void addDescriptionToProxyExt(BControlPoint pt, BDiscoveryPoint discPt) {
        String description = discPt.getDescription();
        if (description != null && !description.isEmpty()) {
            logger.finest(() -> String.format("Adding description for point %s [%s.%s]: %s", pt.getSlotPath(), discPt.getObjectId(), discPt.getPropertyIdentifier(), description));
            CompUtil.setOrAdd((BComponent)pt.getProxyExt(), (String)PROP_DESCRIPTION, (BValue)BString.make((String)description), (int)2, null, null);
        }
    }

    public void addUnitsToProxyExt(BControlPoint pt, BDiscoveryPoint[] props) {
        BDiscoveryPoint unitsProp = Arrays.stream(props).filter(prop -> prop.getPropertyId() == 117).findFirst().orElse(null);
        CompUtil.setOrAdd((BComponent)pt.getProxyExt(), (String)PROP_UNITS, (BValue)BString.make((String)unitsProp.getValue().toString()), (int)2, null, null);
    }

    public boolean isAnalog(BBacnetObjectIdentifier objectId) {
        return objectId.getObjectType() <= 2;
    }

    public boolean isBinary(BBacnetObjectIdentifier objectId) {
        return objectId.getObjectType() >= 3 && objectId.getObjectType() <= 5;
    }
}

