/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.ui;

import com.tridium.report.BExportSourceInfo;
import com.tridium.workbench.fieldeditors.BDialogFE;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"report:ExportSourceInfo"}, requiredPermissions="r")})
public class BExportSourceInfoFE
extends BDialogFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BExportSourceInfoFE.class);
    static BImage wizardIcon = BImage.make((String)"module://icons/x32/wizard.png");
    static AgentFilter ExporterFilter = AgentFilter.is((String)"baja:Exporter");
    static Lexicon lex = Lexicon.make((String)"report");
    private static AgentFilter viewFilter = AgentFilter.is((TypeInfo)BWbView.TYPE.getTypeInfo());
    private static AgentFilter ExportFilter = AgentFilter.is((Type)BExporter.TYPE);
    private BLabel label;
    private BExportSourceInfo src;
    private BOrd source = BOrd.NULL;
    private BOrd tempTarget = BOrd.NULL;
    private String agentId = null;
    private BExporter exporter = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExportSourceInfoFE() {
        BFlowPane flow = new BFlowPane();
        this.label = new BLabel();
        flow.add(null, (BValue)this.label);
        flow.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)flow);
    }

    protected void doSetReadonly(boolean readonly) {
        this.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.src = (BExportSourceInfo)value;
        this.source = this.src.getSource();
        this.agentId = this.src.getAgentId();
        this.exporter = this.src.getExporter();
        if (this.exporter != null) {
            this.exporter = (BExporter)this.exporter.newCopy(true);
        }
        this.setText();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return BExportSourceInfo.make((BOrd)this.source, (String)this.agentId, (BExporter)this.exporter);
    }

    private void setText() {
        this.label.setText(this.source.toString() + " [" + this.agentId + "]");
    }

    public void doEditPressed() {
        BWizard.open((BWidget)this, (WizardModel)new Wizard());
    }

    static String text(String key) {
        return lex.getText("exportSourceInfoFE.wizard." + key);
    }

    class Wizard
    extends WizardModel {
        private BWidget step0;
        private BWidget step1;
        private BWbFieldEditor editor;
        private BListDropDown list;
        private BBorderPane setupPane = new BBorderPane();
        private BWbEditor setup;

        public Wizard() {
            this.buildStep0();
            this.buildStep1();
        }

        void buildStep0() {
            this.editor = BWbFieldEditor.makeFor((BObject)BExportSourceInfoFE.this.source, (Context)BExportSourceInfoFE.this.getCurrentContext());
            this.editor.loadValue((BObject)BExportSourceInfoFE.this.source, BExportSourceInfoFE.this.getCurrentContext());
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(BExportSourceInfoFE.text("sourceOrd")));
            grid.add(null, (BValue)this.editor);
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)new BWizardHeader(wizardIcon, this.getTitle(), UiLexicon.bajaui().getText("wizard.step1") + " of 2"));
            edge.setCenter((BWidget)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0));
            this.step0 = edge;
        }

        void buildStep1() {
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(BExportSourceInfoFE.text("exporter")));
            this.list = new BListDropDown();
            grid.add(null, (BValue)this.list);
            this.list.getList().setSelection((ListSelection)new ExporterListSelection());
            BTabbedPane tabs = new BTabbedPane();
            tabs.addPane(lex.getText("exporter.action"), (BWidget)grid);
            tabs.addPane(lex.getText("exporter.setup"), (BWidget)this.setupPane);
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)new BWizardHeader(wizardIcon, this.getTitle(), UiLexicon.bajaui().getText("wizard.step2") + " of 2"));
            edge.setCenter((BWidget)tabs);
            this.step1 = edge;
        }

        public String getTitle() {
            return BExportSourceInfoFE.text("title");
        }

        public Size getPreferredSizeOfSteps() {
            return new Size(600.0, 320.0);
        }

        public void init() {
            this.updateTo0();
        }

        public void back() {
            this.updateTo0();
        }

        public void next() {
            this.updateTo1();
        }

        public boolean finish() {
            try {
                BOrd s = (BOrd)this.editor.saveValue((BObject)BExportSourceInfoFE.this.source, BExportSourceInfoFE.this.getCurrentContext());
                String a = (String)this.list.getSelectedItem();
                BExportSourceInfoFE.this.source = s;
                BExportSourceInfoFE.this.agentId = a;
                BExportSourceInfoFE.this.exporter = (BExporter)this.setup.saveValue();
                BExportSourceInfoFE.this.setText();
                BExportSourceInfoFE.this.setModified();
            }
            catch (Exception e) {
                BDialog.error((BWidget)BExportSourceInfoFE.this.getWbShell(), (String)BExportSourceInfoFE.text("error"), (Object)e);
                return false;
            }
            return true;
        }

        private void updateTo0() {
            this.update(this.step0, 2);
            this.getWizard().setNextAsDefault();
        }

        private void updateTo1() {
            try {
                BExportSourceInfoFE.this.tempTarget = (BOrd)this.editor.saveValue((BObject)BExportSourceInfoFE.this.source, BExportSourceInfoFE.this.getCurrentContext());
                BObject obj = BExportSourceInfoFE.this.tempTarget.resolve(BExportSourceInfoFE.this.getWbShell().getActiveOrdTarget().get()).get();
                if (obj instanceof BComponent) {
                    obj.asComponent().lease();
                }
                this.list.getList().removeAllItems();
                AgentList agents = obj.getAgents().filter(ExporterFilter);
                if (agents.size() == 0) {
                    this.editor.setModified();
                    BDialog.error((BWidget)BExportSourceInfoFE.this.getWbShell(), (String)"Error", (Object)BExportSourceInfoFE.text("noExporters"));
                    return;
                }
                boolean sel = false;
                for (int i = 0; i < agents.size(); ++i) {
                    String id = agents.get(i).getAgentId();
                    this.list.getList().addItem((Object)id);
                    if (!id.equals(BExportSourceInfoFE.this.agentId)) continue;
                    sel = true;
                    this.list.getList().setSelectedIndex(i);
                }
                if (!sel) {
                    this.list.getList().setSelectedIndex(0);
                }
                this.editor.setModified();
                this.update(this.step1, 5);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.editor.setModified();
                BDialog.error((BWidget)BExportSourceInfoFE.this.getWbShell(), (String)"Error", (Object)BExportSourceInfoFE.text("invalidSource"));
            }
        }

        class ExporterListSelection
        extends ListSelection {
            ExporterListSelection() {
            }

            public void updateList() {
                super.updateList();
                int idx = Wizard.this.list.getSelectedIndex();
                if (idx < 0) {
                    idx = 0;
                }
                String tempId = (String)Wizard.this.list.getList().getItem(idx);
                try {
                    BExporter exp = null;
                    if (null == BExportSourceInfoFE.this.tempTarget || BExportSourceInfoFE.this.tempTarget == BOrd.NULL) {
                        return;
                    }
                    BObject obj = BExportSourceInfoFE.this.tempTarget.resolve(BExportSourceInfoFE.this.getWbShell().getActiveOrdTarget().get()).get();
                    if (null == obj) {
                        return;
                    }
                    AgentList agents = obj.getAgents().filter(ExportFilter);
                    for (int i = 0; i < agents.size(); ++i) {
                        if (!tempId.equals(agents.get(i).getAgentId())) continue;
                        exp = (BExporter)agents.get(i).getInstance();
                        break;
                    }
                    if (null != BExportSourceInfoFE.this.agentId && BExportSourceInfoFE.this.agentId.equals(tempId) && null != BExportSourceInfoFE.this.exporter) {
                        exp = BExportSourceInfoFE.this.exporter;
                    }
                    Wizard.this.setup = (BWbEditor)exp.getAgents().filter(viewFilter).getDefault().getInstance();
                    Wizard.this.setup.loadValue((BObject)exp);
                    Wizard.this.setupPane.setContent((BWidget)Wizard.this.setup);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BDialog.error((BWidget)BExportSourceInfoFE.this.getWbShell(), (String)"Error", (Object)e);
                }
            }
        }
    }
}

