/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.servlet;

import com.tridium.bajaui.ux.BUxNullWidget;
import com.tridium.json.JSONWriter;
import com.tridium.sys.schema.ComplexType;
import com.tridium.uxBuilder.BWebWidgetWrapper;
import com.tridium.uxBuilder.servlet.PxUxAgentFilter;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.bajascript.BIBajaScriptTypeExt;
import javax.baja.bajaux.BIJavaScriptWidget;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;
import javax.baja.web.BIFormFactor;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.JsInfo;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class PxUxDecoder
extends PxDecoder {
    private final boolean includePxProperties;
    private String[] profileAppNames;
    private final Map<TypeInfo, JsInfo> typeToJsInfo = new HashMap<TypeInfo, JsInfo>();
    private static final LexiconModule LEX = LexiconModule.make(PxUxDecoder.class);
    private static final Logger LOG = Logger.getLogger(PxUxDecoder.class.getName());
    private static final AgentFilter IS_USABLE_VIEW = new AgentFilter(){

        public boolean include(AgentInfo agent) {
            TypeInfo type = agent.getAgentType();
            return PxUxDecoder.isView(type) && !PxUxDecoder.isNullWidget(type);
        }
    };

    public PxUxDecoder(BIFile file) throws Exception {
        this(file, false, null);
    }

    public PxUxDecoder(BIFile file, boolean includePxProperties, Context cx) throws Exception {
        this(file.getAbsoluteOrd(), new BufferedInputStream(file.getInputStream()), includePxProperties, cx);
    }

    public PxUxDecoder(BOrd baseOrd, InputStream in) throws Exception {
        this(baseOrd, in, false, null);
    }

    public PxUxDecoder(BOrd baseOrd, InputStream in, boolean includePxProperties, Context cx) throws Exception {
        super(baseOrd, in, cx);
        this.baseOrd = baseOrd;
        this.cx = cx;
        this.includePxProperties = includePxProperties;
    }

    public void setProfileAppNames(String[] profileAppNames) {
        this.profileAppNames = profileAppNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeToJson(JSONWriter writer) throws Exception {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Starting decode of px file " + this.baseOrd);
        }
        long start = System.currentTimeMillis();
        try {
            XElem root = this.parse();
            writer.object();
            this.decodeHeader(root);
            this.decodeImport(root);
            if (this.includePxProperties) {
                this.decodeProperties(root, writer);
            }
            this.decodeContent(root, writer);
            this.decodeTypeInfoMap(writer);
            writer.endObject();
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Decoded " + this.baseOrd + " in " + (end - start) + "ms");
            }
        }
    }

    private void decodeProperties(XElem root, JSONWriter writer) {
        XElem elem = root.elem("properties");
        if (elem == null) {
            return;
        }
        XElem[] propElems = elem.elems("property");
        writer.key("props").array();
        for (XElem propElem : propElems) {
            String name = propElem.get("name");
            String type = propElem.get("type");
            String value = propElem.get("value");
            writer.object();
            writer.key("n").value((Object)name);
            writer.key("t").value((Object)type);
            writer.key("v").value((Object)value);
            this.mapTypeInfo(this.toType(type, propElem));
            XElem[] targElems = propElem.elems("target");
            writer.key("ta").array();
            for (XElem targElem : targElems) {
                writer.object();
                String path = targElem.get("ord");
                writer.key("o").value((Object)path);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endArray();
    }

    private void decodeContent(XElem root, JSONWriter writer) {
        XElem widgetElem = this.getContentElem(root);
        writer.key("content");
        this.decodeFromElem(widgetElem, null, null, null, writer);
    }

    private void decodeFromElem(XElem x, String name, String flags, String facets, JSONWriter writer) {
        TypeInfo type = this.toType(x);
        TypeInfo wrapperType = PxUxDecoder.getWidgetWrapperType(type);
        writer.object();
        writer.key("t").value(wrapperType == null ? type : BWebWidgetWrapper.TYPE);
        if (name != null) {
            writer.key("n").value((Object)name);
        }
        if (flags != null) {
            writer.key("f").value((Object)flags);
        }
        if (facets != null && !facets.isEmpty()) {
            writer.key("ft").value((Object)facets);
        }
        if (type.is(BSimple.TYPE)) {
            String string = x.get("value");
            writer.key("v").value((Object)string);
            this.mapTypeInfo(type);
        } else {
            this.mapTypeInfo(type);
            this.decodeProps(x, type, wrapperType, writer);
        }
        writer.endObject();
    }

    private void mapTypeInfo(TypeInfo type) {
        if (this.typeToJsInfo.get(type) != null) {
            return;
        }
        AgentInfo jsWidgetInfo = null;
        AgentList list = PxUxAgentFilter.getAgentList(type).filter((AgentFilter)new PxUxAgentFilter(type, this.profileAppNames));
        if (list.size() > 0) {
            jsWidgetInfo = list.get(0);
        }
        if (jsWidgetInfo != null) {
            BObject infoInstance = jsWidgetInfo.getInstance();
            JsInfo info = infoInstance instanceof BIJavaScript ? ((BIJavaScript)infoInstance).getJsInfo(null) : ((BIBajaScriptTypeExt)infoInstance).getTypeExtJs(null);
            this.typeToJsInfo.put(type, info);
        }
    }

    private void decodeTypeInfoMap(JSONWriter writer) {
        writer.key("typeMap");
        writer.object();
        for (Map.Entry<TypeInfo, JsInfo> entry : this.typeToJsInfo.entrySet()) {
            TypeInfo type = entry.getKey();
            writer.key(type.toString());
            writer.object();
            writer.key("js").value((Object)entry.getValue().getJsId());
            BIWebResource.DependencyGraph deps = entry.getValue().resolveDependencies();
            if (!deps.isEmpty()) {
                writer.key("dg").value((Object)deps.toJSON());
            }
            if (type.is(BWidget.TYPE)) {
                writer.key("w").value(true);
            } else if (type.is(BBinding.TYPE)) {
                writer.key("b").value(true);
            }
            writer.endObject();
        }
        writer.endObject();
    }

    private TypeInfo toType(String typeSpecStr, XElem elem) {
        BTypeSpec typeSpec = BTypeSpec.make((String)typeSpecStr);
        String typeName = typeSpec.getTypeName();
        TypeInfo type = (TypeInfo)this.types.get(typeName);
        if (type != null) {
            return type;
        }
        try {
            type = Sys.getRegistry().getType(typeSpecStr);
            this.types.put(typeSpec.getTypeName(), type);
            return type;
        }
        catch (Exception exception) {
            throw this.err("Unknown type " + typeName, elem);
        }
    }

    private void decodeProps(XElem x, TypeInfo complexInfo, TypeInfo wrapperType, JSONWriter writer) {
        boolean isEnabled;
        boolean isVisible;
        BValue value;
        ComplexType cType;
        Property p;
        String type = complexInfo.getTypeName();
        String handle = null;
        boolean isVisiblePropertySet = false;
        boolean isEnabledPropertySet = false;
        writer.key("p").array();
        for (int i = 0; i < x.attrSize(); ++i) {
            String name = x.attrName(i);
            try {
                Type propertyType = null;
                if ("name".equals(name)) continue;
                if ("js".equals(name) && wrapperType != null) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning(LEX.getText("validateMedia.jsPropertyOverwritten", null, new Object[]{complexInfo}));
                    continue;
                }
                ComplexType cType2 = (ComplexType)complexInfo.getTypeSpec().getResolvedType();
                Property p2 = cType2.getFrozenProperty(name);
                if (p2 != null) {
                    propertyType = p2.getType();
                }
                if (propertyType == null && "h".equals(name) && complexInfo.is(BComponent.TYPE)) {
                    handle = x.attrValue(i);
                    continue;
                }
                writer.object();
                writer.key("n").value((Object)name);
                if (name.equals("visible")) {
                    isVisiblePropertySet = true;
                }
                if (name.equals("enabled")) {
                    isEnabledPropertySet = true;
                }
                writer.key("v").value((Object)x.attrValue(i));
                if (propertyType != null) {
                    writer.key("t").value((Object)propertyType);
                }
                writer.endObject();
                continue;
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.err("Cannot decode " + type + '.' + name, x, e);
            }
        }
        if (wrapperType != null) {
            writer.object().key("n").value((Object)"js").key("v").value((Object)("view:" + wrapperType)).key("t").value((Object)"baja:Ord").endObject();
        }
        if (!isVisiblePropertySet && (p = (cType = (ComplexType)complexInfo.getTypeSpec().getResolvedType()).getFrozenProperty("visible")) != null && (value = p.getDefaultValue()) instanceof BBoolean && !(isVisible = ((BBoolean)value).getBoolean())) {
            writer.object();
            writer.key("n").value((Object)"visible");
            writer.key("v").value((Object)"false");
            writer.key("t").value((Object)"baja:Boolean");
            writer.endObject();
        }
        if (!isEnabledPropertySet && (p = (cType = (ComplexType)complexInfo.getTypeSpec().getResolvedType()).getFrozenProperty("enabled")) != null && (value = p.getDefaultValue()) instanceof BBoolean && !(isEnabled = ((BBoolean)value).getBoolean())) {
            writer.object();
            writer.key("n").value((Object)"enabled");
            writer.key("v").value((Object)"false");
            writer.key("t").value((Object)"baja:Boolean");
            writer.endObject();
        }
        writer.endArray();
        if (handle != null) {
            writer.key("h").value(handle);
        }
        XElem[] kids = x.elems();
        writer.key("k").array();
        for (XElem kid : kids) {
            String name = kid.get("name", null);
            String flags = kid.get("f", null);
            String facets = kid.get("ft", null);
            this.decodeFromElem(kid, name, flags, facets, writer);
        }
        writer.endArray();
    }

    private static TypeInfo getWidgetWrapperType(TypeInfo type) {
        if (!type.is(BWidget.TYPE)) {
            return null;
        }
        AgentList agents = PxUxAgentFilter.getAgentList(type);
        if (PxUxDecoder.hasJsWidgetAlready(agents)) {
            return null;
        }
        AgentList jsViews = agents.filter(IS_USABLE_VIEW);
        return jsViews.size() == 0 ? null : jsViews.getDefault().getAgentType();
    }

    private static boolean hasJsWidgetAlready(AgentList agents) {
        int size = agents.size();
        for (int i = 0; i < size; ++i) {
            TypeInfo type = agents.get(i).getAgentType();
            if (!PxUxDecoder.isJsWidget(type) || PxUxDecoder.isNullWidget(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullWidget(TypeInfo type) {
        return type.is(BUxNullWidget.TYPE);
    }

    private static boolean isView(TypeInfo type) {
        return type.is(BIJavaScript.TYPE) && type.is(BIFormFactor.TYPE);
    }

    private static boolean isJsWidget(TypeInfo type) {
        return type.is(BIJavaScriptWidget.TYPE);
    }
}

