/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.GeneratedDataTypeDictionary;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class CodegenModel {
    private final GeneratedDataTypeDictionary dataTypeDictionary;
    private final Map<UaNodeId, UaDataTypeSpecification> specifications;
    private final Map<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>> constructors;

    protected CodegenModel(Map<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>> map, GeneratedDataTypeDictionary generatedDataTypeDictionary, Map<UaNodeId, UaDataTypeSpecification> map2) {
        this.constructors = Collections.unmodifiableMap(new HashMap<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>>(map));
        this.dataTypeDictionary = generatedDataTypeDictionary;
        this.specifications = Collections.unmodifiableMap(new HashMap<UaNodeId, UaDataTypeSpecification>(map2));
    }

    public Map<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>> getConstructors() {
        return this.constructors;
    }

    public GeneratedDataTypeDictionary getDataTypeDictionary() {
        return this.dataTypeDictionary;
    }

    public Map<UaNodeId, UaDataTypeSpecification> getSpecifications() {
        return this.specifications;
    }

    @Deprecated
    void a(Supplier<RegisteredClasses> supplier, Supplier<EncoderContext> supplier2) {
        supplier.get().registerClasses(this.constructors);
        for (UaDataTypeSpecification uaDataTypeSpecification : this.specifications.values()) {
            supplier2.get().addDataTypeSpecification(uaDataTypeSpecification);
        }
    }

    protected static abstract class Builder<T extends Builder<T>> {
        protected final Map<UaNodeId, UaDataTypeSpecification> specifications = new HashMap<UaNodeId, UaDataTypeSpecification>();
        protected final Map<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>> constructors = new HashMap<UaNodeId, Function<UaNode.Parameters, ? extends UaInstance>>();
        protected GeneratedDataTypeDictionary dataTypeDictionary = null;

        protected Builder() {
        }

        public T addAll(CodegenModel codegenModel) {
            this.constructors.putAll(codegenModel.constructors);
            this.specifications.putAll(codegenModel.specifications);
            Builder builder = this;
            return (T)builder;
        }

        public <S extends UaInstance> T addClass(UaNodeId uaNodeId, Function<UaNode.Parameters, S> function) {
            this.constructors.put(uaNodeId, function);
            Builder builder = this;
            return (T)builder;
        }

        public T addDataTypeSpecification(UaDataTypeSpecification uaDataTypeSpecification) {
            this.specifications.put(uaDataTypeSpecification.getTypeId(), uaDataTypeSpecification);
            Builder builder = this;
            return (T)builder;
        }

        public abstract CodegenModel build();

        public T setDataTypeDictionary(GeneratedDataTypeDictionary generatedDataTypeDictionary) {
            this.dataTypeDictionary = generatedDataTypeDictionary;
            Builder builder = this;
            return (T)builder;
        }
    }
}

