/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaApplicationURI;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.InternalNamespaceUtils;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.IdType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UaExpandedNodeId
implements Comparable<UaExpandedNodeId> {
    private static final UaExpandedNodeId[] cU = new UaExpandedNodeId[0];
    private final UaApplicationURI cV;
    private final UaNamespace cW;
    private final NodeId cX;
    private final int hash;

    public static UaExpandedNodeId[] arrayFrom(ExpandedNodeId[] expandedNodeIdArray, ServerTable serverTable, NamespaceTable namespaceTable) {
        if (expandedNodeIdArray == null) {
            return null;
        }
        if (expandedNodeIdArray.length == 0) {
            return cU;
        }
        UaExpandedNodeId[] uaExpandedNodeIdArray = new UaExpandedNodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            uaExpandedNodeIdArray[i2] = UaExpandedNodeId.from(expandedNodeIdArray[i2], serverTable, namespaceTable);
        }
        return uaExpandedNodeIdArray;
    }

    public static UaExpandedNodeId from(ExpandedNodeId expandedNodeId, ServerTable serverTable, NamespaceTable namespaceTable) {
        if (expandedNodeId == null) {
            return null;
        }
        UnsignedInteger unsignedInteger = expandedNodeId.getServerIndex();
        UaApplicationURI uaApplicationURI = serverTable.getServer(unsignedInteger.intValue());
        if (uaApplicationURI == null) {
            throw new IllegalArgumentException("Could not find ServerIndex: " + expandedNodeId.getServerIndex() + " in given ServerTable: " + serverTable);
        }
        String string = expandedNodeId.getNamespaceUri();
        UaNamespace uaNamespace = string == null ? InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(expandedNodeId.getNamespaceIndex(), namespaceTable) : InternalNamespaceUtils.getNamespace(expandedNodeId.getNamespaceUri(), namespaceTable);
        return UaExpandedNodeId.from(uaApplicationURI, uaNamespace, expandedNodeId.getValue());
    }

    public static UaExpandedNodeId from(String string, String string2, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("ServerUri cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("NamespaceUri cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Value part cannot be null");
        }
        return new UaExpandedNodeId(UaApplicationURI.from(string), UaNamespace.from(string2), object);
    }

    public static UaExpandedNodeId from(UaApplicationURI uaApplicationURI, UaNamespace uaNamespace, Object object) {
        if (uaApplicationURI == null) {
            throw new IllegalArgumentException("Server (uri) cannot be null");
        }
        if (uaNamespace == null) {
            throw new IllegalArgumentException("Namespace (uri) cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Value part cannot be null");
        }
        return new UaExpandedNodeId(uaApplicationURI, uaNamespace, object);
    }

    private UaExpandedNodeId(UaApplicationURI uaApplicationURI, UaNamespace uaNamespace, Object object) {
        this.cV = uaApplicationURI;
        this.cW = uaNamespace;
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(uaNamespace.getURI(), object);
        this.cX = NodeId.get(expandedNodeId.getIdType(), 0, expandedNodeId.getValue());
        this.hash = this.if();
    }

    public ExpandedNodeId asExpandedNodeId(ServerTable serverTable) {
        int n2 = serverTable.getIndex(this.getServerUri());
        if (n2 < 0) {
            throw new IllegalArgumentException("The given ServerTable doesn't contain the ServerUri: " + this.getServerUri() + ", it has: " + serverTable.toArray());
        }
        return new ExpandedNodeId(UnsignedInteger.valueOf(n2), this.getNamespaceUri(), this.getValue());
    }

    @Override
    public int compareTo(UaExpandedNodeId uaExpandedNodeId) {
        if (this == uaExpandedNodeId) {
            return 0;
        }
        int n2 = this.cV.compareTo(uaExpandedNodeId.cV);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.cW.compareTo(uaExpandedNodeId.cW);
        if (n2 != 0) {
            return n2;
        }
        return this.cX.compareTo(uaExpandedNodeId.cX);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaExpandedNodeId uaExpandedNodeId = (UaExpandedNodeId)object;
        if (this.hash != uaExpandedNodeId.hash) {
            return false;
        }
        if (this.cW == null ? uaExpandedNodeId.cW != null : !this.cW.equals(uaExpandedNodeId.cW)) {
            return false;
        }
        if (this.cV == null ? uaExpandedNodeId.cV != null : !this.cV.equals(uaExpandedNodeId.cV)) {
            return false;
        }
        return !(this.cX == null ? uaExpandedNodeId.cX != null : !this.cX.equals(uaExpandedNodeId.cX));
    }

    public IdType getIdType() {
        return this.cX.getIdType();
    }

    public UaNamespace getNamespace() {
        return this.cW;
    }

    public String getNamespaceUri() {
        return this.cW.getURI();
    }

    public UaApplicationURI getServer() {
        return this.cV;
    }

    public String getServerUri() {
        return this.cV.getURI();
    }

    public Object getValue() {
        return this.cX.getValue();
    }

    public String getValueAsParseForm() {
        return this.cX.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isLocal(ServerTable serverTable) {
        if (serverTable == null) {
            throw new IllegalArgumentException("The given ServerTable cannot be null");
        }
        int n2 = serverTable.getIndex(this.getServerUri());
        return n2 == 0;
    }

    public String toString() {
        return this.cV + ":" + this.cW + ":" + this.cX.getValue();
    }

    private int if() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.hash;
        n3 = 31 * n3 + (this.cW == null ? 0 : this.cW.hashCode());
        n3 = 31 * n3 + (this.cV == null ? 0 : this.cV.hashCode());
        n3 = 31 * n3 + (this.cX == null ? 0 : this.cX.hashCode());
        return n3;
    }
}

