/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.UaRelativePathElement;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UaRelativePath {
    public static final UaRelativePath EMPTY = new UaRelativePath(new UaRelativePathElement[0]);
    private final List<UaRelativePathElement> elements;

    public static UaRelativePath from(List<UaRelativePathElement> list) {
        return new UaRelativePath(list);
    }

    public static UaRelativePath from(RelativePath relativePath, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (relativePath == null) {
            return null;
        }
        ArrayList<UaRelativePathElement> arrayList = new ArrayList<UaRelativePathElement>();
        if (relativePath.getElements() != null) {
            for (int i2 = 0; i2 < relativePath.getElements().length; ++i2) {
                arrayList.add(UaRelativePathElement.from(relativePath.getElements()[i2], namespaceTable));
            }
        }
        return UaRelativePath.from(arrayList.toArray(new UaRelativePathElement[0]));
    }

    public static UaRelativePath from(UaRelativePathElement ... uaRelativePathElementArray) {
        return new UaRelativePath(uaRelativePathElementArray);
    }

    private UaRelativePath(List<UaRelativePathElement> list) {
        InternalArguments.checkNotNullCollectionAndElements(list, "elements");
        this.elements = Collections.unmodifiableList(new ArrayList<UaRelativePathElement>(list));
    }

    private UaRelativePath(UaRelativePathElement ... uaRelativePathElementArray) {
        InternalArguments.checkNotNullArrayAndElements(uaRelativePathElementArray, "elements");
        this.elements = Collections.unmodifiableList(new ArrayList<UaRelativePathElement>(Arrays.asList(uaRelativePathElementArray)));
    }

    public UaRelativePath append(UaRelativePath uaRelativePath) {
        ArrayList<UaRelativePathElement> arrayList = new ArrayList<UaRelativePathElement>(this.elements);
        arrayList.addAll(uaRelativePath.getElements());
        return UaRelativePath.from(arrayList);
    }

    public UaRelativePath append(UaRelativePathElement uaRelativePathElement) {
        ArrayList<UaRelativePathElement> arrayList = new ArrayList<UaRelativePathElement>(this.elements);
        arrayList.add(uaRelativePathElement);
        return UaRelativePath.from(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaRelativePath)) {
            return false;
        }
        UaRelativePath uaRelativePath = (UaRelativePath)object;
        return Objects.equals(this.elements, uaRelativePath.elements);
    }

    public List<UaRelativePathElement> getElements() {
        return this.elements;
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public RelativeNamePath toRelativeNamePath(NamespaceTable namespaceTable) {
        RelativePath relativePath = this.toRelativePath(namespaceTable);
        QualifiedName[] qualifiedNameArray = new QualifiedName[relativePath.getElements().length];
        for (int i2 = 0; i2 < relativePath.getElements().length; ++i2) {
            qualifiedNameArray[i2] = relativePath.getElements()[i2].getTargetName();
        }
        return RelativeNamePath.from(qualifiedNameArray);
    }

    public RelativePath toRelativePath(NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        ArrayList<RelativePathElement> arrayList = new ArrayList<RelativePathElement>();
        for (UaRelativePathElement uaRelativePathElement : this.elements) {
            arrayList.add(uaRelativePathElement.toRelativePathElement(namespaceTable));
        }
        return new RelativePath(arrayList.toArray(new RelativePathElement[arrayList.size()]));
    }

    public String toString() {
        return "UaRelativePath [elements=" + this.elements + "]";
    }
}

