/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.client.nodes.UaMethodImpl;
import com.prosysopc.ua.client.nodes.UaObjectImpl;
import com.prosysopc.ua.client.nodes.UaObjectTypeImpl;
import com.prosysopc.ua.client.nodes.UaPropertyImpl;
import com.prosysopc.ua.client.nodes.UaReferenceTypeImpl;
import com.prosysopc.ua.client.nodes.UaVariableImpl;
import com.prosysopc.ua.client.nodes.UaVariableTypeImpl;
import com.prosysopc.ua.client.nodes.UaViewImpl;
import com.prosysopc.ua.nodes.AbstractUaNodeFactory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.NodeClass;

public class UaClientNodeFactory
extends AbstractUaNodeFactory {
    private final AddressSpace addressSpace;

    public UaClientNodeFactory(AddressSpace addressSpace) {
        super(addressSpace);
        this.addressSpace = addressSpace;
        try {
            this.registerNodeClass(NodeClass.Object, parameters -> new UaObjectImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.Variable, parameters -> new UaVariableImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.Method, parameters -> new UaMethodImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.ObjectType, parameters -> new UaObjectTypeImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.VariableType, parameters -> new UaVariableTypeImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.ReferenceType, parameters -> new UaReferenceTypeImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.DataType, parameters -> new UaDataTypeImpl((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.View, parameters -> new UaViewImpl((UaNode.Parameters)parameters));
            this.registerTypeDefinition(UaIds.PropertyType, parameters -> new UaPropertyImpl((UaNode.Parameters)parameters));
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new RuntimeException("Error creating default client node factory", uaNodeFactoryException);
        }
    }

    @Override
    protected NamespaceTable getNamespaceTable() {
        return this.addressSpace.getNamespaceTable();
    }

    @Override
    protected RegisteredClasses getRegisteredClasses() {
        return this.addressSpace.getClient().getRegisteredClasses();
    }

    @Override
    protected UaType getType(UaNodeId uaNodeId) throws Exception {
        return this.addressSpace.getType(NodeId.from(uaNodeId, this.getNamespaceTable()));
    }
}

