/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaClientReference.class);
    private final AddressSpace addressSpace;
    private final NodeId ew;
    private final ExpandedNodeId hK;
    private final ExpandedNodeId hL;

    public UaClientReference(NodeId nodeId, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, AddressSpace addressSpace) {
        this.ew = nodeId;
        this.hL = expandedNodeId2;
        this.hK = expandedNodeId;
        this.addressSpace = addressSpace;
    }

    public UaClientReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AddressSpace addressSpace) {
        this(nodeId, new ExpandedNodeId(uaNode.getNodeId()), new ExpandedNodeId(uaNode2.getNodeId()), addressSpace);
    }

    @Override
    public void delete() {
        UaNode uaNode = this.getSourceNode();
        UaNode uaNode2 = this.getTargetNode();
        if (uaNode != null) {
            uaNode.deleteReference(this);
        }
        if (uaNode2 != null) {
            uaNode2.deleteReference(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaClientReference uaClientReference = (UaClientReference)object;
        if (this.hL == null ? uaClientReference.hL != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.hL, uaClientReference.hL)) {
            return false;
        }
        if (this.hK == null ? uaClientReference.hK != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.hK, uaClientReference.hK)) {
            return false;
        }
        return !(this.ew == null ? uaClientReference.ew != null : !this.ew.equals(uaClientReference.ew));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        logger.debug("getIsInverse: nodeId={} sourceId={} targetId={}", new Object[]{nodeId, this.hK, this.hL});
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.hK)) {
            return false;
        }
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.hL)) {
            return true;
        }
        throw new RuntimeException("getIsInverse() called from non-related node");
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        return this.getIsInverse(uaNode.getNodeId());
    }

    @Override
    public UaReferenceType getReferenceType() {
        UaNode uaNode = this.g(this.ew);
        if (uaNode instanceof UaReferenceType) {
            return (UaReferenceType)uaNode;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.ew;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return this.hK;
    }

    @Override
    public UaNode getSourceNode() {
        UaNode uaNode = this.b(this.hK);
        return uaNode;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return this.hL;
    }

    @Override
    public UaNode getTargetNode() {
        UaNode uaNode = this.b(this.hL);
        return uaNode;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.ew == null ? 0 : this.ew.hashCode());
        n3 = 31 * n3 + (this.hL == null ? 0 : this.hL.hashCode());
        n3 = 31 * n3 + (this.hK == null ? 0 : this.hK.hashCode());
        return n3;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append(" ReferenceTypeId=");
        stringBuilder.append(this.getReferenceTypeId());
        stringBuilder.append(" SourceId=");
        stringBuilder.append(this.getSourceId());
        stringBuilder.append(" TargetId=");
        stringBuilder.append(this.getTargetId());
        return stringBuilder.toString();
    }

    private UaNode b(ExpandedNodeId expandedNodeId) {
        try {
            return this.g(this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }

    private UaNode g(NodeId nodeId) {
        try {
            return this.addressSpace.getNode(nodeId);
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }
}

