/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResult;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadRequest;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateRequest;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.ReadRequest;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.WriteRequest;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeServiceHandler
extends ServiceHandler {
    protected static final Logger logger = LoggerFactory.getLogger(AttributeServiceHandler.class);

    private static ServiceResult a(WriteValue writeValue) {
        if (writeValue == null) {
            return new ServiceResult(StatusCodes.Bad_StructureMissing);
        }
        if (writeValue.getNodeId() == null) {
            return new ServiceResult(StatusCodes.Bad_NodeIdInvalid);
        }
        if (!AttributesUtil.isValid(writeValue.getAttributeId())) {
            return new ServiceResult(StatusCodes.Bad_AttributeIdInvalid);
        }
        if (writeValue.getIndexRange() != null && !writeValue.getIndexRange().isEmpty()) {
            try {
                NumericRange.parse(writeValue.getIndexRange());
            }
            catch (Exception exception) {
                return new ServiceResult(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception);
            }
        }
        return null;
    }

    public AttributeServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        super(sessionManager, nodeManagerTable);
    }

    public int getMaxNodesPerHistoryReadData() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadData().intValue();
    }

    public int getMaxNodesPerHistoryReadEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadEvents().intValue();
    }

    public int getMaxNodesPerHistoryUpdateData() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateData().intValue();
    }

    public int getMaxNodesPerHistoryUpdateEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateEvents().intValue();
    }

    public int getMaxNodesPerRead() {
        return this.getOperationLimits().getMaxNodesPerRead().intValue();
    }

    public int getMaxNodesPerWrite() {
        return this.getOperationLimits().getMaxNodesPerWrite().intValue();
    }

    public final void onHistoryRead(EndpointServiceRequest<HistoryReadRequest, HistoryReadResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryReadRequest historyReadRequest = endpointServiceRequest.getRequest();
        HistoryReadResponse historyReadResponse = new HistoryReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.historyRead(serviceContext, historyReadRequest, historyReadResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(historyReadResponse, serviceException);
        }
        historyReadResponse.setDiagnosticInfos(this.validateResponse(historyReadRequest, historyReadResponse, serviceContext, historyReadResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(historyReadResponse, AttributeServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onHistoryUpdate(EndpointServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryUpdateRequest historyUpdateRequest = endpointServiceRequest.getRequest();
        HistoryUpdateResponse historyUpdateResponse = new HistoryUpdateResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.historyUpdate(serviceContext, endpointServiceRequest.getRequest(), historyUpdateResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(historyUpdateResponse, serviceException);
        }
        historyUpdateResponse.setDiagnosticInfos(this.validateResponse(historyUpdateRequest, historyUpdateResponse, serviceContext, historyUpdateResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(historyUpdateResponse, AttributeServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onRead(EndpointServiceRequest<ReadRequest, ReadResponse> endpointServiceRequest) throws ServiceFaultException {
        ReadRequest readRequest = endpointServiceRequest.getRequest();
        ReadResponse readResponse = new ReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.read(serviceContext, readRequest, readResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(readResponse, serviceException);
        }
        readResponse.setDiagnosticInfos(this.validateResponse(readRequest, readResponse, serviceContext, readResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(readResponse, AttributeServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public final void onWrite(EndpointServiceRequest<WriteRequest, WriteResponse> endpointServiceRequest) throws ServiceFaultException {
        WriteRequest writeRequest = endpointServiceRequest.getRequest();
        WriteResponse writeResponse = new WriteResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(endpointServiceRequest);
            this.write(serviceContext, writeRequest, writeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(writeResponse, serviceException);
        }
        writeResponse.setDiagnosticInfos(this.validateResponse(writeRequest, writeResponse, serviceContext, writeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(writeResponse, AttributeServiceHandler.localizationHintsForServiceContext(serviceContext));
    }

    public void setMaxNodesPerHistoryReadData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadData(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryReadEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadEvents(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryUpdateData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateData(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryUpdateEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateEvents(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerRead(int n2) {
        this.getOperationLimits().setMaxNodesPerRead(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerWrite(int n2) {
        this.getOperationLimits().setMaxNodesPerWrite(UnsignedInteger.valueOf(n2));
    }

    private Object a(int n2, ServiceContext serviceContext, HistoryReadDetails historyReadDetails, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, TimestampsToReturn timestampsToReturn, HistoryResult[] historyResultArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            return nodeManager.getHistoryManager().beginHistoryRead(serviceContext, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    private Object a(int n2, ServiceContext serviceContext, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            return nodeManager.getHistoryManager().beginHistoryUpdate(serviceContext, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    private Object a(int n2, ServiceContext serviceContext, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            return nodeManager.getIoManager().beginRead(serviceContext, readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    private Object a(int n2, ServiceContext serviceContext, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            return nodeManager.getIoManager().beginWrite(serviceContext, writeValueArray, statusCodeArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    private void a(int n2, ServiceContext serviceContext, Object object, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            nodeManager.getHistoryManager().endHistoryRead(serviceContext, object, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
        }
        catch (StatusException statusException) {
            // empty catch block
        }
    }

    private void a(int n2, ServiceContext serviceContext, Object object, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            nodeManager.getHistoryManager().endHistoryUpdate(serviceContext, object, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            // empty catch block
        }
    }

    private void a(int n2, ServiceContext serviceContext, Object object, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            nodeManager.getIoManager().endRead(serviceContext, object, readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            // empty catch block
        }
    }

    private void a(int n2, ServiceContext serviceContext, Object object, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        try {
            NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
            nodeManager.getIoManager().endWrite(serviceContext, object, writeValueArray, statusCodeArray, diagnosticInfoArray);
        }
        catch (StatusException statusException) {
            // empty catch block
        }
    }

    private int cpw() {
        int n2 = this.getMaxNodesPerHistoryUpdateData();
        int n3 = this.getMaxNodesPerHistoryUpdateEvents();
        if (n2 <= 0) {
            return n3;
        }
        if (n3 <= 0) {
            return n2;
        }
        return Math.max(n2, n3);
    }

    private <T> T[] a(T[] TArray, List<Integer> list) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            objectArray[i2] = TArray[list.get(i2)];
        }
        return objectArray;
    }

    private void a(TimestampsToReturn timestampsToReturn, DataValue dataValue) {
        switch (timestampsToReturn) {
            case Neither: {
                dataValue.setServerTimestamp(DateTime.MIN_VALUE);
                dataValue.setSourceTimestamp(DateTime.MIN_VALUE);
                break;
            }
            case Server: {
                dataValue.setSourceTimestamp(DateTime.MIN_VALUE);
                if (dataValue.getServerTimestamp() != null) break;
                dataValue.setServerTimestamp(DateTime.currentTime());
                break;
            }
            case Source: {
                dataValue.setServerTimestamp(DateTime.MIN_VALUE);
                break;
            }
            case Both: {
                if (dataValue.getServerTimestamp() != null) break;
                dataValue.setServerTimestamp(DateTime.currentTime());
                break;
            }
        }
    }

    private <T> void a(T[] TArray, T[] TArray2, List<Integer> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TArray2[list.get((int)i2).intValue()] = TArray[i2];
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected void historyRead(ServiceContext serviceContext, HistoryReadRequest historyReadRequest, HistoryReadResponse historyReadResponse) throws ServiceException {
        Object object;
        Object object2;
        HistoryReadValueId[] historyReadValueIdArray;
        DiagnosticInfo[] diagnosticInfoArray2;
        Cloneable cloneable;
        Serializable serializable;
        HistoryResult[] historyResultArray;
        TimestampsToReturn timestampsToReturn = historyReadRequest.getTimestampsToReturn();
        if (timestampsToReturn == TimestampsToReturn.Neither) {
            throw new ServiceException(StatusCodes.Bad_InvalidTimestampArgument);
        }
        Session session = serviceContext.getSession();
        Object[] objectArray = historyReadRequest.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerHistoryReadData());
        HistoryReadDetails historyReadDetails = (HistoryReadDetails)historyReadRequest.getHistoryReadDetails();
        boolean bl = Boolean.TRUE.equals(historyReadRequest.getReleaseContinuationPoints());
        TreeMap<Serializable, Cloneable> treeMap = new TreeMap<Serializable, Cloneable>();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            historyResultArray = objectArray[i2];
            serializable = Integer.valueOf(historyResultArray.getNodeId().getNamespaceIndex());
            if (!treeMap.containsKey(serializable)) {
                cloneable = new ArrayList();
                cloneable.add(i2);
                treeMap.put(serializable, cloneable);
                continue;
            }
            ((List)treeMap.get(serializable)).add(i2);
        }
        HistoryContinuationPoint[] historyContinuationPointArray = new HistoryContinuationPoint[objectArray.length];
        historyResultArray = new HistoryResult[objectArray.length];
        serializable = new TreeMap();
        cloneable = new TreeMap();
        TreeMap<DiagnosticInfo[], HistoryContinuationPoint[]> treeMap2 = new TreeMap<DiagnosticInfo[], HistoryContinuationPoint[]>();
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            historyReadValueIdArray = (HistoryReadValueId[])treeMap.get(diagnosticInfoArray2);
            object2 = (HistoryReadValueId[])this.a(objectArray, (List<Integer>)historyReadValueIdArray);
            serializable.put(diagnosticInfoArray2, object2);
            object = this.a(historyResultArray, (List<Integer>)historyReadValueIdArray);
            cloneable.put(diagnosticInfoArray2, object);
            HistoryContinuationPoint[] historyContinuationPointArray2 = this.a(historyContinuationPointArray, (List<Integer>)historyReadValueIdArray);
            treeMap2.put(diagnosticInfoArray2, historyContinuationPointArray2);
        }
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            historyReadValueIdArray = (HistoryReadValueId[])serializable.get(diagnosticInfoArray2);
            object2 = (HistoryResult[])cloneable.get(diagnosticInfoArray2);
            object = (HistoryContinuationPoint[])treeMap2.get(diagnosticInfoArray2);
            for (int i3 = 0; i3 < historyReadValueIdArray.length; ++i3) {
                HistoryReadValueId historyReadValueId = historyReadValueIdArray[i3];
                try {
                    if (bl) {
                        this.releaseHistoryContinuationPoint(serviceContext, historyReadValueId.getNodeId(), historyReadValueId.getContinuationPoint());
                        continue;
                    }
                    if (historyReadValueId.getContinuationPoint() == null) continue;
                    object[i3] = session.getHistoryContinuationPoint(historyReadValueId.getContinuationPoint());
                    if (((HistoryContinuationPoint)object[i3]).getDetails() != null) continue;
                    throw new StatusException(StatusCodes.Bad_ContinuationPointInvalid);
                }
                catch (StatusException statusException) {
                    logger.debug("historyRead: Invalid continuation point for nodeToRead=" + historyReadValueId + " error:", (Throwable)statusException);
                    object2[i3] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
                }
            }
            if (bl) continue;
            Object object3 = this.a(diagnosticInfoArray2.intValue(), serviceContext, historyReadDetails, historyReadValueIdArray, (HistoryContinuationPoint[])object, timestampsToReturn, (HistoryResult[])object2);
            for (int i4 = 0; i4 < historyReadValueIdArray.length; ++i4) {
                if (object2[i4] != null) continue;
                HistoryReadValueId historyReadValueId = historyReadValueIdArray[i4];
                try {
                    NumericRange numericRange;
                    try {
                        numericRange = NumericRange.parse(historyReadValueId.getIndexRange());
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new StatusException(serviceResultException);
                    }
                    object2[i4] = this.readNodeHistory(serviceContext, object3, timestampsToReturn, historyReadValueId.getNodeId(), numericRange, (HistoryContinuationPoint)object[i4], historyReadDetails, i4);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("historyRead: Invalid continuation point for nodeToRead=" + historyReadValueId + " error:", (Throwable)statusException);
                    object2[i4] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
                }
            }
            this.a(diagnosticInfoArray2.intValue(), serviceContext, object3, historyReadDetails, timestampsToReturn, historyReadValueIdArray, (HistoryContinuationPoint[])object, (HistoryResult[])object2);
        }
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            historyReadValueIdArray = (List)treeMap.get(diagnosticInfoArray2);
            object2 = (HistoryResult[])cloneable.get(diagnosticInfoArray2);
            this.a((T[])object2, (T[])historyResultArray, (List<Integer>)historyReadValueIdArray);
            object = (HistoryContinuationPoint[])treeMap2.get(diagnosticInfoArray2);
            this.a((T[])object, (T[])historyContinuationPointArray, (List<Integer>)historyReadValueIdArray);
        }
        HistoryReadResult[] historyReadResultArray = new HistoryReadResult[objectArray.length];
        diagnosticInfoArray2 = new DiagnosticInfo[objectArray.length];
        for (int i5 = 0; i5 < objectArray.length; ++i5) {
            historyReadResultArray[i5] = new HistoryReadResult();
            diagnosticInfoArray2[i5] = new DiagnosticInfo();
            if (!bl) {
                historyReadResultArray[i5].setHistoryData(historyResultArray[i5].getData());
                historyReadResultArray[i5].setStatusCode(historyResultArray[i5].getStatusCode());
                diagnosticInfoArray2[i5] = historyResultArray[i5].getDiagnosticInfo();
                if (historyResultArray[i5].getContinuationPoint() == null) continue;
                try {
                    if (historyContinuationPointArray[i5] != null) {
                        object = historyContinuationPointArray[i5];
                        object2 = session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i5].getContinuationPoint(), ((HistoryContinuationPoint)object).getDetails(), ((HistoryContinuationPoint)object).getTimestampsToReturn()));
                    } else {
                        object2 = session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i5].getContinuationPoint(), historyReadDetails, timestampsToReturn));
                    }
                    historyReadResultArray[i5].setContinuationPoint((ByteString)object2);
                }
                catch (StatusException statusException) {
                    historyReadResultArray[i5].setStatusCode(statusException.getStatusCode());
                    diagnosticInfoArray2[i5] = statusException.getDiagnosticInfo();
                }
                continue;
            }
            object2 = historyResultArray[i5];
            object = object2 != null && ((HistoryResult)object2).getStatusCode() != null ? ((HistoryResult)object2).getStatusCode() : StatusCode.GOOD;
            historyReadResultArray[i5].setStatusCode((StatusCode)object);
        }
        historyReadResponse.setResults(historyReadResultArray);
        historyReadResponse.setDiagnosticInfos(diagnosticInfoArray2);
    }

    protected void historyUpdate(ServiceContext serviceContext, HistoryUpdateRequest historyUpdateRequest, HistoryUpdateResponse historyUpdateResponse) throws ServiceException {
        DiagnosticInfo[] diagnosticInfoArray;
        Cloneable[] cloneableArray;
        DynamicStructure[] dynamicStructureArray;
        HistoryUpdateDetails[] historyUpdateDetailsArray;
        Serializable serializable;
        Cloneable cloneable;
        Object[] objectArray = historyUpdateRequest.getHistoryUpdateDetails();
        this.checkRequestLength(objectArray, this.cpw());
        HistoryUpdateResult[] historyUpdateResultArray = new HistoryUpdateResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray2 = new DiagnosticInfo[objectArray.length];
        HistoryUpdateDetails[] historyUpdateDetailsArray2 = new HistoryUpdateDetails[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            historyUpdateDetailsArray2[i2] = (HistoryUpdateDetails)objectArray[i2];
        }
        TreeMap treeMap = new TreeMap();
        for (int i3 = 0; i3 < historyUpdateDetailsArray2.length; ++i3) {
            cloneable = historyUpdateDetailsArray2[i3];
            serializable = Integer.valueOf(HistoryManager.getNodeIdFromHistoryUpdateDetails((HistoryUpdateDetails)cloneable).getNamespaceIndex());
            if (!treeMap.containsKey(serializable)) {
                Iterator iterator = new ArrayList();
                iterator.add(i3);
                treeMap.put(serializable, iterator);
                continue;
            }
            ((List)treeMap.get(serializable)).add(i3);
        }
        TreeMap<Integer, HistoryUpdateDetails[]> treeMap2 = new TreeMap<Integer, HistoryUpdateDetails[]>();
        cloneable = new TreeMap();
        serializable = new TreeMap();
        for (Integer n2 : treeMap.keySet()) {
            historyUpdateDetailsArray = (HistoryUpdateDetails[])treeMap.get(n2);
            dynamicStructureArray = this.a(historyUpdateDetailsArray2, (List<Integer>)historyUpdateDetailsArray);
            treeMap2.put(n2, (HistoryUpdateDetails[])dynamicStructureArray);
            cloneableArray = this.a(historyUpdateResultArray, (List<Integer>)historyUpdateDetailsArray);
            cloneable.put(n2, cloneableArray);
            diagnosticInfoArray = this.a(diagnosticInfoArray2, (List<Integer>)historyUpdateDetailsArray);
            serializable.put(n2, diagnosticInfoArray);
        }
        for (Integer n2 : treeMap.keySet()) {
            historyUpdateDetailsArray = (HistoryUpdateDetails[])treeMap2.get(n2);
            dynamicStructureArray = (HistoryUpdateResult[])cloneable.get(n2);
            cloneableArray = (DiagnosticInfo[])serializable.get(n2);
            diagnosticInfoArray = this.a((int)n2, serviceContext, historyUpdateDetailsArray, (HistoryUpdateResult[])dynamicStructureArray, (DiagnosticInfo[])cloneableArray);
            for (int i4 = 0; i4 < historyUpdateDetailsArray.length; ++i4) {
                if (dynamicStructureArray[i4] != null) continue;
                dynamicStructureArray[i4] = new HistoryUpdateResult();
                cloneableArray[i4] = new DiagnosticInfo();
                try {
                    this.updateNodeHistory(serviceContext, diagnosticInfoArray, historyUpdateDetailsArray[i4], (HistoryUpdateResult)dynamicStructureArray[i4]);
                    ((HistoryUpdateResult)dynamicStructureArray[i4]).setStatusCode(StatusCode.GOOD);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("StatusException: ", (Throwable)statusException);
                    ((HistoryUpdateResult)dynamicStructureArray[i4]).setStatusCode(statusException.getStatusCode());
                    cloneableArray[i4] = statusException.getDiagnosticInfo();
                }
            }
            this.a((int)n2, serviceContext, (Object)diagnosticInfoArray, historyUpdateDetailsArray, (HistoryUpdateResult[])dynamicStructureArray, (DiagnosticInfo[])cloneableArray);
        }
        for (Integer n2 : treeMap.keySet()) {
            historyUpdateDetailsArray = (List)treeMap.get(n2);
            dynamicStructureArray = (HistoryUpdateResult[])cloneable.get(n2);
            this.a(dynamicStructureArray, historyUpdateResultArray, (List<Integer>)historyUpdateDetailsArray);
            cloneableArray = (DiagnosticInfo[])serializable.get(n2);
            this.a(cloneableArray, diagnosticInfoArray2, (List<Integer>)historyUpdateDetailsArray);
        }
        historyUpdateResponse.setResults(historyUpdateResultArray);
        historyUpdateResponse.setDiagnosticInfos(diagnosticInfoArray2);
    }

    protected void read(ServiceContext serviceContext, ReadRequest readRequest, ReadResponse readResponse) throws ServiceException {
        Object object;
        Cloneable[] cloneableArray;
        ReadValueId[] readValueIdArray;
        Cloneable cloneable;
        Serializable serializable;
        DiagnosticInfo[] diagnosticInfoArray;
        DateTime dateTime;
        logger.debug("read");
        Double d2 = readRequest.getMaxAge();
        if (d2 == null || d2 == 0.0) {
            dateTime = DateTime.MAX_VALUE;
        } else {
            if (d2 < 0.0) {
                throw new ServiceException(StatusCodes.Bad_MaxAgeInvalid);
            }
            dateTime = d2 >= 2.147483647E9 ? DateTime.MIN_VALUE : DateTime.fromInstant(Instant.now().minus(Duration.ofMillis(d2.longValue())));
        }
        TimestampsToReturn timestampsToReturn = readRequest.getTimestampsToReturn();
        if (timestampsToReturn == null) {
            throw new ServiceException(StatusCodes.Bad_TimestampsToReturnInvalid);
        }
        Object[] objectArray = readRequest.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRead());
        TreeMap<Serializable, Cloneable> treeMap = new TreeMap<Serializable, Cloneable>();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            diagnosticInfoArray = objectArray[i2];
            serializable = Integer.valueOf(diagnosticInfoArray.getNodeId().getNamespaceIndex());
            if (!treeMap.containsKey(serializable)) {
                cloneable = new ArrayList();
                cloneable.add(i2);
                treeMap.put(serializable, cloneable);
                continue;
            }
            ((List)treeMap.get(serializable)).add(i2);
        }
        DataValue[] dataValueArray = new DataValue[objectArray.length];
        diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        serializable = new TreeMap();
        cloneable = new TreeMap();
        TreeMap<DiagnosticInfo[], DiagnosticInfo[]> treeMap2 = new TreeMap<DiagnosticInfo[], DiagnosticInfo[]>();
        TreeMap<DiagnosticInfo[], DiagnosticInfo[]> treeMap3 = new TreeMap<DiagnosticInfo[], DiagnosticInfo[]>();
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            readValueIdArray = (ReadValueId[])treeMap.get(diagnosticInfoArray2);
            cloneableArray = (ReadValueId[])this.a(objectArray, (List<Integer>)readValueIdArray);
            serializable.put(diagnosticInfoArray2, cloneableArray);
            DataValue[] object22 = this.a(dataValueArray, (List<Integer>)readValueIdArray);
            cloneable.put(diagnosticInfoArray2, object22);
            object = this.a(diagnosticInfoArray, (List<Integer>)readValueIdArray);
            treeMap2.put(diagnosticInfoArray2, (DiagnosticInfo[])object);
        }
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            readValueIdArray = (ReadValueId[])serializable.get(diagnosticInfoArray2);
            cloneableArray = (DataValue[])cloneable.get(diagnosticInfoArray2);
            DiagnosticInfo[] diagnosticInfoArray3 = (DiagnosticInfo[])treeMap2.get(diagnosticInfoArray2);
            object = this.a(diagnosticInfoArray2.intValue(), serviceContext, readValueIdArray, timestampsToReturn, dateTime, (DataValue[])cloneableArray, diagnosticInfoArray3);
            treeMap3.put(diagnosticInfoArray2, (DiagnosticInfo[])object);
        }
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            readValueIdArray = (ReadValueId[])serializable.get(diagnosticInfoArray2);
            cloneableArray = (DataValue[])cloneable.get(diagnosticInfoArray2);
            DiagnosticInfo[] diagnosticInfoArray4 = (DiagnosticInfo[])treeMap2.get(diagnosticInfoArray2);
            object = treeMap3.get(diagnosticInfoArray2);
            for (int i2 = 0; i2 < readValueIdArray.length; ++i2) {
                Object object2;
                if (cloneableArray[i2] != null || readValueIdArray[i2] == null) continue;
                cloneableArray[i2] = new DataValue(StatusCode.GOOD);
                try {
                    ReadValueId readValueId = readValueIdArray[i2];
                    this.validateEncoding(readValueId);
                    logger.debug("nodesToReadSplit[{}]{}", (Object)i2, (Object)readValueId);
                    object2 = NumericRange.parse(readValueId.getIndexRange());
                    if (readValueId.getAttributeId() != Attributes.Value && !((NumericRange)object2).equals(NumericRange.getEmpty())) {
                        throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                    }
                    NodeId nodeId = readValueId.getNodeId();
                    this.readAttribute(serviceContext, object, nodeId, readValueId.getAttributeId(), (NumericRange)object2, timestampsToReturn, dateTime, (DataValue)cloneableArray[i2]);
                    logger.debug("resultsSplit[{}]{}", (Object)i2, (Object)cloneableArray[i2]);
                    if (((DataValue)cloneableArray[i2]).getStatusCode() == null || ((DataValue)cloneableArray[i2]).getStatusCode().isBad()) {
                        ((DataValue)cloneableArray[i2]).setValue(null);
                    }
                    this.a(timestampsToReturn, (DataValue)cloneableArray[i2]);
                    if (!readValueId.getAttributeId().equals(Attributes.Value) || !logger.isDebugEnabled()) continue;
                    logger.debug("TimestampsToReturn: {} AttributeId: {} Node: {}, Server timestamp: {}, Source timestamp: {}", new Object[]{timestampsToReturn, readValueId.getAttributeId(), nodeId, ((DataValue)cloneableArray[i2]).getServerTimestamp(), ((DataValue)cloneableArray[i2]).getSourceTimestamp()});
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("StatusException: ", (Throwable)statusException);
                    ((DataValue)cloneableArray[i2]).setStatusCode(statusException.getStatusCode());
                    diagnosticInfoArray4[i2] = statusException.getDiagnosticInfo();
                    continue;
                }
                catch (ServiceResultException serviceResultException) {
                    logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
                    ((DataValue)cloneableArray[i2]).setStatusCode(serviceResultException.getStatusCode());
                    object2 = serviceResultException.getAdditionalTextField();
                    if (object2 == null) continue;
                    diagnosticInfoArray4[i2] = new DiagnosticInfo();
                    diagnosticInfoArray4[i2].setAdditionalInfo((String)object2);
                }
            }
            this.a(diagnosticInfoArray2.intValue(), serviceContext, object, readValueIdArray, timestampsToReturn, dateTime, (DataValue[])cloneableArray, diagnosticInfoArray4);
        }
        for (DiagnosticInfo[] diagnosticInfoArray2 : treeMap.keySet()) {
            readValueIdArray = (List)treeMap.get(diagnosticInfoArray2);
            cloneableArray = (DataValue[])cloneable.get(diagnosticInfoArray2);
            this.a(cloneableArray, dataValueArray, (List<Integer>)readValueIdArray);
            DiagnosticInfo[] diagnosticInfoArray5 = (DiagnosticInfo[])treeMap2.get(diagnosticInfoArray2);
            this.a(diagnosticInfoArray5, diagnosticInfoArray, (List<Integer>)readValueIdArray);
        }
        readResponse.setResults(dataValueArray);
        boolean bl = true;
        for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
            if (diagnosticInfo != null) continue;
            bl = false;
            break;
        }
        readResponse.setDiagnosticInfos((DiagnosticInfo[])(bl ? diagnosticInfoArray : null));
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getNodeManagerTable().readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected HistoryResult readNodeHistory(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getNodeManagerTable().historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        this.getNodeManagerTable().releaseHistoryContinuationPoint(serviceContext, nodeId, byteString);
    }

    protected void updateNodeHistory(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getNodeManagerTable().historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void write(ServiceContext serviceContext, WriteRequest writeRequest, WriteResponse writeResponse) throws ServiceException {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        WriteValue[] writeValueArray;
        Cloneable cloneable;
        Serializable serializable;
        DiagnosticInfo[] diagnosticInfoArray;
        logger.debug("write");
        Object[] objectArray3 = writeRequest.getNodesToWrite();
        this.checkRequestLength(objectArray3, this.getMaxNodesPerWrite());
        TreeMap<Serializable, Cloneable> treeMap = new TreeMap<Serializable, Cloneable>();
        for (int i2 = 0; i2 < objectArray3.length; ++i2) {
            diagnosticInfoArray = objectArray3[i2];
            serializable = Integer.valueOf(diagnosticInfoArray.getNodeId().getNamespaceIndex());
            if (!treeMap.containsKey(serializable)) {
                cloneable = new ArrayList();
                cloneable.add(i2);
                treeMap.put(serializable, cloneable);
                continue;
            }
            ((List)treeMap.get(serializable)).add(i2);
        }
        StatusCode[] statusCodeArray = new StatusCode[objectArray3.length];
        diagnosticInfoArray = new DiagnosticInfo[objectArray3.length];
        serializable = new TreeMap();
        cloneable = new TreeMap();
        TreeMap<Integer, DiagnosticInfo[]> treeMap2 = new TreeMap<Integer, DiagnosticInfo[]>();
        TreeMap<Integer, DiagnosticInfo[]> treeMap3 = new TreeMap<Integer, DiagnosticInfo[]>();
        for (Integer n2 : treeMap.keySet()) {
            writeValueArray = (WriteValue[])treeMap.get(n2);
            objectArray2 = (WriteValue[])this.a(objectArray3, (List<Integer>)writeValueArray);
            serializable.put(n2, objectArray2);
            objectArray = this.a(statusCodeArray, (List<Integer>)writeValueArray);
            cloneable.put(n2, objectArray);
            object = this.a(diagnosticInfoArray, (List<Integer>)writeValueArray);
            treeMap2.put(n2, (DiagnosticInfo[])object);
        }
        for (Integer n2 : treeMap.keySet()) {
            writeValueArray = (WriteValue[])serializable.get(n2);
            objectArray2 = (StatusCode[])cloneable.get(n2);
            objectArray = (DiagnosticInfo[])treeMap2.get(n2);
            object = this.a((int)n2, serviceContext, writeValueArray, (StatusCode[])objectArray2, (DiagnosticInfo[])objectArray);
            treeMap3.put(n2, (DiagnosticInfo[])object);
        }
        for (Integer n2 : treeMap.keySet()) {
            writeValueArray = (WriteValue[])serializable.get(n2);
            objectArray2 = (StatusCode[])cloneable.get(n2);
            objectArray = (DiagnosticInfo[])treeMap2.get(n2);
            object = treeMap3.get(n2);
            for (int i3 = 0; i3 < writeValueArray.length; ++i3) {
                Object object2;
                if (objectArray2[i3] != null) continue;
                try {
                    WriteValue writeValue = writeValueArray[i3];
                    object2 = AttributeServiceHandler.a(writeValue);
                    if (object2 != null && ((ServiceResult)object2).isBad()) {
                        throw new StatusException(((ServiceResult)object2).getCode());
                    }
                    NodeId nodeId = writeValue.getNodeId();
                    if (this.writeAttribute(serviceContext, object, nodeId, writeValue.getAttributeId(), NumericRange.parse(writeValue.getIndexRange()), writeValue.getValue())) {
                        objectArray2[i3] = StatusCode.GOOD;
                        continue;
                    }
                    objectArray2[i3] = StatusCode.valueOf(StatusCodes.Good_CompletesAsynchronously);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("Write failed", (Throwable)statusException);
                    objectArray[i3] = statusException.getDiagnosticInfo();
                    objectArray2[i3] = statusException.getStatusCode();
                    continue;
                }
                catch (ServiceResultException serviceResultException) {
                    objectArray2[i3] = serviceResultException.getStatusCode();
                    object2 = serviceResultException.getAdditionalTextField();
                    if (object2 == null) continue;
                    objectArray[i3] = new DiagnosticInfo();
                    ((DiagnosticInfo)objectArray[i3]).setAdditionalInfo((String)object2);
                }
            }
            this.a((int)n2, serviceContext, object, writeValueArray, (StatusCode[])objectArray2, (DiagnosticInfo[])objectArray);
        }
        for (Integer n2 : treeMap.keySet()) {
            writeValueArray = (List)treeMap.get(n2);
            objectArray2 = (StatusCode[])cloneable.get(n2);
            this.a(objectArray2, statusCodeArray, (List<Integer>)writeValueArray);
            objectArray = (DiagnosticInfo[])treeMap2.get(n2);
            this.a(objectArray, diagnosticInfoArray, (List<Integer>)writeValueArray);
        }
        writeResponse.setResults(statusCodeArray);
        writeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getNodeManagerTable().writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }
}

