/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.c;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.SessionDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SessionSecurityDiagnosticsDataType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsManager {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private final AtomicBoolean iB = new AtomicBoolean(false);
    private SubscriptionDiagnosticsArrayTypeNode iC;
    private boolean iD = true;
    private final UaServer hF;
    private ServerDiagnosticsTypeNode iE;
    private final c iF = new c();
    private final Map<Session, SessionDiagnosticsObjectTypeNode> iG = new ConcurrentHashMap<Session, SessionDiagnosticsObjectTypeNode>();
    private SessionsDiagnosticsSummaryTypeNode iH;
    private final Map<Subscription, SubscriptionDiagnosticsTypeNode> iI = new ConcurrentHashMap<Subscription, SubscriptionDiagnosticsTypeNode>();
    private volatile boolean iJ = this.iB.get();

    protected DiagnosticsManager(UaServer uaServer) {
        this.hF = uaServer;
    }

    public boolean isEnabled() {
        return this.iB.get();
    }

    public boolean isRemoveSamplingIntervalDiagnosticsArrayOnStart() {
        return this.iD;
    }

    public void setRemoveSamplingIntervalDiagnosticsArrayOnStart(boolean bl) {
        this.iD = bl;
    }

    private void a(Collection<Session> collection, SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionDiagnosticsDataType> arrayList = new ArrayList<SessionDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
                if (sessionDiagnosticsObjectTypeNode == null) continue;
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionDiagnostics());
            }
            sessionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Session> collection, SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionSecurityDiagnosticsDataType> arrayList = new ArrayList<SessionSecurityDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
                if (sessionDiagnosticsObjectTypeNode == null) continue;
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnostics());
            }
            sessionSecurityDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionSecurityDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Subscription> collection, SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SubscriptionDiagnosticsDataType> arrayList = new ArrayList<SubscriptionDiagnosticsDataType>();
            for (Subscription subscription : collection) {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iI.get(subscription);
                if (subscriptionDiagnosticsTypeNode == null) continue;
                arrayList.add((SubscriptionDiagnosticsDataType)subscriptionDiagnosticsTypeNode.getValue().getValue().getValue());
            }
            subscriptionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SubscriptionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private SubscriptionManager getSubscriptionManager() {
        return this.hF.getSubscriptionManager();
    }

    private void cpx() throws StatusException {
        this.iE = this.hF.getNodeManagerRoot().getServerData().getServerDiagnosticsNode();
        this.iH = this.iE.getSessionsDiagnosticsSummaryNode();
        this.iC = this.iE.getSubscriptionDiagnosticsArrayNode();
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (dataValue2.isNull()) {
                    return;
                }
                boolean bl = dataValue2.getValue().booleanValue();
                DiagnosticsManager.this.iB.set(bl);
                if (bl) {
                    DiagnosticsManager.this.onDiagnosticsEnabled();
                } else {
                    DiagnosticsManager.this.onDiagnosticsDisabled();
                }
            }
        };
        this.iE.addEnabledChangeListener(dataChangeListener);
        DataValue dataValue = this.iE.getEnabledFlagNode().getValue();
        if (dataValue != null && !dataValue.isNull() && ((Boolean)dataValue.getValue().getValue()).booleanValue()) {
            dataChangeListener.onDataChange(this.iE, null, dataValue);
        }
    }

    private void cpy() {
        try {
            UaNode uaNode = this.hF.getNodeManagerRoot().getNode(Identifiers.ViewsFolder);
            this.iF.cqr().set(uaNode.getComponents().length);
            this.cpA();
        }
        catch (StatusException statusException) {
            logger.warn("ViewsFolder not available", (Throwable)statusException);
        }
    }

    private void cpz() {
        DataValue dataValue = new DataValue(StatusCode.valueOf(StatusCodes.Bad_NotReadable));
        try {
            for (NodeId nodeId : this.hF.getNodeManagerRoot().cqe()) {
                UaVariable uaVariable = (UaVariable)this.hF.getAddressSpace().getNode(nodeId);
                uaVariable.setValue(dataValue);
            }
        }
        catch (Exception exception) {
            logger.error("Could not update diagnostics", (Throwable)exception);
        }
    }

    private void cpA() {
        if (this.isEnabled()) {
            try {
                this.iE.setServerDiagnosticsSummary(this.iF.cqh());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSession(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hF.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.iG.put(session, sessionDiagnosticsObjectTypeNode);
                this.iH.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iH.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iH.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.iF.cqk().incrementAndGet();
                this.cpB();
                this.cpA();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        } else {
            this.cpB();
        }
    }

    protected void addSessionNoIncrement(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hF.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.iG.put(session, sessionDiagnosticsObjectTypeNode);
                this.iH.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iH.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iH.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.iF.cqk().incrementAndGet();
                this.cpA();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSubscription(Session session, Subscription subscription) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        if (this.isEnabled()) {
            try {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.hF.getNodeManagerUaServer().createInstance(SubscriptionDiagnosticsTypeNode.class, subscription.getSubscriptionId().toString(), NodeId.randomGUID(this.hF.getNodeManagerUaServer().getNamespaceIndex()));
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.iI.put(subscription, subscriptionDiagnosticsTypeNode);
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
                logger.trace("addSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.iE.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.updateSubscription(subscription);
                this.cpC();
                this.iF.cql().incrementAndGet();
                this.cpA();
                session.getSessionDiagnostics().cqN().incrementAndGet();
            }
            catch (Exception exception) {
                logger.error("Could not add diagnostics node", (Throwable)exception);
            }
        } else {
            this.cpC();
        }
    }

    protected void close() {
        logger.debug("close");
        if (this.iE != null) {
            this.iE.setEnabled(false);
        }
        this.iE = null;
    }

    protected void onDiagnosticsDisabled() {
        if (this.iJ) {
            for (Subscription object : this.hF.getSubscriptionManager().getSubscriptions()) {
                this.removeSubscription(object.getSession(), object);
            }
            for (Session session : this.hF.getSessionManager().getSessions()) {
                this.removeSession(session);
            }
            this.cpz();
        } else {
            logger.trace("Diagnostics is disabled, onDiagnosticsDisabled aborted");
        }
        this.iJ = false;
    }

    protected void onDiagnosticsEnabled() {
        if (!this.iJ) {
            for (Session iterator : this.hF.getSessionManager().getSessions()) {
                iterator.resetDiagnostics();
                this.hF.getDiagnosticsManager().addSessionNoIncrement(iterator);
            }
            this.iF.cqk().set(this.hF.getSessionManager().getSessionCount());
            SubscriptionManager subscriptionManager = this.getSubscriptionManager();
            this.iF.cql().set(0L);
            this.cpA();
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                if (Session.INTERNAL_SESSION == subscription.getSession()) continue;
                subscription.getSession().getSessionDiagnostics().cqN().set(0L);
            }
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                subscription.getDiagnostics().crq();
                this.addSubscription(subscription.getSession(), subscription);
                if (Session.INTERNAL_SESSION == subscription.getSession()) continue;
                subscription.getSession().getSessionDiagnostics().cqL().set(subscription.getItemCount());
            }
            this.cpy();
        } else {
            logger.trace("Diagnostics is enabled, onDiagnosticsEnabled aborted");
        }
        this.iJ = true;
    }

    protected void removeSession(Session session) {
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.remove(session);
        logger.trace("removeSession, session: {}, diag: {}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
        if (sessionDiagnosticsObjectTypeNode != null) {
            try {
                logger.trace("removeSession, deleting diagnostics nodes");
                this.iH.getSessionDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.iH.getSessionSecurityDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.iH.removeComponent(sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getNodeManager().deleteNode(sessionDiagnosticsObjectTypeNode, true, true);
                logger.trace("removeSession, deleted diagnostics nodes");
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.iE != null && this.iE.isEnabled()) {
            this.iF.cqk().set(this.hF.getSessionManager().getSessionCount());
            this.cpA();
        }
    }

    protected void removeSubscription(Session session, Subscription subscription) {
        logger.trace("removeSubscription, session: {}, subscription {}", (Object)session, (Object)subscription);
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iI.remove(subscription);
        if (subscriptionDiagnosticsTypeNode != null) {
            try {
                if (session != null) {
                    SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
                    logger.trace("removeSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                    if (sessionDiagnosticsObjectTypeNode != null) {
                        sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                    }
                }
                this.iE.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                subscriptionDiagnosticsTypeNode.getNodeManager().deleteNode(subscriptionDiagnosticsTypeNode, true, true);
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.isEnabled()) {
            try {
                this.iF.cql().decrementAndGet();
                this.cpA();
                if (session.getSessionDiagnostics() != null) {
                    session.getSessionDiagnostics().cqN().decrementAndGet();
                    session.updateDiagnostics();
                }
                this.a(this.iI.keySet(), this.iC);
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void start() throws StatusException {
        logger.debug("start");
        if (this.iD) {
            try {
                this.hF.getNodeManagerRoot().deleteNode(Identifiers.Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cpx();
    }

    protected void updateSession(Session session) {
        if (Session.INTERNAL_SESSION == session) {
            return;
        }
        logger.trace("updateSession, session: {}", (Object)session);
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
        if (this.isEnabled() && sessionDiagnosticsObjectTypeNode != null) {
            try {
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.a(this.iG.keySet(), this.iH.getSessionDiagnosticsArrayNode());
                this.a(this.iG.keySet(), this.iH.getSessionSecurityDiagnosticsArrayNode());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void updateSubscription(Subscription subscription) {
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.iI.get(subscription);
        if (this.isEnabled() && subscriptionDiagnosticsTypeNode != null) {
            try {
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.a(this.iI.keySet(), this.iC);
                Session session = subscription.getSession();
                if (session == null) {
                    return;
                }
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.iG.get(session);
                logger.debug("diag object debug: {}, session: {}, subscription", new Object[]{sessionDiagnosticsObjectTypeNode, session, subscription});
                if (sessionDiagnosticsObjectTypeNode == null) {
                    return;
                }
                SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode();
                if (subscriptionDiagnosticsArrayTypeNode != null) {
                    this.a(session.cqz(), subscriptionDiagnosticsArrayTypeNode);
                }
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    void cpB() {
        this.iF.cqi().incrementAndGet();
        this.cpA();
    }

    void cpC() {
        this.iF.cqj().incrementAndGet();
        this.cpA();
    }

    void cpD() {
        this.iF.cqo().incrementAndGet();
        this.cpA();
    }

    void cpE() {
        this.iF.cqq().incrementAndGet();
        this.cpA();
    }

    void cpF() {
        this.iF.cqt().incrementAndGet();
        this.cpA();
    }
}

