/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerUaNode
extends EventManager {
    static final Logger logger = LoggerFactory.getLogger(EventManagerUaNode.class);

    private static void a(UaNode uaNode, Collection<ConditionTypeNode> collection, Set<NodeId> set) {
        if (uaNode == null) {
            return;
        }
        if (set.contains(uaNode.getNodeId())) {
            return;
        }
        set.add(uaNode.getNodeId());
        if (uaNode instanceof ConditionTypeNode) {
            collection.add((ConditionTypeNode)uaNode);
        }
        HashSet<UaReference> hashSet = new HashSet<UaReference>();
        hashSet.addAll(Arrays.asList(uaNode.getReferences(Identifiers.HasNotifier, false)));
        hashSet.addAll(Arrays.asList(uaNode.getReferences(Identifiers.HasEventSource, false)));
        hashSet.addAll(Arrays.asList(uaNode.getReferences(Identifiers.HasCondition, false)));
        for (UaReference uaReference : hashSet) {
            EventManagerUaNode.a(uaReference.getTargetNode(), collection, set);
        }
    }

    static void a(UaNode uaNode, Collection<ConditionTypeNode> collection) {
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        EventManagerUaNode.a(uaNode, collection, hashSet);
    }

    public EventManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
    }

    public Collection<ConditionTypeNode> getConditions() {
        try {
            return this.getConditions(Identifiers.Server);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("ObjectsFolder not available", statusException);
        }
    }

    public Collection<ConditionTypeNode> getConditions(NodeId nodeId) throws StatusException {
        return this.getConditions(this.getNodeManagerTable().getNode(nodeId));
    }

    public Collection<ConditionTypeNode> getConditions(UaNode uaNode) {
        ArrayList<ConditionTypeNode> arrayList = new ArrayList<ConditionTypeNode>();
        this.collectConditions(uaNode, arrayList);
        return arrayList;
    }

    @Override
    public boolean onCall(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaMethod uaMethod, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray2) throws StatusException {
        logger.debug("onCall: ", (Object)("object=" + uaNode == null ? nodeId : (uaNode.getBrowseName() + "; method=" + uaMethod == null ? nodeId2 : uaMethod.getBrowseName())));
        if (super.onCall(serviceContext, nodeId, uaNode, nodeId2, uaMethod, variantArray, statusCodeArray, diagnosticInfoArray, variantArray2)) {
            return true;
        }
        if (!(uaNode instanceof ConditionType) && !(uaNode instanceof StateMachineType)) {
            return false;
        }
        ConditionTypeNode conditionTypeNode = null;
        if (uaNode instanceof ConditionTypeNode) {
            conditionTypeNode = (ConditionTypeNode)uaNode;
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_Enable, "Enable")) {
            return this.enable(serviceContext, conditionTypeNode);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_Disable, "Disable")) {
            return this.disable(serviceContext, conditionTypeNode);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_AddComment, "AddComment")) {
            Class[] classArray = new Class[]{ByteString.class, LocalizedText.class};
            MethodManager.checkInputArguments(classArray, variantArray, statusCodeArray, diagnosticInfoArray, true);
            ByteString byteString = (ByteString)variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.addComment(serviceContext, conditionTypeNode, byteString, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.AcknowledgeableConditionType_Acknowledge, "Acknowledge")) {
            Class[] classArray = new Class[]{ByteString.class, LocalizedText.class};
            MethodManager.checkInputArguments(classArray, variantArray, statusCodeArray, diagnosticInfoArray, true);
            ByteString byteString = (ByteString)variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.acknowledge(serviceContext, (AcknowledgeableConditionTypeNode)conditionTypeNode, byteString, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.AcknowledgeableConditionType_Confirm, "Confirm")) {
            Class[] classArray = new Class[]{ByteString.class, LocalizedText.class};
            MethodManager.checkInputArguments(classArray, variantArray, statusCodeArray, diagnosticInfoArray, true);
            ByteString byteString = (ByteString)variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.confirm(serviceContext, (AcknowledgeableConditionTypeNode)conditionTypeNode, byteString, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_Unshelve, "Unshelve")) {
            ShelvedStateMachineTypeNode shelvedStateMachineTypeNode = (ShelvedStateMachineTypeNode)uaNode;
            AlarmConditionTypeNode alarmConditionTypeNode = shelvedStateMachineTypeNode.getCondition();
            return this.unshelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_OneShotShelve, "OneShotShelve")) {
            ShelvedStateMachineTypeNode shelvedStateMachineTypeNode = (ShelvedStateMachineTypeNode)uaNode;
            AlarmConditionTypeNode alarmConditionTypeNode = shelvedStateMachineTypeNode.getCondition();
            return this.oneshotshelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_TimedShelve, "TimedShelve")) {
            Class[] classArray = new Class[]{Double.class};
            MethodManager.checkInputArguments(classArray, variantArray, statusCodeArray, diagnosticInfoArray, false);
            double d2 = Double.parseDouble(variantArray[0].getValue().toString());
            ShelvedStateMachineTypeNode shelvedStateMachineTypeNode = (ShelvedStateMachineTypeNode)uaNode;
            AlarmConditionTypeNode alarmConditionTypeNode = shelvedStateMachineTypeNode.getCondition();
            return this.timedshelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode, d2);
        }
        return false;
    }

    protected boolean acknowledge(ServiceContext serviceContext, AcknowledgeableConditionTypeNode acknowledgeableConditionTypeNode, ByteString byteString, LocalizedText localizedText) throws StatusException {
        return this.getListener().onAcknowledge(serviceContext, acknowledgeableConditionTypeNode, byteString, localizedText);
    }

    protected boolean addComment(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode, ByteString byteString, LocalizedText localizedText) throws StatusException {
        return this.getListener().onAddComment(serviceContext, conditionTypeNode, byteString, localizedText);
    }

    protected void collectConditions(UaNode uaNode, Collection<ConditionTypeNode> collection) {
        EventManagerUaNode.a(uaNode, collection);
    }

    protected boolean confirm(ServiceContext serviceContext, AcknowledgeableConditionTypeNode acknowledgeableConditionTypeNode, ByteString byteString, LocalizedText localizedText) throws StatusException {
        return this.getListener().onConfirm(serviceContext, acknowledgeableConditionTypeNode, byteString, localizedText);
    }

    protected boolean disable(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode) throws StatusException {
        if (!conditionTypeNode.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionAlreadyDisabled);
        }
        return this.getListener().onDisable(serviceContext, conditionTypeNode);
    }

    protected boolean enable(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode) throws StatusException {
        if (conditionTypeNode.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionAlreadyEnabled);
        }
        return this.getListener().onEnable(serviceContext, conditionTypeNode);
    }

    protected boolean oneshotshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode) throws StatusException {
        return this.getListener().onOneshotShelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
    }

    @Override
    protected void refreshItem(MonitoredEventItem monitoredEventItem) {
        if (monitoredEventItem.getNodeId().getNamespaceIndex() != this.getNodeManager().getNamespaceIndex()) {
            return;
        }
        UaNode uaNode = monitoredEventItem.getNode();
        logger.debug("refreshItem: node={}", (Object)uaNode);
        if (uaNode instanceof ConditionTypeNode) {
            ConditionTypeNode conditionTypeNode = (ConditionTypeNode)uaNode;
            if (conditionTypeNode.isRetain().booleanValue()) {
                monitoredEventItem.notifyEvent(conditionTypeNode.getLastEvent());
            }
        } else {
            ArrayList<ConditionTypeNode> arrayList = new ArrayList<ConditionTypeNode>();
            this.collectConditions(uaNode, arrayList);
            for (ConditionTypeNode conditionTypeNode : arrayList) {
                if (!conditionTypeNode.isRetain().booleanValue()) continue;
                monitoredEventItem.notifyEvent(conditionTypeNode.getLastEvent());
            }
        }
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }

    protected boolean timedshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode, double d2) throws StatusException {
        return this.getListener().onTimedShelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode, d2);
    }

    protected boolean unshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode) throws StatusException {
        return this.getListener().onUnshelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
    }
}

