/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaExternalNodeImpl;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalNodeManager {
    private static Logger logger = LoggerFactory.getLogger(ExternalNodeManager.class);
    private final NodeManagerTable nodeManagerTable;
    private final HashMap<Integer, HashMap<NodeId, UaExternalNode>> iN = new HashMap();

    protected ExternalNodeManager(NodeManagerTable nodeManagerTable) {
        this.nodeManagerTable = nodeManagerTable;
    }

    public UaExternalNode getNode(NodeId nodeId) throws StatusException {
        UaExternalNode uaExternalNode;
        if (NodeId.isNull(nodeId)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = nodeId.getNamespaceIndex();
        HashMap<NodeId, UaExternalNode> hashMap = this.iN.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.iN.put(n2, hashMap);
        }
        if ((uaExternalNode = hashMap.get(nodeId)) == null) {
            uaExternalNode = new UaExternalNodeImpl(this.nodeManagerTable.getNodeManagerRoot(), nodeId);
            hashMap.put(nodeId, uaExternalNode);
        }
        return uaExternalNode;
    }

    public Collection<UaExternalNode> getNodesByNamespace(int n2) {
        HashMap<NodeId, UaExternalNode> hashMap = this.iN.get(n2);
        if (hashMap == null) {
            return new ArrayList<UaExternalNode>();
        }
        return hashMap.values();
    }

    public boolean hasNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull(nodeId)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = nodeId.getNamespaceIndex();
        HashMap<NodeId, UaExternalNode> hashMap = this.iN.get(n2);
        if (hashMap == null) {
            return false;
        }
        UaExternalNode uaExternalNode = hashMap.get(nodeId);
        return uaExternalNode != null;
    }

    public boolean removeNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull(nodeId)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = nodeId.getNamespaceIndex();
        HashMap<NodeId, UaExternalNode> hashMap = this.iN.get(n2);
        if (hashMap == null) {
            return false;
        }
        UaExternalNode uaExternalNode = hashMap.get(nodeId);
        if (uaExternalNode == null) {
            return false;
        }
        hashMap.remove(nodeId);
        return true;
    }

    public boolean removeNode(UaExternalNode uaExternalNode) throws StatusException {
        return this.removeNode(uaExternalNode.getNodeId());
    }

    public boolean removeNodesByNamespace(int n2) {
        HashMap<NodeId, UaExternalNode> hashMap = this.iN.remove(n2);
        if (hashMap == null) {
            return false;
        }
        hashMap.clear();
        return true;
    }
}

