/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AggregateCalculator;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AggregateFilter;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataChangeFilter;
import com.prosysopc.ua.stack.core.DataChangeTrigger;
import com.prosysopc.ua.stack.core.DeadbandType;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.HistoricalDataConfigurationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredDataItem
extends MonitoredItem {
    private static final StatusCode jP = StatusCode.valueOf(StatusCodes.Bad_WaitingForInitialData);
    private static final Logger logger = LoggerFactory.getLogger(MonitoredDataItem.class);
    protected static final DataValue DELAY_SAMPLE = new DataValue(StatusCode.valueOf(StatusCodes.Good_MoreData));
    private volatile Boolean jQ;
    private Range jR;
    private UaProperty jS;
    private NumericRange fq;
    protected AggregateFilterConfiguration aggregateFilter = null;
    private volatile boolean jT = false;
    private volatile DataValue jU = null;
    private volatile DataValue jV = null;
    private BlockingDeque<DataValue> jW = null;
    private final DataChangeListener jX = new DataChangeListener(){

        @Override
        public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
            MonitoredDataItem.this.assignEuRange(dataValue2);
        }
    };
    private volatile double fr = -1.0;
    protected DataChangeListener dataChangeListener = new DataChangeListener(){

        @Override
        public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
            MonitoredDataItem.this.notifyDataChange(dataValue2);
        }
    };
    private volatile DataValue jY = null;

    protected static long getServerTimestampInMillis(DataValue dataValue) {
        return dataValue == null || dataValue.getServerTimestamp() == null ? 0L : dataValue.getServerTimestamp().getTimeInMillis();
    }

    protected static long getSourceTimestampInMillis(DataValue dataValue) {
        return dataValue == null || dataValue.getSourceTimestamp() == null ? 0L : dataValue.getSourceTimestamp().getTimeInMillis();
    }

    public MonitoredDataItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, UnsignedInteger unsignedInteger2, NumericRange numericRange, MonitoringMode monitoringMode) {
        super(serviceContext, subscription, unsignedInteger, nodeId, unsignedInteger2, monitoringMode);
        this.queueSize = 0L;
        this.setIndexRange(numericRange);
    }

    public AggregateFilter getAggregateFilter() {
        if (this.getFilter() instanceof AggregateFilter) {
            return (AggregateFilter)this.getFilter();
        }
        return null;
    }

    public DataChangeFilter getDataChangeFilter() {
        if (this.getFilter() instanceof DataChangeFilter) {
            return (DataChangeFilter)this.getFilter();
        }
        return null;
    }

    public DataChangeTrigger getDataChangeTrigger() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        return dataChangeFilter == null ? DataChangeTrigger.StatusValue : dataChangeFilter.getTrigger();
    }

    public DeadbandType getDeadbandType() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        return dataChangeFilter == null ? DeadbandType.None : DeadbandType.valueOf(this.getDataChangeFilter().getDeadbandType().intValue());
    }

    public double getDeadbandValue() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        return dataChangeFilter == null ? 0.0 : this.getDataChangeFilter().getDeadbandValue();
    }

    public Range getEuRange() {
        return this.jR;
    }

    public UaProperty getEuRangeProperty() {
        return this.jS;
    }

    @Override
    public NumericRange getIndexRange() {
        return this.fq;
    }

    public DataValue getLastValue() {
        return this.jU;
    }

    @Override
    public double getSamplingInterval() {
        return this.fr;
    }

    public synchronized boolean hasMoreSamples() {
        return this.jW == null ? !this.jT : !this.jW.isEmpty();
    }

    public void notifyDataChange(DataValue dataValue) {
        this.notifyDataChange(dataValue, true);
    }

    public void notifyDataChange(DataValue dataValue, boolean bl) {
        if (!this.isAccessible()) {
            logger.debug("Skipped adding new sample, accessible=false");
            return;
        }
        if (MonitoringMode.Disabled.equals(this.getMonitoringMode())) {
            logger.debug("Skipping adding new sample, MonitoringMode is Disabled");
            return;
        }
        if (bl) {
            dataValue = this.applyIndexRange(dataValue);
        }
        if (dataValue.getServerTimestamp() == null || DateTime.MIN_VALUE.equals(dataValue.getServerTimestamp())) {
            dataValue.setServerTimestamp(DateTime.currentTime());
        }
        logger.trace("notifyDataChange: value={}", (Object)dataValue);
        if (!this.hasAggregateFilter()) {
            boolean bl2 = this.isInSameSamplingInterval(dataValue, this.jV, this.jU);
            if (this.a(this.getLastValue(), dataValue, bl2)) {
                this.addNewSample(dataValue, bl2);
            }
        } else {
            boolean bl3 = true;
            DateTime dateTime = dataValue.getSourceTimestamp();
            if (this.aggregateFilter.d(dateTime)) {
                DataValue dataValue2 = this.aggregateFilter.lastValue();
                if (this.isInSameSamplingInterval(dataValue, dataValue2, dataValue2)) {
                    logger.trace("notifyDataChange: ignore");
                    bl3 = false;
                } else {
                    logger.debug("notifyDataChange: add");
                    this.aggregateFilter.e(dataValue);
                }
                if (!this.checkAggregate(dateTime)) {
                    this.jT = false;
                    this.cpX();
                }
            }
        }
    }

    public void notifyResendData() {
        if (this.getMonitoringMode().equals(MonitoringMode.Reporting) && this.isAccessible()) {
            this.jY = null;
            this.addNewSample(this.getLastValue(), true);
        }
    }

    @Deprecated
    public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
        this.notifyDataChange(dataValue2);
    }

    public void setEuRange(Range range) {
        logger.debug("setEuRange: {}", (Object)range);
        this.jR = range;
    }

    public void setEuRangeProperty(UaProperty uaProperty) {
        if (this.jS != uaProperty) {
            logger.debug("setEuRangeProperty: euRangeProperty={}", (Object)uaProperty);
            this.assignEuRange(uaProperty.getValue());
            if (this.jS instanceof ServerNode) {
                ((ServerNode)((Object)this.jS)).removeDataChangeListener(this.jX);
            }
            if (uaProperty instanceof ServerNode) {
                ((ServerNode)((Object)uaProperty)).addDataChangeListener(this.jX);
            }
            this.jS = uaProperty;
        }
    }

    public void setSamplingInterval(double d2) {
        this.fr = d2 < 0.0 ? this.getSubscription().getPublishingInterval() : d2;
    }

    private boolean a(DataValue dataValue, DataValue dataValue2, boolean bl) {
        Object object;
        logger.debug("filter: value={}; lastValue={}", (Object)dataValue2, (Object)dataValue);
        if (dataValue == null) {
            return true;
        }
        if (dataValue.isNull() && dataValue2 != null && !dataValue2.isNull()) {
            return true;
        }
        if (!dataValue.isNull() && (dataValue2 == null || dataValue2.isNull())) {
            return true;
        }
        if (!dataValue.getStatusCode().equals(dataValue2.getStatusCode())) {
            return true;
        }
        if (dataValue != null && !dataValue.isNull() && dataValue.getValue() != null && dataValue.getValue().getValue() != null && (dataValue.getValue().getValue().equals(Double.NaN) || dataValue.getValue().getValue().equals(Float.valueOf(Float.NaN)))) {
            return true;
        }
        DataChangeTrigger dataChangeTrigger = this.getDataChangeTrigger();
        logger.debug("filter: trigger={}", (Object)dataChangeTrigger);
        if (dataChangeTrigger.equals(DataChangeTrigger.Status)) {
            return false;
        }
        if (dataChangeTrigger.equals(DataChangeTrigger.StatusValueTimestamp) && DeadbandType.None == this.getDeadbandType()) {
            object = dataValue.getSourceTimestamp();
            DateTime dateTime = dataValue2.getSourceTimestamp();
            if (object == null ? dateTime != null : !((DateTime)object).equals(dateTime)) {
                return true;
            }
        }
        if (dataValue.isNull()) {
            return false;
        }
        object = !bl && Number.class.isAssignableFrom(dataValue.getValue().getCompositeClass()) ? this.getDeadbandType() : DeadbandType.None;
        return this.checkDeadband(dataValue, dataValue2, (DeadbandType)object);
    }

    private DataValue cpV() {
        return this.jY;
    }

    private DataValue cpW() {
        if (this.subscription.isClosed()) {
            return null;
        }
        DataValue dataValue = new DataValue(jP);
        try {
            this.subscription.getSubscriptionManager().getNodeManagerTable().initializeMonitoredDataItem(this.getServiceContext(), this, dataValue);
        }
        catch (StatusException statusException) {
            logger.debug("StatusException: ", (Throwable)statusException);
            dataValue.setStatusCode(statusException.getStatusCode());
        }
        catch (Exception exception) {
            logger.error("Unexpected error: subscription=" + this.subscription + " subscriptionManager=" + this.subscription.getSubscriptionManager(), (Throwable)exception);
        }
        UnsignedInteger unsignedInteger = dataValue.getStatusCode().getValue();
        this.jQ = !unsignedInteger.equals(StatusCodes.Bad_NotReadable) && !unsignedInteger.equals(StatusCodes.Bad_UserAccessDenied);
        logger.debug("initialValue: {}", (Object)dataValue);
        return dataValue;
    }

    private void b(UaVariable uaVariable) {
        UaProperty[] uaPropertyArray = uaVariable.getProperties();
        if (uaPropertyArray != null) {
            for (UaProperty uaProperty : uaPropertyArray) {
                if (!Identifiers.Range.equals(uaProperty.getDataTypeId()) || !uaProperty.getBrowseName().getName().equalsIgnoreCase("EURange")) continue;
                this.setEuRangeProperty(uaProperty);
                break;
            }
        }
    }

    private DataValue d(DataValue dataValue) {
        return this.a(dataValue, true);
    }

    private DataValue a(DataValue dataValue, boolean bl) {
        if (dataValue == null) {
            return null;
        }
        DateTime dateTime = bl ? DateTime.currentTime() : dataValue.getServerTimestamp();
        switch (this.getTimestampsToReturn()) {
            case Neither: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), DateTime.MIN_VALUE, DateTime.MIN_VALUE);
                break;
            }
            case Server: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), DateTime.MIN_VALUE, dateTime);
                break;
            }
            case Source: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), DateTime.MIN_VALUE);
                break;
            }
            case Both: {
                if (!bl) break;
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dateTime);
                break;
            }
        }
        return dataValue;
    }

    private void cpX() {
        if (this.subscription.isPublishingEnabled()) {
            if (this.getMonitoringMode().equals(MonitoringMode.Reporting)) {
                this.subscription.newSampleAvailable(this);
            }
            if (this.links != null && !this.links.isEmpty()) {
                logger.debug("Link list is not empty, checking if need to trigger");
                boolean bl = false;
                boolean bl2 = false;
                for (MonitoredItem monitoredItem : this.links) {
                    if (monitoredItem.getMonitoringMode() != MonitoringMode.Sampling) continue;
                    if (!bl && monitoredItem instanceof MonitoredDataItem && ((MonitoredDataItem)monitoredItem).hasMoreSamples()) {
                        logger.debug("hasMoreSamples true for item={}", (Object)monitoredItem);
                        bl = true;
                    }
                    if (bl2 || !(monitoredItem instanceof MonitoredEventItem) || ((MonitoredEventItem)monitoredItem).getCurrentQueueSize() <= 0) continue;
                    logger.debug("getCurrentQueueSize larger than 0 for item={}", (Object)monitoredItem);
                    bl2 = true;
                }
                this.subscription.needTrigger(this, bl, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewSample(DataValue dataValue, boolean bl) {
        if (this.subscription.isPublishingEnabled() && dataValue != null) {
            MonitoredDataItem monitoredDataItem = this;
            synchronized (monitoredDataItem) {
                logger.trace("addNewSample: queue={}", this.jW);
                boolean bl2 = this.getQueueSize() > 1L;
                DataValue dataValue2 = dataValue;
                if (this.jW != null) {
                    logger.trace("addNewSample: queue.size={} QueueSize={} prevValue={}", new Object[]{this.jW.size(), this.getQueueSize(), this.jV});
                    if (bl) {
                        DataValue dataValue3 = (DataValue)this.jW.pollLast();
                        logger.trace("addNewSample: replacing the last sample; last={}", (Object)dataValue3);
                        if (dataValue3 != null && dataValue3.getStatusCode().isOverflow()) {
                            dataValue2 = this.setOverflowBit(dataValue);
                        }
                        bl2 = false;
                    }
                    boolean bl3 = false;
                    while (!this.jW.offerLast(dataValue2)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("addNewSample: queue overflow: SubscriptionId={} ItemId={} discardOldest={}", new Object[]{this.subscription.getSubscriptionId(), this.getMonitoredItemId(), this.discardOldest});
                        }
                        if (this.discardOldest) {
                            this.jW.pollFirst();
                            if (this.getQueueSize() > 1L) {
                                this.jW.addFirst(this.setOverflowBit((DataValue)this.jW.pollFirst()));
                            }
                        } else {
                            this.jW.pollLast();
                            if (this.getQueueSize() > 1L) {
                                dataValue2 = this.setOverflowBit(dataValue);
                            }
                        }
                        this.subscription.incrementOverflowCount();
                        bl3 = true;
                    }
                    if (bl3) {
                        this.subscription.updateDiagnostics();
                    }
                }
                this.setLastValue(dataValue, bl2);
                this.cpX();
            }
        }
    }

    protected DataValue applyIndexRange(DataValue dataValue) {
        if (!NumericRange.isNullOrEmpty(this.getIndexRange())) {
            logger.debug("applyIndexRange: value={} indexRange={}", (Object)dataValue, (Object)this.getIndexRange());
            dataValue = dataValue.clone();
            try {
                IoManager.applyIndexRangeToReadValue(dataValue, this.getIndexRange());
                logger.debug("applyIndexRange: new value={}", (Object)dataValue);
            }
            catch (StatusException statusException) {
                logger.info("Failed to apply IndexRange " + this.getIndexRange() + " to " + dataValue.getValue(), (Throwable)statusException);
                dataValue.setStatusCode(statusException.getStatusCode());
            }
        }
        return dataValue;
    }

    protected void assignEuRange(DataValue dataValue) {
        if (dataValue != null && !dataValue.isNull()) {
            try {
                this.setEuRange((Range)dataValue.getValue().getValue());
            }
            catch (ClassCastException classCastException) {
                logger.warn("initRange: Cannot cast current value of a range property to Range");
                this.setEuRange(null);
            }
        } else {
            this.setEuRange(null);
        }
    }

    protected boolean checkAggregate(DateTime dateTime) {
        boolean bl = false;
        if (this.aggregateFilter.c(dateTime)) {
            ArrayList arrayList = this.aggregateFilter.b(dateTime);
            logger.debug("checkAggregate: aggregateValues={}", (Object)arrayList);
            if (arrayList != null) {
                for (DataValue dataValue : arrayList) {
                    if (dataValue.getStatusCode().getValue().equals(StatusCodes.Bad_NoData)) continue;
                    this.addNewSample(dataValue, false);
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected boolean checkDeadband(DataValue dataValue, DataValue dataValue2, DeadbandType deadbandType) {
        Variant variant = dataValue.getValue();
        Variant variant2 = dataValue2.getValue();
        logger.debug("checkDeadband: lastVariantValue={}", (Object)variant);
        logger.debug("checkDeadband: variantValue={}", (Object)variant2);
        if (variant2.isArray() || variant.isArray()) {
            int[] nArray = MultiDimensionArrayUtils.getArrayLengths(variant2.getValue());
            if (!Arrays.equals(nArray, MultiDimensionArrayUtils.getArrayLengths(variant.getValue()))) {
                logger.debug("checkDeadband: array lengths are not equal {}", (Object)Arrays.toString(nArray));
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("checkDeadband: arrayLengths={}", (Object)Arrays.toString(nArray));
            }
            MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant2.getValue(), nArray);
            MultiDimensionArrayUtils.ArrayIterator arrayIterator2 = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), nArray);
            while (arrayIterator.hasNext()) {
                if (!this.checkDeadband(deadbandType, arrayIterator.next(), arrayIterator2.next())) continue;
                logger.debug("checkDeadband: elements differ");
                return true;
            }
            return false;
        }
        return this.checkDeadband(deadbandType, variant.getValue(), variant2.getValue());
    }

    protected boolean checkDeadband(DeadbandType deadbandType, Object object, Object object2) {
        double d2;
        double d3;
        logger.debug("checkDeadband: deadbandType={} lastValue={} value={}", new Object[]{deadbandType, object, object2});
        if (object == null) {
            return object2 != null;
        }
        if (object2 == null) {
            return true;
        }
        if (deadbandType == DeadbandType.None) {
            d3 = 0.0;
        } else {
            try {
                d2 = ((Number)object).doubleValue();
                double d4 = ((Number)object2).doubleValue();
                d3 = Math.abs(d2 - d4);
            }
            catch (ClassCastException classCastException) {
                logger.warn("checkDeadband: value " + object2 + " of class " + object2 == null ? "null" : object2.getClass() + " is not a Number, even though deadband is " + deadbandType, (Throwable)classCastException);
                return true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkDeadband: deadbandValue=" + this.getDeadbandValue() + " diff=" + d3 + (deadbandType == DeadbandType.Percent ? " valueRange=" + this.getValueRange() : ""));
        }
        switch (deadbandType) {
            case None: {
                return !object.equals(object2);
            }
            case Absolute: {
                return d3 > this.getDeadbandValue();
            }
            case Percent: {
                d2 = this.getDeadbandValue() / 100.0 * this.getValueRange();
                return d3 > d2;
            }
        }
        return false;
    }

    protected synchronized void clearQueue() {
        logger.debug("clearQueue");
        if (this.jW != null) {
            this.jW.clear();
        }
    }

    protected AggregateFilterConfiguration getAggregateFilterConfiguration() {
        return this.aggregateFilter;
    }

    @Override
    protected long getDefaultQueueSize() {
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataValue getNextSample(boolean bl) {
        logger.trace("getNextSample: queue={}", this.jW);
        DataValue dataValue = null;
        if (this.getMonitoringMode().equals(MonitoringMode.Reporting) || bl) {
            MonitoredDataItem monitoredDataItem = this;
            synchronized (monitoredDataItem) {
                if (this.hasAggregateFilter()) {
                    logger.debug("getNextSample: aggregate queueSize={}", (Object)this.aggregateFilter.getQueueSize());
                    this.checkAggregate(DateTime.currentTime());
                }
                if (this.jW != null) {
                    dataValue = this.jW.poll();
                    logger.debug("getNextSample: sample from queue={}", (Object)dataValue);
                }
                if (dataValue == null && !this.jT) {
                    dataValue = this.getLastValue();
                    logger.debug("getNextSample: sample from lastValue={}", (Object)dataValue);
                }
                DataValue dataValue2 = this.cpV();
                if (dataValue == null || dataValue == dataValue2) {
                    return null;
                }
                long l2 = MonitoredDataItem.getSourceTimestampInMillis(dataValue);
                long l3 = MonitoredDataItem.getSourceTimestampInMillis(dataValue2);
                if (l2 <= 0L || l2 >= l3 + (long)this.getSamplingInterval()) {
                    this.jT = true;
                } else {
                    long l4 = MonitoredDataItem.getServerTimestampInMillis(dataValue2);
                    long l5 = DateTime.currentTime().getTimeInMillis();
                    if (l4 != 0L && l4 + (long)this.getSamplingInterval() > l5) {
                        logger.debug("getNextSample: sample TOO NEW={} - lastReported={}", (Object)dataValue, (Object)dataValue2);
                        return DELAY_SAMPLE;
                    }
                }
                this.jY = dataValue;
                dataValue = this.a(dataValue, !this.hasAggregateFilter());
            }
            logger.debug("getNextSample: sample={}", (Object)dataValue);
        } else if (logger.isDebugEnabled()) {
            logger.debug("getNextSample: Skipping MonitoredDataItem={} as it is in mode={}", (Object)this, (Object)this.getMonitoringMode());
        }
        return dataValue;
    }

    protected DataValue getPrevValue() {
        return this.jV;
    }

    protected BlockingDeque<DataValue> getQueue() {
        return this.jW;
    }

    protected double getValueRange() {
        if (this.jR == null) {
            return 0.0;
        }
        return this.jR.getHigh() - this.jR.getLow();
    }

    protected boolean hasAggregateFilter() {
        return this.getAggregateFilter() != null;
    }

    protected void initAggregateFilter() {
        boolean bl = true;
        try {
            HistoricalDataConfigurationType historicalDataConfigurationType = (HistoricalDataConfigurationType)this.node.getReference(Identifiers.HasHistoricalConfiguration, false).getTargetNode();
            bl = historicalDataConfigurationType.isStepped();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.aggregateFilter = new AggregateFilterConfiguration(this.getSubscription().getSubscriptionManager().getNodeManagerTable().getServer().getAggregateCalculator(), this.getAggregateFilter(), bl, this.queueSize, this.fr == -1.0 ? this.getSubscription().getPublishingInterval() : this.fr);
    }

    protected boolean isAccessible() {
        Object object;
        block8: {
            if (this.jQ == null) {
                try {
                    if (this.getServiceContext().getSession().isActive()) {
                        try {
                            object = this.getSubscription().getSubscriptionManager().getNodeManagerTable().getIoManager(this.getNodeId());
                            if (object == null) {
                                this.jQ = true;
                                return true;
                            }
                        }
                        catch (StatusException statusException) {
                            this.jQ = true;
                            return true;
                        }
                        UaNode uaNode = ((ServiceManagerBase)object).getNode(this.nodeId);
                        ((ServiceManagerBase)object).checkIsValueNode(uaNode);
                        UaVariable uaVariable = (UaVariable)uaNode;
                        ((IoManager)object).checkAccessLevel(this.getServiceContext(), null, this.getNodeId(), uaVariable, AccessLevelType.Options.CurrentRead);
                        this.jQ = true;
                        break block8;
                    }
                    this.jQ = false;
                }
                catch (StatusException statusException) {
                    this.jQ = false;
                }
            }
        }
        if ((object = this.jQ) == null) {
            return this.isAccessible();
        }
        return (Boolean)object;
    }

    protected boolean isInSameSamplingInterval(DataValue dataValue, DataValue dataValue2, DataValue dataValue3) {
        if (this.getSamplingInterval() == 0.0) {
            logger.trace("isInSameSamplingInterval: no (0-sampling interval in use)");
            return false;
        }
        if (dataValue2 != null && dataValue3 != null && dataValue.getSourceTimestamp() != null && dataValue2.getSourceTimestamp() != null && dataValue3.getSourceTimestamp() != null) {
            double d2 = dataValue.getSourceTimestamp().getTimeInMillis();
            double d3 = dataValue3.getSourceTimestamp().getTimeInMillis();
            double d4 = dataValue2.getSourceTimestamp().getTimeInMillis();
            double d5 = d2 - d3;
            double d6 = d2 - d4;
            double d7 = d3 - d4;
            double d8 = this.getSamplingInterval();
            logger.trace("isInSameSamplingInterval: dt={} dt2={} dt_last={} samplingInterval={}", new Object[]{d5, d6, d7, d8});
            if (d5 < d8 && d6 < 2.0 * d8 && d7 < d8) {
                logger.trace("isInSameSamplingInterval: yes");
                return true;
            }
        }
        logger.trace("isInSameSamplingInterval: no");
        return false;
    }

    @Override
    protected void monitoringModeChanged() throws ServiceException {
        super.monitoringModeChanged();
        this.cpX();
    }

    @Override
    protected void plugNodeListener() {
        if (this.getAttributeId().equals(Attributes.Value)) {
            UaNode uaNode = this.getNode();
            if (uaNode instanceof UaVariable) {
                ((UaVariable)uaNode).addDataChangeListener(this.dataChangeListener);
            }
            if (uaNode instanceof UaVariable && this.getDataChangeFilter() != null && DeadbandType.Percent == DeadbandType.valueOf(this.getDataChangeFilter().getDeadbandType())) {
                this.b((UaVariable)uaNode);
            }
        }
    }

    protected void setDataChangeFilter(DataChangeFilter dataChangeFilter) throws ServiceException {
        this.setFilter(dataChangeFilter);
    }

    protected void setIndexRange(NumericRange numericRange) {
        this.fq = numericRange;
    }

    protected void setLastValue(DataValue dataValue, boolean bl) {
        logger.trace("setLastValue: updatePrevValue={} lastValue={}", (Object)bl, (Object)this.jU);
        if (bl) {
            this.jV = this.jU;
        }
        this.jU = dataValue;
        if (this.hasAggregateFilter() && bl && this.jV == null) {
            this.jV = this.jU;
        }
        this.jT = false;
    }

    protected DataValue setOverflowBit(DataValue dataValue) {
        return new DataValue(dataValue.getValue(), StatusCode.getFromBits(dataValue.getStatusCode().getValueAsIntBits() | 0x480), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
    }

    protected void startSampling(boolean bl) {
        if (MonitoringMode.Disabled.equals(this.getMonitoringMode())) {
            return;
        }
        MonitoringMode monitoringMode = this.getPrevMonitoringMode();
        if (monitoringMode != null && !MonitoringMode.Disabled.equals(monitoringMode)) {
            return;
        }
        logger.debug("startSampling, sendInitialValues: {}", (Object)bl);
        if (bl) {
            if (!this.hasAggregateFilter()) {
                this.addNewSample(this.cpW(), false);
            } else {
                if (!this.isAccessible()) {
                    DataValue dataValue = this.cpW();
                    if (dataValue != null && dataValue.getStatusCode().isBad()) {
                        dataValue = dataValue.clone();
                        dataValue.setValue(null);
                        this.addNewSample(dataValue, false);
                    } else {
                        logger.debug("isAccessible is false, but received non-bad item as the initial value, skipping..");
                    }
                }
                this.initAggregateFilter();
            }
        }
    }

    @Override
    protected void unPlugNodeListener() {
        logger.debug("unPlugNodeListener {} {}", (Object)this.subscription, (Object)this);
        UaNode uaNode = this.getNode();
        if (uaNode instanceof ServerNode) {
            ((ServerNode)uaNode).removeDataChangeListener(this.dataChangeListener);
        }
        this.assignEuRange(null);
    }

    protected void updateAccessible(Session session) {
        logger.debug("updateAccessible: session={}", (Object)session);
        if (session != null) {
            logger.debug("updateAccessible: session.userIdentity={}", (Object)session.getUserIdentity());
        }
        this.jQ = null;
    }

    @Override
    protected void updateFilter() {
        logger.debug("updateFilter: {}", (Object)this.getFilter());
        if (this.getNode() instanceof UaVariable && !this.hasAggregateFilter() && DeadbandType.Percent == DeadbandType.valueOf(this.getDataChangeFilter().getDeadbandType())) {
            this.b((UaVariable)this.getNode());
        } else {
            this.assignEuRange(null);
        }
        if (this.getNode() instanceof UaVariable && this.hasAggregateFilter()) {
            DateTime dateTime = DateTime.currentTime().getTimeInMillis() - this.getAggregateFilter().getStartTime().getTimeInMillis() > 10000L ? DateTime.currentTime() : this.getAggregateFilter().getStartTime();
            double d2 = this.getAggregateFilter().getProcessingInterval() < this.getSamplingInterval() * 2.0 ? this.getSamplingInterval() * 2.0 : this.getAggregateFilter().getProcessingInterval();
            try {
                this.setFilter(new AggregateFilter(dateTime, this.getAggregateFilter().getAggregateType(), d2, this.getAggregateFilter().getAggregateConfiguration()));
            }
            catch (ServiceException serviceException) {
                logger.warn("Error in MonitoredDataItem.updateFilter:", (Throwable)serviceException);
            }
            this.setFilterResult(new AggregateFilterResult(dateTime, d2, this.getAggregateFilter().getAggregateConfiguration()));
        }
    }

    @Override
    protected synchronized void updateQueue() {
        logger.debug("updateQueue");
        BlockingDeque<DataValue> blockingDeque = this.jW;
        boolean bl = this.getMonitoringMode().equals(MonitoringMode.Disabled);
        BlockingDeque<Object> blockingDeque2 = this.jW = bl || this.queueSize <= 1L ? null : new LinkedBlockingDeque((int)this.queueSize);
        if (logger.isDebugEnabled()) {
            logger.debug("updateQueue: making queue of size: " + (this.jW == null ? "null" : Long.valueOf(this.queueSize)));
        }
        if (blockingDeque != null) {
            logger.debug("updateQueue: oldQueue={}", blockingDeque);
            if (this.jW != null) {
                while (!blockingDeque.isEmpty()) {
                    this.addNewSample(blockingDeque.poll(), false);
                }
            } else {
                blockingDeque.clear();
            }
        } else {
            this.startSampling(true);
        }
        logger.debug("updateQueue done. Active size={}", (Object)(this.jW == null ? 0 : this.jW.size()));
    }

    protected class AggregateFilterConfiguration {
        private DateTime kb;
        private DateTime kc = DateTime.MIN_VALUE;
        private long kd;
        private boolean s;
        private a ke;
        private AggregateFilter kf;
        private AggregateCalculator cG;

        public AggregateFilterConfiguration(AggregateCalculator aggregateCalculator, AggregateFilter aggregateFilter, boolean bl, long l2, double d2) {
            this.cG = aggregateCalculator;
            this.kf = aggregateFilter;
            this.kb = aggregateFilter.getStartTime();
            this.kd = aggregateFilter.getProcessingInterval().longValue() * 10000L;
            this.s = bl;
            int n2 = (int)Math.ceil((double)aggregateFilter.getProcessingInterval().longValue() / d2 * (double)(l2 + 1L));
            this.ke = new a(n2);
        }

        public int getQueueSize() {
            return this.ke.kg.size();
        }

        public DataValue lastValue() {
            return (DataValue)this.ke.kg.peekLast();
        }

        private void e(DataValue dataValue) {
            this.ke.e(dataValue);
        }

        private ArrayList<DataValue> b(DateTime dateTime) {
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            DateTime dateTime2 = this.cpZ();
            while (this.kc.getValue() + this.kd <= dateTime.getValue()) {
                this.kc = new DateTime(this.kc.getValue() + this.kd);
            }
            DateTime dateTime3 = this.kc;
            if (dateTime2.compareTo(dateTime3) < 0) {
                try {
                    AggregateCalculator.AggregateCalculatorContinuationPoint aggregateCalculatorContinuationPoint = null;
                    HistoryData historyData = new HistoryData();
                    do {
                        aggregateCalculatorContinuationPoint = this.cG.calculateAggregates(dateTime2, dateTime3, (double)this.kd / 10000.0, this.kf.getAggregateType(), this.kf.getAggregateConfiguration(), this.s, this.ke, aggregateCalculatorContinuationPoint, historyData);
                        arrayList.addAll(Arrays.asList(historyData.getDataValues()));
                    } while (aggregateCalculatorContinuationPoint != null);
                }
                catch (StatusException statusException) {
                    logger.error("Error while calculating Aggregates", (Throwable)statusException);
                    return null;
                }
            }
            return arrayList;
        }

        private DateTime cpZ() {
            DateTime dateTime;
            if (this.kc == DateTime.MIN_VALUE) {
                dateTime = this.kb;
                this.kc = this.kb;
            } else {
                dateTime = this.kc;
            }
            return dateTime;
        }

        private void f(DataValue dataValue) {
            this.ke.getQueue().pollLast();
            this.ke.getQueue().offer(dataValue);
        }

        private boolean c(DateTime dateTime) {
            return this.kc == DateTime.MIN_VALUE ? this.kb.getValue() + this.kd <= dateTime.getValue() : this.kc.getValue() + this.kd <= dateTime.getValue();
        }

        private boolean d(DateTime dateTime) {
            return this.kb.getValue() <= dateTime.getValue();
        }
    }

    private class a
    implements AggregateCalculator.HistoryDataProvider {
        private BlockingDeque<DataValue> kg;

        private a(int n2) {
            this.kg = new LinkedBlockingDeque<DataValue>(n2);
        }

        @Override
        public DataValue readFirstAfterTimestamp(DateTime dateTime, boolean bl) {
            Iterator iterator = this.kg.descendingIterator();
            DataValue dataValue = null;
            while (iterator.hasNext()) {
                DataValue dataValue2 = (DataValue)iterator.next();
                if (dataValue2.getSourceTimestamp().compareTo(dateTime) <= 0 && (!bl || dataValue2.getSourceTimestamp().compareTo(dateTime) != 0)) continue;
                dataValue = dataValue2;
            }
            return dataValue;
        }

        @Override
        public DataValue readFirstBeforeTimestamp(DateTime dateTime, boolean bl) {
            Iterator iterator = this.kg.descendingIterator();
            DataValue dataValue = null;
            while (iterator.hasNext()) {
                DataValue dataValue2 = (DataValue)iterator.next();
                if (dataValue2.getSourceTimestamp().compareTo(dateTime) >= 0 && (!bl || dataValue2.getSourceTimestamp().compareTo(dateTime) != 0)) continue;
                dataValue = dataValue2;
            }
            return dataValue;
        }

        @Override
        public List<DataValue> readRawAll(DateTime dateTime, DateTime dateTime2, boolean bl, boolean bl2) throws StatusException {
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            DataValue dataValue = this.kg.peek();
            while (dataValue != null && (dataValue.getSourceTimestamp().compareTo(dateTime) > 0 || bl && dataValue.getSourceTimestamp().compareTo(dateTime) == 0) && (dataValue.getSourceTimestamp().compareTo(dateTime2) < 0 || bl2 && dataValue.getSourceTimestamp().compareTo(dateTime2) == 0)) {
                arrayList.add(this.kg.poll());
                dataValue = this.kg.peek();
            }
            return arrayList;
        }

        private void e(DataValue dataValue) {
            boolean bl;
            boolean bl2 = bl = !this.kg.offer(dataValue);
            while (bl) {
                this.kg.poll();
                bl = !this.kg.offer(dataValue);
            }
        }

        private BlockingDeque<DataValue> getQueue() {
            return this.kg;
        }
    }
}

