/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.server.ReverseConnectionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ReverseConnectionParameters {
    private final String kR;
    private final String kS;
    private final Function<List<String>, String> kT;
    private final List<Integer> kU;
    private final Executor kV;
    private final Consumer<ReverseConnectionStatus> kW;

    public static Builder builder() {
        return new Builder();
    }

    public static ReverseConnectionParameters from(String string, String string2) {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(string);
        builder.setEndpointUrlForClientConnection(string2);
        return builder.build();
    }

    private ReverseConnectionParameters(String string, String string2, List<Integer> list, Executor executor, Consumer<ReverseConnectionStatus> consumer, Function<List<String>, String> function) {
        this.kR = string;
        this.kS = string2;
        this.kU = Collections.unmodifiableList(new ArrayList<Integer>(list));
        this.kV = executor;
        this.kW = consumer;
        this.kT = function;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReverseConnectionParameters)) {
            return false;
        }
        ReverseConnectionParameters reverseConnectionParameters = (ReverseConnectionParameters)object;
        return Objects.equals(this.kR, reverseConnectionParameters.kR);
    }

    public String getClientServerEndpointUrl() {
        return this.kR;
    }

    public String getEndpointUrlForClientConnection() {
        return this.kS;
    }

    public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
        return this.kT;
    }

    public List<Integer> getRetryWaitIntervals() {
        return this.kU;
    }

    public int hashCode() {
        return Objects.hash(this.kR);
    }

    public void internalFireStatusNotification(ReverseConnectionStatus reverseConnectionStatus) {
        if (this.kV == null || this.kW == null) {
            return;
        }
        try {
            this.kV.execute(() -> this.kW.accept(reverseConnectionStatus));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public Builder toBuilder() {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(this.kR);
        builder.setEndpointUrlForClientConnection(this.kS);
        builder.setStatusListener(this.kV, this.kW);
        builder.setEndpointUrlForClientConnectionSelector(this.kT);
        builder.getRetryWaitIntervals().clear();
        builder.getRetryWaitIntervals().addAll(this.getRetryWaitIntervals());
        return builder;
    }

    public String toString() {
        return "ReverseConnectionParameters [clientServerEndpointUrl=" + this.kR + ", endpointUrlForClientConnection=" + this.kS + ", retryWaitIntervals=" + this.kU + "]";
    }

    public static class Builder {
        private String kR;
        private String kS;
        private final List<Integer> kU;
        private Executor kV;
        private Consumer<ReverseConnectionStatus> kW;
        private Function<List<String>, String> kT = list -> (String)list.get(0);

        private Builder() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(100);
            arrayList.add(500);
            arrayList.add(1000);
            this.kU = arrayList;
        }

        public ReverseConnectionParameters build() {
            return new ReverseConnectionParameters(this.kR, this.kS, this.kU, this.kV, this.kW, this.kT);
        }

        public String getClientServerEndpointUrl() {
            return this.kR;
        }

        public String getEndpointUrlForClientConnection() {
            return this.kS;
        }

        public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
            return this.kT;
        }

        public List<Integer> getRetryWaitIntervals() {
            return this.kU;
        }

        public Builder setClientServerEndpointUrl(String string) {
            this.kR = string;
            return this;
        }

        public Builder setEndpointUrlForClientConnection(String string) {
            this.kS = string;
            return this;
        }

        public void setEndpointUrlForClientConnectionSelector(Function<List<String>, String> function) {
            InternalArguments.checkNotNull(function, "endpointUrlForClientConnectionSelector");
            this.kT = function;
        }

        public Builder setStatusListener(Executor executor, Consumer<ReverseConnectionStatus> consumer) {
            this.kV = executor;
            this.kW = consumer;
            return this;
        }
    }
}

