/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SemanticChangeEvent {
    private final Map<NodeId, SemanticChangeStructureDataType> lb = new ConcurrentHashMap<NodeId, SemanticChangeStructureDataType>();
    private final NamespaceTable je;
    private SemanticChangeStructureDataType[] lc = null;

    public SemanticChangeEvent(NamespaceTable namespaceTable) {
        this.je = namespaceTable;
    }

    public void addChange(NodeId nodeId, NodeId nodeId2) {
        if (!this.lb.containsKey(nodeId)) {
            this.lb.put(nodeId, new SemanticChangeStructureDataType(nodeId, nodeId2));
        }
    }

    public void addChange(UaNode uaNode) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.je.toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addChange(nodeId, nodeId2);
    }

    public void clearChanges() {
        this.lb.clear();
        this.lc = null;
    }

    public SemanticChangeStructureDataType[] getChanges() {
        if (this.lc != null) {
            return this.lc;
        }
        return this.lb.values().toArray(new SemanticChangeStructureDataType[this.lb.size()]);
    }

    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) {
        this.clearChanges();
        this.lc = semanticChangeStructureDataTypeArray;
    }
}

