/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchy;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyException;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDeclarationHierarchyCache {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDeclarationHierarchyCache.class);
    private final Map<UaType, InstanceDeclarationHierarchy> cache = new ConcurrentHashMap<UaType, InstanceDeclarationHierarchy>();
    private final Set<NodeId> pS = new CopyOnWriteArraySet<NodeId>();

    public void clear() {
        this.cache.clear();
    }

    public InstanceDeclarationHierarchy getForType(UaType uaType) throws InstanceDeclarationHierarchyException {
        if (this.cache.containsKey(uaType)) {
            return this.cache.get(uaType);
        }
        InstanceDeclarationHierarchy instanceDeclarationHierarchy = this.b(uaType);
        this.cache.put(uaType, instanceDeclarationHierarchy);
        return instanceDeclarationHierarchy;
    }

    private synchronized InstanceDeclarationHierarchy b(UaType uaType) throws InstanceDeclarationHierarchyException {
        if (this.cache.containsKey(uaType)) {
            return this.cache.get(uaType);
        }
        if (this.pS.contains(uaType.getNodeId())) {
            throw new InstanceDeclarationHierarchyException("Encountered a loop in typespace, asked type id: " + uaType.getNodeId() + ", name: " + uaType.getBrowseName() + " , which is already under construction");
        }
        this.pS.add(uaType.getNodeId());
        logger.debug("Building InstanceDeclarationHierarchy for type, id={}, name={}", (Object)uaType.getNodeId(), (Object)uaType.getBrowseName());
        InstanceDeclarationHierarchy instanceDeclarationHierarchy = new InstanceDeclarationHierarchy(uaType, this);
        this.pS.remove(uaType.getNodeId());
        return instanceDeclarationHierarchy;
    }
}

