/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.instantiation.b;
import com.prosysopc.ua.server.instantiation.h;
import com.prosysopc.ua.server.instantiation.k;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TemporaryInstanceDeclaration {
    private final Set<RelativeNamePath> pT;
    private final Set<b> pU;
    private final Set<h> qm;
    private final UaNode node;
    private final List<UaNode> nodes;
    private final NodeId nodeId;

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        return new Builder(temporaryInstanceDeclaration);
    }

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
        return new Builder(temporaryInstanceDeclaration, relativeNamePath);
    }

    public static Builder builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
        return new Builder(uaNode, relativeNamePath);
    }

    public static Builder builder(UaType uaType) {
        return TemporaryInstanceDeclaration.builder(uaType, RelativeNamePath.EMPTY);
    }

    private TemporaryInstanceDeclaration(UaNode uaNode, List<UaNode> list, LinkedHashSet<RelativeNamePath> linkedHashSet, LinkedHashSet<b> linkedHashSet2, LinkedHashSet<h> linkedHashSet3) {
        this.node = uaNode;
        this.nodeId = uaNode.getNodeId();
        this.nodes = Collections.unmodifiableList(new ArrayList<UaNode>(list));
        this.pT = Collections.unmodifiableSet(linkedHashSet);
        this.pU = Collections.unmodifiableSet(linkedHashSet2);
        this.qm = Collections.unmodifiableSet(linkedHashSet3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryInstanceDeclaration temporaryInstanceDeclaration = (TemporaryInstanceDeclaration)object;
        if (this.pT == null ? temporaryInstanceDeclaration.pT != null : !this.pT.equals(temporaryInstanceDeclaration.pT)) {
            return false;
        }
        if (this.pU == null ? temporaryInstanceDeclaration.pU != null : !this.pU.equals(temporaryInstanceDeclaration.pU)) {
            return false;
        }
        if (this.qm == null ? temporaryInstanceDeclaration.qm != null : !this.qm.equals(temporaryInstanceDeclaration.qm)) {
            return false;
        }
        return !(this.nodeId == null ? temporaryInstanceDeclaration.nodeId != null : !this.nodeId.equals(temporaryInstanceDeclaration.nodeId));
    }

    public Set<RelativeNamePath> getBrowsePaths() {
        return this.pT;
    }

    public Set<b> getExternalReferences() {
        return this.pU;
    }

    public Set<h> getInternalReferences() {
        return this.qm;
    }

    public UaNode getNode() {
        return this.node;
    }

    public List<UaNode> getNodes() {
        return this.nodes;
    }

    public RelativeNamePath getPrimaryPath() {
        return this.pT.iterator().next();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.pT == null ? 0 : this.pT.hashCode());
        n3 = 31 * n3 + (this.pU == null ? 0 : this.pU.hashCode());
        n3 = 31 * n3 + (this.qm == null ? 0 : this.qm.hashCode());
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean hasPath(RelativeNamePath relativeNamePath) {
        return this.pT.contains(relativeNamePath);
    }

    public boolean isRoot() {
        return this.pT.size() == 1 && this.getPrimaryPath().isEmpty();
    }

    public String toString() {
        return "Paths=" + this.pT;
    }

    TemporaryInstanceDeclaration b(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        Builder builder = TemporaryInstanceDeclaration.builder(this);
        builder.nodes.addAll(temporaryInstanceDeclaration.nodes);
        builder.addBrowsePath(temporaryInstanceDeclaration.pT);
        builder.addExternalReference(temporaryInstanceDeclaration.pU);
        builder.addInternalReference(temporaryInstanceDeclaration.qm);
        return builder.build();
    }

    public static class Builder {
        private final LinkedHashSet<RelativeNamePath> qn = new LinkedHashSet();
        private final LinkedHashSet<b> qo = new LinkedHashSet();
        private final LinkedHashSet<h> qp = new LinkedHashSet();
        private final UaNode node;
        private final List<UaNode> nodes = new ArrayList<UaNode>();

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            this.qn.addAll(temporaryInstanceDeclaration.pT);
            this.qo.addAll(temporaryInstanceDeclaration.pU);
            this.qp.addAll(temporaryInstanceDeclaration.qm);
        }

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.pT) {
                this.qn.add(relativeNamePath.append((RelativeNamePath)comparable));
            }
            this.qo.addAll(temporaryInstanceDeclaration.pU);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.qm) {
                this.qp.add(new h(((k)comparable).getReferenceType(), relativeNamePath.append(((h)comparable).csZ())));
            }
        }

        private Builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
            this.node = uaNode;
            this.nodes.add(uaNode);
            this.qn.add(relativeNamePath);
        }

        public void addBrowsePath(Collection<? extends RelativeNamePath> collection) {
            this.qn.addAll(collection);
        }

        public void addBrowsePath(RelativeNamePath relativeNamePath) {
            this.qn.add(relativeNamePath);
        }

        public void addExternalReference(Collection<? extends b> collection) {
            this.qo.addAll(collection);
        }

        public void addExternalReference(b b2) {
            this.qo.add(b2);
        }

        public void addInternalReference(Collection<? extends h> collection) {
            this.qp.addAll(collection);
        }

        public void addInternalReference(h h2) {
            this.qp.add(h2);
        }

        public TemporaryInstanceDeclaration build() {
            return new TemporaryInstanceDeclaration(this.node, this.nodes, this.qn, this.qo, this.qp);
        }

        public UaNode getNode() {
            return this.node;
        }

        public RelativeNamePath getPrimaryPath() {
            return (RelativeNamePath)this.qn.iterator().next();
        }
    }
}

