/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.instantiation.InstantiationParameters;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStateVariableInstantiationStrategy
implements InstantiationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TwoStateVariableInstantiationStrategy.class);
    private final Boolean qq;
    private final String qr;
    private final String qs;

    public TwoStateVariableInstantiationStrategy(String string, String string2, boolean bl) {
        this.qs = string;
        this.qr = string2;
        this.qq = bl;
    }

    @Override
    public UaNode createInstance(InstantiationParameters instantiationParameters) {
        logger.debug("Creating TwoStateVariable");
        UaNode uaNode = instantiationParameters.getInstanceDeclaration().getNode();
        TwoStateVariableTypeNode twoStateVariableTypeNode = instantiationParameters.getNodeManager().createInstance(TwoStateVariableTypeNode.class, instantiationParameters.getNodeId(), uaNode.getBrowseName(), uaNode.getDisplayName());
        twoStateVariableTypeNode.setTrueState(this.qs, LocalizedText.NO_LOCALE);
        twoStateVariableTypeNode.setFalseState(this.qr, LocalizedText.NO_LOCALE);
        twoStateVariableTypeNode.setId(this.qq);
        return twoStateVariableTypeNode;
    }

    @Override
    public boolean createsCompleteHierarchy() {
        return true;
    }
}

