/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.UaBrowseNamePath;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.instantiation.DefaultInstantiationStrategy;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionBasedNodeBuilderConfiguration
implements UaNodeBuilderConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBasedNodeBuilderConfiguration.class);
    private final InstantiationStrategy qt;
    private final Map<UaBrowseNamePath, InstantiationStrategy> qu;
    private final Map<UaQualifiedName, InstantiationStrategy> qv;
    private final boolean qw;

    public static Builder builder() {
        return new Builder(new DefaultInstantiationStrategy(DefaultInstantiationStrategy.MethodInstantiationLogic.SHARED));
    }

    public static Builder builder(InstantiationStrategy instantiationStrategy) {
        return new Builder(instantiationStrategy);
    }

    public static Builder builder(DefaultInstantiationStrategy.MethodInstantiationLogic methodInstantiationLogic) {
        return new Builder(new DefaultInstantiationStrategy(methodInstantiationLogic));
    }

    private TypeDefinitionBasedNodeBuilderConfiguration(InstantiationStrategy instantiationStrategy, Map<UaBrowseNamePath, InstantiationStrategy> map, Map<UaQualifiedName, InstantiationStrategy> map2, boolean bl) {
        this.qt = instantiationStrategy;
        this.qu = map;
        this.qv = map2;
        this.qw = bl;
    }

    @Override
    public InstantiationStrategy getInstantiationStrategy(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters instantiationStrategySearchParameters) {
        try {
            if (instantiationStrategySearchParameters.getHierarchy().length == 0) {
                return this.qt;
            }
            InstanceDeclaration[] instanceDeclarationArray = instantiationStrategySearchParameters.getHierarchy();
            UaNode uaNode = instanceDeclarationArray[instanceDeclarationArray.length - 1].getNode();
            logger.debug("Searching using TypeDefinition of node with id: {}, name:{}", (Object)uaNode.getNodeId(), (Object)uaNode.getBrowseName());
            if (uaNode instanceof UaInstance || uaNode instanceof UaType) {
                Comparable<UaNodeId> comparable;
                UaType uaType;
                InstantiationStrategy instantiationStrategy = null;
                NamespaceTable namespaceTable = uaType.getAddressSpace().getNamespaceTable();
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                for (uaType = uaNode instanceof UaType ? (UaType)uaNode : ((UaInstance)uaNode).getTypeDefinition(); uaType != null && instantiationStrategy == null; uaType = uaType.getSuperType()) {
                    comparable = UaNodeId.fromLocal(uaType.getNodeId(), namespaceTable);
                    UaBrowseNamePath uaBrowseNamePath = UaBrowseNamePath.from(comparable, new UaQualifiedName[]{uaQualifiedName});
                    instantiationStrategy = this.qu.get(uaBrowseNamePath);
                    if (instantiationStrategy != null) {
                        logger.debug("Found td/id: {}/{}, found: {}", new Object[]{uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable), instantiationStrategy});
                        continue;
                    }
                    logger.debug("Not found in/td/id: {}/({})/{}, searching again using super type of the typedefinition", new Object[]{uaNode.getBrowseName(), uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable)});
                }
                if (instantiationStrategy == null) {
                    comparable = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                    instantiationStrategy = this.qv.get(comparable);
                }
                if (instantiationStrategy == null && ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                    instantiationStrategy = this.qt;
                }
                logger.debug("Returning strategy:{}", instantiationStrategy);
                if (instantiationStrategy != null) {
                    return instantiationStrategy;
                }
            }
            if (ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                return this.qt;
            }
            if (this.qw && !ModellingRule.MandatoryPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) && !ModellingRule.OptionalPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule())) {
                return this.qt;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error while searching InstantiationStrategy", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public static class Builder {
        private final InstantiationStrategy qx;
        private final Map<UaBrowseNamePath, InstantiationStrategy> qy;
        private final Map<UaQualifiedName, InstantiationStrategy> qz;
        private boolean qw;

        private Builder(InstantiationStrategy instantiationStrategy) {
            this.qx = instantiationStrategy;
            this.qy = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            this.qz = new HashMap<UaQualifiedName, InstantiationStrategy>();
            this.qw = false;
        }

        public Builder addOptional(Collection<UaBrowseNamePath> collection) {
            this.addOptional(collection.toArray(new UaBrowseNamePath[collection.size()]));
            return this;
        }

        public Builder addOptional(UaBrowseNamePath ... uaBrowseNamePathArray) {
            if (uaBrowseNamePathArray != null) {
                for (UaBrowseNamePath uaBrowseNamePath : uaBrowseNamePathArray) {
                    this.qy.put(uaBrowseNamePath, this.qx);
                }
            }
            return this;
        }

        public Builder addOptional(UaQualifiedName uaQualifiedName) {
            this.qz.put(uaQualifiedName, this.qx);
            return this;
        }

        public TypeDefinitionBasedNodeBuilderConfiguration build() {
            HashMap<UaBrowseNamePath, InstantiationStrategy> hashMap = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            hashMap.putAll(this.qy);
            HashMap<UaQualifiedName, InstantiationStrategy> hashMap2 = new HashMap<UaQualifiedName, InstantiationStrategy>();
            hashMap2.putAll(this.qz);
            return new TypeDefinitionBasedNodeBuilderConfiguration(this.qx, hashMap, hashMap2, this.qw);
        }

        public Builder setInstantiateAllOptionals(boolean bl) {
            this.qw = bl;
            return this;
        }

        public Builder setInstantiationStrategy(UaBrowseNamePath uaBrowseNamePath, InstantiationStrategy instantiationStrategy) {
            this.qy.put(uaBrowseNamePath, instantiationStrategy);
            return this;
        }
    }
}

