/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.io;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.io.IoManagerListenerChain;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class IoManagerListenerChainImpl
implements IoManagerListenerChain {
    private final List<IoManagerListener> listeners = new ArrayList<IoManagerListener>();

    @Override
    public void addListeners(IoManagerListener ... ioManagerListenerArray) {
        this.listeners.addAll(0, Arrays.asList(ioManagerListenerArray));
    }

    @Override
    public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable uaVariable) {
        IoManagerListener ioManagerListener;
        AccessLevelType accessLevelType = null;
        Iterator<IoManagerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext() && (accessLevelType = (ioManagerListener = iterator.next()).onGetUserAccessLevel(serviceContext, nodeId, uaVariable)) == null) {
        }
        return accessLevelType;
    }

    @Override
    public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod uaMethod) {
        IoManagerListener ioManagerListener;
        Boolean bl = null;
        Iterator<IoManagerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext() && (bl = (ioManagerListener = iterator.next()).onGetUserExecutable(serviceContext, nodeId, uaMethod)) == null) {
        }
        return bl;
    }

    @Override
    public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode) {
        IoManagerListener ioManagerListener;
        AttributeWriteMask attributeWriteMask = null;
        Iterator<IoManagerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext() && (attributeWriteMask = (ioManagerListener = iterator.next()).onGetUserWriteMask(serviceContext, nodeId, uaNode)) == null) {
        }
        return attributeWriteMask;
    }

    @Override
    public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        for (IoManagerListener ioManagerListener : this.listeners) {
            if (!ioManagerListener.onReadNonValue(serviceContext, nodeId, uaNode, unsignedInteger, dataValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        for (IoManagerListener ioManagerListener : this.listeners) {
            if (!ioManagerListener.onReadValue(serviceContext, nodeId, uaValueNode, numericRange, timestampsToReturn, dateTime, dataValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        for (IoManagerListener ioManagerListener : this.listeners) {
            if (!ioManagerListener.onWriteNonValue(serviceContext, nodeId, uaNode, unsignedInteger, dataValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        for (IoManagerListener ioManagerListener : this.listeners) {
            if (!ioManagerListener.onWriteValue(serviceContext, nodeId, uaValueNode, numericRange, dataValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeListeners(IoManagerListener ... ioManagerListenerArray) {
        this.listeners.removeAll(Arrays.asList(ioManagerListenerArray));
    }

    @Override
    public void setListeners(IoManagerListener ... ioManagerListenerArray) {
        this.listeners.clear();
        this.addListeners(ioManagerListenerArray);
    }
}

