/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackInstanceVariable
extends InstanceVariable {
    private static final Logger logger = LoggerFactory.getLogger(CallbackInstanceVariable.class);
    private DateTime qK = INITIALIZATION_TIME;
    protected UaVariableCallback callback;

    public CallbackInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        super(nodeManagerUaNode, nodeId, nodeId2);
    }

    public CallbackInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId, uaVariable);
    }

    public UaVariableCallback getCallback() {
        return this.callback;
    }

    @Override
    public DataValue getValue() {
        if (this.callback != null) {
            try {
                Object object = this.callback.getValue();
                DataValue dataValue = object == null ? new DataValue(StatusCode.BAD) : new DataValue(new Variant(object));
                dataValue.setServerTimestamp(DateTime.currentTime());
                dataValue.setSourceTimestamp(this.qK);
                return dataValue;
            }
            catch (StatusException statusException) {
                logger.error("StatusException: ", (Throwable)statusException);
                return new DataValue(statusException.getStatusCode());
            }
        }
        return null;
    }

    public void setCallback(UaVariableCallback uaVariableCallback) {
        this.callback = uaVariableCallback;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (this.callback != null) {
            this.callback.setValue(dataValue.getValue().getValue());
            this.qK = DateTime.currentTime();
        }
    }
}

