/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.Locale;
import java.util.Map;

public class UaDataTypeNode
extends UaTypeNode
implements UaDataType {
    public UaDataTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaDataTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaDataTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new DataTypeAttributes());
    }

    @Override
    public DataTypeDefinition getDataTypeDefinition() {
        NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.getNodeId(), namespaceTable);
        UaDataTypeSpecification uaDataTypeSpecification = this.getAddressSpace().getServer().getEncoderContext().getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification.toDataTypeDefinition(namespaceTable);
        }
        return null;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.DataType;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof DataTypeAttributes) {
            this.setIsAbstract(((DataTypeAttributes)nodeAttributes).getIsAbstract());
        } else if (nodeAttributes instanceof GenericAttributes) {
            GenericAttributes genericAttributes = (GenericAttributes)nodeAttributes;
            if (genericAttributes.getAttributeValues() != null) {
                for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    if (!Attributes.IsAbstract.equals(genericAttributeValue.getAttributeId())) continue;
                    this.setIsAbstract((Boolean)genericAttributeValue.getValue());
                }
            }
        } else {
            throw new IllegalArgumentException("Incorrect NodeAttributes subtype given, was: " + nodeAttributes);
        }
        super.setAttributes(nodeAttributes);
    }

    protected DataTypeAttributes getAttributes(DataTypeAttributes dataTypeAttributes) {
        super.getAttributes(dataTypeAttributes);
        dataTypeAttributes.setIsAbstract(this.getIsAbstract());
        return dataTypeAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.IsAbstract, this.getIsAbstract());
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (Attributes.DataTypeDefinition.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.getDataTypeDefinition()));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }
}

