/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaObjectType;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.nodes.UaCallable;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.EventNotifierType;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class UaObjectNode
extends UaInstanceNode
implements UaObject,
UaCallable {
    private final List<CallableListener> listeners = new CopyOnWriteArrayList<CallableListener>();
    EventNotifierType hZ = EventNotifierType.of();

    public UaObjectNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaObjectNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaObjectNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void addCallListener(CallableListener callableListener) {
        this.listeners.add(callableListener);
    }

    @Override
    public Object[] callMethod(NodeId nodeId, Object ... objectArray) throws StatusException {
        Variant[] variantArray = new Variant[objectArray.length];
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < variantArray.length; ++i2) {
            variantArray[i2] = new Variant(objectArray[i2]);
        }
        Variant[] variantArray2 = this.callMethod(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
        Object[] objectArray2 = new Object[variantArray2.length];
        for (int i3 = 0; i3 < variantArray2.length; ++i3) {
            objectArray2[i3] = variantArray2[i3].getValue();
        }
        return objectArray2;
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        throw new StatusException(StatusCodes.Bad_MethodInvalid);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new ObjectAttributes());
    }

    @Override
    public EventNotifierType getEventNotifier() {
        if (this.hZ.contains(EventNotifierType.Options.SubscribeToEvents)) {
            return this.hZ;
        }
        Set<EventNotifierType.Options> set = this.hZ.toSet();
        UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasEventSource, false);
        UaReference[] uaReferenceArray2 = this.getReferences(Identifiers.HasEventSource, true);
        if (uaReferenceArray.length > 0 || uaReferenceArray2.length > 0) {
            set.add(EventNotifierType.Options.SubscribeToEvents);
        }
        return EventNotifierType.of(set);
    }

    @Override
    public UaProperty getIcon() {
        return this.getProperty(UaObjectType.ICON_PROPERTY);
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Object;
    }

    @Override
    public void removeCallListener(CallableListener callableListener) {
        this.listeners.remove(callableListener);
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof ObjectAttributes) {
            this.setEventNotifier(EventNotifierType.of(((ObjectAttributes)nodeAttributes).getEventNotifier()));
        } else if (nodeAttributes instanceof GenericAttributes) {
            GenericAttributes genericAttributes = (GenericAttributes)nodeAttributes;
            if (genericAttributes.getAttributeValues() != null) {
                for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    if (!Attributes.EventNotifier.equals(genericAttributeValue.getAttributeId())) continue;
                    this.setEventNotifier(EventNotifierType.of((UnsignedByte)genericAttributeValue.getValue()));
                }
            }
        } else {
            throw new IllegalArgumentException("Incorrect NodeAttributes subtype given, was: " + nodeAttributes);
        }
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setEventNotifier(EventNotifierType eventNotifierType) {
        this.hZ = eventNotifierType;
    }

    @Override
    public void setIcon(UaProperty uaProperty) throws StatusException {
        this.setPropertyValue(UaObjectType.ICON_PROPERTY, uaProperty);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    protected void deleteIfNodeExists(NodeId nodeId) {
        if (this.nodeManager.hasNode(nodeId)) {
            try {
                this.nodeManager.deleteNode(nodeId, true, true);
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }
    }

    protected NodeAttributes getAttributes(ObjectAttributes objectAttributes) {
        super.getAttributes(objectAttributes);
        objectAttributes.setEventNotifier((UnsignedByte)this.getEventNotifier().asBuiltInType());
        return objectAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.EventNotifier, this.getEventNotifier().asBuiltInType());
    }

    @Override
    protected ExpandedNodeId getDefaultTypeDefinition() {
        return new ExpandedNodeId(Identifiers.BaseObjectType);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.EventNotifier);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.EventNotifier)) {
            dataValue.setValue(new Variant(this.getEventNotifier().asBuiltInType()));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.EventNotifier)) {
            if (object instanceof EventNotifierType) {
                this.hZ = (EventNotifierType)object;
            } else {
                byte by = 0;
                if (object instanceof UnsignedByte) {
                    by = ((UnsignedByte)object).byteValue();
                } else if (object instanceof UnsignedInteger) {
                    by = ((UnsignedInteger)object).byteValue();
                }
                this.hZ = EventNotifierType.of(UnsignedByte.getFromBits(by));
            }
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

