/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    ApplicationDescription J = new ApplicationDescription();
    List<KeyPair> rh = new CopyOnWriteArrayList<KeyPair>();
    List<SignedSoftwareCertificate> ri = new CopyOnWriteArrayList<SignedSoftwareCertificate>();
    List<Locale> lF = new CopyOnWriteArrayList<Locale>();
    HttpsSettings gy = new HttpsSettings();
    OpcTcpSettings rj = new OpcTcpSettings();
    private EncoderContext av = new EncoderContext(new NamespaceTable(), new ServerTable());

    public Application() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.J.setApplicationUri("urn:" + string + ":" + UUID.randomUUID());
        this.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        this.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
    }

    public void addApplicationInstanceCertificate(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.rh.add(keyPair);
    }

    public void addLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.lF.add(locale);
    }

    public void addSoftwareCertificate(SignedSoftwareCertificate signedSoftwareCertificate) {
        if (signedSoftwareCertificate == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.ri.add(signedSoftwareCertificate);
    }

    public ApplicationDescription getApplicationDescription() {
        return this.J;
    }

    public KeyPair getApplicationInstanceCertificate() {
        int n2 = this.rh.size() - 1;
        if (n2 < 0) {
            return null;
        }
        return this.rh.get(n2);
    }

    public KeyPair getApplicationInstanceCertificate(byte[] byArray) {
        logger.debug("getApplicationInstanceCertificate: expected={}", (Object)CryptoUtil.toHex(byArray));
        if (byArray != null) {
            int n2 = 0;
            for (KeyPair keyPair : this.rh) {
                byte[] byArray2 = keyPair.getCertificate().getEncodedThumbprint();
                logger.debug("getApplicationInstanceCertificate: cert[{}]={}", (Object)n2++, (Object)CryptoUtil.toHex(byArray2));
                if (!Arrays.equals(byArray2, byArray)) continue;
                return keyPair;
            }
        }
        return null;
    }

    public KeyPair[] getApplicationInstanceCertificates() {
        return this.rh.toArray(new KeyPair[this.rh.size()]);
    }

    public String getApplicationUri() {
        return this.J.getApplicationUri();
    }

    public EncoderContext getEncoderContext() {
        return this.av;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gy;
    }

    public String[] getLocaleIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.lF.size());
        for (Locale locale : this.lF) {
            arrayList.add(LocalizedText.toLocaleId(locale));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Locale[] getLocales() {
        return this.lF.toArray(new Locale[0]);
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.rj;
    }

    public String getProductUri() {
        return this.J.getProductUri();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.ri.toArray(new SignedSoftwareCertificate[this.ri.size()]);
    }

    public void removeApplicationInstanceCertificate(KeyPair keyPair) {
        this.rh.remove(keyPair);
    }

    public void removeApplicationInstanceCertificates() {
        this.rh.clear();
    }

    public void removeLocale(Locale locale) {
        this.lF.remove(locale);
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.J.setApplicationName(localizedText);
    }

    public void setApplicationUri(String string) {
        this.J.setApplicationUri(string);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gy = httpsSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.rj = opcTcpSettings;
    }

    public void setProductUri(String string) {
        this.J.setProductUri(string);
    }
}

