/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticInfo
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticInfo.class);
    public static boolean disableAdditionalInfo = true;
    @Deprecated
    public static final NodeId ID = Identifiers.DiagnosticInfo;
    public static final DiagnosticInfo[] EMPTY_ARRAY = new DiagnosticInfo[0];
    Integer rF;
    Integer rG;
    Integer rH;
    Integer rI;
    String additionalInfo;
    StatusCode rJ;
    DiagnosticInfo rK;
    List<String> rL;
    String[] rM;

    public static void toString(DiagnosticInfo diagnosticInfo, StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3) {
        DiagnosticInfo diagnosticInfo2;
        stringBuilder.append(bl3 ? "Inner Info: " : "Diagnostic Info: ");
        if (!bl && diagnosticInfo.getLocalizedTextStr() != null) {
            stringBuilder.append(diagnosticInfo.getLocalizedTextStr());
            stringBuilder.append(' ');
        }
        if (!bl2 && diagnosticInfo.getInnerStatusCode() != null) {
            stringBuilder.append("(");
            stringBuilder.append(diagnosticInfo.getInnerStatusCode().toString());
            stringBuilder.append(")");
        }
        stringBuilder.append('\n');
        if (diagnosticInfo.getAdditionalInfo() != null) {
            stringBuilder.append('\t');
            stringBuilder.append(diagnosticInfo.getAdditionalInfo());
            stringBuilder.append('\n');
        }
        if (diagnosticInfo.getSymbolicIdStr() != null) {
            stringBuilder.append("\tSymbolicId: " + diagnosticInfo.getSymbolicIdStr() + "\n");
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            stringBuilder.append("\tNamespaceUri: " + diagnosticInfo.getNamespaceUriStr() + "\n");
        }
        if ((diagnosticInfo2 = diagnosticInfo.getInnerDiagnosticInfo()) != null) {
            DiagnosticInfo.toString(diagnosticInfo2, stringBuilder, false, false, true);
        }
    }

    public DiagnosticInfo() {
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, Integer n2, Integer n3, Integer n4, Integer n5) {
        this.setAdditionalInfo(string);
        this.rK = diagnosticInfo;
        this.rJ = statusCode;
        this.rI = n2;
        this.rH = n3;
        this.rG = n4;
        this.rF = n5;
    }

    public DiagnosticInfo(String string, DiagnosticInfo diagnosticInfo, StatusCode statusCode, String string2, String string3, String string4, String string5, List<String> list) {
        this.setAdditionalInfo(string);
        this.rK = diagnosticInfo;
        this.rJ = statusCode;
        this.rL = list;
        this.rI = this.addOrGetIndex(string2);
        this.rH = this.addOrGetIndex(string3);
        this.rG = this.addOrGetIndex(string4);
        this.rF = this.addOrGetIndex(string5);
    }

    public Object clone() {
        try {
            DiagnosticInfo diagnosticInfo = (DiagnosticInfo)super.clone();
            diagnosticInfo.rM = StructureUtils.clone(this.rM);
            diagnosticInfo.rL = Optional.ofNullable(this.rL).map(list -> new ArrayList(list)).orElse(null);
            return diagnosticInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every DiagnosticInfo shall be Cloneable", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiagnosticInfo)) {
            return false;
        }
        DiagnosticInfo diagnosticInfo = (DiagnosticInfo)object;
        return Objects.equals(diagnosticInfo.rF, this.rF) && Objects.equals(diagnosticInfo.rG, this.rG) && Objects.equals(diagnosticInfo.rH, this.rH) && Objects.equals(diagnosticInfo.rI, this.rI) && Objects.equals(diagnosticInfo.additionalInfo, this.additionalInfo) && Objects.equals(diagnosticInfo.rJ, this.rJ) && Objects.equals(diagnosticInfo.rK, this.rK);
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public DiagnosticInfo getInnerDiagnosticInfo() {
        return this.rK;
    }

    public StatusCode getInnerStatusCode() {
        return this.rJ;
    }

    public Integer getLocale() {
        return this.rI;
    }

    public String getLocaleStr() {
        if (this.rI == null) {
            return null;
        }
        if (this.rM != null) {
            return this.rM[this.rI];
        }
        if (this.rL != null) {
            return this.rL.get(this.rI);
        }
        return this.rI.toString();
    }

    public Integer getLocalizedText() {
        return this.rH;
    }

    public String getLocalizedTextStr() {
        if (this.rH == null) {
            return null;
        }
        if (this.rM != null) {
            return this.rM[this.rH];
        }
        if (this.rL != null) {
            return this.rL.get(this.rH);
        }
        return this.rH.toString();
    }

    public Integer getNamespaceUri() {
        return this.rG;
    }

    public String getNamespaceUriStr() {
        if (this.rG == null) {
            return null;
        }
        if (this.rM != null) {
            return this.rM[this.rG];
        }
        if (this.rL != null) {
            return this.rL.get(this.rG);
        }
        return this.rG.toString();
    }

    public List<String> getStringTable() {
        return this.rL;
    }

    public Integer getSymbolicId() {
        return this.rF;
    }

    public String getSymbolicIdStr() {
        if (this.rF == null) {
            return null;
        }
        if (this.rM != null) {
            return this.rM[this.rF];
        }
        if (this.rL != null) {
            return this.rL.get(this.rF);
        }
        return this.rF.toString();
    }

    public int hashCode() {
        return Objects.hash(this.rF, this.rG, this.rH, this.rI, this.additionalInfo, this.rK, this.rJ);
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = disableAdditionalInfo ? null : string;
    }

    public void setInnerDiagnosticInfo(DiagnosticInfo diagnosticInfo) {
        this.rK = diagnosticInfo;
    }

    public void setInnerStatusCode(StatusCode statusCode) {
        this.rJ = statusCode;
    }

    public void setLocale(Integer n2) {
        this.rI = n2;
    }

    public void setLocaleStr(String string) {
        this.rI = this.addOrGetIndex(string);
    }

    public void setLocalizedText(Integer n2) {
        this.rH = n2;
    }

    public void setLocalizedTextStr(String string) {
        this.rH = this.addOrGetIndex(string);
    }

    public void setNamespaceUri(Integer n2) {
        this.rG = n2;
    }

    public void setNamespaceUriStr(String string) {
        this.rG = this.addOrGetIndex(string);
    }

    public void setStringArray(String[] stringArray) {
        this.rL = null;
        this.rM = stringArray;
    }

    public void setStringTable(List<String> list) {
        this.rL = list;
        this.rM = null;
    }

    public void setSymbolicId(Integer n2) {
        this.rF = n2;
    }

    public void setSymbolicIdStr(String string) {
        this.rF = this.addOrGetIndex(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticInfo.toString(this, stringBuilder, false, false, false);
        return stringBuilder.toString();
    }

    private int addOrGetIndex(String string) {
        int n2 = this.rL.indexOf(string);
        if (n2 >= 0) {
            return n2;
        }
        this.rL.add(string);
        return this.rL.size() - 1;
    }
}

