/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LocalizedText {
    public static final Pattern LOCALE_PATTERN = Pattern.compile("^(([a-z]{2})(-([A-Z]{2,3}){1})?)?$");
    public static final Locale NO_LOCALE;
    @Deprecated
    public static final Locale NULL_LOCALE;
    public static final LocalizedText[] EMPTY_ARRAY;
    @Deprecated
    public static final NodeId ID;
    public static final LocalizedText EMPTY;
    @Deprecated
    public static final LocalizedText NULL;
    public static final LocalizedText EMPTY_EN;
    private final a delegate;
    private final int hash;

    public static Builder builder() {
        return new Builder();
    }

    public static LocalizedText english(String string) {
        return new LocalizedText(string, "en");
    }

    public static LocalizedText from(String string) {
        return LocalizedText.from(string, NO_LOCALE);
    }

    public static LocalizedText from(String string, Locale locale) {
        return LocalizedText.from(string, locale == null ? null : LocalizedText.toLocaleId(locale));
    }

    public static LocalizedText from(String string, String string2) {
        if (StringUtils.isNullOrEmpty(string) && StringUtils.isNullOrEmpty(string2)) {
            return EMPTY;
        }
        return new LocalizedText(string, string2);
    }

    public static LocalizedText merge(LocalizedText localizedText, LocalizedText localizedText2) {
        boolean bl = true;
        if (localizedText == null) {
            localizedText = EMPTY;
        }
        if (EMPTY == localizedText) {
            return localizedText2;
        }
        Builder builder = localizedText.toBuilder();
        if (bl) {
            builder.cti();
        }
        builder.setTexts(localizedText2);
        if (bl) {
            builder.cti();
        }
        return builder.build();
    }

    public static Locale toLocale(String string) {
        if (string == null) {
            return Locale.ROOT;
        }
        Matcher matcher = LOCALE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return NO_LOCALE;
        }
        String string2 = matcher.group(2);
        String string3 = matcher.group(4);
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        return new Locale(string2, string3);
    }

    public static String toLocaleId(Locale locale) {
        if (locale == null) {
            return "";
        }
        return locale.getLanguage() + (!locale.getCountry().equals("") ? "-" + locale.getCountry() : "");
    }

    public LocalizedText(String string) {
        this(string, NO_LOCALE);
    }

    public LocalizedText(String string, Locale locale) {
        this(string, locale == null ? null : LocalizedText.toLocaleId(locale));
    }

    public LocalizedText(String string, String string2) {
        this(new c(string2, string));
    }

    private LocalizedText(a a2) {
        if (a2 == null) {
            throw new IllegalStateException("Internal delegate was null");
        }
        this.delegate = a2;
        this.hash = a2.hashCode();
    }

    public LocalizedText asSingleLocale(List<Locale> list) {
        if (this.delegate instanceof c) {
            return this;
        }
        return new LocalizedText(this.delegate.h(list));
    }

    public LocalizedText asSingleLocale(Locale locale) {
        if (locale == null) {
            return this.asSingleLocale(Collections.emptyList());
        }
        return this.asSingleLocale(Arrays.asList(locale));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocalizedText)) {
            return false;
        }
        LocalizedText localizedText = (LocalizedText)object;
        if (this.hash != localizedText.hash) {
            return false;
        }
        return Objects.equals(this.delegate, localizedText.delegate);
    }

    public Locale getLocale() {
        return LocalizedText.toLocale(this.getLocaleId());
    }

    public String getLocaleId() {
        return this.delegate.getLocaleId();
    }

    public String getText() {
        return this.delegate.getText();
    }

    public String getText(List<Locale> list) {
        return this.asSingleLocale(list).getText();
    }

    public String getText(Locale locale) {
        return this.getText(Arrays.asList(locale));
    }

    public Map<String, String> getTexts() {
        return Collections.unmodifiableMap(this.delegate.getData());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean hasText(Locale locale) {
        String string = LocalizedText.toLocaleId(locale);
        return this.hasText(string);
    }

    public boolean hasText(String string) {
        return this.delegate.hasText(string);
    }

    public Builder toBuilder() {
        Builder builder = LocalizedText.builder();
        this.getTexts().forEach((string, string2) -> builder.setText((String)string2, (String)string));
        return builder;
    }

    public String toString() {
        return this.delegate.toString();
    }

    static {
        NULL_LOCALE = NO_LOCALE = Locale.ROOT;
        EMPTY_ARRAY = new LocalizedText[0];
        ID = Identifiers.LocalizedText;
        NULL = EMPTY = new LocalizedText("", NULL_LOCALE);
        EMPTY_EN = LocalizedText.english("");
    }

    private static class c
    extends a {
        private final String rO;
        private final String text;

        private c(String string, String string2) {
            this.rO = string == null ? "" : string;
            this.text = string2 == null ? "" : string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            c c2 = (c)object;
            return Objects.equals(this.rO, c2.rO) && Objects.equals(this.text, c2.text);
        }

        @Override
        public Map<String, String> getData() {
            return Collections.singletonMap(this.rO, this.text);
        }

        @Override
        public String getLocaleId() {
            return this.rO;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public int hashCode() {
            return Objects.hash(this.rO, this.text);
        }

        @Override
        public boolean hasText(String string) {
            if (StringUtils.isNullOrEmpty(string)) {
                return StringUtils.isNullOrEmpty(string);
            }
            return string.equals(this.rO);
        }

        @Override
        public c h(List<Locale> list) {
            return this;
        }

        public String toString() {
            String string = this.getLocaleId();
            if (string == null || string.isEmpty()) {
                return this.text == null ? "" : this.text;
            }
            return "(" + this.getLocaleId() + ") " + this.getText();
        }
    }

    private static class b
    extends a {
        private final LinkedHashMap<String, String> data;

        private b(LinkedHashMap<String, String> linkedHashMap) {
            this.data = linkedHashMap;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof b)) {
                return false;
            }
            b b2 = (b)object;
            return Objects.equals(this.data, b2.data);
        }

        @Override
        public Map<String, String> getData() {
            return this.data;
        }

        @Override
        public String getLocaleId() {
            if (this.data.containsKey("")) {
                return "";
            }
            return this.data.entrySet().stream().findFirst().map(entry -> (String)entry.getKey()).orElse(null);
        }

        @Override
        public String getText() {
            if (this.data.containsKey("")) {
                return this.data.get("");
            }
            return this.data.entrySet().stream().findFirst().map(entry -> (String)entry.getValue()).orElse(null);
        }

        public int hashCode() {
            return Objects.hash(this.data);
        }

        @Override
        public boolean hasText(String string) {
            if (StringUtils.isNullOrEmpty(string)) {
                return this.data.containsKey(null) || this.data.containsKey("");
            }
            return this.data.containsKey(string);
        }

        @Override
        public c h(List<Locale> list) {
            String string;
            if (list == null) {
                list = Collections.emptyList();
            }
            for (Locale locale : list) {
                string = locale == null ? "" : LocalizedText.toLocaleId(locale);
                if (!this.data.containsKey(string)) continue;
                return new c(string, this.data.get(string));
            }
            for (Locale locale : list) {
                string = locale == null ? "" : locale.getLanguage();
                for (Map.Entry<String, String> entry : this.data.entrySet()) {
                    String string2 = entry.getKey() == null ? "" : LocalizedText.toLocale(entry.getKey()).getLanguage();
                    if (!Objects.equals(string, string2)) continue;
                    return new c(entry.getKey() == null ? "" : entry.getKey(), entry.getValue());
                }
            }
            return new c(this.getLocaleId(), this.getText());
        }

        public String toString() {
            return "[texts=" + this.data + "]";
        }
    }

    private static abstract class a {
        private a() {
        }

        public abstract Map<String, String> getData();

        public abstract String getLocaleId();

        public abstract String getText();

        public abstract boolean hasText(String var1);

        public abstract c h(List<Locale> var1);
    }

    public static final class Builder {
        private final LinkedHashMap<String, String> data = new LinkedHashMap();

        public LocalizedText build() {
            this.data.forEach((string, string2) -> {
                if (string == null || string2 == null) {
                    throw new IllegalStateException("LocalizedText.Builder doesn't support null values nor null keys, use empty String instead, data was: " + this.data);
                }
            });
            if (this.data.isEmpty()) {
                return EMPTY;
            }
            if (this.data.size() == 1) {
                Map.Entry<String, String> entry = this.data.entrySet().iterator().next();
                LocalizedText localizedText = new LocalizedText(entry.getValue(), entry.getKey());
                if (EMPTY.equals(localizedText)) {
                    return EMPTY;
                }
                return localizedText;
            }
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.data);
            return new LocalizedText(new b(linkedHashMap));
        }

        public Map<String, String> getTexts() {
            return this.data;
        }

        public Builder removeAll() {
            this.data.clear();
            return this;
        }

        public Builder removeText(Locale locale) {
            if (locale == null) {
                locale = Locale.ROOT;
            }
            this.data.remove(LocalizedText.toLocaleId(locale));
            return this;
        }

        public Builder removeText(String string) {
            if (string == null) {
                string = "";
            }
            this.data.remove(string);
            return this;
        }

        public Builder setDefaultText(String string) {
            this.implSet(string, "");
            return this;
        }

        public Builder setText(String string, Locale locale) {
            this.implSet(string, LocalizedText.toLocaleId(locale));
            return this;
        }

        public Builder setText(String string, String string2) {
            this.implSet(string, string2);
            return this;
        }

        public Builder setTexts(LocalizedText localizedText) {
            if (localizedText == null) {
                localizedText = EMPTY;
            }
            this.data.putAll(localizedText.getTexts());
            return this;
        }

        private void implSet(String string, String string2) {
            if (string2 == null) {
                string2 = "";
            }
            if (string == null) {
                string = "";
            }
            this.data.put(string2, string);
        }

        Builder cti() {
            if ("".equals(this.data.get(""))) {
                this.data.clear();
                return this;
            }
            Iterator<Map.Entry<String, String>> iterator = this.data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (!"".equals(entry.getValue())) continue;
                iterator.remove();
            }
            return this;
        }
    }
}

