/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18595")
public enum ActionState implements Enumeration
{
    Idle(0),
    Executing(1),
    Done(2);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<ActionState> NONE;
    public static final EnumSet<ActionState> ALL;
    private static final Map<Integer, ActionState> map;
    private final int value;

    private ActionState(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static ActionState valueOf(int n2) {
        return map.get(n2);
    }

    public static ActionState valueOf(Integer n2) {
        return n2 == null ? null : ActionState.valueOf((int)n2);
    }

    public static ActionState valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : ActionState.valueOf(unsignedInteger.intValue());
    }

    public static ActionState[] valueOf(int[] nArray) {
        ActionState[] actionStateArray = new ActionState[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            actionStateArray[i2] = ActionState.valueOf(nArray[i2]);
        }
        return actionStateArray;
    }

    public static ActionState[] valueOf(Integer[] integerArray) {
        ActionState[] actionStateArray = new ActionState[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            actionStateArray[i2] = ActionState.valueOf(integerArray[i2]);
        }
        return actionStateArray;
    }

    public static ActionState[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        ActionState[] actionStateArray = new ActionState[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            actionStateArray[i2] = ActionState.valueOf(unsignedIntegerArray[i2]);
        }
        return actionStateArray;
    }

    public static UnsignedInteger getMask(ActionState ... actionStateArray) {
        int n2 = 0;
        for (ActionState actionState : actionStateArray) {
            n2 |= actionState.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<ActionState> collection) {
        int n2 = 0;
        for (ActionState actionState : collection) {
            n2 |= actionState.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<ActionState> getSet(UnsignedInteger unsignedInteger) {
        return ActionState.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<ActionState> getSet(int n2) {
        ArrayList<ActionState> arrayList = new ArrayList<ActionState>();
        for (ActionState actionState : ActionState.values()) {
            if ((n2 & actionState.value) != actionState.value) continue;
            arrayList.add(actionState);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ActionState.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(ActionState.class);
        ALL = EnumSet.allOf(ActionState.class);
        map = new HashMap<Integer, ActionState>();
        for (ActionState actionState : ActionState.values()) {
            map.put(actionState.value, actionState);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("ActionState");
        builder.setJavaClass(ActionState.class);
        builder.setTypeId(UaIds.ActionState);
        builder.addMapping(0, "Idle");
        builder.addMapping(1, "Executing");
        builder.addMapping(2, "Done");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return ActionState.builder();
            }
        });
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ActionState.class, SPECIFICATION);
    }

    public static class Builder
    implements Enumeration.Builder {
        private ActionState value;

        private Builder() {
        }

        @Override
        public ActionState build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = ActionState.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum ActionState int value: " + n2);
            }
            return this;
        }
    }
}

