/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=662")
public class HistoryReadRequest
extends DynamicStructure
implements ServiceRequest<HistoryReadResponse> {
    public static final StructureSpecification SPECIFICATION;

    public HistoryReadRequest() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected HistoryReadRequest(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public HistoryReadRequest(RequestHeader requestHeader, Structure structure, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId[] historyReadValueIdArray) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setRequestHeader(requestHeader);
        this.setHistoryReadDetails(structure);
        this.setTimestampsToReturn(timestampsToReturn);
        this.setReleaseContinuationPoints(bl);
        this.setNodesToRead(historyReadValueIdArray);
    }

    @Override
    public RequestHeader getRequestHeader() {
        return (RequestHeader)this.indexGet(0);
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.indexSet(requestHeader, 0);
    }

    public Structure getHistoryReadDetails() {
        return (Structure)this.indexGet(1);
    }

    public void setHistoryReadDetails(Structure structure) {
        this.indexSet(structure, 1);
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return (TimestampsToReturn)this.indexGet(2);
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.indexSet(timestampsToReturn, 2);
    }

    public Boolean getReleaseContinuationPoints() {
        return (Boolean)this.indexGet(3);
    }

    public void setReleaseContinuationPoints(Boolean bl) {
        this.indexSet(bl, 3);
    }

    public HistoryReadValueId[] getNodesToRead() {
        return (HistoryReadValueId[])this.indexGet(4);
    }

    public void setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
        this.indexSet(historyReadValueIdArray, 4);
    }

    @Override
    public HistoryReadRequest clone() {
        return (HistoryReadRequest)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new HistoryReadRequest());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.HistoryReadDetails);
        builder.addField(Fields.TimestampsToReturn);
        builder.addField(Fields.ReleaseContinuationPoints);
        builder.addField(Fields.NodesToRead);
        builder.setBinaryEncodeId(UaIds.HistoryReadRequest_DefaultBinary);
        builder.setXmlEncodeId(UaIds.HistoryReadRequest_DefaultXml);
        builder.setJsonEncodeId(UaIds.HistoryReadRequest_DefaultJson);
        builder.setTypeId(UaIds.HistoryReadRequest);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("HistoryReadRequest");
        builder.setJavaClass(HistoryReadRequest.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new HistoryReadRequest((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(HistoryReadRequest.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public RequestHeader getRequestHeader() {
            return (RequestHeader)this.indexGet(0);
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.indexSet(requestHeader, 0);
            return this;
        }

        public Structure getHistoryReadDetails() {
            return (Structure)this.indexGet(1);
        }

        public Builder setHistoryReadDetails(Structure structure) {
            this.indexSet(structure, 1);
            return this;
        }

        public TimestampsToReturn getTimestampsToReturn() {
            return (TimestampsToReturn)this.indexGet(2);
        }

        public Builder setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.indexSet(timestampsToReturn, 2);
            return this;
        }

        public Boolean getReleaseContinuationPoints() {
            return (Boolean)this.indexGet(3);
        }

        public Builder setReleaseContinuationPoints(Boolean bl) {
            this.indexSet(bl, 3);
            return this;
        }

        public HistoryReadValueId[] getNodesToRead() {
            return (HistoryReadValueId[])this.indexGet(4);
        }

        public Builder setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
            this.indexSet(historyReadValueIdArray, 4);
            return this;
        }

        @Override
        public HistoryReadRequest build() {
            return (HistoryReadRequest)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader(0, "RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false, 0),
        HistoryReadDetails(1, "HistoryReadDetails", Structure.class, false, UaIds.Structure, -1, null, false, 0),
        TimestampsToReturn(2, "TimestampsToReturn", TimestampsToReturn.class, false, UaIds.TimestampsToReturn, -1, null, false, 0),
        ReleaseContinuationPoints(3, "ReleaseContinuationPoints", Boolean.class, false, UaIds.Boolean, -1, null, false, 0),
        NodesToRead(4, "NodesToRead", HistoryReadValueId[].class, false, UaIds.HistoryReadValueId, 1, UaArrayDimensions.valueOf(0L), false, 1);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

