/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=444")
public class OpenSecureChannelRequest
extends DynamicStructure
implements ServiceRequest<OpenSecureChannelResponse> {
    public static final StructureSpecification SPECIFICATION;

    public OpenSecureChannelRequest() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected OpenSecureChannelRequest(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public OpenSecureChannelRequest(RequestHeader requestHeader, UnsignedInteger unsignedInteger, SecurityTokenRequestType securityTokenRequestType, MessageSecurityMode messageSecurityMode, ByteString byteString, UnsignedInteger unsignedInteger2) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setRequestHeader(requestHeader);
        this.setClientProtocolVersion(unsignedInteger);
        this.setRequestType(securityTokenRequestType);
        this.setSecurityMode(messageSecurityMode);
        this.setClientNonce(byteString);
        this.setRequestedLifetime(unsignedInteger2);
    }

    @Override
    public RequestHeader getRequestHeader() {
        return (RequestHeader)this.indexGet(0);
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.indexSet(requestHeader, 0);
    }

    public UnsignedInteger getClientProtocolVersion() {
        return (UnsignedInteger)this.indexGet(1);
    }

    public void setClientProtocolVersion(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 1);
    }

    public SecurityTokenRequestType getRequestType() {
        return (SecurityTokenRequestType)this.indexGet(2);
    }

    public void setRequestType(SecurityTokenRequestType securityTokenRequestType) {
        this.indexSet(securityTokenRequestType, 2);
    }

    public MessageSecurityMode getSecurityMode() {
        return (MessageSecurityMode)this.indexGet(3);
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.indexSet(messageSecurityMode, 3);
    }

    public ByteString getClientNonce() {
        return (ByteString)this.indexGet(4);
    }

    public void setClientNonce(ByteString byteString) {
        this.indexSet(byteString, 4);
    }

    public UnsignedInteger getRequestedLifetime() {
        return (UnsignedInteger)this.indexGet(5);
    }

    public void setRequestedLifetime(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 5);
    }

    @Override
    public OpenSecureChannelRequest clone() {
        return (OpenSecureChannelRequest)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new OpenSecureChannelRequest());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.ClientProtocolVersion);
        builder.addField(Fields.RequestType);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.ClientNonce);
        builder.addField(Fields.RequestedLifetime);
        builder.setBinaryEncodeId(UaIds.OpenSecureChannelRequest_DefaultBinary);
        builder.setXmlEncodeId(UaIds.OpenSecureChannelRequest_DefaultXml);
        builder.setJsonEncodeId(UaIds.OpenSecureChannelRequest_DefaultJson);
        builder.setTypeId(UaIds.OpenSecureChannelRequest);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("OpenSecureChannelRequest");
        builder.setJavaClass(OpenSecureChannelRequest.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new OpenSecureChannelRequest((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(OpenSecureChannelRequest.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public RequestHeader getRequestHeader() {
            return (RequestHeader)this.indexGet(0);
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.indexSet(requestHeader, 0);
            return this;
        }

        public UnsignedInteger getClientProtocolVersion() {
            return (UnsignedInteger)this.indexGet(1);
        }

        public Builder setClientProtocolVersion(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 1);
            return this;
        }

        public SecurityTokenRequestType getRequestType() {
            return (SecurityTokenRequestType)this.indexGet(2);
        }

        public Builder setRequestType(SecurityTokenRequestType securityTokenRequestType) {
            this.indexSet(securityTokenRequestType, 2);
            return this;
        }

        public MessageSecurityMode getSecurityMode() {
            return (MessageSecurityMode)this.indexGet(3);
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.indexSet(messageSecurityMode, 3);
            return this;
        }

        public ByteString getClientNonce() {
            return (ByteString)this.indexGet(4);
        }

        public Builder setClientNonce(ByteString byteString) {
            this.indexSet(byteString, 4);
            return this;
        }

        public UnsignedInteger getRequestedLifetime() {
            return (UnsignedInteger)this.indexGet(5);
        }

        public Builder setRequestedLifetime(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 5);
            return this;
        }

        @Override
        public OpenSecureChannelRequest build() {
            return (OpenSecureChannelRequest)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader(0, "RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false, 0),
        ClientProtocolVersion(1, "ClientProtocolVersion", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        RequestType(2, "RequestType", SecurityTokenRequestType.class, false, UaIds.SecurityTokenRequestType, -1, null, false, 0),
        SecurityMode(3, "SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false, 0),
        ClientNonce(4, "ClientNonce", ByteString.class, false, UaIds.ByteString, -1, null, false, 0),
        RequestedLifetime(5, "RequestedLifetime", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

