/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=392")
public class ResponseHeader
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public ResponseHeader() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected ResponseHeader(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public ResponseHeader(DateTime dateTime, UnsignedInteger unsignedInteger, StatusCode statusCode, DiagnosticInfo diagnosticInfo, String[] stringArray, Structure structure) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setTimestamp(dateTime);
        this.setRequestHandle(unsignedInteger);
        this.setServiceResult(statusCode);
        this.setServiceDiagnostics(diagnosticInfo);
        this.setStringTable(stringArray);
        this.setAdditionalHeader(structure);
    }

    public DateTime getTimestamp() {
        return (DateTime)this.indexGet(0);
    }

    public void setTimestamp(DateTime dateTime) {
        this.indexSet(dateTime, 0);
    }

    public UnsignedInteger getRequestHandle() {
        return (UnsignedInteger)this.indexGet(1);
    }

    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 1);
    }

    public StatusCode getServiceResult() {
        return (StatusCode)this.indexGet(2);
    }

    public void setServiceResult(StatusCode statusCode) {
        this.indexSet(statusCode, 2);
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return (DiagnosticInfo)this.indexGet(3);
    }

    public void setServiceDiagnostics(DiagnosticInfo diagnosticInfo) {
        this.indexSet(diagnosticInfo, 3);
    }

    public String[] getStringTable() {
        return (String[])this.indexGet(4);
    }

    public void setStringTable(String[] stringArray) {
        this.indexSet(stringArray, 4);
    }

    public Structure getAdditionalHeader() {
        return (Structure)this.indexGet(5);
    }

    public void setAdditionalHeader(Structure structure) {
        this.indexSet(structure, 5);
    }

    @Override
    public ResponseHeader clone() {
        return (ResponseHeader)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new ResponseHeader());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Timestamp);
        builder.addField(Fields.RequestHandle);
        builder.addField(Fields.ServiceResult);
        builder.addField(Fields.ServiceDiagnostics);
        builder.addField(Fields.StringTable);
        builder.addField(Fields.AdditionalHeader);
        builder.setBinaryEncodeId(UaIds.ResponseHeader_DefaultBinary);
        builder.setXmlEncodeId(UaIds.ResponseHeader_DefaultXml);
        builder.setJsonEncodeId(UaIds.ResponseHeader_DefaultJson);
        builder.setTypeId(UaIds.ResponseHeader);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ResponseHeader");
        builder.setJavaClass(ResponseHeader.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new ResponseHeader((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ResponseHeader.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public DateTime getTimestamp() {
            return (DateTime)this.indexGet(0);
        }

        public Builder setTimestamp(DateTime dateTime) {
            this.indexSet(dateTime, 0);
            return this;
        }

        public UnsignedInteger getRequestHandle() {
            return (UnsignedInteger)this.indexGet(1);
        }

        public Builder setRequestHandle(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 1);
            return this;
        }

        public StatusCode getServiceResult() {
            return (StatusCode)this.indexGet(2);
        }

        public Builder setServiceResult(StatusCode statusCode) {
            this.indexSet(statusCode, 2);
            return this;
        }

        public DiagnosticInfo getServiceDiagnostics() {
            return (DiagnosticInfo)this.indexGet(3);
        }

        public Builder setServiceDiagnostics(DiagnosticInfo diagnosticInfo) {
            this.indexSet(diagnosticInfo, 3);
            return this;
        }

        public String[] getStringTable() {
            return (String[])this.indexGet(4);
        }

        public Builder setStringTable(String[] stringArray) {
            this.indexSet(stringArray, 4);
            return this;
        }

        public Structure getAdditionalHeader() {
            return (Structure)this.indexGet(5);
        }

        public Builder setAdditionalHeader(Structure structure) {
            this.indexSet(structure, 5);
            return this;
        }

        @Override
        public ResponseHeader build() {
            return (ResponseHeader)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Timestamp(0, "Timestamp", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        RequestHandle(1, "RequestHandle", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false, 0),
        ServiceResult(2, "ServiceResult", StatusCode.class, false, UaIds.StatusCode, -1, null, false, 0),
        ServiceDiagnostics(3, "ServiceDiagnostics", DiagnosticInfo.class, false, UaIds.DiagnosticInfo, -1, null, false, 0),
        StringTable(4, "StringTable", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false, 1),
        AdditionalHeader(5, "AdditionalHeader", Structure.class, false, UaIds.Structure, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

