/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.Description;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StatusCodes {
    private static Map<UnsignedInteger, String> ERROR_NAMES = new HashMap<UnsignedInteger, String>();
    private static Map<UnsignedInteger, String> ERROR_DESCRIPTIONS = new HashMap<UnsignedInteger, String>();
    private static Map<String, UnsignedInteger> ERROR_NAMES_REV = new HashMap<String, UnsignedInteger>();
    private static final int MASK = -805371904;
    @Description(value="The operation failed.")
    public static final UnsignedInteger Bad = UnsignedInteger.valueOf(0x80000000L);
    @Description(value="The aggregate configuration is not valid for specified node.")
    public static final UnsignedInteger Bad_AggregateConfigurationRejected = UnsignedInteger.valueOf(2161770496L);
    @Description(value="The aggregate value could not be derived due to invalid data inputs.")
    public static final UnsignedInteger Bad_AggregateInvalidInputs = UnsignedInteger.valueOf(2161508352L);
    @Description(value="The requested number of Aggregates does not match the requested number of NodeIds.")
    public static final UnsignedInteger Bad_AggregateListMismatch = UnsignedInteger.valueOf(2161377280L);
    @Description(value="The requested Aggregate is not support by the server.")
    public static final UnsignedInteger Bad_AggregateNotSupported = UnsignedInteger.valueOf(2161442816L);
    @Description(value="An equivalent rule already exists.")
    public static final UnsignedInteger Bad_AlreadyExists = UnsignedInteger.valueOf(2165637120L);
    @Description(value="The signature generated with the client certificate is missing or invalid.")
    public static final UnsignedInteger Bad_ApplicationSignatureInvalid = UnsignedInteger.valueOf(0x80580000L);
    @Description(value="The client did not specify all of the input arguments for the method.")
    public static final UnsignedInteger Bad_ArgumentsMissing = UnsignedInteger.valueOf(2155216896L);
    @Description(value="The attribute is not supported for the specified Node.")
    public static final UnsignedInteger Bad_AttributeIdInvalid = UnsignedInteger.valueOf(2150957056L);
    @Description(value="No data found to provide upper or lower bound value.")
    public static final UnsignedInteger Bad_BoundNotFound = UnsignedInteger.valueOf(2161573888L);
    @Description(value="The server cannot retrieve a bound for the variable.")
    public static final UnsignedInteger Bad_BoundNotSupported = UnsignedInteger.valueOf(0x80D80000L);
    @Description(value="The browse direction is not valid.")
    public static final UnsignedInteger Bad_BrowseDirectionInvalid = UnsignedInteger.valueOf(2152529920L);
    @Description(value="The browse name is not unique among nodes that share the same relationship with the parent.")
    public static final UnsignedInteger Bad_BrowseNameDuplicated = UnsignedInteger.valueOf(2153840640L);
    @Description(value="The browse name is invalid.")
    public static final UnsignedInteger Bad_BrowseNameInvalid = UnsignedInteger.valueOf(0x80600000L);
    @Description(value="The certificate chain is incomplete.")
    public static final UnsignedInteger Bad_CertificateChainIncomplete = UnsignedInteger.valueOf(2165112832L);
    @Description(value="The HostName used to connect to a server does not match a HostName in the certificate.")
    public static final UnsignedInteger Bad_CertificateHostNameInvalid = UnsignedInteger.valueOf(2148925440L);
    @Description(value="The certificate provided as a parameter is not valid.")
    public static final UnsignedInteger Bad_CertificateInvalid = UnsignedInteger.valueOf(2148663296L);
    @Description(value="It was not possible to determine if the issuer certificate has been revoked.")
    public static final UnsignedInteger Bad_CertificateIssuerRevocationUnknown = UnsignedInteger.valueOf(2149318656L);
    @Description(value="The issuer certificate has been revoked.")
    public static final UnsignedInteger Bad_CertificateIssuerRevoked = UnsignedInteger.valueOf(2149449728L);
    @Description(value="An issuer certificate has expired or is not yet valid.")
    public static final UnsignedInteger Bad_CertificateIssuerTimeInvalid = UnsignedInteger.valueOf(2148859904L);
    @Description(value="The issuer certificate may not be used for the requested operation.")
    public static final UnsignedInteger Bad_CertificateIssuerUseNotAllowed = UnsignedInteger.valueOf(2149122048L);
    @Description(value="The certificate does not meet the requirements of the security policy.")
    public static final UnsignedInteger Bad_CertificatePolicyCheckFailed = UnsignedInteger.valueOf(2165571584L);
    @Description(value="It was not possible to determine if the certificate has been revoked.")
    public static final UnsignedInteger Bad_CertificateRevocationUnknown = UnsignedInteger.valueOf(2149253120L);
    @Description(value="The certificate has been revoked.")
    public static final UnsignedInteger Bad_CertificateRevoked = UnsignedInteger.valueOf(2149384192L);
    @Description(value="The certificate has expired or is not yet valid.")
    public static final UnsignedInteger Bad_CertificateTimeInvalid = UnsignedInteger.valueOf(2148794368L);
    @Description(value="The certificate is not trusted.")
    public static final UnsignedInteger Bad_CertificateUntrusted = UnsignedInteger.valueOf(2149187584L);
    @Description(value="The URI specified in the ApplicationDescription does not match the URI in the certificate.")
    public static final UnsignedInteger Bad_CertificateUriInvalid = UnsignedInteger.valueOf(2148990976L);
    @Description(value="The certificate may not be used for the requested operation.")
    public static final UnsignedInteger Bad_CertificateUseNotAllowed = UnsignedInteger.valueOf(0x80180000L);
    @Description(value="A low level communication error occurred.")
    public static final UnsignedInteger Bad_CommunicationError = UnsignedInteger.valueOf(0x80050000L);
    @Description(value="This condition has already been disabled.")
    public static final UnsignedInteger Bad_ConditionAlreadyDisabled = UnsignedInteger.valueOf(0x80980000L);
    @Description(value="This condition has already been enabled.")
    public static final UnsignedInteger Bad_ConditionAlreadyEnabled = UnsignedInteger.valueOf(0x80CC0000L);
    @Description(value="The condition has already been shelved.")
    public static final UnsignedInteger Bad_ConditionAlreadyShelved = UnsignedInteger.valueOf(2161180672L);
    @Description(value="The condition branch has already been acknowledged.")
    public static final UnsignedInteger Bad_ConditionBranchAlreadyAcked = UnsignedInteger.valueOf(2161049600L);
    @Description(value="The condition branch has already been confirmed.")
    public static final UnsignedInteger Bad_ConditionBranchAlreadyConfirmed = UnsignedInteger.valueOf(0x80D00000L);
    @Description(value="Property not available, this condition is disabled.")
    public static final UnsignedInteger Bad_ConditionDisabled = UnsignedInteger.valueOf(0x80990000L);
    @Description(value="The condition is not currently shelved.")
    public static final UnsignedInteger Bad_ConditionNotShelved = UnsignedInteger.valueOf(2161246208L);
    @Description(value="There is a problem with the configuration that affects the usefulness of the value.")
    public static final UnsignedInteger Bad_ConfigurationError = UnsignedInteger.valueOf(0x80890000L);
    @Description(value="The network connection has been closed.")
    public static final UnsignedInteger Bad_ConnectionClosed = UnsignedInteger.valueOf(2158886912L);
    @Description(value="Could not establish a network connection to remote server.")
    public static final UnsignedInteger Bad_ConnectionRejected = UnsignedInteger.valueOf(2158755840L);
    @Description(value="The content filter is not valid.")
    public static final UnsignedInteger Bad_ContentFilterInvalid = UnsignedInteger.valueOf(0x80480000L);
    @Description(value="The continuation point provide is longer valid.")
    public static final UnsignedInteger Bad_ContinuationPointInvalid = UnsignedInteger.valueOf(2152333312L);
    @Description(value="The data encoding is invalid.")
    public static final UnsignedInteger Bad_DataEncodingInvalid = UnsignedInteger.valueOf(0x80380000L);
    @Description(value="The server does not support the requested data encoding for the node.")
    public static final UnsignedInteger Bad_DataEncodingUnsupported = UnsignedInteger.valueOf(2151219200L);
    @Description(value="Data is missing due to collection started/stopped/lost.")
    public static final UnsignedInteger Bad_DataLost = UnsignedInteger.valueOf(2157772800L);
    @Description(value="The DataSet specified for the DataSetWriter creation is invalid.")
    public static final UnsignedInteger Bad_DataSetIdInvalid = UnsignedInteger.valueOf(2162622464L);
    @Description(value="The extension object cannot be (de)serialized because the data type id is not recognized.")
    public static final UnsignedInteger Bad_DataTypeIdUnknown = UnsignedInteger.valueOf(0x80110000L);
    @Description(value="Expected data is unavailable for the requested time range due to an un-mounted volume, an off-line archive or tape, or similar reason for temporary unavailability.")
    public static final UnsignedInteger Bad_DataUnavailable = UnsignedInteger.valueOf(2157838336L);
    @Description(value="The deadband filter is not valid.")
    public static final UnsignedInteger Bad_DeadbandFilterInvalid = UnsignedInteger.valueOf(0x808E0000L);
    @Description(value="Decoding halted because of invalid data in the stream.")
    public static final UnsignedInteger Bad_DecodingError = UnsignedInteger.valueOf(0x80070000L);
    @Description(value="A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is Bad.")
    public static final UnsignedInteger Bad_DependentValueChanged = UnsignedInteger.valueOf(2162360320L);
    @Description(value="There has been a failure in the device/data source that generates the value that has affected the value.")
    public static final UnsignedInteger Bad_DeviceFailure = UnsignedInteger.valueOf(0x808B0000L);
    @Description(value="The dialog condition is not active.")
    public static final UnsignedInteger Bad_DialogNotActive = UnsignedInteger.valueOf(2160918528L);
    @Description(value="The response is not valid for the dialog.")
    public static final UnsignedInteger Bad_DialogResponseInvalid = UnsignedInteger.valueOf(2160984064L);
    @Description(value="The server has disconnected from the client.")
    public static final UnsignedInteger Bad_Disconnect = UnsignedInteger.valueOf(2158821376L);
    @Description(value="No DiscoveryUrl was specified.")
    public static final UnsignedInteger Bad_DiscoveryUrlMissing = UnsignedInteger.valueOf(2152792064L);
    @Description(value="The related EngineeringUnit has been changed but this change has not been applied to the device. The Variable Value is still dependent on the previous unit but its status is currently Bad.")
    public static final UnsignedInteger Bad_DominantValueChanged = UnsignedInteger.valueOf(2162229248L);
    @Description(value="The reference type between the nodes is already defined.")
    public static final UnsignedInteger Bad_DuplicateReferenceNotAllowed = UnsignedInteger.valueOf(0x80660000L);
    @Description(value="It is delivered with a Variable value when Variable has changed but the value is not legal.")
    public static final UnsignedInteger Bad_Edited_OutOfRange = UnsignedInteger.valueOf(2165899264L);
    @Description(value="It is delivered with a dependent Variable value when a dominant Variable has changed, the value is not legal and the change has not been applied.")
    public static final UnsignedInteger Bad_Edited_OutOfRange_DominantValueChanged = UnsignedInteger.valueOf(2166095872L);
    @Description(value="It is delivered with a dependent Variable value when a dominant or dependent Variable has changed, the value is not legal and the change has not been applied.")
    public static final UnsignedInteger Bad_Edited_OutOfRange_DominantValueChanged_DependentValueChanged = UnsignedInteger.valueOf(2166226944L);
    @Description(value="Encoding halted because of invalid data in the objects being serialized.")
    public static final UnsignedInteger Bad_EncodingError = UnsignedInteger.valueOf(0x80060000L);
    @Description(value="The message encoding/decoding limits imposed by the stack have been exceeded.")
    public static final UnsignedInteger Bad_EncodingLimitsExceeded = UnsignedInteger.valueOf(0x80080000L);
    @Description(value="Cannot move beyond end of the stream.")
    public static final UnsignedInteger Bad_EndOfStream = UnsignedInteger.valueOf(0x80B00000L);
    @Description(value="The data or event was not successfully inserted because a matching entry exists.")
    public static final UnsignedInteger Bad_EntryExists = UnsignedInteger.valueOf(2157903872L);
    @Description(value="The event filter is not valid.")
    public static final UnsignedInteger Bad_EventFilterInvalid = UnsignedInteger.valueOf(2152136704L);
    @Description(value="The specified event id is not recognized.")
    public static final UnsignedInteger Bad_EventIdUnknown = UnsignedInteger.valueOf(2157576192L);
    @Description(value="The event cannot be acknowledged.")
    public static final UnsignedInteger Bad_EventNotAcknowledgeable = UnsignedInteger.valueOf(0x80BB0000L);
    @Description(value="The stream did not return all data requested (possibly because it is a non-blocking stream).")
    public static final UnsignedInteger Bad_ExpectedStreamToBlock = UnsignedInteger.valueOf(2159280128L);
    @Description(value="The referenced element is not a valid element in the content filter.")
    public static final UnsignedInteger Bad_FilterElementInvalid = UnsignedInteger.valueOf(2160328704L);
    @Description(value="The referenced literal is not a valid value.")
    public static final UnsignedInteger Bad_FilterLiteralInvalid = UnsignedInteger.valueOf(2160394240L);
    @Description(value="A monitoring filter cannot be used in combination with the attribute specified.")
    public static final UnsignedInteger Bad_FilterNotAllowed = UnsignedInteger.valueOf(2152005632L);
    @Description(value="The number of operands provided for the filter operator was less then expected for the operand provided.")
    public static final UnsignedInteger Bad_FilterOperandCountMismatch = UnsignedInteger.valueOf(2160263168L);
    @Description(value="The operand used in a content filter is not valid.")
    public static final UnsignedInteger Bad_FilterOperandInvalid = UnsignedInteger.valueOf(2152267776L);
    @Description(value="An unrecognized operator was provided in a filter.")
    public static final UnsignedInteger Bad_FilterOperatorInvalid = UnsignedInteger.valueOf(2160132096L);
    @Description(value="A valid operator was provided, but the server does not provide support for this filter operator.")
    public static final UnsignedInteger Bad_FilterOperatorUnsupported = UnsignedInteger.valueOf(2160197632L);
    @Description(value="The history details parameter is not valid.")
    public static final UnsignedInteger Bad_HistoryOperationInvalid = UnsignedInteger.valueOf(2154889216L);
    @Description(value="The server does not support the requested operation.")
    public static final UnsignedInteger Bad_HistoryOperationUnsupported = UnsignedInteger.valueOf(2154954752L);
    @Description(value="The server does not support changing the user identity assigned to the session.")
    public static final UnsignedInteger Bad_IdentityChangeNotSupported = UnsignedInteger.valueOf(2160459776L);
    @Description(value="The user identity token is not valid.")
    public static final UnsignedInteger Bad_IdentityTokenInvalid = UnsignedInteger.valueOf(0x80200000L);
    @Description(value="The user identity token is valid but the server has rejected it.")
    public static final UnsignedInteger Bad_IdentityTokenRejected = UnsignedInteger.valueOf(2149646336L);
    @Description(value="The written data does not match the IndexRange specified.")
    public static final UnsignedInteger Bad_IndexRangeDataMismatch = UnsignedInteger.valueOf(2162819072L);
    @Description(value="The syntax of the index range parameter is invalid.")
    public static final UnsignedInteger Bad_IndexRangeInvalid = UnsignedInteger.valueOf(2151022592L);
    @Description(value="No data exists within the range of indexes specified.")
    public static final UnsignedInteger Bad_IndexRangeNoData = UnsignedInteger.valueOf(2151088128L);
    @Description(value="It is delivered with a Variable value when a source Variable has changed but the value is not legal.")
    public static final UnsignedInteger Bad_InitialValue_OutOfRange = UnsignedInteger.valueOf(2165964800L);
    @Description(value="The client of the current session does not support one or more Profiles that are necessary for the subscription.")
    public static final UnsignedInteger Bad_InsufficientClientProfile = UnsignedInteger.valueOf(2155610112L);
    @Description(value="An internal error occurred as a result of a programming or configuration error.")
    public static final UnsignedInteger Bad_InternalError = UnsignedInteger.valueOf(0x80020000L);
    @Description(value="One or more arguments are invalid.")
    public static final UnsignedInteger Bad_InvalidArgument = UnsignedInteger.valueOf(2158690304L);
    @Description(value="The server does not allow this type of self reference on this node.")
    public static final UnsignedInteger Bad_InvalidSelfReference = UnsignedInteger.valueOf(2154233856L);
    @Description(value="The operation cannot be completed because the object is closed, uninitialized or in some other invalid state.")
    public static final UnsignedInteger Bad_InvalidState = UnsignedInteger.valueOf(2158952448L);
    @Description(value="The timestamp is outside the range allowed by the server.")
    public static final UnsignedInteger Bad_InvalidTimestamp = UnsignedInteger.valueOf(2149777408L);
    @Description(value="The defined timestamp to return was invalid.")
    public static final UnsignedInteger Bad_InvalidTimestampArgument = UnsignedInteger.valueOf(2159869952L);
    @Description(value="The server requires a license to operate in general or to perform a service or operation, but existing license is expired.")
    public static final UnsignedInteger Bad_LicenseExpired = UnsignedInteger.valueOf(2165178368L);
    @Description(value="The server has limits on number of allowed operations / objects, based on installed licenses, and these limits where exceeded.")
    public static final UnsignedInteger Bad_LicenseLimitsExceeded = UnsignedInteger.valueOf(2165243904L);
    @Description(value="The server does not have a license which is required to operate in general or to perform a service or operation.")
    public static final UnsignedInteger Bad_LicenseNotAvailable = UnsignedInteger.valueOf(0x81100000L);
    @Description(value="The locale in the requested write operation is not supported.")
    public static final UnsignedInteger Bad_LocaleNotSupported = UnsignedInteger.valueOf(2163015680L);
    @Description(value="The requested operation is not allowed, because the Node is locked by a different application.")
    public static final UnsignedInteger Bad_Locked = UnsignedInteger.valueOf(2162753536L);
    @Description(value="The max age parameter is invalid.")
    public static final UnsignedInteger Bad_MaxAgeInvalid = UnsignedInteger.valueOf(0x80700000L);
    @Description(value="The operation could not be finished because all available connections are in use.")
    public static final UnsignedInteger Bad_MaxConnectionsReached = UnsignedInteger.valueOf(2159476736L);
    @Description(value="The requested notification message is no longer available.")
    public static final UnsignedInteger Bad_MessageNotAvailable = UnsignedInteger.valueOf(2155544576L);
    @Description(value="The method id does not refer to a method for the specified object.")
    public static final UnsignedInteger Bad_MethodInvalid = UnsignedInteger.valueOf(2155151360L);
    @Description(value="The monitored item filter parameter is not valid.")
    public static final UnsignedInteger Bad_MonitoredItemFilterInvalid = UnsignedInteger.valueOf(2151874560L);
    @Description(value="The server does not support the requested monitored item filter.")
    public static final UnsignedInteger Bad_MonitoredItemFilterUnsupported = UnsignedInteger.valueOf(0x80440000L);
    @Description(value="The monitoring item id does not refer to a valid monitored item.")
    public static final UnsignedInteger Bad_MonitoredItemIdInvalid = UnsignedInteger.valueOf(2151809024L);
    @Description(value="The monitoring mode is invalid.")
    public static final UnsignedInteger Bad_MonitoringModeInvalid = UnsignedInteger.valueOf(2151743488L);
    @Description(value="Communication with the data source is defined, but not established, and there is no last known value available.")
    public static final UnsignedInteger Bad_NoCommunication = UnsignedInteger.valueOf(2150694912L);
    @Description(value="The operation could not be processed because all continuation points have been allocated.")
    public static final UnsignedInteger Bad_NoContinuationPoints = UnsignedInteger.valueOf(2152398848L);
    @Description(value="No data exists for the requested time range or event filter.")
    public static final UnsignedInteger Bad_NoData = UnsignedInteger.valueOf(2157641728L);
    @Description(value="No data is currently available for reading from a non-blocking stream.")
    public static final UnsignedInteger Bad_NoDataAvailable = UnsignedInteger.valueOf(2159083520L);
    @Description(value="The server will not allow the node to be deleted.")
    public static final UnsignedInteger Bad_NoDeleteRights = UnsignedInteger.valueOf(2154364928L);
    @Description(value="The data or event was not successfully updated because no matching entry exists.")
    public static final UnsignedInteger Bad_NoEntryExists = UnsignedInteger.valueOf(0x80A00000L);
    @Description(value="The requested operation has no match to return.")
    public static final UnsignedInteger Bad_NoMatch = UnsignedInteger.valueOf(2154758144L);
    @Description(value="There is no subscription available for this session.")
    public static final UnsignedInteger Bad_NoSubscription = UnsignedInteger.valueOf(2155413504L);
    @Description(value="The client did not provide at least one software certificate that is valid and meets the profile requirements for the server.")
    public static final UnsignedInteger Bad_NoValidCertificates = UnsignedInteger.valueOf(2153316352L);
    @Description(value="The variable has no default value and no initial value.")
    public static final UnsignedInteger Bad_NoValue = UnsignedInteger.valueOf(0x80F00000L);
    @Description(value="The node attributes are not valid for the node class.")
    public static final UnsignedInteger Bad_NodeAttributesInvalid = UnsignedInteger.valueOf(2153906176L);
    @Description(value="The node class is not valid.")
    public static final UnsignedInteger Bad_NodeClassInvalid = UnsignedInteger.valueOf(2153709568L);
    @Description(value="The requested node id is already used by another node.")
    public static final UnsignedInteger Bad_NodeIdExists = UnsignedInteger.valueOf(2153644032L);
    @Description(value="The syntax the node id is not valid or refers to a node that is not valid for the operation.")
    public static final UnsignedInteger Bad_NodeIdInvalid = UnsignedInteger.valueOf(0x80330000L);
    @Description(value="The requested node id was reject because it was either invalid or server does not allow node ids to be specified by the client.")
    public static final UnsignedInteger Bad_NodeIdRejected = UnsignedInteger.valueOf(2153578496L);
    @Description(value="The node id refers to a node that does not exist in the server address space.")
    public static final UnsignedInteger Bad_NodeIdUnknown = UnsignedInteger.valueOf(2150891520L);
    @Description(value="The node is not part of the view.")
    public static final UnsignedInteger Bad_NodeNotInView = UnsignedInteger.valueOf(2152595456L);
    @Description(value="The nonce does appear to be not a random value or it is not the correct length.")
    public static final UnsignedInteger Bad_NonceInvalid = UnsignedInteger.valueOf(2149842944L);
    @Description(value="The variable should receive its value from another variable, but has never been configured to do so.")
    public static final UnsignedInteger Bad_NotConnected = UnsignedInteger.valueOf(0x808A0000L);
    @Description(value="The executable attribute does not allow the execution of the method.")
    public static final UnsignedInteger Bad_NotExecutable = UnsignedInteger.valueOf(0x81110000L);
    @Description(value="A requested item was not found or a search operation ended without success.")
    public static final UnsignedInteger Bad_NotFound = UnsignedInteger.valueOf(2151546880L);
    @Description(value="Requested operation is not implemented.")
    public static final UnsignedInteger Bad_NotImplemented = UnsignedInteger.valueOf(0x80400000L);
    @Description(value="The access level does not allow reading or subscribing to the Node.")
    public static final UnsignedInteger Bad_NotReadable = UnsignedInteger.valueOf(2151284736L);
    @Description(value="The requested operation is not supported.")
    public static final UnsignedInteger Bad_NotSupported = UnsignedInteger.valueOf(2151481344L);
    @Description(value="The provided Nodeid was not a type definition nodeid.")
    public static final UnsignedInteger Bad_NotTypeDefinition = UnsignedInteger.valueOf(0x80C80000L);
    @Description(value="The access level does not allow writing to the Node.")
    public static final UnsignedInteger Bad_NotWritable = UnsignedInteger.valueOf(2151350272L);
    @Description(value="No processing could be done because there was nothing to do.")
    public static final UnsignedInteger Bad_NothingToDo = UnsignedInteger.valueOf(0x800F0000L);
    @Description(value="The number was not accepted because of a numeric overflow.")
    public static final UnsignedInteger Bad_NumericOverflow = UnsignedInteger.valueOf(2165440512L);
    @Description(value="The object cannot be used because it has been deleted.")
    public static final UnsignedInteger Bad_ObjectDeleted = UnsignedInteger.valueOf(2151612416L);
    @Description(value="The asynchronous operation was abandoned by the caller.")
    public static final UnsignedInteger Bad_OperationAbandoned = UnsignedInteger.valueOf(2159214592L);
    @Description(value="Not enough memory to complete the operation.")
    public static final UnsignedInteger Bad_OutOfMemory = UnsignedInteger.valueOf(0x80030000L);
    @Description(value="The value was out of range.")
    public static final UnsignedInteger Bad_OutOfRange = UnsignedInteger.valueOf(2151415808L);
    @Description(value="It is delivered with a dependent Variable value when a dominant Variable has changed and the value is not legal.")
    public static final UnsignedInteger Bad_OutOfRange_DominantValueChanged = UnsignedInteger.valueOf(2166030336L);
    @Description(value="It is delivered with a dependent Variable value when a dominant or dependent Variable has changed and the value is not legal.")
    public static final UnsignedInteger Bad_OutOfRange_DominantValueChanged_DependentValueChanged = UnsignedInteger.valueOf(2166161408L);
    @Description(value="The source of the data is not operational.")
    public static final UnsignedInteger Bad_OutOfService = UnsignedInteger.valueOf(0x808D0000L);
    @Description(value="The parent node id does not to refer to a valid node.")
    public static final UnsignedInteger Bad_ParentNodeIdInvalid = UnsignedInteger.valueOf(2153447424L);
    @Description(value="The applications do not have compatible protocol versions.")
    public static final UnsignedInteger Bad_ProtocolVersionUnsupported = UnsignedInteger.valueOf(2159935488L);
    @Description(value="The requested operation requires too many resources in the server.")
    public static final UnsignedInteger Bad_QueryTooComplex = UnsignedInteger.valueOf(2154692608L);
    @Description(value="The reference type is not valid for a reference to a remote server.")
    public static final UnsignedInteger Bad_ReferenceLocalOnly = UnsignedInteger.valueOf(0x80680000L);
    @Description(value="The reference could not be created because it violates constraints imposed by the data model.")
    public static final UnsignedInteger Bad_ReferenceNotAllowed = UnsignedInteger.valueOf(2153512960L);
    @Description(value="The reference type id does not refer to a valid reference type node.")
    public static final UnsignedInteger Bad_ReferenceTypeIdInvalid = UnsignedInteger.valueOf(2152464384L);
    @Description(value="This Condition refresh failed, a Condition refresh operation is already in progress.")
    public static final UnsignedInteger Bad_RefreshInProgress = UnsignedInteger.valueOf(2157379584L);
    @Description(value="The request was cancelled by the client.")
    public static final UnsignedInteger Bad_RequestCancelledByClient = UnsignedInteger.valueOf(2150367232L);
    @Description(value="The request was cancelled by the client with the Cancel service.")
    public static final UnsignedInteger Bad_RequestCancelledByRequest = UnsignedInteger.valueOf(2153381888L);
    @Description(value="The header for the request is missing or invalid.")
    public static final UnsignedInteger Bad_RequestHeaderInvalid = UnsignedInteger.valueOf(2150236160L);
    @Description(value="The request could not be sent because of a network interruption.")
    public static final UnsignedInteger Bad_RequestInterrupted = UnsignedInteger.valueOf(0x80840000L);
    @Description(value="The request was rejected by the server because it did not meet the criteria set by the server.")
    public static final UnsignedInteger Bad_RequestNotAllowed = UnsignedInteger.valueOf(2162425856L);
    @Description(value="The request has not been processed by the server yet.")
    public static final UnsignedInteger Bad_RequestNotComplete = UnsignedInteger.valueOf(2165506048L);
    @Description(value="Timeout occurred while processing the request.")
    public static final UnsignedInteger Bad_RequestTimeout = UnsignedInteger.valueOf(0x80850000L);
    @Description(value="The request message size exceeds limits set by the server.")
    public static final UnsignedInteger Bad_RequestTooLarge = UnsignedInteger.valueOf(0x80B80000L);
    @Description(value="The security token request type is not valid.")
    public static final UnsignedInteger Bad_RequestTypeInvalid = UnsignedInteger.valueOf(2152923136L);
    @Description(value="The requested operation is not allowed, because the Node is not locked by the application.")
    public static final UnsignedInteger Bad_RequiresLock = UnsignedInteger.valueOf(2162950144L);
    @Description(value="An operating system resource is not available.")
    public static final UnsignedInteger Bad_ResourceUnavailable = UnsignedInteger.valueOf(0x80040000L);
    @Description(value="The response message size exceeds limits set by the client or server.")
    public static final UnsignedInteger Bad_ResponseTooLarge = UnsignedInteger.valueOf(2159607808L);
    @Description(value="The secure channel has been closed.")
    public static final UnsignedInteger Bad_SecureChannelClosed = UnsignedInteger.valueOf(0x80860000L);
    @Description(value="The specified secure channel is no longer valid.")
    public static final UnsignedInteger Bad_SecureChannelIdInvalid = UnsignedInteger.valueOf(0x80220000L);
    @Description(value="The token has expired or is not recognized.")
    public static final UnsignedInteger Bad_SecureChannelTokenUnknown = UnsignedInteger.valueOf(0x80870000L);
    @Description(value="An error occurred verifying security.")
    public static final UnsignedInteger Bad_SecurityChecksFailed = UnsignedInteger.valueOf(2148728832L);
    @Description(value="The operation is not permitted over the current secure channel.")
    public static final UnsignedInteger Bad_SecurityModeInsufficient = UnsignedInteger.valueOf(2162556928L);
    @Description(value="The security mode does not meet the requirements set by the server.")
    public static final UnsignedInteger Bad_SecurityModeRejected = UnsignedInteger.valueOf(2152988672L);
    @Description(value="The security policy does not meet the requirements set by the server.")
    public static final UnsignedInteger Bad_SecurityPolicyRejected = UnsignedInteger.valueOf(0x80550000L);
    @Description(value="The semaphore file specified by the client is not valid.")
    public static final UnsignedInteger Bad_SemaphoreFileMissing = UnsignedInteger.valueOf(2152857600L);
    @Description(value="There has been a failure in the sensor from which the value is derived by the device/data source.")
    public static final UnsignedInteger Bad_SensorFailure = UnsignedInteger.valueOf(0x808C0000L);
    @Description(value="The sequence number is not valid.")
    public static final UnsignedInteger Bad_SequenceNumberInvalid = UnsignedInteger.valueOf(0x80880000L);
    @Description(value="The sequence number is unknown to the server.")
    public static final UnsignedInteger Bad_SequenceNumberUnknown = UnsignedInteger.valueOf(2155479040L);
    @Description(value="The server has stopped and cannot process any requests.")
    public static final UnsignedInteger Bad_ServerHalted = UnsignedInteger.valueOf(0x800E0000L);
    @Description(value="The server index is not valid.")
    public static final UnsignedInteger Bad_ServerIndexInvalid = UnsignedInteger.valueOf(2154430464L);
    @Description(value="No ServerName was specified.")
    public static final UnsignedInteger Bad_ServerNameMissing = UnsignedInteger.valueOf(0x80500000L);
    @Description(value="The operation could not complete because the client is not connected to the server.")
    public static final UnsignedInteger Bad_ServerNotConnected = UnsignedInteger.valueOf(0x800D0000L);
    @Description(value="The Server does not have the resources to process the request at this time.")
    public static final UnsignedInteger Bad_ServerTooBusy = UnsignedInteger.valueOf(0x80EE0000L);
    @Description(value="The ServerUri is not a valid URI.")
    public static final UnsignedInteger Bad_ServerUriInvalid = UnsignedInteger.valueOf(2152660992L);
    @Description(value="The server does not support the requested service.")
    public static final UnsignedInteger Bad_ServiceUnsupported = UnsignedInteger.valueOf(0x800B0000L);
    @Description(value="The session was closed by the client.")
    public static final UnsignedInteger Bad_SessionClosed = UnsignedInteger.valueOf(2149974016L);
    @Description(value="The session id is not valid.")
    public static final UnsignedInteger Bad_SessionIdInvalid = UnsignedInteger.valueOf(2149908480L);
    @Description(value="The session cannot be used because ActivateSession has not been called.")
    public static final UnsignedInteger Bad_SessionNotActivated = UnsignedInteger.valueOf(2150039552L);
    @Description(value="The shelving time not within an acceptable range.")
    public static final UnsignedInteger Bad_ShelvingTimeOutOfRange = UnsignedInteger.valueOf(2161311744L);
    @Description(value="The operation was cancelled because the application is shutting down.")
    public static final UnsignedInteger Bad_Shutdown = UnsignedInteger.valueOf(0x800C0000L);
    @Description(value="The source node id does not reference a valid node.")
    public static final UnsignedInteger Bad_SourceNodeIdInvalid = UnsignedInteger.valueOf(2154037248L);
    @Description(value="The sub-state machine is not currently active.")
    public static final UnsignedInteger Bad_StateNotActive = UnsignedInteger.valueOf(2160001024L);
    @Description(value="A mandatory structured parameter was missing or null.")
    public static final UnsignedInteger Bad_StructureMissing = UnsignedInteger.valueOf(2152071168L);
    @Description(value="The subscription id is not valid.")
    public static final UnsignedInteger Bad_SubscriptionIdInvalid = UnsignedInteger.valueOf(0x80280000L);
    @Description(value="A value had an invalid syntax.")
    public static final UnsignedInteger Bad_SyntaxError = UnsignedInteger.valueOf(2159411200L);
    @Description(value="The target node id does not reference a valid node.")
    public static final UnsignedInteger Bad_TargetNodeIdInvalid = UnsignedInteger.valueOf(2154102784L);
    @Description(value="The server does not recognize the QueryString specified.")
    public static final UnsignedInteger Bad_TcpEndpointUrlInvalid = UnsignedInteger.valueOf(0x80830000L);
    @Description(value="An internal error occurred.")
    public static final UnsignedInteger Bad_TcpInternalError = UnsignedInteger.valueOf(0x80820000L);
    @Description(value="The size of the message chunk specified in the header is too large.")
    public static final UnsignedInteger Bad_TcpMessageTooLarge = UnsignedInteger.valueOf(0x80800000L);
    @Description(value="The type of the message specified in the header invalid.")
    public static final UnsignedInteger Bad_TcpMessageTypeInvalid = UnsignedInteger.valueOf(2155741184L);
    @Description(value="There are not enough resources to process the request.")
    public static final UnsignedInteger Bad_TcpNotEnoughResources = UnsignedInteger.valueOf(0x80810000L);
    @Description(value="The SecureChannelId and/or TokenId are not currently in use.")
    public static final UnsignedInteger Bad_TcpSecureChannelUnknown = UnsignedInteger.valueOf(2155806720L);
    @Description(value="The server cannot process the request because it is too busy.")
    public static final UnsignedInteger Bad_TcpServerTooBusy = UnsignedInteger.valueOf(2155675648L);
    @Description(value="The device identity needs a ticket before it can be accepted.")
    public static final UnsignedInteger Bad_TicketInvalid = UnsignedInteger.valueOf(2166358016L);
    @Description(value="The device identity needs a ticket before it can be accepted.")
    public static final UnsignedInteger Bad_TicketRequired = UnsignedInteger.valueOf(2166292480L);
    @Description(value="The operation timed out.")
    public static final UnsignedInteger Bad_Timeout = UnsignedInteger.valueOf(0x800A0000L);
    @Description(value="The Client requested history using a TimestampsToReturn the Server does not support.")
    public static final UnsignedInteger Bad_TimestampNotSupported = UnsignedInteger.valueOf(2158034944L);
    @Description(value="The timestamps to return parameter is invalid.")
    public static final UnsignedInteger Bad_TimestampsToReturnInvalid = UnsignedInteger.valueOf(2150301696L);
    @Description(value="Too many arguments were provided.")
    public static final UnsignedInteger Bad_TooManyArguments = UnsignedInteger.valueOf(2162491392L);
    @Description(value="The requested operation has too many matches to return.")
    public static final UnsignedInteger Bad_TooManyMatches = UnsignedInteger.valueOf(2154627072L);
    @Description(value="The request could not be processed because there are too many monitored items in the subscription.")
    public static final UnsignedInteger Bad_TooManyMonitoredItems = UnsignedInteger.valueOf(2161836032L);
    @Description(value="The request could not be processed because it specified too many operations.")
    public static final UnsignedInteger Bad_TooManyOperations = UnsignedInteger.valueOf(0x80100000L);
    @Description(value="The server has reached the maximum number of queued publish requests.")
    public static final UnsignedInteger Bad_TooManyPublishRequests = UnsignedInteger.valueOf(0x80780000L);
    @Description(value="The server has reached its maximum number of sessions.")
    public static final UnsignedInteger Bad_TooManySessions = UnsignedInteger.valueOf(2153119744L);
    @Description(value="The server has reached its maximum number of subscriptions.")
    public static final UnsignedInteger Bad_TooManySubscriptions = UnsignedInteger.valueOf(0x80770000L);
    @Description(value="The operation is not allowed because a transaction is in progress.")
    public static final UnsignedInteger Bad_TransactionPending = UnsignedInteger.valueOf(0x80E80000L);
    @Description(value="The type definition node id does not reference an appropriate type node.")
    public static final UnsignedInteger Bad_TypeDefinitionInvalid = UnsignedInteger.valueOf(2153971712L);
    @Description(value="The value supplied for the attribute is not of the same type as the attribute's value.")
    public static final UnsignedInteger Bad_TypeMismatch = UnsignedInteger.valueOf(2155085824L);
    @Description(value="An unexpected error occurred.")
    public static final UnsignedInteger Bad_UnexpectedError = UnsignedInteger.valueOf(0x80010000L);
    @Description(value="An unrecognized response was received from the server.")
    public static final UnsignedInteger Bad_UnknownResponse = UnsignedInteger.valueOf(0x80090000L);
    @Description(value="User does not have permission to perform the requested operation.")
    public static final UnsignedInteger Bad_UserAccessDenied = UnsignedInteger.valueOf(2149515264L);
    @Description(value="The user token signature is missing or invalid.")
    public static final UnsignedInteger Bad_UserSignatureInvalid = UnsignedInteger.valueOf(2153185280L);
    @Description(value="The view id does not refer to a valid view node.")
    public static final UnsignedInteger Bad_ViewIdUnknown = UnsignedInteger.valueOf(2154496000L);
    @Description(value="The view parameters are not consistent with each other.")
    public static final UnsignedInteger Bad_ViewParameterMismatch = UnsignedInteger.valueOf(2160721920L);
    @Description(value="The view timestamp is not available or not supported.")
    public static final UnsignedInteger Bad_ViewTimestampInvalid = UnsignedInteger.valueOf(2160656384L);
    @Description(value="The view version is not available or not supported.")
    public static final UnsignedInteger Bad_ViewVersionInvalid = UnsignedInteger.valueOf(2160787456L);
    @Description(value="Waiting for the server to obtain values from the underlying data source.")
    public static final UnsignedInteger Bad_WaitingForInitialData = UnsignedInteger.valueOf(2150760448L);
    @Description(value="The asynchronous operation is waiting for a response.")
    public static final UnsignedInteger Bad_WaitingForResponse = UnsignedInteger.valueOf(2159149056L);
    @Description(value="Non blocking behaviour is required and the operation would block.")
    public static final UnsignedInteger Bad_WouldBlock = UnsignedInteger.valueOf(2159345664L);
    @Description(value="The server does not support writing the combination of value, status and timestamps provided.")
    public static final UnsignedInteger Bad_WriteNotSupported = UnsignedInteger.valueOf(2155020288L);
    @Description(value="The operation succeeded.")
    public static final UnsignedInteger Good = UnsignedInteger.valueOf(0L);
    @Description(value="The operation is not finished and needs to be called again.")
    public static final UnsignedInteger Good_CallAgain = UnsignedInteger.valueOf(0xA90000L);
    @Description(value="The value is accurate, and the signal source supports cascade handshaking.")
    public static final UnsignedInteger Good_Cascade = UnsignedInteger.valueOf(0x4090000L);
    @Description(value="The value source supports cascade handshaking and the value has been Initialized based on an initialization request from a cascade secondary.")
    public static final UnsignedInteger Good_CascadeInitializationAcknowledged = UnsignedInteger.valueOf(0x4010000L);
    @Description(value="The value source supports cascade handshaking and is requesting initialization of a cascade primary.")
    public static final UnsignedInteger Good_CascadeInitializationRequest = UnsignedInteger.valueOf(0x4020000L);
    @Description(value="The value source supports cascade handshaking, however, the source\u2019s current state does not allow for cascade.")
    public static final UnsignedInteger Good_CascadeNotInvited = UnsignedInteger.valueOf(0x4030000L);
    @Description(value="The value source supports cascade handshaking, however, the source has not selected the corresponding cascade primary for use.")
    public static final UnsignedInteger Good_CascadeNotSelected = UnsignedInteger.valueOf(0x4040000L);
    @Description(value="The value written was accepted but was clamped.")
    public static final UnsignedInteger Good_Clamped = UnsignedInteger.valueOf(0x300000L);
    @Description(value="The communication layer has raised an event.")
    public static final UnsignedInteger Good_CommunicationEvent = UnsignedInteger.valueOf(0xA70000L);
    @Description(value="The processing will complete asynchronously.")
    public static final UnsignedInteger Good_CompletesAsynchronously = UnsignedInteger.valueOf(0x2E0000L);
    @Description(value="The request specifies fields which are not valid for the EventType or cannot be saved by the historian.")
    public static final UnsignedInteger Good_DataIgnored = UnsignedInteger.valueOf(0xD90000L);
    @Description(value="A dependent value has been changed but the change has not been applied to the device.")
    public static final UnsignedInteger Good_DependentValueChanged = UnsignedInteger.valueOf(0xE00000L);
    @Description(value="The value does not come from the real source and has been edited by the server.")
    public static final UnsignedInteger Good_Edited = UnsignedInteger.valueOf(0xDC0000L);
    @Description(value="It is delivered with a dominant Variable value when a dependent Variable has changed but the change has not been applied.")
    public static final UnsignedInteger Good_Edited_DependentValueChanged = UnsignedInteger.valueOf(0x1160000L);
    @Description(value="It is delivered with a dependent Variable value when a dominant Variable has changed but the change has not been applied.")
    public static final UnsignedInteger Good_Edited_DominantValueChanged = UnsignedInteger.valueOf(0x1170000L);
    @Description(value="It is delivered with a dependent Variable value when a dominant or dependent Variable has changed but change has not been applied.")
    public static final UnsignedInteger Good_Edited_DominantValueChanged_DependentValueChanged = UnsignedInteger.valueOf(0x1180000L);
    @Description(value="The data or event was successfully inserted into the historical database.")
    public static final UnsignedInteger Good_EntryInserted = UnsignedInteger.valueOf(0xA20000L);
    @Description(value="The data or event field was successfully replaced in the historical database.")
    public static final UnsignedInteger Good_EntryReplaced = UnsignedInteger.valueOf(0xA30000L);
    @Description(value="There is a fault state condition active in the value source.")
    public static final UnsignedInteger Good_FaultStateActive = UnsignedInteger.valueOf(0x4070000L);
    @Description(value="A fault state condition is being requested of the destination.")
    public static final UnsignedInteger Good_InitiateFaultState = UnsignedInteger.valueOf(0x4080000L);
    @Description(value="The value has been overridden.")
    public static final UnsignedInteger Good_LocalOverride = UnsignedInteger.valueOf(0x960000L);
    @Description(value="More data is available in the time range beyond the number of values requested.")
    public static final UnsignedInteger Good_MoreData = UnsignedInteger.valueOf(0xA60000L);
    @Description(value="No data exists for the requested time range or event filter.")
    public static final UnsignedInteger Good_NoData = UnsignedInteger.valueOf(0xA50000L);
    @Description(value="A non-critical timeout occurred.")
    public static final UnsignedInteger Good_NonCriticalTimeout = UnsignedInteger.valueOf(0xAA0000L);
    @Description(value="Sampling has slowed down due to resource limitations.")
    public static final UnsignedInteger Good_Overload = UnsignedInteger.valueOf(0x2F0000L);
    @Description(value="The log-on for the user succeeded but the user is required to change the password.")
    public static final UnsignedInteger Good_PasswordChangeRequired = UnsignedInteger.valueOf(0xEF0000L);
    @Description(value="There was an error in execution of these post-actions.")
    public static final UnsignedInteger Good_PostActionFailed = UnsignedInteger.valueOf(0xDD0000L);
    @Description(value="The server should have followed a reference to a node in a remote server but did not. The result set may be incomplete.")
    public static final UnsignedInteger Good_ResultsMayBeIncomplete = UnsignedInteger.valueOf(0xBA0000L);
    @Description(value="The Server does not support retransmission queue and acknowledgement of sequence numbers is not available.")
    public static final UnsignedInteger Good_RetransmissionQueueNotSupported = UnsignedInteger.valueOf(0xDF0000L);
    @Description(value="The system is shutting down.")
    public static final UnsignedInteger Good_ShutdownEvent = UnsignedInteger.valueOf(0xA80000L);
    @Description(value="The value is derived from multiple sources and has the required number of Good sources, but less than the full number of Good sources.")
    public static final UnsignedInteger Good_SubNormal = UnsignedInteger.valueOf(0xEB0000L);
    @Description(value="The subscription was transferred to another session.")
    public static final UnsignedInteger Good_SubscriptionTransferred = UnsignedInteger.valueOf(0x2D0000L);
    @Description(value="The operation was uncertain.")
    public static final UnsignedInteger Uncertain = UnsignedInteger.valueOf(0x40000000L);
    @Description(value="The value may not be accurate due to a configuration issue.")
    public static final UnsignedInteger Uncertain_ConfigurationError = UnsignedInteger.valueOf(1108279296L);
    @Description(value="The aggregate value is derived from multiple values and has less than the required number of Good values.")
    public static final UnsignedInteger Uncertain_DataSubNormal = UnsignedInteger.valueOf(0x40A40000L);
    @Description(value="A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is uncertain.")
    public static final UnsignedInteger Uncertain_DependentValueChanged = UnsignedInteger.valueOf(1088552960L);
    @Description(value="The related EngineeringUnit has been changed but the Variable Value is still provided based on the previous unit.")
    public static final UnsignedInteger Uncertain_DominantValueChanged = UnsignedInteger.valueOf(1088290816L);
    @Description(value="The value is outside of the range of values defined for this parameter.")
    public static final UnsignedInteger Uncertain_EngineeringUnitsExceeded = UnsignedInteger.valueOf(0x40940000L);
    @Description(value="The value is an initial value for a variable that normally receives its value from another variable.")
    public static final UnsignedInteger Uncertain_InitialValue = UnsignedInteger.valueOf(1083310080L);
    @Description(value="Whatever was updating this value has stopped doing so.")
    public static final UnsignedInteger Uncertain_LastUsableValue = UnsignedInteger.valueOf(0x40900000L);
    @Description(value="Communication to the data source has failed. The variable value is the last value that had a good quality.")
    public static final UnsignedInteger Uncertain_NoCommunicationLastUsableValue = UnsignedInteger.valueOf(1083113472L);
    @Description(value="The list of references may not be complete because the underlying system is not available.")
    public static final UnsignedInteger Uncertain_NotAllNodesAvailable = UnsignedInteger.valueOf(0x40C00000L);
    @Description(value="The server was not able to delete all target references.")
    public static final UnsignedInteger Uncertain_ReferenceNotDeleted = UnsignedInteger.valueOf(1086062592L);
    @Description(value="One of the references to follow in the relative path references to a node in the address space in another server.")
    public static final UnsignedInteger Uncertain_ReferenceOutOfServer = UnsignedInteger.valueOf(1080819712L);
    @Description(value="The value may not be accurate due to a sensor calibration fault.")
    public static final UnsignedInteger Uncertain_SensorCalibration = UnsignedInteger.valueOf(1107951616L);
    @Description(value="The value is at one of the sensor limits.")
    public static final UnsignedInteger Uncertain_SensorNotAccurate = UnsignedInteger.valueOf(1083375616L);
    @Description(value="The value is simulated.")
    public static final UnsignedInteger Uncertain_SimulatedValue = UnsignedInteger.valueOf(1107886080L);
    @Description(value="The data value is derived from multiple sources and has less than the required number of Good sources.")
    public static final UnsignedInteger Uncertain_SubNormal = UnsignedInteger.valueOf(1083506688L);
    @Description(value="The value is an operational value that was manually overwritten.")
    public static final UnsignedInteger Uncertain_SubstituteValue = UnsignedInteger.valueOf(1083244544L);
    @Description(value="The value may not be accurate because the transducer is in manual mode.")
    public static final UnsignedInteger Uncertain_TransducerInManual = UnsignedInteger.valueOf(1107820544L);

    public static String getStatusCodeErrorName(UnsignedInteger unsignedInteger) {
        return ERROR_NAMES.get(unsignedInteger);
    }

    public static UnsignedInteger getStatusCodeFromErrorName(String string) {
        return ERROR_NAMES_REV.get(string);
    }

    public static String getStatusCodeDescription(UnsignedInteger unsignedInteger) {
        return ERROR_DESCRIPTIONS.get(unsignedInteger);
    }

    public static Set<UnsignedInteger> getKnownStatusCodes() {
        return Collections.unmodifiableSet(ERROR_NAMES.keySet());
    }

    private static void init(UnsignedInteger unsignedInteger, String string, String string2) {
        int n2 = unsignedInteger.intValue() & 0xCFFF0000;
        UnsignedInteger unsignedInteger2 = UnsignedInteger.getFromBits(n2);
        ERROR_DESCRIPTIONS.put(unsignedInteger2, string2);
        ERROR_NAMES.put(unsignedInteger2, string);
        ERROR_NAMES_REV.put(string, unsignedInteger2);
    }

    static {
        StatusCodes.init(UnsignedInteger.valueOf(0x80000000L), "Bad", "The operation failed.");
        StatusCodes.init(UnsignedInteger.valueOf(2161770496L), "Bad_AggregateConfigurationRejected", "The aggregate configuration is not valid for specified node.");
        StatusCodes.init(UnsignedInteger.valueOf(2161508352L), "Bad_AggregateInvalidInputs", "The aggregate value could not be derived due to invalid data inputs.");
        StatusCodes.init(UnsignedInteger.valueOf(2161377280L), "Bad_AggregateListMismatch", "The requested number of Aggregates does not match the requested number of NodeIds.");
        StatusCodes.init(UnsignedInteger.valueOf(2161442816L), "Bad_AggregateNotSupported", "The requested Aggregate is not support by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2165637120L), "Bad_AlreadyExists", "An equivalent rule already exists.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80580000L), "Bad_ApplicationSignatureInvalid", "The signature generated with the client certificate is missing or invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2155216896L), "Bad_ArgumentsMissing", "The client did not specify all of the input arguments for the method.");
        StatusCodes.init(UnsignedInteger.valueOf(2150957056L), "Bad_AttributeIdInvalid", "The attribute is not supported for the specified Node.");
        StatusCodes.init(UnsignedInteger.valueOf(2161573888L), "Bad_BoundNotFound", "No data found to provide upper or lower bound value.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80D80000L), "Bad_BoundNotSupported", "The server cannot retrieve a bound for the variable.");
        StatusCodes.init(UnsignedInteger.valueOf(2152529920L), "Bad_BrowseDirectionInvalid", "The browse direction is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2153840640L), "Bad_BrowseNameDuplicated", "The browse name is not unique among nodes that share the same relationship with the parent.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80600000L), "Bad_BrowseNameInvalid", "The browse name is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2165112832L), "Bad_CertificateChainIncomplete", "The certificate chain is incomplete.");
        StatusCodes.init(UnsignedInteger.valueOf(2148925440L), "Bad_CertificateHostNameInvalid", "The HostName used to connect to a server does not match a HostName in the certificate.");
        StatusCodes.init(UnsignedInteger.valueOf(2148663296L), "Bad_CertificateInvalid", "The certificate provided as a parameter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2149318656L), "Bad_CertificateIssuerRevocationUnknown", "It was not possible to determine if the issuer certificate has been revoked.");
        StatusCodes.init(UnsignedInteger.valueOf(2149449728L), "Bad_CertificateIssuerRevoked", "The issuer certificate has been revoked.");
        StatusCodes.init(UnsignedInteger.valueOf(2148859904L), "Bad_CertificateIssuerTimeInvalid", "An issuer certificate has expired or is not yet valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2149122048L), "Bad_CertificateIssuerUseNotAllowed", "The issuer certificate may not be used for the requested operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2165571584L), "Bad_CertificatePolicyCheckFailed", "The certificate does not meet the requirements of the security policy.");
        StatusCodes.init(UnsignedInteger.valueOf(2149253120L), "Bad_CertificateRevocationUnknown", "It was not possible to determine if the certificate has been revoked.");
        StatusCodes.init(UnsignedInteger.valueOf(2149384192L), "Bad_CertificateRevoked", "The certificate has been revoked.");
        StatusCodes.init(UnsignedInteger.valueOf(2148794368L), "Bad_CertificateTimeInvalid", "The certificate has expired or is not yet valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2149187584L), "Bad_CertificateUntrusted", "The certificate is not trusted.");
        StatusCodes.init(UnsignedInteger.valueOf(2148990976L), "Bad_CertificateUriInvalid", "The URI specified in the ApplicationDescription does not match the URI in the certificate.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80180000L), "Bad_CertificateUseNotAllowed", "The certificate may not be used for the requested operation.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80050000L), "Bad_CommunicationError", "A low level communication error occurred.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80980000L), "Bad_ConditionAlreadyDisabled", "This condition has already been disabled.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80CC0000L), "Bad_ConditionAlreadyEnabled", "This condition has already been enabled.");
        StatusCodes.init(UnsignedInteger.valueOf(2161180672L), "Bad_ConditionAlreadyShelved", "The condition has already been shelved.");
        StatusCodes.init(UnsignedInteger.valueOf(2161049600L), "Bad_ConditionBranchAlreadyAcked", "The condition branch has already been acknowledged.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80D00000L), "Bad_ConditionBranchAlreadyConfirmed", "The condition branch has already been confirmed.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80990000L), "Bad_ConditionDisabled", "Property not available, this condition is disabled.");
        StatusCodes.init(UnsignedInteger.valueOf(2161246208L), "Bad_ConditionNotShelved", "The condition is not currently shelved.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80890000L), "Bad_ConfigurationError", "There is a problem with the configuration that affects the usefulness of the value.");
        StatusCodes.init(UnsignedInteger.valueOf(2158886912L), "Bad_ConnectionClosed", "The network connection has been closed.");
        StatusCodes.init(UnsignedInteger.valueOf(2158755840L), "Bad_ConnectionRejected", "Could not establish a network connection to remote server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80480000L), "Bad_ContentFilterInvalid", "The content filter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2152333312L), "Bad_ContinuationPointInvalid", "The continuation point provide is longer valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80380000L), "Bad_DataEncodingInvalid", "The data encoding is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2151219200L), "Bad_DataEncodingUnsupported", "The server does not support the requested data encoding for the node.");
        StatusCodes.init(UnsignedInteger.valueOf(2157772800L), "Bad_DataLost", "Data is missing due to collection started/stopped/lost.");
        StatusCodes.init(UnsignedInteger.valueOf(2162622464L), "Bad_DataSetIdInvalid", "The DataSet specified for the DataSetWriter creation is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80110000L), "Bad_DataTypeIdUnknown", "The extension object cannot be (de)serialized because the data type id is not recognized.");
        StatusCodes.init(UnsignedInteger.valueOf(2157838336L), "Bad_DataUnavailable", "Expected data is unavailable for the requested time range due to an un-mounted volume, an off-line archive or tape, or similar reason for temporary unavailability.");
        StatusCodes.init(UnsignedInteger.valueOf(0x808E0000L), "Bad_DeadbandFilterInvalid", "The deadband filter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80070000L), "Bad_DecodingError", "Decoding halted because of invalid data in the stream.");
        StatusCodes.init(UnsignedInteger.valueOf(2162360320L), "Bad_DependentValueChanged", "A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is Bad.");
        StatusCodes.init(UnsignedInteger.valueOf(0x808B0000L), "Bad_DeviceFailure", "There has been a failure in the device/data source that generates the value that has affected the value.");
        StatusCodes.init(UnsignedInteger.valueOf(2160918528L), "Bad_DialogNotActive", "The dialog condition is not active.");
        StatusCodes.init(UnsignedInteger.valueOf(2160984064L), "Bad_DialogResponseInvalid", "The response is not valid for the dialog.");
        StatusCodes.init(UnsignedInteger.valueOf(2158821376L), "Bad_Disconnect", "The server has disconnected from the client.");
        StatusCodes.init(UnsignedInteger.valueOf(2152792064L), "Bad_DiscoveryUrlMissing", "No DiscoveryUrl was specified.");
        StatusCodes.init(UnsignedInteger.valueOf(2162229248L), "Bad_DominantValueChanged", "The related EngineeringUnit has been changed but this change has not been applied to the device. The Variable Value is still dependent on the previous unit but its status is currently Bad.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80660000L), "Bad_DuplicateReferenceNotAllowed", "The reference type between the nodes is already defined.");
        StatusCodes.init(UnsignedInteger.valueOf(2165899264L), "Bad_Edited_OutOfRange", "It is delivered with a Variable value when Variable has changed but the value is not legal.");
        StatusCodes.init(UnsignedInteger.valueOf(2166095872L), "Bad_Edited_OutOfRange_DominantValueChanged", "It is delivered with a dependent Variable value when a dominant Variable has changed, the value is not legal and the change has not been applied.");
        StatusCodes.init(UnsignedInteger.valueOf(2166226944L), "Bad_Edited_OutOfRange_DominantValueChanged_DependentValueChanged", "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed, the value is not legal and the change has not been applied.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80060000L), "Bad_EncodingError", "Encoding halted because of invalid data in the objects being serialized.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80080000L), "Bad_EncodingLimitsExceeded", "The message encoding/decoding limits imposed by the stack have been exceeded.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80B00000L), "Bad_EndOfStream", "Cannot move beyond end of the stream.");
        StatusCodes.init(UnsignedInteger.valueOf(2157903872L), "Bad_EntryExists", "The data or event was not successfully inserted because a matching entry exists.");
        StatusCodes.init(UnsignedInteger.valueOf(2152136704L), "Bad_EventFilterInvalid", "The event filter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2157576192L), "Bad_EventIdUnknown", "The specified event id is not recognized.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80BB0000L), "Bad_EventNotAcknowledgeable", "The event cannot be acknowledged.");
        StatusCodes.init(UnsignedInteger.valueOf(2159280128L), "Bad_ExpectedStreamToBlock", "The stream did not return all data requested (possibly because it is a non-blocking stream).");
        StatusCodes.init(UnsignedInteger.valueOf(2160328704L), "Bad_FilterElementInvalid", "The referenced element is not a valid element in the content filter.");
        StatusCodes.init(UnsignedInteger.valueOf(2160394240L), "Bad_FilterLiteralInvalid", "The referenced literal is not a valid value.");
        StatusCodes.init(UnsignedInteger.valueOf(2152005632L), "Bad_FilterNotAllowed", "A monitoring filter cannot be used in combination with the attribute specified.");
        StatusCodes.init(UnsignedInteger.valueOf(2160263168L), "Bad_FilterOperandCountMismatch", "The number of operands provided for the filter operator was less then expected for the operand provided.");
        StatusCodes.init(UnsignedInteger.valueOf(2152267776L), "Bad_FilterOperandInvalid", "The operand used in a content filter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2160132096L), "Bad_FilterOperatorInvalid", "An unrecognized operator was provided in a filter.");
        StatusCodes.init(UnsignedInteger.valueOf(2160197632L), "Bad_FilterOperatorUnsupported", "A valid operator was provided, but the server does not provide support for this filter operator.");
        StatusCodes.init(UnsignedInteger.valueOf(2154889216L), "Bad_HistoryOperationInvalid", "The history details parameter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2154954752L), "Bad_HistoryOperationUnsupported", "The server does not support the requested operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2160459776L), "Bad_IdentityChangeNotSupported", "The server does not support changing the user identity assigned to the session.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80200000L), "Bad_IdentityTokenInvalid", "The user identity token is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2149646336L), "Bad_IdentityTokenRejected", "The user identity token is valid but the server has rejected it.");
        StatusCodes.init(UnsignedInteger.valueOf(2162819072L), "Bad_IndexRangeDataMismatch", "The written data does not match the IndexRange specified.");
        StatusCodes.init(UnsignedInteger.valueOf(2151022592L), "Bad_IndexRangeInvalid", "The syntax of the index range parameter is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2151088128L), "Bad_IndexRangeNoData", "No data exists within the range of indexes specified.");
        StatusCodes.init(UnsignedInteger.valueOf(2165964800L), "Bad_InitialValue_OutOfRange", "It is delivered with a Variable value when a source Variable has changed but the value is not legal.");
        StatusCodes.init(UnsignedInteger.valueOf(2155610112L), "Bad_InsufficientClientProfile", "The client of the current session does not support one or more Profiles that are necessary for the subscription.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80020000L), "Bad_InternalError", "An internal error occurred as a result of a programming or configuration error.");
        StatusCodes.init(UnsignedInteger.valueOf(2158690304L), "Bad_InvalidArgument", "One or more arguments are invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2154233856L), "Bad_InvalidSelfReference", "The server does not allow this type of self reference on this node.");
        StatusCodes.init(UnsignedInteger.valueOf(2158952448L), "Bad_InvalidState", "The operation cannot be completed because the object is closed, uninitialized or in some other invalid state.");
        StatusCodes.init(UnsignedInteger.valueOf(2149777408L), "Bad_InvalidTimestamp", "The timestamp is outside the range allowed by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2159869952L), "Bad_InvalidTimestampArgument", "The defined timestamp to return was invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2165178368L), "Bad_LicenseExpired", "The server requires a license to operate in general or to perform a service or operation, but existing license is expired.");
        StatusCodes.init(UnsignedInteger.valueOf(2165243904L), "Bad_LicenseLimitsExceeded", "The server has limits on number of allowed operations / objects, based on installed licenses, and these limits where exceeded.");
        StatusCodes.init(UnsignedInteger.valueOf(0x81100000L), "Bad_LicenseNotAvailable", "The server does not have a license which is required to operate in general or to perform a service or operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2163015680L), "Bad_LocaleNotSupported", "The locale in the requested write operation is not supported.");
        StatusCodes.init(UnsignedInteger.valueOf(2162753536L), "Bad_Locked", "The requested operation is not allowed, because the Node is locked by a different application.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80700000L), "Bad_MaxAgeInvalid", "The max age parameter is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2159476736L), "Bad_MaxConnectionsReached", "The operation could not be finished because all available connections are in use.");
        StatusCodes.init(UnsignedInteger.valueOf(2155544576L), "Bad_MessageNotAvailable", "The requested notification message is no longer available.");
        StatusCodes.init(UnsignedInteger.valueOf(2155151360L), "Bad_MethodInvalid", "The method id does not refer to a method for the specified object.");
        StatusCodes.init(UnsignedInteger.valueOf(2151874560L), "Bad_MonitoredItemFilterInvalid", "The monitored item filter parameter is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80440000L), "Bad_MonitoredItemFilterUnsupported", "The server does not support the requested monitored item filter.");
        StatusCodes.init(UnsignedInteger.valueOf(2151809024L), "Bad_MonitoredItemIdInvalid", "The monitoring item id does not refer to a valid monitored item.");
        StatusCodes.init(UnsignedInteger.valueOf(2151743488L), "Bad_MonitoringModeInvalid", "The monitoring mode is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2150694912L), "Bad_NoCommunication", "Communication with the data source is defined, but not established, and there is no last known value available.");
        StatusCodes.init(UnsignedInteger.valueOf(2152398848L), "Bad_NoContinuationPoints", "The operation could not be processed because all continuation points have been allocated.");
        StatusCodes.init(UnsignedInteger.valueOf(2157641728L), "Bad_NoData", "No data exists for the requested time range or event filter.");
        StatusCodes.init(UnsignedInteger.valueOf(2159083520L), "Bad_NoDataAvailable", "No data is currently available for reading from a non-blocking stream.");
        StatusCodes.init(UnsignedInteger.valueOf(2154364928L), "Bad_NoDeleteRights", "The server will not allow the node to be deleted.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80A00000L), "Bad_NoEntryExists", "The data or event was not successfully updated because no matching entry exists.");
        StatusCodes.init(UnsignedInteger.valueOf(2154758144L), "Bad_NoMatch", "The requested operation has no match to return.");
        StatusCodes.init(UnsignedInteger.valueOf(2155413504L), "Bad_NoSubscription", "There is no subscription available for this session.");
        StatusCodes.init(UnsignedInteger.valueOf(2153316352L), "Bad_NoValidCertificates", "The client did not provide at least one software certificate that is valid and meets the profile requirements for the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80F00000L), "Bad_NoValue", "The variable has no default value and no initial value.");
        StatusCodes.init(UnsignedInteger.valueOf(2153906176L), "Bad_NodeAttributesInvalid", "The node attributes are not valid for the node class.");
        StatusCodes.init(UnsignedInteger.valueOf(2153709568L), "Bad_NodeClassInvalid", "The node class is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2153644032L), "Bad_NodeIdExists", "The requested node id is already used by another node.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80330000L), "Bad_NodeIdInvalid", "The syntax the node id is not valid or refers to a node that is not valid for the operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2153578496L), "Bad_NodeIdRejected", "The requested node id was reject because it was either invalid or server does not allow node ids to be specified by the client.");
        StatusCodes.init(UnsignedInteger.valueOf(2150891520L), "Bad_NodeIdUnknown", "The node id refers to a node that does not exist in the server address space.");
        StatusCodes.init(UnsignedInteger.valueOf(2152595456L), "Bad_NodeNotInView", "The node is not part of the view.");
        StatusCodes.init(UnsignedInteger.valueOf(2149842944L), "Bad_NonceInvalid", "The nonce does appear to be not a random value or it is not the correct length.");
        StatusCodes.init(UnsignedInteger.valueOf(0x808A0000L), "Bad_NotConnected", "The variable should receive its value from another variable, but has never been configured to do so.");
        StatusCodes.init(UnsignedInteger.valueOf(0x81110000L), "Bad_NotExecutable", "The executable attribute does not allow the execution of the method.");
        StatusCodes.init(UnsignedInteger.valueOf(2151546880L), "Bad_NotFound", "A requested item was not found or a search operation ended without success.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80400000L), "Bad_NotImplemented", "Requested operation is not implemented.");
        StatusCodes.init(UnsignedInteger.valueOf(2151284736L), "Bad_NotReadable", "The access level does not allow reading or subscribing to the Node.");
        StatusCodes.init(UnsignedInteger.valueOf(2151481344L), "Bad_NotSupported", "The requested operation is not supported.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80C80000L), "Bad_NotTypeDefinition", "The provided Nodeid was not a type definition nodeid.");
        StatusCodes.init(UnsignedInteger.valueOf(2151350272L), "Bad_NotWritable", "The access level does not allow writing to the Node.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800F0000L), "Bad_NothingToDo", "No processing could be done because there was nothing to do.");
        StatusCodes.init(UnsignedInteger.valueOf(2165440512L), "Bad_NumericOverflow", "The number was not accepted because of a numeric overflow.");
        StatusCodes.init(UnsignedInteger.valueOf(2151612416L), "Bad_ObjectDeleted", "The object cannot be used because it has been deleted.");
        StatusCodes.init(UnsignedInteger.valueOf(2159214592L), "Bad_OperationAbandoned", "The asynchronous operation was abandoned by the caller.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80030000L), "Bad_OutOfMemory", "Not enough memory to complete the operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2151415808L), "Bad_OutOfRange", "The value was out of range.");
        StatusCodes.init(UnsignedInteger.valueOf(2166030336L), "Bad_OutOfRange_DominantValueChanged", "It is delivered with a dependent Variable value when a dominant Variable has changed and the value is not legal.");
        StatusCodes.init(UnsignedInteger.valueOf(2166161408L), "Bad_OutOfRange_DominantValueChanged_DependentValueChanged", "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed and the value is not legal.");
        StatusCodes.init(UnsignedInteger.valueOf(0x808D0000L), "Bad_OutOfService", "The source of the data is not operational.");
        StatusCodes.init(UnsignedInteger.valueOf(2153447424L), "Bad_ParentNodeIdInvalid", "The parent node id does not to refer to a valid node.");
        StatusCodes.init(UnsignedInteger.valueOf(2159935488L), "Bad_ProtocolVersionUnsupported", "The applications do not have compatible protocol versions.");
        StatusCodes.init(UnsignedInteger.valueOf(2154692608L), "Bad_QueryTooComplex", "The requested operation requires too many resources in the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80680000L), "Bad_ReferenceLocalOnly", "The reference type is not valid for a reference to a remote server.");
        StatusCodes.init(UnsignedInteger.valueOf(2153512960L), "Bad_ReferenceNotAllowed", "The reference could not be created because it violates constraints imposed by the data model.");
        StatusCodes.init(UnsignedInteger.valueOf(2152464384L), "Bad_ReferenceTypeIdInvalid", "The reference type id does not refer to a valid reference type node.");
        StatusCodes.init(UnsignedInteger.valueOf(2157379584L), "Bad_RefreshInProgress", "This Condition refresh failed, a Condition refresh operation is already in progress.");
        StatusCodes.init(UnsignedInteger.valueOf(2150367232L), "Bad_RequestCancelledByClient", "The request was cancelled by the client.");
        StatusCodes.init(UnsignedInteger.valueOf(2153381888L), "Bad_RequestCancelledByRequest", "The request was cancelled by the client with the Cancel service.");
        StatusCodes.init(UnsignedInteger.valueOf(2150236160L), "Bad_RequestHeaderInvalid", "The header for the request is missing or invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80840000L), "Bad_RequestInterrupted", "The request could not be sent because of a network interruption.");
        StatusCodes.init(UnsignedInteger.valueOf(2162425856L), "Bad_RequestNotAllowed", "The request was rejected by the server because it did not meet the criteria set by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2165506048L), "Bad_RequestNotComplete", "The request has not been processed by the server yet.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80850000L), "Bad_RequestTimeout", "Timeout occurred while processing the request.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80B80000L), "Bad_RequestTooLarge", "The request message size exceeds limits set by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2152923136L), "Bad_RequestTypeInvalid", "The security token request type is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2162950144L), "Bad_RequiresLock", "The requested operation is not allowed, because the Node is not locked by the application.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80040000L), "Bad_ResourceUnavailable", "An operating system resource is not available.");
        StatusCodes.init(UnsignedInteger.valueOf(2159607808L), "Bad_ResponseTooLarge", "The response message size exceeds limits set by the client or server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80860000L), "Bad_SecureChannelClosed", "The secure channel has been closed.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80220000L), "Bad_SecureChannelIdInvalid", "The specified secure channel is no longer valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80870000L), "Bad_SecureChannelTokenUnknown", "The token has expired or is not recognized.");
        StatusCodes.init(UnsignedInteger.valueOf(2148728832L), "Bad_SecurityChecksFailed", "An error occurred verifying security.");
        StatusCodes.init(UnsignedInteger.valueOf(2162556928L), "Bad_SecurityModeInsufficient", "The operation is not permitted over the current secure channel.");
        StatusCodes.init(UnsignedInteger.valueOf(2152988672L), "Bad_SecurityModeRejected", "The security mode does not meet the requirements set by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80550000L), "Bad_SecurityPolicyRejected", "The security policy does not meet the requirements set by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2152857600L), "Bad_SemaphoreFileMissing", "The semaphore file specified by the client is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x808C0000L), "Bad_SensorFailure", "There has been a failure in the sensor from which the value is derived by the device/data source.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80880000L), "Bad_SequenceNumberInvalid", "The sequence number is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2155479040L), "Bad_SequenceNumberUnknown", "The sequence number is unknown to the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800E0000L), "Bad_ServerHalted", "The server has stopped and cannot process any requests.");
        StatusCodes.init(UnsignedInteger.valueOf(2154430464L), "Bad_ServerIndexInvalid", "The server index is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80500000L), "Bad_ServerNameMissing", "No ServerName was specified.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800D0000L), "Bad_ServerNotConnected", "The operation could not complete because the client is not connected to the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80EE0000L), "Bad_ServerTooBusy", "The Server does not have the resources to process the request at this time.");
        StatusCodes.init(UnsignedInteger.valueOf(2152660992L), "Bad_ServerUriInvalid", "The ServerUri is not a valid URI.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800B0000L), "Bad_ServiceUnsupported", "The server does not support the requested service.");
        StatusCodes.init(UnsignedInteger.valueOf(2149974016L), "Bad_SessionClosed", "The session was closed by the client.");
        StatusCodes.init(UnsignedInteger.valueOf(2149908480L), "Bad_SessionIdInvalid", "The session id is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2150039552L), "Bad_SessionNotActivated", "The session cannot be used because ActivateSession has not been called.");
        StatusCodes.init(UnsignedInteger.valueOf(2161311744L), "Bad_ShelvingTimeOutOfRange", "The shelving time not within an acceptable range.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800C0000L), "Bad_Shutdown", "The operation was cancelled because the application is shutting down.");
        StatusCodes.init(UnsignedInteger.valueOf(2154037248L), "Bad_SourceNodeIdInvalid", "The source node id does not reference a valid node.");
        StatusCodes.init(UnsignedInteger.valueOf(2160001024L), "Bad_StateNotActive", "The sub-state machine is not currently active.");
        StatusCodes.init(UnsignedInteger.valueOf(2152071168L), "Bad_StructureMissing", "A mandatory structured parameter was missing or null.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80280000L), "Bad_SubscriptionIdInvalid", "The subscription id is not valid.");
        StatusCodes.init(UnsignedInteger.valueOf(2159411200L), "Bad_SyntaxError", "A value had an invalid syntax.");
        StatusCodes.init(UnsignedInteger.valueOf(2154102784L), "Bad_TargetNodeIdInvalid", "The target node id does not reference a valid node.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80830000L), "Bad_TcpEndpointUrlInvalid", "The server does not recognize the QueryString specified.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80820000L), "Bad_TcpInternalError", "An internal error occurred.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80800000L), "Bad_TcpMessageTooLarge", "The size of the message chunk specified in the header is too large.");
        StatusCodes.init(UnsignedInteger.valueOf(2155741184L), "Bad_TcpMessageTypeInvalid", "The type of the message specified in the header invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80810000L), "Bad_TcpNotEnoughResources", "There are not enough resources to process the request.");
        StatusCodes.init(UnsignedInteger.valueOf(2155806720L), "Bad_TcpSecureChannelUnknown", "The SecureChannelId and/or TokenId are not currently in use.");
        StatusCodes.init(UnsignedInteger.valueOf(2155675648L), "Bad_TcpServerTooBusy", "The server cannot process the request because it is too busy.");
        StatusCodes.init(UnsignedInteger.valueOf(2166358016L), "Bad_TicketInvalid", "The device identity needs a ticket before it can be accepted.");
        StatusCodes.init(UnsignedInteger.valueOf(2166292480L), "Bad_TicketRequired", "The device identity needs a ticket before it can be accepted.");
        StatusCodes.init(UnsignedInteger.valueOf(0x800A0000L), "Bad_Timeout", "The operation timed out.");
        StatusCodes.init(UnsignedInteger.valueOf(2158034944L), "Bad_TimestampNotSupported", "The Client requested history using a TimestampsToReturn the Server does not support.");
        StatusCodes.init(UnsignedInteger.valueOf(2150301696L), "Bad_TimestampsToReturnInvalid", "The timestamps to return parameter is invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2162491392L), "Bad_TooManyArguments", "Too many arguments were provided.");
        StatusCodes.init(UnsignedInteger.valueOf(2154627072L), "Bad_TooManyMatches", "The requested operation has too many matches to return.");
        StatusCodes.init(UnsignedInteger.valueOf(2161836032L), "Bad_TooManyMonitoredItems", "The request could not be processed because there are too many monitored items in the subscription.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80100000L), "Bad_TooManyOperations", "The request could not be processed because it specified too many operations.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80780000L), "Bad_TooManyPublishRequests", "The server has reached the maximum number of queued publish requests.");
        StatusCodes.init(UnsignedInteger.valueOf(2153119744L), "Bad_TooManySessions", "The server has reached its maximum number of sessions.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80770000L), "Bad_TooManySubscriptions", "The server has reached its maximum number of subscriptions.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80E80000L), "Bad_TransactionPending", "The operation is not allowed because a transaction is in progress.");
        StatusCodes.init(UnsignedInteger.valueOf(2153971712L), "Bad_TypeDefinitionInvalid", "The type definition node id does not reference an appropriate type node.");
        StatusCodes.init(UnsignedInteger.valueOf(2155085824L), "Bad_TypeMismatch", "The value supplied for the attribute is not of the same type as the attribute's value.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80010000L), "Bad_UnexpectedError", "An unexpected error occurred.");
        StatusCodes.init(UnsignedInteger.valueOf(0x80090000L), "Bad_UnknownResponse", "An unrecognized response was received from the server.");
        StatusCodes.init(UnsignedInteger.valueOf(2149515264L), "Bad_UserAccessDenied", "User does not have permission to perform the requested operation.");
        StatusCodes.init(UnsignedInteger.valueOf(2153185280L), "Bad_UserSignatureInvalid", "The user token signature is missing or invalid.");
        StatusCodes.init(UnsignedInteger.valueOf(2154496000L), "Bad_ViewIdUnknown", "The view id does not refer to a valid view node.");
        StatusCodes.init(UnsignedInteger.valueOf(2160721920L), "Bad_ViewParameterMismatch", "The view parameters are not consistent with each other.");
        StatusCodes.init(UnsignedInteger.valueOf(2160656384L), "Bad_ViewTimestampInvalid", "The view timestamp is not available or not supported.");
        StatusCodes.init(UnsignedInteger.valueOf(2160787456L), "Bad_ViewVersionInvalid", "The view version is not available or not supported.");
        StatusCodes.init(UnsignedInteger.valueOf(2150760448L), "Bad_WaitingForInitialData", "Waiting for the server to obtain values from the underlying data source.");
        StatusCodes.init(UnsignedInteger.valueOf(2159149056L), "Bad_WaitingForResponse", "The asynchronous operation is waiting for a response.");
        StatusCodes.init(UnsignedInteger.valueOf(2159345664L), "Bad_WouldBlock", "Non blocking behaviour is required and the operation would block.");
        StatusCodes.init(UnsignedInteger.valueOf(2155020288L), "Bad_WriteNotSupported", "The server does not support writing the combination of value, status and timestamps provided.");
        StatusCodes.init(UnsignedInteger.valueOf(0L), "Good", "The operation succeeded.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA90000L), "Good_CallAgain", "The operation is not finished and needs to be called again.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4090000L), "Good_Cascade", "The value is accurate, and the signal source supports cascade handshaking.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4010000L), "Good_CascadeInitializationAcknowledged", "The value source supports cascade handshaking and the value has been Initialized based on an initialization request from a cascade secondary.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4020000L), "Good_CascadeInitializationRequest", "The value source supports cascade handshaking and is requesting initialization of a cascade primary.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4030000L), "Good_CascadeNotInvited", "The value source supports cascade handshaking, however, the source\u2019s current state does not allow for cascade.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4040000L), "Good_CascadeNotSelected", "The value source supports cascade handshaking, however, the source has not selected the corresponding cascade primary for use.");
        StatusCodes.init(UnsignedInteger.valueOf(0x300000L), "Good_Clamped", "The value written was accepted but was clamped.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA70000L), "Good_CommunicationEvent", "The communication layer has raised an event.");
        StatusCodes.init(UnsignedInteger.valueOf(0x2E0000L), "Good_CompletesAsynchronously", "The processing will complete asynchronously.");
        StatusCodes.init(UnsignedInteger.valueOf(0xD90000L), "Good_DataIgnored", "The request specifies fields which are not valid for the EventType or cannot be saved by the historian.");
        StatusCodes.init(UnsignedInteger.valueOf(0xE00000L), "Good_DependentValueChanged", "A dependent value has been changed but the change has not been applied to the device.");
        StatusCodes.init(UnsignedInteger.valueOf(0xDC0000L), "Good_Edited", "The value does not come from the real source and has been edited by the server.");
        StatusCodes.init(UnsignedInteger.valueOf(0x1160000L), "Good_Edited_DependentValueChanged", "It is delivered with a dominant Variable value when a dependent Variable has changed but the change has not been applied.");
        StatusCodes.init(UnsignedInteger.valueOf(0x1170000L), "Good_Edited_DominantValueChanged", "It is delivered with a dependent Variable value when a dominant Variable has changed but the change has not been applied.");
        StatusCodes.init(UnsignedInteger.valueOf(0x1180000L), "Good_Edited_DominantValueChanged_DependentValueChanged", "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed but change has not been applied.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA20000L), "Good_EntryInserted", "The data or event was successfully inserted into the historical database.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA30000L), "Good_EntryReplaced", "The data or event field was successfully replaced in the historical database.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4070000L), "Good_FaultStateActive", "There is a fault state condition active in the value source.");
        StatusCodes.init(UnsignedInteger.valueOf(0x4080000L), "Good_InitiateFaultState", "A fault state condition is being requested of the destination.");
        StatusCodes.init(UnsignedInteger.valueOf(0x960000L), "Good_LocalOverride", "The value has been overridden.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA60000L), "Good_MoreData", "More data is available in the time range beyond the number of values requested.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA50000L), "Good_NoData", "No data exists for the requested time range or event filter.");
        StatusCodes.init(UnsignedInteger.valueOf(0xAA0000L), "Good_NonCriticalTimeout", "A non-critical timeout occurred.");
        StatusCodes.init(UnsignedInteger.valueOf(0x2F0000L), "Good_Overload", "Sampling has slowed down due to resource limitations.");
        StatusCodes.init(UnsignedInteger.valueOf(0xEF0000L), "Good_PasswordChangeRequired", "The log-on for the user succeeded but the user is required to change the password.");
        StatusCodes.init(UnsignedInteger.valueOf(0xDD0000L), "Good_PostActionFailed", "There was an error in execution of these post-actions.");
        StatusCodes.init(UnsignedInteger.valueOf(0xBA0000L), "Good_ResultsMayBeIncomplete", "The server should have followed a reference to a node in a remote server but did not. The result set may be incomplete.");
        StatusCodes.init(UnsignedInteger.valueOf(0xDF0000L), "Good_RetransmissionQueueNotSupported", "The Server does not support retransmission queue and acknowledgement of sequence numbers is not available.");
        StatusCodes.init(UnsignedInteger.valueOf(0xA80000L), "Good_ShutdownEvent", "The system is shutting down.");
        StatusCodes.init(UnsignedInteger.valueOf(0xEB0000L), "Good_SubNormal", "The value is derived from multiple sources and has the required number of Good sources, but less than the full number of Good sources.");
        StatusCodes.init(UnsignedInteger.valueOf(0x2D0000L), "Good_SubscriptionTransferred", "The subscription was transferred to another session.");
        StatusCodes.init(UnsignedInteger.valueOf(0x40000000L), "Uncertain", "The operation was uncertain.");
        StatusCodes.init(UnsignedInteger.valueOf(1108279296L), "Uncertain_ConfigurationError", "The value may not be accurate due to a configuration issue.");
        StatusCodes.init(UnsignedInteger.valueOf(0x40A40000L), "Uncertain_DataSubNormal", "The aggregate value is derived from multiple values and has less than the required number of Good values.");
        StatusCodes.init(UnsignedInteger.valueOf(1088552960L), "Uncertain_DependentValueChanged", "A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is uncertain.");
        StatusCodes.init(UnsignedInteger.valueOf(1088290816L), "Uncertain_DominantValueChanged", "The related EngineeringUnit has been changed but the Variable Value is still provided based on the previous unit.");
        StatusCodes.init(UnsignedInteger.valueOf(0x40940000L), "Uncertain_EngineeringUnitsExceeded", "The value is outside of the range of values defined for this parameter.");
        StatusCodes.init(UnsignedInteger.valueOf(1083310080L), "Uncertain_InitialValue", "The value is an initial value for a variable that normally receives its value from another variable.");
        StatusCodes.init(UnsignedInteger.valueOf(0x40900000L), "Uncertain_LastUsableValue", "Whatever was updating this value has stopped doing so.");
        StatusCodes.init(UnsignedInteger.valueOf(1083113472L), "Uncertain_NoCommunicationLastUsableValue", "Communication to the data source has failed. The variable value is the last value that had a good quality.");
        StatusCodes.init(UnsignedInteger.valueOf(0x40C00000L), "Uncertain_NotAllNodesAvailable", "The list of references may not be complete because the underlying system is not available.");
        StatusCodes.init(UnsignedInteger.valueOf(1086062592L), "Uncertain_ReferenceNotDeleted", "The server was not able to delete all target references.");
        StatusCodes.init(UnsignedInteger.valueOf(1080819712L), "Uncertain_ReferenceOutOfServer", "One of the references to follow in the relative path references to a node in the address space in another server.");
        StatusCodes.init(UnsignedInteger.valueOf(1107951616L), "Uncertain_SensorCalibration", "The value may not be accurate due to a sensor calibration fault.");
        StatusCodes.init(UnsignedInteger.valueOf(1083375616L), "Uncertain_SensorNotAccurate", "The value is at one of the sensor limits.");
        StatusCodes.init(UnsignedInteger.valueOf(1107886080L), "Uncertain_SimulatedValue", "The value is simulated.");
        StatusCodes.init(UnsignedInteger.valueOf(1083506688L), "Uncertain_SubNormal", "The data value is derived from multiple sources and has less than the required number of Good sources.");
        StatusCodes.init(UnsignedInteger.valueOf(1083244544L), "Uncertain_SubstituteValue", "The value is an operational value that was manually overwritten.");
        StatusCodes.init(UnsignedInteger.valueOf(1107820544L), "Uncertain_TransducerInManual", "The value may not be accurate because the transducer is in manual mode.");
    }
}

