/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=101")
public class StructureField
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public StructureField() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected StructureField(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public StructureField(String string, LocalizedText localizedText, NodeId nodeId, Integer n2, UnsignedInteger[] unsignedIntegerArray, UnsignedInteger unsignedInteger, Boolean bl) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setName(string);
        this.setDescription(localizedText);
        this.setDataType(nodeId);
        this.setValueRank(n2);
        this.setArrayDimensions(unsignedIntegerArray);
        this.setMaxStringLength(unsignedInteger);
        this.setIsOptional(bl);
    }

    public String getName() {
        return (String)this.indexGet(0);
    }

    public void setName(String string) {
        this.indexSet(string, 0);
    }

    public LocalizedText getDescription() {
        return (LocalizedText)this.indexGet(1);
    }

    public void setDescription(LocalizedText localizedText) {
        this.indexSet(localizedText, 1);
    }

    public NodeId getDataType() {
        return (NodeId)this.indexGet(2);
    }

    public void setDataType(NodeId nodeId) {
        this.indexSet(nodeId, 2);
    }

    public Integer getValueRank() {
        return (Integer)this.indexGet(3);
    }

    public void setValueRank(Integer n2) {
        this.indexSet(n2, 3);
    }

    public UnsignedInteger[] getArrayDimensions() {
        return (UnsignedInteger[])this.indexGet(4);
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.indexSet(unsignedIntegerArray, 4);
    }

    public UnsignedInteger getMaxStringLength() {
        return (UnsignedInteger)this.indexGet(5);
    }

    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 5);
    }

    public Boolean getIsOptional() {
        return (Boolean)this.indexGet(6);
    }

    public void setIsOptional(Boolean bl) {
        this.indexSet(bl, 6);
    }

    @Override
    public StructureField clone() {
        return (StructureField)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new StructureField());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Name);
        builder.addField(Fields.Description);
        builder.addField(Fields.DataType);
        builder.addField(Fields.ValueRank);
        builder.addField(Fields.ArrayDimensions);
        builder.addField(Fields.MaxStringLength);
        builder.addField(Fields.IsOptional);
        builder.setBinaryEncodeId(UaIds.StructureField_DefaultBinary);
        builder.setXmlEncodeId(UaIds.StructureField_DefaultXml);
        builder.setJsonEncodeId(UaIds.StructureField_DefaultJson);
        builder.setTypeId(UaIds.StructureField);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("StructureField");
        builder.setJavaClass(StructureField.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new StructureField((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(StructureField.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public String getName() {
            return (String)this.indexGet(0);
        }

        public Builder setName(String string) {
            this.indexSet(string, 0);
            return this;
        }

        public LocalizedText getDescription() {
            return (LocalizedText)this.indexGet(1);
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.indexSet(localizedText, 1);
            return this;
        }

        public NodeId getDataType() {
            return (NodeId)this.indexGet(2);
        }

        public Builder setDataType(NodeId nodeId) {
            this.indexSet(nodeId, 2);
            return this;
        }

        public Integer getValueRank() {
            return (Integer)this.indexGet(3);
        }

        public Builder setValueRank(Integer n2) {
            this.indexSet(n2, 3);
            return this;
        }

        public UnsignedInteger[] getArrayDimensions() {
            return (UnsignedInteger[])this.indexGet(4);
        }

        public Builder setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
            this.indexSet(unsignedIntegerArray, 4);
            return this;
        }

        public UnsignedInteger getMaxStringLength() {
            return (UnsignedInteger)this.indexGet(5);
        }

        public Builder setMaxStringLength(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 5);
            return this;
        }

        public Boolean getIsOptional() {
            return (Boolean)this.indexGet(6);
        }

        public Builder setIsOptional(Boolean bl) {
            this.indexSet(bl, 6);
            return this;
        }

        @Override
        public StructureField build() {
            return (StructureField)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Name(0, "Name", String.class, false, UaIds.String, -1, null, false, 0),
        Description(1, "Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false, 0),
        DataType(2, "DataType", NodeId.class, false, UaIds.NodeId, -1, null, false, 0),
        ValueRank(3, "ValueRank", Integer.class, false, UaIds.Int32, -1, null, false, 0),
        ArrayDimensions(4, "ArrayDimensions", UnsignedInteger[].class, false, UaIds.UInt32, 1, UaArrayDimensions.valueOf(0L), false, 1),
        MaxStringLength(5, "MaxStringLength", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        IsOptional(6, "IsOptional", Boolean.class, false, UaIds.Boolean, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

