/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface IEncoder {
    public EncoderContext getEncoderContext();

    public List<Locale> getLocales();

    public void put(String var1, Object var2, UaNodeId var3, int var4) throws EncodingException;

    default public void putBoolean(String string, Boolean bl) throws EncodingException {
        this.put(string, bl, UaIds.Boolean, 0);
    }

    default public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        this.put(string, booleanArray, UaIds.Boolean, 1);
    }

    default public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Boolean, 1);
            return;
        }
        this.put(string, collection.toArray(new Boolean[0]), UaIds.Boolean, 1);
    }

    default public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        this.put(string, unsignedByte, UaIds.Byte, 0);
    }

    default public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Byte, 1);
            return;
        }
        this.putByteArray(string, collection.toArray(UnsignedByte.EMPTY_ARRAY));
    }

    default public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        this.put(string, unsignedByteArray, UaIds.Byte, 1);
    }

    default public void putByteString(String string, ByteString byteString) throws EncodingException {
        this.put(string, byteString, UaIds.ByteString, 0);
    }

    default public void putByteStringArray(String string, ByteString[] byteStringArray) throws EncodingException {
        this.put(string, byteStringArray, UaIds.ByteString, 1);
    }

    default public void putByteStringArray(String string, Collection<ByteString> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.ByteString, 1);
            return;
        }
        this.put(string, collection.toArray(ByteString.EMPTY_ARRAY), UaIds.ByteString, 1);
    }

    default public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        this.put(string, dataValue, UaIds.DataValue, 0);
    }

    default public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.DataValue, 1);
            return;
        }
        this.put(string, collection.toArray(DataValue.EMPTY_ARRAY), UaIds.DataValue, 1);
    }

    default public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        this.put(string, dataValueArray, UaIds.DataValue, 1);
    }

    default public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        this.put(string, dateTime, UaIds.DateTime, 0);
    }

    default public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.DateTime, 1);
            return;
        }
        this.put(string, collection.toArray(DateTime.EMPTY_ARRAY), UaIds.DateTime, 1);
    }

    default public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        this.put(string, dateTimeArray, UaIds.DateTime, 1);
    }

    default public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        this.put(string, diagnosticInfo, UaIds.DiagnosticInfo, 0);
    }

    default public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.DiagnosticInfo, 1);
            return;
        }
        this.put(string, collection.toArray(DiagnosticInfo.EMPTY_ARRAY), UaIds.DiagnosticInfo, 1);
    }

    default public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        this.put(string, diagnosticInfoArray, UaIds.DiagnosticInfo, 1);
    }

    default public void putDouble(String string, double d2) throws EncodingException {
        this.put(string, d2, UaIds.Double, 0);
    }

    default public void putDouble(String string, Double d2) throws EncodingException {
        this.put(string, d2, UaIds.Double, 0);
    }

    default public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Double, 1);
            return;
        }
        this.put(string, collection.toArray(new Double[0]), UaIds.Double, 1);
    }

    default public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        this.put(string, doubleArray, UaIds.Double, 1);
    }

    default public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        this.put(string, expandedNodeId, UaIds.ExpandedNodeId, 0);
    }

    default public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.ExpandedNodeId, 1);
            return;
        }
        this.put(string, collection.toArray(ExpandedNodeId.EMPTY_ARRAY), UaIds.ExpandedNodeId, 1);
    }

    default public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        this.put(string, expandedNodeIdArray, UaIds.ExpandedNodeId, 1);
    }

    default public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        this.put(string, extensionObject, UaIds.Structure, 0);
    }

    default public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        this.put(string, collection == null ? null : collection.toArray(ExtensionObject.EMPTY_ARRAY), UaIds.Structure, 1);
    }

    default public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        this.put(string, extensionObjectArray, UaIds.Structure, 1);
    }

    default public void putFloat(String string, float f2) throws EncodingException {
        this.put(string, Float.valueOf(f2), UaIds.Float, 0);
    }

    default public void putFloat(String string, Float f2) throws EncodingException {
        this.put(string, f2, UaIds.Float, 0);
    }

    default public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Float, 1);
            return;
        }
        this.put(string, collection.toArray(new Float[0]), UaIds.Float, 1);
    }

    default public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        this.put(string, floatArray, UaIds.Float, 1);
    }

    default public void putGuid(String string, UUID uUID) throws EncodingException {
        this.put(string, uUID, UaIds.Guid, 0);
    }

    default public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Guid, 1);
            return;
        }
        this.put(string, collection.toArray(new UUID[0]), UaIds.Guid, 1);
    }

    default public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        this.put(string, uUIDArray, UaIds.Guid, 1);
    }

    default public void putInt16(String string, short s2) throws EncodingException {
        this.put(string, s2, UaIds.Int16, 0);
    }

    default public void putInt16(String string, Short s2) throws EncodingException {
        this.put(string, s2, UaIds.Int16, 0);
    }

    default public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Int16, 1);
            return;
        }
        this.put(string, collection.toArray(new Short[0]), UaIds.Int16, 1);
    }

    default public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        this.put(string, shortArray, UaIds.Int16, 1);
    }

    default public void putInt32(String string, int n2) throws EncodingException {
        this.put(string, n2, UaIds.Int32, 0);
    }

    default public void putInt32(String string, Integer n2) throws EncodingException {
        this.put(string, n2, UaIds.Int32, 0);
    }

    default public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Int32, 1);
            return;
        }
        this.put(string, collection.toArray(new Integer[0]), UaIds.Int32, 1);
    }

    default public void putInt32Array(String string, int[] nArray) throws EncodingException {
        if (nArray == null) {
            this.put(string, null, UaIds.Int32, 1);
            return;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        this.put(string, integerArray, UaIds.Int32, 1);
    }

    default public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        this.put(string, integerArray, UaIds.Int32, 1);
    }

    default public void putInt64(String string, long l2) throws EncodingException {
        this.put(string, l2, UaIds.Int64, 0);
    }

    default public void putInt64(String string, Long l2) throws EncodingException {
        this.put(string, l2, UaIds.Int64, 0);
    }

    default public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.Int64, 1);
            return;
        }
        this.put(string, collection.toArray(new Long[0]), UaIds.Int64, 1);
    }

    default public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        this.put(string, longArray, UaIds.Int64, 1);
    }

    default public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        this.put(string, localizedText, UaIds.LocalizedText, 0);
    }

    default public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.LocalizedText, 1);
            return;
        }
        this.put(string, collection.toArray(LocalizedText.EMPTY_ARRAY), UaIds.LocalizedText, 1);
    }

    default public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        this.put(string, localizedTextArray, UaIds.LocalizedText, 1);
    }

    default public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        this.put(string, nodeId, UaIds.NodeId, 0);
    }

    default public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.NodeId, 1);
            return;
        }
        this.put(string, collection.toArray(NodeId.EMPTY_ARRAY), UaIds.NodeId, 1);
    }

    default public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        this.put(string, nodeIdArray, UaIds.NodeId, 1);
    }

    default public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        this.put(string, qualifiedName, UaIds.QualifiedName, 0);
    }

    default public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.QualifiedName, 1);
            return;
        }
        this.put(string, collection.toArray(QualifiedName.EMPTY_ARRAY), UaIds.QualifiedName, 1);
    }

    default public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        this.put(string, qualifiedNameArray, UaIds.QualifiedName, 1);
    }

    default public void putSByte(String string, byte by) throws EncodingException {
        this.put(string, by, UaIds.SByte, 0);
    }

    default public void putSByte(String string, Byte by) throws EncodingException {
        this.put(string, by, UaIds.SByte, 0);
    }

    default public void putSByte(String string, int n2) throws EncodingException {
        this.put(string, (byte)n2, UaIds.SByte, 0);
    }

    default public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
        this.put(string, byteArray, UaIds.SByte, 1);
    }

    default public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.SByte, 1);
            return;
        }
        this.put(string, collection.toArray(new Byte[0]), UaIds.SByte, 1);
    }

    default public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        this.put(string, statusCode, UaIds.StatusCode, 0);
    }

    default public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.StatusCode, 1);
            return;
        }
        this.put(string, collection.toArray(StatusCode.EMPTY_ARRAY), UaIds.StatusCode, 1);
    }

    default public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        this.put(string, statusCodeArray, UaIds.StatusCode, 1);
    }

    default public void putString(String string, String string2) throws EncodingException {
        this.put(string, string2, UaIds.String, 0);
    }

    default public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.String, 1);
            return;
        }
        this.put(string, collection.toArray(new String[0]), UaIds.String, 1);
    }

    default public void putStringArray(String string, String[] stringArray) throws EncodingException {
        this.put(string, stringArray, UaIds.String, 1);
    }

    default public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        this.put(string, unsignedShort, UaIds.UInt16, 0);
    }

    default public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.UInt16, 1);
            return;
        }
        this.put(string, collection.toArray(UnsignedShort.EMPTY_ARRAY), UaIds.UInt16, 1);
    }

    default public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        this.put(string, unsignedShortArray, UaIds.UInt16, 1);
    }

    default public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        this.put(string, unsignedInteger, UaIds.UInt32, 0);
    }

    default public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.UInt32, 1);
            return;
        }
        this.putUInt32Array(string, collection.toArray(UnsignedInteger.EMPTY_ARRAY));
    }

    default public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        this.put(string, unsignedIntegerArray, UaIds.UInt32, 1);
    }

    default public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        this.put(string, unsignedLong, UaIds.UInt64, 0);
    }

    default public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.UInt64, 1);
            return;
        }
        this.putUInt64Array(string, collection.toArray(UnsignedLong.EMPTY_ARRAY));
    }

    default public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        this.put(string, unsignedLongArray, UaIds.UInt64, 1);
    }

    default public void putVariant(String string, Variant variant) throws EncodingException {
        this.put(string, variant, UaIds.BaseDataType, 0);
    }

    default public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        this.put(string, variantArray, UaIds.BaseDataType, 1);
    }

    default public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        this.put(string, xmlElement, UaIds.XmlElement, 0);
    }

    default public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        if (collection == null) {
            this.put(string, null, UaIds.XmlElement, 1);
            return;
        }
        this.put(string, collection.toArray(XmlElement.EMPTY_ARRAY), UaIds.XmlElement, 1);
    }

    default public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        this.put(string, xmlElementArray, UaIds.XmlElement, 1);
    }
}

